/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.notification;

import com.intellij.icons.AllIcons;
import com.intellij.ide.errorTreeView.CustomizeColoredTreeCellRendererReplacement;
import com.intellij.ide.errorTreeView.ErrorTreeElement;
import com.intellij.ide.errorTreeView.ErrorTreeElementKind;
import com.intellij.ide.errorTreeView.GroupingElement;
import com.intellij.ide.errorTreeView.NavigatableMessageElement;
import com.intellij.ide.errorTreeView.NewErrorTreeRenderer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.ui.CustomizeColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import com.intellij.util.ui.tree.WideSelectionTreeUI;
import java.awt.Color;
import java.awt.Component;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JTree;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NotificationMessageElement
extends NavigatableMessageElement {
    public static final String MSG_STYLE = "messageStyle";
    public static final String LINK_STYLE = "linkStyle";
    @NotNull
    private final CustomizeColoredTreeCellRenderer b;
    @NotNull
    private final CustomizeColoredTreeCellRenderer a;

    public NotificationMessageElement(final @NotNull ErrorTreeElementKind errorTreeElementKind, @Nullable GroupingElement groupingElement, String[] stringArray, @NotNull Navigatable navigatable, String string, String string2) {
        if (errorTreeElementKind == null) {
            NotificationMessageElement.a(0);
        }
        if (navigatable == null) {
            NotificationMessageElement.a(1);
        }
        super(errorTreeElementKind, groupingElement, stringArray, navigatable, string, string2);
        this.b = new CustomizeColoredTreeCellRenderer(){

            public void customizeCellRenderer(SimpleColoredComponent simpleColoredComponent, JTree jTree, Object object, boolean bl2, boolean bl3, boolean bl4, int n2, boolean bl5) {
                simpleColoredComponent.setIcon(this.a(errorTreeElementKind));
                simpleColoredComponent.setFont(jTree.getFont());
                simpleColoredComponent.append(NewErrorTreeRenderer.calcPrefix((ErrorTreeElement)NotificationMessageElement.this));
            }

            @NotNull
            private Icon a(@NotNull ErrorTreeElementKind errorTreeElementKind2) {
                if (errorTreeElementKind2 == null) {
                    1.a(0);
                }
                Icon icon = AllIcons.General.Mdot_empty;
                switch (errorTreeElementKind2) {
                    case INFO: {
                        icon = AllIcons.General.Information;
                        break;
                    }
                    case ERROR: {
                        icon = AllIcons.General.Error;
                        break;
                    }
                    case WARNING: {
                        icon = AllIcons.General.Warning;
                        break;
                    }
                    case NOTE: {
                        icon = AllIcons.General.Tip;
                        break;
                    }
                    case GENERIC: {
                        icon = AllIcons.General.Mdot_empty;
                    }
                }
                Icon icon2 = icon;
                if (icon2 == null) {
                    1.a(1);
                }
                return icon2;
            }

            private static /* synthetic */ void a(int n2) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n3;
                String string;
                switch (n2) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        n3 = 3;
                        break;
                    }
                    case 1: {
                        n3 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "kind";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/externalSystem/service/notification/NotificationMessageElement$1";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/externalSystem/service/notification/NotificationMessageElement$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIcon";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getIcon";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n2) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        this.a = new MyCustomizeColoredTreeCellRendererReplacement();
    }

    @Nullable
    public CustomizeColoredTreeCellRenderer getRightSelfRenderer() {
        return this.a;
    }

    @Nullable
    public CustomizeColoredTreeCellRenderer getLeftSelfRenderer() {
        return this.b;
    }

    protected JEditorPane installJep(@NotNull JEditorPane jEditorPane) {
        if (jEditorPane == null) {
            NotificationMessageElement.a(2);
        }
        String string = StringUtil.join((String[])this.getText(), (String)"<br>");
        jEditorPane.setEditable(false);
        jEditorPane.setOpaque(false);
        jEditorPane.setEditorKit(UIUtil.getHTMLEditorKit());
        jEditorPane.setHighlighter(null);
        StyleSheet styleSheet = ((HTMLDocument)jEditorPane.getDocument()).getStyleSheet();
        Style style = styleSheet.addStyle(MSG_STYLE, null);
        styleSheet.addStyle(LINK_STYLE, style);
        jEditorPane.setText(string);
        return jEditorPane;
    }

    protected void updateStyle(@NotNull JEditorPane jEditorPane, @Nullable JTree jTree, Object object, boolean bl2, boolean bl3) {
        if (jEditorPane == null) {
            NotificationMessageElement.a(3);
        }
        HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
        Style style = hTMLDocument.getStyleSheet().getStyle(MSG_STYLE);
        if (object instanceof LoadingNode) {
            StyleConstants.setForeground(style, (Color)JBColor.GRAY);
        } else if (bl2) {
            StyleConstants.setForeground(style, bl3 ? UIUtil.getTreeSelectionForeground() : UIUtil.getTreeTextForeground());
        } else {
            StyleConstants.setForeground(style, UIUtil.getTreeTextForeground());
        }
        if (UIUtil.isUnderGTKLookAndFeel() || jTree != null && WideSelectionTreeUI.isWideSelection((JTree)jTree)) {
            jEditorPane.setOpaque(false);
        } else {
            jEditorPane.setOpaque(bl2 && bl3);
        }
        hTMLDocument.setCharacterAttributes(0, hTMLDocument.getLength(), style, false);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigatable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myEditorPane";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorPane";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/service/notification/NotificationMessageElement";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "installJep";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "updateStyle";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyCustomizeColoredTreeCellRendererReplacement
    extends CustomizeColoredTreeCellRendererReplacement {
        @NotNull
        private final JEditorPane a;

        private MyCustomizeColoredTreeCellRendererReplacement() {
            this.a = NotificationMessageElement.this.installJep(new MyEditorPane());
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl2, boolean bl3, boolean bl4, int n2, boolean bl5) {
            NotificationMessageElement.this.updateStyle(this.a, jTree, object, bl2, bl5);
            return this.a;
        }

        private class MyEditorPane
        extends JEditorPane {
            private MyEditorPane() {
            }

            @Override
            public AccessibleContext getAccessibleContext() {
                if (this.accessibleContext == null) {
                    return new AccessibleMyEditorPane();
                }
                return this.accessibleContext;
            }

            protected class AccessibleMyEditorPane
            extends JComponent.AccessibleJComponent {
                protected AccessibleMyEditorPane() {
                    super(MyEditorPane.this);
                }

                @Override
                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.LABEL;
                }

                @Override
                public String getAccessibleName() {
                    try {
                        Document document = MyEditorPane.this.getDocument();
                        String string = document.getText(0, document.getLength());
                        return AccessibleContextUtil.replaceLineSeparatorsWithPunctuation((String)string);
                    }
                    catch (BadLocationException badLocationException) {
                        return super.getAccessibleName();
                    }
                }
            }
        }
    }
}

