/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.DependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryLevel;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProvider;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeModelsProviderImpl
implements IdeModelsProvider {
    @NotNull
    protected final Project myProject;
    @NotNull
    private final Map<ModuleData, Module> b;
    private final Map<Module, Map<String, List<ModuleOrderEntry>>> a;

    public IdeModelsProviderImpl(@NotNull Project project2) {
        if (project2 == null) {
            IdeModelsProviderImpl.a(0);
        }
        this.b = ContainerUtil.createWeakMap();
        this.a = ContainerUtil.createWeakMap();
        this.myProject = project2;
    }

    @NotNull
    public Module[] getModules() {
        Module[] moduleArray = ModuleManager.getInstance((Project)this.myProject).getModules();
        if (moduleArray == null) {
            IdeModelsProviderImpl.a(1);
        }
        return moduleArray;
    }

    @NotNull
    public Module[] getModules(@NotNull ProjectData projectData) {
        if (projectData == null) {
            IdeModelsProviderImpl.a(2);
        }
        List list2 = ContainerUtil.filter((Object[])this.getModules(), module2 -> {
            if (projectData == null) {
                IdeModelsProviderImpl.a(25);
            }
            return ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)projectData.getOwner(), (Module)module2) && StringUtil.equals((CharSequence)projectData.getLinkedExternalProjectPath(), (CharSequence)ExternalSystemApiUtil.getExternalRootProjectPath((Module)module2));
        });
        Module[] moduleArray = (Module[])ContainerUtil.toArray((List)list2, (Object[])new Module[list2.size()]);
        if (moduleArray == null) {
            IdeModelsProviderImpl.a(3);
        }
        return moduleArray;
    }

    @NotNull
    public OrderEntry[] getOrderEntries(@NotNull Module module2) {
        if (module2 == null) {
            IdeModelsProviderImpl.a(4);
        }
        OrderEntry[] orderEntryArray = ModuleRootManager.getInstance((Module)module2).getOrderEntries();
        if (orderEntryArray == null) {
            IdeModelsProviderImpl.a(5);
        }
        return orderEntryArray;
    }

    @Nullable
    public Module findIdeModule(@NotNull ModuleData moduleData) {
        Module module2;
        if (moduleData == null) {
            IdeModelsProviderImpl.a(6);
        }
        if ((module2 = this.b.get(moduleData)) == null) {
            for (String string : this.suggestModuleNameCandidates(moduleData)) {
                Module module3 = this.findIdeModule(string);
                if (module3 == null || !IdeModelsProviderImpl.a(moduleData, module3)) continue;
                this.b.put(moduleData, module3);
                return module3;
            }
        } else {
            return module2;
        }
        return null;
    }

    protected String[] suggestModuleNameCandidates(@NotNull ModuleData moduleData) {
        ExternalProjectSettings externalProjectSettings;
        char c2;
        if (moduleData == null) {
            IdeModelsProviderImpl.a(7);
        }
        String string = moduleData.getGroup();
        File file = new File(moduleData.getLinkedExternalProjectPath());
        if (file.isFile()) {
            file = file.getParentFile();
        }
        if (file.getParentFile() != null) {
            string = file.getParentFile().getName();
        }
        char c3 = c2 = (externalProjectSettings = ExternalSystemApiUtil.getSettings((Project)this.myProject, (ProjectSystemId)moduleData.getOwner()).getLinkedProjectSettings(moduleData.getLinkedExternalProjectPath())) != null && externalProjectSettings.isUseQualifiedModuleNames() ? (char)'.' : '-';
        if (string == null || StringUtil.startsWith((CharSequence)moduleData.getInternalName(), (CharSequence)string)) {
            return new String[]{moduleData.getInternalName(), moduleData.getInternalName() + "~1"};
        }
        return new String[]{moduleData.getInternalName(), string + c2 + moduleData.getInternalName(), string + c2 + moduleData.getInternalName() + "~1"};
    }

    private static boolean a(@NotNull ModuleData moduleData, @NotNull Module module2) {
        if (moduleData == null) {
            IdeModelsProviderImpl.a(8);
        }
        if (module2 == null) {
            IdeModelsProviderImpl.a(9);
        }
        for (VirtualFile virtualFile : ModuleRootManager.getInstance((Module)module2).getContentRoots()) {
            if (!FileUtil.pathsEqual((String)virtualFile.getPath(), (String)moduleData.getLinkedExternalProjectPath())) continue;
            return true;
        }
        return ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)moduleData.getOwner(), (Module)module2) && FileUtil.pathsEqual((String)ExternalSystemApiUtil.getExternalProjectPath((Module)module2), (String)moduleData.getLinkedExternalProjectPath());
    }

    @Nullable
    public Module findIdeModule(@NotNull String string) {
        if (string == null) {
            IdeModelsProviderImpl.a(10);
        }
        return ModuleManager.getInstance((Project)this.myProject).findModuleByName(string);
    }

    @Nullable
    public UnloadedModuleDescription getUnloadedModuleDescription(@NotNull ModuleData moduleData) {
        if (moduleData == null) {
            IdeModelsProviderImpl.a(11);
        }
        for (String string : this.suggestModuleNameCandidates(moduleData)) {
            UnloadedModuleDescription unloadedModuleDescription = ModuleManager.getInstance((Project)this.myProject).getUnloadedModuleDescription(string);
            if (unloadedModuleDescription == null) continue;
            return unloadedModuleDescription;
        }
        return null;
    }

    @Nullable
    public Library findIdeLibrary(@NotNull LibraryData libraryData) {
        if (libraryData == null) {
            IdeModelsProviderImpl.a(12);
        }
        LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable(this.myProject);
        for (Library library : libraryTable.getLibraries()) {
            if (!ExternalSystemApiUtil.isRelated((Library)library, (LibraryData)libraryData)) continue;
            return library;
        }
        return null;
    }

    @Nullable
    public ModuleOrderEntry findIdeModuleDependency(@NotNull ModuleDependencyData moduleDependencyData, @NotNull Module module3) {
        Map map;
        List list2;
        if (moduleDependencyData == null) {
            IdeModelsProviderImpl.a(13);
        }
        if (module3 == null) {
            IdeModelsProviderImpl.a(14);
        }
        if ((list2 = (List)(map = this.a.computeIfAbsent(module3, module2 -> Arrays.stream(this.getOrderEntries((Module)module2)).filter(ModuleOrderEntry.class::isInstance).map(ModuleOrderEntry.class::cast).collect(Collectors.groupingBy(ModuleOrderEntry::getModuleName)))).get(moduleDependencyData.getInternalName())) == null) {
            return null;
        }
        for (ModuleOrderEntry moduleOrderEntry : list2) {
            if (!moduleOrderEntry.getScope().equals((Object)moduleDependencyData.getScope())) continue;
            return moduleOrderEntry;
        }
        return null;
    }

    @Nullable
    public OrderEntry findIdeModuleOrderEntry(@NotNull DependencyData dependencyData) {
        Module module2;
        if (dependencyData == null) {
            IdeModelsProviderImpl.a(15);
        }
        if ((module2 = this.findIdeModule(dependencyData.getOwnerModule())) == null) {
            return null;
        }
        LibraryDependencyData libraryDependencyData = null;
        ModuleDependencyData moduleDependencyData = null;
        if (dependencyData instanceof LibraryDependencyData) {
            libraryDependencyData = (LibraryDependencyData)dependencyData;
        } else if (dependencyData instanceof ModuleDependencyData) {
            moduleDependencyData = (ModuleDependencyData)dependencyData;
        } else {
            return null;
        }
        for (OrderEntry orderEntry : this.getOrderEntries(module2)) {
            Object object;
            if (orderEntry instanceof LibraryOrderEntry && libraryDependencyData != null) {
                if (((LibraryOrderEntry)orderEntry).isModuleLevel() && libraryDependencyData.getLevel() != LibraryLevel.MODULE) continue;
                if (StringUtil.isEmpty((String)((LibraryOrderEntry)orderEntry).getLibraryName())) {
                    object = ContainerUtil.map2Set((Collection)((LibraryData)libraryDependencyData.getTarget()).getPaths(LibraryPathType.BINARY), string -> PathUtil.getLocalPath((String)string));
                    Set set = ContainerUtil.map2Set((Object[])orderEntry.getUrls(OrderRootType.CLASSES), string -> PathUtil.getLocalPath((String)VfsUtilCore.urlToPath((String)string)));
                    if (!set.equals(object) || ((LibraryOrderEntry)orderEntry).getScope() != dependencyData.getScope()) continue;
                    return orderEntry;
                }
            }
            Object object2 = object = libraryDependencyData != null ? libraryDependencyData.getInternalName() : moduleDependencyData.getInternalName();
            if (!((String)object).equals(orderEntry.getPresentableName()) || orderEntry instanceof ExportableOrderEntry && ((ExportableOrderEntry)orderEntry).getScope() != dependencyData.getScope()) continue;
            return orderEntry;
        }
        return null;
    }

    @NotNull
    public VirtualFile[] getContentRoots(Module module2) {
        VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)module2).getContentRoots();
        if (virtualFileArray == null) {
            IdeModelsProviderImpl.a(16);
        }
        return virtualFileArray;
    }

    @NotNull
    public VirtualFile[] getSourceRoots(Module module2) {
        VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)module2).getSourceRoots();
        if (virtualFileArray == null) {
            IdeModelsProviderImpl.a(17);
        }
        return virtualFileArray;
    }

    @NotNull
    public VirtualFile[] getSourceRoots(Module module2, boolean bl2) {
        VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)module2).getSourceRoots(bl2);
        if (virtualFileArray == null) {
            IdeModelsProviderImpl.a(18);
        }
        return virtualFileArray;
    }

    @NotNull
    public Library[] getAllLibraries() {
        Library[] libraryArray = LibraryTablesRegistrar.getInstance().getLibraryTable(this.myProject).getLibraries();
        if (libraryArray == null) {
            IdeModelsProviderImpl.a(19);
        }
        return libraryArray;
    }

    @Nullable
    public Library getLibraryByName(String string) {
        return LibraryTablesRegistrar.getInstance().getLibraryTable(this.myProject).getLibraryByName(string);
    }

    @NotNull
    public String[] getLibraryUrls(@NotNull Library library, @NotNull OrderRootType orderRootType) {
        if (library == null) {
            IdeModelsProviderImpl.a(20);
        }
        if (orderRootType == null) {
            IdeModelsProviderImpl.a(21);
        }
        String[] stringArray = library.getUrls(orderRootType);
        if (stringArray == null) {
            IdeModelsProviderImpl.a(22);
        }
        return stringArray;
    }

    @NotNull
    public List<Module> getAllDependentModules(@NotNull Module module2) {
        if (module2 == null) {
            IdeModelsProviderImpl.a(23);
        }
        List list2 = ModuleUtilCore.getAllDependentModules((Module)module2);
        if (list2 == null) {
            IdeModelsProviderImpl.a(24);
        }
        return list2;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 24: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/IdeModelsProviderImpl";
                break;
            }
            case 2: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectData";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 14: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleData";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModule";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModuleName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryData";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/IdeModelsProviderImpl";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderEntries";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRoots";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRoots";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllLibraries";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryUrls";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDependentModules";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 24: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getModules";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOrderEntries";
                break;
            }
            case 6: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findIdeModule";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "suggestModuleNameCandidates";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableIdeModule";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getUnloadedModuleDescription";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findIdeLibrary";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findIdeModuleDependency";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findIdeModuleOrderEntry";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryUrls";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getAllDependentModules";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getModules$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

