/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.autoimport;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileChangeListenerBase
implements BulkFileListener {
    protected abstract boolean isRelevant(String var1);

    protected abstract void updateFile(VirtualFile var1, VFileEvent var2);

    protected abstract void deleteFile(VirtualFile var1, VFileEvent var2);

    protected abstract void apply();

    public void before(@NotNull List<? extends VFileEvent> list2) {
        if (list2 == null) {
            FileChangeListenerBase.a(0);
        }
        for (VFileEvent vFileEvent : list2) {
            VFileMoveEvent vFileMoveEvent;
            String string;
            if (vFileEvent instanceof VFileDeleteEvent) {
                this.a(vFileEvent.getFile(), vFileEvent);
                continue;
            }
            if (!this.isRelevant(vFileEvent.getPath())) continue;
            if (vFileEvent instanceof VFilePropertyChangeEvent) {
                if (!FileChangeListenerBase.a(vFileEvent)) continue;
                this.a(vFileEvent.getFile(), vFileEvent);
                continue;
            }
            if (!(vFileEvent instanceof VFileMoveEvent) || this.isRelevant(string = (vFileMoveEvent = (VFileMoveEvent)vFileEvent).getNewParent().getPath() + "/" + vFileMoveEvent.getFile().getName())) continue;
            this.a(vFileMoveEvent.getFile(), vFileEvent);
        }
    }

    private void a(VirtualFile virtualFile, final VFileEvent vFileEvent) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)virtualFile, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile virtualFile) {
                if (virtualFile == null) {
                    1.a(0);
                }
                if (FileChangeListenerBase.this.isRelevant(virtualFile.getPath())) {
                    FileChangeListenerBase.this.deleteFile(virtualFile, vFileEvent);
                }
                return true;
            }

            @Nullable
            public Iterable<VirtualFile> getChildrenIterable(@NotNull VirtualFile virtualFile) {
                if (virtualFile == null) {
                    1.a(1);
                }
                return virtualFile.isDirectory() && virtualFile instanceof NewVirtualFile ? ((NewVirtualFile)virtualFile).iterInDbChildren() : null;
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "f";
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/autoimport/FileChangeListenerBase$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getChildrenIterable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void after(@NotNull List<? extends VFileEvent> list2) {
        if (list2 == null) {
            FileChangeListenerBase.a(1);
        }
        for (VFileEvent vFileEvent : list2) {
            VirtualFile virtualFile;
            VFileCreateEvent vFileCreateEvent;
            if (!this.isRelevant(vFileEvent.getPath())) continue;
            if (vFileEvent instanceof VFileCreateEvent) {
                vFileCreateEvent = (VFileCreateEvent)vFileEvent;
                virtualFile = vFileCreateEvent.getParent().findChild(vFileCreateEvent.getChildName());
                if (virtualFile == null) continue;
                this.updateFile(virtualFile, vFileEvent);
                continue;
            }
            if (vFileEvent instanceof VFileCopyEvent) {
                vFileCreateEvent = (VFileCopyEvent)vFileEvent;
                virtualFile = vFileCreateEvent.getNewParent().findChild(vFileCreateEvent.getNewChildName());
                if (virtualFile == null) continue;
                this.updateFile(virtualFile, vFileEvent);
                continue;
            }
            if (vFileEvent instanceof VFileContentChangeEvent) {
                this.updateFile(vFileEvent.getFile(), vFileEvent);
                continue;
            }
            if (vFileEvent instanceof VFilePropertyChangeEvent) {
                if (!FileChangeListenerBase.a(vFileEvent)) continue;
                this.updateFile(vFileEvent.getFile(), vFileEvent);
                continue;
            }
            if (!(vFileEvent instanceof VFileMoveEvent)) continue;
            this.updateFile(vFileEvent.getFile(), vFileEvent);
        }
        this.apply();
    }

    private static boolean a(VFileEvent vFileEvent) {
        return ((VFilePropertyChangeEvent)vFileEvent).getPropertyName().equals("name") && !Comparing.equal((Object)((VFilePropertyChangeEvent)vFileEvent).getOldValue(), (Object)((VFilePropertyChangeEvent)vFileEvent).getNewValue());
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "events";
        objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/autoimport/FileChangeListenerBase";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "before";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "after";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

