/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Order(value=-2147483648)
public class ProjectDataServiceImpl
extends AbstractProjectDataService<ProjectData, Project> {
    @NotNull
    public Key<ProjectData> getTargetDataKey() {
        Key key = ProjectKeys.PROJECT;
        if (key == null) {
            ProjectDataServiceImpl.a(0);
        }
        return key;
    }

    public void importData(@NotNull Collection<DataNode<ProjectData>> collection, @Nullable ProjectData projectData, @NotNull Project project2, @NotNull IdeModifiableModelsProvider ideModifiableModelsProvider) {
        if (collection == null) {
            ProjectDataServiceImpl.a(1);
        }
        if (project2 == null) {
            ProjectDataServiceImpl.a(2);
        }
        if (ideModifiableModelsProvider == null) {
            ProjectDataServiceImpl.a(3);
        }
        if (collection.isEmpty()) {
            return;
        }
        if (collection.size() != 1) {
            throw new IllegalArgumentException(String.format("Expected to get a single project but got %d: %s", collection.size(), collection));
        }
        DataNode<ProjectData> dataNode = collection.iterator().next();
        assert (projectData == dataNode.getData());
        if (!ExternalSystemApiUtil.isOneToOneMapping((Project)project2, (ProjectData)((ProjectData)dataNode.getData()))) {
            return;
        }
        if (!project2.getName().equals(projectData.getInternalName())) {
            ProjectDataServiceImpl.a(projectData.getInternalName(), projectData.getOwner(), project2);
        }
    }

    private static void a(final @NotNull String string, final @NotNull ProjectSystemId projectSystemId, final @NotNull Project project2) {
        if (string == null) {
            ProjectDataServiceImpl.a(4);
        }
        if (projectSystemId == null) {
            ProjectDataServiceImpl.a(5);
        }
        if (project2 == null) {
            ProjectDataServiceImpl.a(6);
        }
        if (!(project2 instanceof ProjectEx) || string.equals(project2.getName())) {
            return;
        }
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)true, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project2){

            public void execute() {
                String string2 = project2.getName();
                ((ProjectEx)project2).setProjectName(string);
                ExternalSystemApiUtil.getSettings((Project)project2, (ProjectSystemId)projectSystemId).getPublisher().onProjectRenamed(string2, string);
            }
        });
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataServiceImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetDataKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataServiceImpl";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "importData";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "renameProject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

