/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.settings;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.project.settings.ConfigurationData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractModuleDataService;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.service.project.settings.ConfigurationHandler;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Order(value=-2147483645)
@ApiStatus.Experimental
public class ConfigurationDataService
extends AbstractProjectDataService<ConfigurationData, Void> {
    private static final Logger a = Logger.getInstance(ConfigurationDataService.class);
    public static final String EXTERNAL_SYSTEM_CONFIGURATION_IMPORT_ENABLED = "external.system.configuration.import.enabled";

    @NotNull
    public Key<ConfigurationData> getTargetDataKey() {
        Key key = ProjectKeys.CONFIGURATION;
        if (key == null) {
            ConfigurationDataService.a(0);
        }
        return key;
    }

    public void importData(@NotNull Collection<DataNode<ConfigurationData>> collection, @Nullable ProjectData projectData, @NotNull Project project2, @NotNull IdeModifiableModelsProvider ideModifiableModelsProvider) {
        if (collection == null) {
            ConfigurationDataService.a(1);
        }
        if (project2 == null) {
            ConfigurationDataService.a(2);
        }
        if (ideModifiableModelsProvider == null) {
            ConfigurationDataService.a(3);
        }
        if (collection.isEmpty() || !Registry.is((String)EXTERNAL_SYSTEM_CONFIGURATION_IMPORT_ENABLED)) {
            return;
        }
        DataNode<ConfigurationData> dataNode = collection.iterator().next();
        DataNode dataNode2 = ExternalSystemApiUtil.findParent(dataNode, (Key)ProjectKeys.PROJECT);
        assert (dataNode2 != null);
        DataNode dataNode3 = ExternalSystemApiUtil.find((DataNode)dataNode2, (Key)ProjectKeys.CONFIGURATION);
        if (dataNode3 != null) {
            if (!ExternalSystemApiUtil.isOneToOneMapping((Project)project2, (ProjectData)((ProjectData)dataNode2.getData()))) {
                a.warn("This external project are not the only project in the current IDE workspace, found project level configuration can override the configuration came from other external projects.");
            }
            for (ConfigurationHandler configurationHandler : (ConfigurationHandler[])ConfigurationHandler.EP_NAME.getExtensions()) {
                configurationHandler.apply(project2, ideModifiableModelsProvider, (ConfigurationData)dataNode3.getData());
            }
        }
        for (DataNode<ConfigurationData> dataNode4 : collection) {
            DataNode dataNode5;
            ConfigurationHandler configurationHandler;
            if (dataNode4 == dataNode3 || (dataNode5 = ExternalSystemApiUtil.findParent(dataNode4, (Key)ProjectKeys.MODULE)) == null) continue;
            configurationHandler = (Module)dataNode5.getUserData(AbstractModuleDataService.MODULE_KEY);
            Object object = configurationHandler = configurationHandler != null ? configurationHandler : ideModifiableModelsProvider.findIdeModule((ModuleData)dataNode5.getData());
            if (configurationHandler == null) {
                a.warn(String.format("Can't import module level configuration. Reason: target module (%s) is not found at the ide", dataNode5));
                continue;
            }
            for (ConfigurationHandler configurationHandler2 : (ConfigurationHandler[])ConfigurationHandler.EP_NAME.getExtensions()) {
                configurationHandler2.apply((Module)configurationHandler, ideModifiableModelsProvider, (ConfigurationData)dataNode4.getData());
            }
        }
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/settings/ConfigurationDataService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetDataKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/settings/ConfigurationDataService";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "importData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

