/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.settings;

import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.settings.AbstractExternalProjectSettingsControl;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListener;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemSettingsControl;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.externalSystem.util.PaintAwarePanel;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExternalSystemConfigurable<ProjectSettings extends ExternalProjectSettings, L extends ExternalSystemSettingsListener<ProjectSettings>, SystemSettings extends AbstractExternalSystemSettings<SystemSettings, ProjectSettings, L>>
implements SearchableConfigurable,
Configurable.NoScroll {
    @NotNull
    private final List<ExternalSystemSettingsControl<ProjectSettings>> f;
    @NotNull
    private final ProjectSystemId a;
    @NotNull
    private final Project g;
    @Nullable
    private ExternalSystemSettingsControl<SystemSettings> h;
    @Nullable
    private ExternalSystemSettingsControl<ProjectSettings> e;
    private PaintAwarePanel b;
    private JBList c;
    private DefaultListModel d;

    protected AbstractExternalSystemConfigurable(@NotNull Project project2, @NotNull ProjectSystemId projectSystemId) {
        if (project2 == null) {
            AbstractExternalSystemConfigurable.a(0);
        }
        if (projectSystemId == null) {
            AbstractExternalSystemConfigurable.a(1);
        }
        this.f = ContainerUtilRt.newArrayList();
        this.g = project2;
        this.a = projectSystemId;
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.g;
        if (project2 == null) {
            AbstractExternalSystemConfigurable.a(2);
        }
        return project2;
    }

    @Nls
    public String getDisplayName() {
        return this.a.getReadableName();
    }

    @Nullable
    public JComponent createComponent() {
        if (this.b == null) {
            this.b = new PaintAwarePanel(new GridBagLayout());
            SystemSettings SystemSettings = this.a();
            this.a(SystemSettings);
            this.b(SystemSettings);
            ExternalSystemUiUtil.fillBottom(this.b);
        }
        return this.b;
    }

    @NotNull
    private SystemSettings a() {
        ExternalSystemManager externalSystemManager = ExternalSystemApiUtil.getManager((ProjectSystemId)this.a);
        assert (externalSystemManager != null);
        AbstractExternalSystemSettings abstractExternalSystemSettings = (AbstractExternalSystemSettings)externalSystemManager.getSettingsProvider().fun((Object)this.g);
        if (abstractExternalSystemSettings == null) {
            AbstractExternalSystemConfigurable.a(3);
        }
        return (SystemSettings)abstractExternalSystemSettings;
    }

    private void a(@NotNull SystemSettings SystemSettings) {
        if (SystemSettings == null) {
            AbstractExternalSystemConfigurable.a(4);
        }
        this.d = new DefaultListModel();
        this.c = new JBList((ListModel)this.d);
        this.c.setSelectionMode(0);
        this.a(ExternalSystemBundle.message((String)"settings.title.linked.projects", (Object[])new Object[]{this.a.getReadableName()}));
        this.b.add((Component)new JBScrollPane((Component)this.c), ExternalSystemUiUtil.getFillLineConstraints(1));
        this.a(ExternalSystemBundle.message((String)"settings.title.project.settings", (Object[])new Object[0]));
        ArrayList arrayList = ContainerUtilRt.newArrayList((Iterable)SystemSettings.getLinkedProjectsSettings());
        this.c.setVisibleRowCount(Math.max(3, Math.min(5, arrayList.size())));
        ContainerUtil.sort((List)arrayList, Comparator.comparing(externalProjectSettings -> this.getProjectName(externalProjectSettings.getExternalProjectPath())));
        this.f.clear();
        for (ExternalProjectSettings externalProjectSettings2 : arrayList) {
            ExternalSystemSettingsControl<ExternalProjectSettings> externalSystemSettingsControl = this.createProjectSettingsControl(externalProjectSettings2);
            externalSystemSettingsControl.fillUi(this.b, 1);
            this.d.addElement(this.getProjectName(externalProjectSettings2.getExternalProjectPath()));
            this.f.add(externalSystemSettingsControl);
            if (externalSystemSettingsControl instanceof AbstractExternalProjectSettingsControl) {
                ((AbstractExternalProjectSettingsControl)externalSystemSettingsControl).setCurrentProject(this.g);
            }
            externalSystemSettingsControl.showUi(false);
        }
        this.c.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                int n2 = AbstractExternalSystemConfigurable.this.c.getSelectedIndex();
                if (n2 < 0) {
                    return;
                }
                if (AbstractExternalSystemConfigurable.this.e != null) {
                    AbstractExternalSystemConfigurable.this.e.showUi(false);
                }
                AbstractExternalSystemConfigurable.this.e = (ExternalSystemSettingsControl)AbstractExternalSystemConfigurable.this.f.get(n2);
                AbstractExternalSystemConfigurable.this.e.showUi(true);
            }
        });
        if (!this.d.isEmpty()) {
            this.c.setSelectedIndex(0);
        }
    }

    public void selectProject(@NotNull String string) {
        if (string == null) {
            AbstractExternalSystemConfigurable.a(5);
        }
        this.c.setSelectedValue((Object)this.getProjectName(string), true);
    }

    private void a(@NotNull String string) {
        if (string == null) {
            AbstractExternalSystemConfigurable.a(6);
        }
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)string, (boolean)false, (Insets)JBUI.emptyInsets()));
        this.b.add((Component)jPanel, ExternalSystemUiUtil.getFillLineConstraints(0));
    }

    @NotNull
    protected abstract ExternalSystemSettingsControl<ProjectSettings> createProjectSettingsControl(@NotNull ProjectSettings var1);

    @NotNull
    protected String getProjectName(@NotNull String string) {
        File file;
        if (string == null) {
            AbstractExternalSystemConfigurable.a(7);
        }
        String string2 = (file = new File(string)).isDirectory() || file.getParentFile() == null ? file.getName() : file.getParentFile().getName();
        if (string2 == null) {
            AbstractExternalSystemConfigurable.a(8);
        }
        return string2;
    }

    private void b(@NotNull SystemSettings SystemSettings) {
        if (SystemSettings == null) {
            AbstractExternalSystemConfigurable.a(9);
        }
        this.h = this.createSystemSettingsControl(SystemSettings);
        if (this.h != null) {
            this.a(ExternalSystemBundle.message((String)"settings.title.system.settings", (Object[])new Object[]{this.a.getReadableName()}));
            this.h.fillUi(this.b, 1);
        }
    }

    @Nullable
    protected abstract ExternalSystemSettingsControl<SystemSettings> createSystemSettingsControl(@NotNull SystemSettings var1);

    public boolean isModified() {
        for (ExternalSystemSettingsControl<ProjectSettings> externalSystemSettingsControl : this.f) {
            if (!externalSystemSettingsControl.isModified()) continue;
            return true;
        }
        return this.h != null && this.h.isModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply() throws ConfigurationException {
        SystemSettings SystemSettings = this.a();
        ExternalSystemSettingsListener externalSystemSettingsListener = SystemSettings.getPublisher();
        externalSystemSettingsListener.onBulkChangeStart();
        try {
            ArrayList arrayList = ContainerUtilRt.newArrayList();
            for (ExternalSystemSettingsControl<ProjectSettings> externalSystemSettingsControl : this.f) {
                ProjectSettings ProjectSettings = this.newProjectSettings();
                externalSystemSettingsControl.apply(ProjectSettings);
                arrayList.add(ProjectSettings);
            }
            SystemSettings.setLinkedProjectsSettings((Collection)arrayList);
            for (ExternalSystemSettingsControl<ProjectSettings> externalSystemSettingsControl : this.f) {
                if (!(externalSystemSettingsControl instanceof AbstractExternalProjectSettingsControl)) continue;
                ((AbstractExternalProjectSettingsControl)AbstractExternalProjectSettingsControl.class.cast(externalSystemSettingsControl)).updateInitialSettings();
            }
            if (this.h != null) {
                this.h.apply(SystemSettings);
            }
        }
        finally {
            externalSystemSettingsListener.onBulkChangeEnd();
        }
    }

    @NotNull
    protected abstract ProjectSettings newProjectSettings();

    public void reset() {
        for (ExternalSystemSettingsControl<ProjectSettings> externalSystemSettingsControl : this.f) {
            externalSystemSettingsControl.reset();
        }
        if (this.h != null) {
            this.h.reset();
        }
    }

    public void disposeUIResources() {
        for (ExternalSystemSettingsControl<ProjectSettings> externalSystemSettingsControl : this.f) {
            externalSystemSettingsControl.disposeUIResources();
        }
        this.f.clear();
        this.b = null;
        this.c = null;
        this.d = null;
        this.h = null;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/settings/AbstractExternalSystemConfigurable";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkedProjectPath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/settings/AbstractExternalSystemConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "prepareProjectSettings";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "selectProject";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addTitle";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getProjectName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "prepareSystemSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

