/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.settings;

import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.ide.util.projectWizard.NamePathComponent;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListener;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemSettingsControl;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.externalSystem.util.PaintAwarePanel;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.projectImport.ProjectFormatPanel;
import com.intellij.ui.HideableTitledPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractImportFromExternalSystemControl<ProjectSettings extends ExternalProjectSettings, L extends ExternalSystemSettingsListener<ProjectSettings>, SystemSettings extends AbstractExternalSystemSettings<SystemSettings, ProjectSettings, L>> {
    @NotNull
    private final SystemSettings f;
    @NotNull
    private final ProjectSettings j;
    @NotNull
    private final PaintAwarePanel k;
    @NotNull
    private final NamePathComponent a;
    @Nullable
    private final HideableTitledPanel h;
    @NotNull
    private final ProjectFormatPanel d;
    @NotNull
    private final ExternalSystemSettingsControl<ProjectSettings> b;
    @NotNull
    private final ProjectSystemId c;
    @Nullable
    private final ExternalSystemSettingsControl<SystemSettings> i;
    @Nullable
    Project myCurrentProject;
    private boolean g;
    private final JLabel e;

    protected AbstractImportFromExternalSystemControl(@NotNull ProjectSystemId projectSystemId, @NotNull SystemSettings SystemSettings, @NotNull ProjectSettings ProjectSettings) {
        if (projectSystemId == null) {
            AbstractImportFromExternalSystemControl.a(0);
        }
        if (SystemSettings == null) {
            AbstractImportFromExternalSystemControl.a(1);
        }
        if (ProjectSettings == null) {
            AbstractImportFromExternalSystemControl.a(2);
        }
        this(projectSystemId, SystemSettings, ProjectSettings, false);
    }

    protected AbstractImportFromExternalSystemControl(@NotNull ProjectSystemId projectSystemId, @NotNull SystemSettings SystemSettings, @NotNull ProjectSettings ProjectSettings, boolean bl2) {
        if (projectSystemId == null) {
            AbstractImportFromExternalSystemControl.a(3);
        }
        if (SystemSettings == null) {
            AbstractImportFromExternalSystemControl.a(4);
        }
        if (ProjectSettings == null) {
            AbstractImportFromExternalSystemControl.a(5);
        }
        this.k = new PaintAwarePanel(new GridBagLayout());
        this.c = projectSystemId;
        this.f = SystemSettings;
        this.j = ProjectSettings;
        this.b = this.createProjectSettingsControl(ProjectSettings);
        this.i = this.createSystemSettingsControl(SystemSettings);
        this.g = bl2;
        String string = ExternalSystemBundle.message((String)"settings.label.select.project", (Object[])new Object[]{projectSystemId.getReadableName()});
        ExternalSystemManager externalSystemManager = ExternalSystemApiUtil.getManager((ProjectSystemId)projectSystemId);
        assert (externalSystemManager != null);
        this.a = new NamePathComponent("", string, string, "", false, false);
        this.a.setNameComponentVisible(false);
        this.a.setNameValue("untitled");
        FileChooserDescriptor fileChooserDescriptor = externalSystemManager.getExternalProjectDescriptor();
        BrowseFilesListener browseFilesListener = new BrowseFilesListener(this.a.getPathComponent(), string, "", fileChooserDescriptor);
        this.a.getPathPanel().setBrowseButtonActionListener((ActionListener)browseFilesListener);
        this.a.getPathComponent().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                AbstractImportFromExternalSystemControl.this.onLinkedProjectPathChange(AbstractImportFromExternalSystemControl.this.a.getPath());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                AbstractImportFromExternalSystemControl.this.onLinkedProjectPathChange(AbstractImportFromExternalSystemControl.this.a.getPath());
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                AbstractImportFromExternalSystemControl.this.onLinkedProjectPathChange(AbstractImportFromExternalSystemControl.this.a.getPath());
            }
        });
        this.k.add((Component)this.a, ExternalSystemUiUtil.getFillLineConstraints(0));
        this.b.fillUi(this.k, 0);
        this.d = new ProjectFormatPanel();
        this.e = new JLabel(ExternalSystemBundle.message((String)"settings.label.project.format", (Object[])new Object[0]));
        this.k.add((Component)this.e, ExternalSystemUiUtil.getLabelConstraints(0));
        this.k.add((Component)this.d.getStorageFormatComboBox(), ExternalSystemUiUtil.getFillLineConstraints(0));
        if (this.i != null) {
            PaintAwarePanel paintAwarePanel = new PaintAwarePanel();
            this.i.fillUi(paintAwarePanel, 0);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)paintAwarePanel, "Center");
            this.h = new HideableTitledPanel(ExternalSystemBundle.message((String)"settings.title.system.settings", (Object[])new Object[]{this.c.getReadableName()}), false);
            this.h.setContentComponent((JComponent)jPanel);
            this.h.setOn(false);
            this.k.add((Component)this.h, ExternalSystemUiUtil.getFillLineConstraints(0));
        } else {
            this.h = null;
        }
        ExternalSystemUiUtil.fillBottom(this.k);
    }

    public void setCurrentProject(@Nullable Project project2) {
        this.myCurrentProject = project2;
    }

    protected abstract void onLinkedProjectPathChange(@NotNull String var1);

    @NotNull
    protected abstract ExternalSystemSettingsControl<ProjectSettings> createProjectSettingsControl(@NotNull ProjectSettings var1);

    @Nullable
    protected abstract ExternalSystemSettingsControl<SystemSettings> createSystemSettingsControl(@NotNull SystemSettings var1);

    @NotNull
    public JComponent getComponent() {
        PaintAwarePanel paintAwarePanel = this.k;
        if (paintAwarePanel == null) {
            AbstractImportFromExternalSystemControl.a(6);
        }
        return paintAwarePanel;
    }

    @NotNull
    public ExternalSystemSettingsControl<ProjectSettings> getProjectSettingsControl() {
        ExternalSystemSettingsControl<ProjectSettings> externalSystemSettingsControl = this.b;
        if (externalSystemSettingsControl == null) {
            AbstractImportFromExternalSystemControl.a(7);
        }
        return externalSystemSettingsControl;
    }

    @Nullable
    public ExternalSystemSettingsControl<SystemSettings> getSystemSettingsControl() {
        return this.i;
    }

    public void setLinkedProjectPath(@NotNull String string) {
        if (string == null) {
            AbstractImportFromExternalSystemControl.a(8);
        }
        this.j.setExternalProjectPath(string);
        this.a.setPath(string);
    }

    @NotNull
    public SystemSettings getSystemSettings() {
        SystemSettings SystemSettings = this.f;
        if (SystemSettings == null) {
            AbstractImportFromExternalSystemControl.a(9);
        }
        return SystemSettings;
    }

    @NotNull
    public ProjectSettings getProjectSettings() {
        ProjectSettings ProjectSettings = this.j;
        if (ProjectSettings == null) {
            AbstractImportFromExternalSystemControl.a(10);
        }
        return ProjectSettings;
    }

    public void setShowProjectFormatPanel(boolean bl2) {
        this.g = bl2;
    }

    public void reset() {
        this.reset(null);
    }

    public void reset(@Nullable WizardContext wizardContext) {
        this.a.setNameComponentVisible(false);
        this.a.setNameValue("untitled");
        this.a.setPath("");
        this.b.reset(wizardContext);
        if (this.i != null) {
            this.i.reset(wizardContext);
        }
        if (this.h != null) {
            this.h.setOn(false);
        }
        this.e.setVisible(this.g);
        this.d.setVisible(this.g);
        this.d.getPanel().setVisible(this.g);
        this.d.getStorageFormatComboBox().setVisible(this.g);
    }

    public void apply() {
        String string = this.a.getPath();
        this.j.setExternalProjectPath(ExternalSystemApiUtil.normalizePath((String)string));
        this.b.apply(this.j);
        if (this.i != null) {
            this.i.apply(this.f);
        }
    }

    @Nullable
    public ProjectFormatPanel getProjectFormatPanel() {
        return this.g ? this.d : null;
    }

    public boolean validate(WizardContext wizardContext, boolean bl2) throws ConfigurationException {
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return true;
        }
        if (!this.b.validate(this.j)) {
            return false;
        }
        if (this.i != null && !this.i.validate(this.f)) {
            return false;
        }
        String string = this.a.getPath();
        if (StringUtil.isEmpty((String)string)) {
            throw new ConfigurationException(ExternalSystemBundle.message((String)"error.project.undefined", (Object[])new Object[0]));
        }
        if (this.myCurrentProject != null) {
            ExternalSystemManager externalSystemManager = ExternalSystemApiUtil.getManager((ProjectSystemId)this.c);
            assert (externalSystemManager != null);
            AbstractExternalSystemSettings abstractExternalSystemSettings = (AbstractExternalSystemSettings)externalSystemManager.getSettingsProvider().fun((Object)this.myCurrentProject);
            if (abstractExternalSystemSettings.getLinkedProjectSettings(string) != null) {
                throw new ConfigurationException(ExternalSystemBundle.message((String)"error.project.already.registered", (Object[])new Object[0]));
            }
        }
        return !wizardContext.isCreatingNewProject() || this.a.validateNameAndPath(wizardContext, bl2);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemSettings";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSettings";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/settings/AbstractImportFromExternalSystemControl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/settings/AbstractImportFromExternalSystemControl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectSettingsControl";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemSettings";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectSettings";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setLinkedProjectPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

