/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.view.ExternalProjectsStructure;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalProjectsViewAdapter;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleNodeVisitor;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.InputEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectExternalSystemNodeDialog
extends DialogWrapper {
    @NotNull
    private final SimpleTree a;
    @Nullable
    private final NodeSelector b;
    @Nullable
    protected Boolean groupTasks;
    @Nullable
    protected Boolean useTasksNode;

    public SelectExternalSystemNodeDialog(@NotNull ProjectSystemId projectSystemId, @NotNull Project project2, @NotNull String string, Class<? extends ExternalSystemNode> clazz, @Nullable NodeSelector nodeSelector) {
        if (projectSystemId == null) {
            SelectExternalSystemNodeDialog.a(0);
        }
        if (project2 == null) {
            SelectExternalSystemNodeDialog.a(1);
        }
        if (string == null) {
            SelectExternalSystemNodeDialog.a(2);
        }
        this(projectSystemId, project2, string, new Class[]{clazz}, nodeSelector);
    }

    public SelectExternalSystemNodeDialog(@NotNull ProjectSystemId projectSystemId, @NotNull Project project2, @NotNull String string, final Class<? extends ExternalSystemNode>[] classArray, @Nullable NodeSelector nodeSelector) {
        if (projectSystemId == null) {
            SelectExternalSystemNodeDialog.a(3);
        }
        if (project2 == null) {
            SelectExternalSystemNodeDialog.a(4);
        }
        if (string == null) {
            SelectExternalSystemNodeDialog.a(5);
        }
        super(project2, false);
        this.b = nodeSelector;
        this.setTitle(string);
        this.a = new SimpleTree();
        this.a.getSelectionModel().setSelectionMode(1);
        ExternalProjectsView externalProjectsView = ExternalProjectsManagerImpl.getInstance(project2).getExternalProjectsView(projectSystemId);
        if (externalProjectsView != null) {
            final ExternalProjectsStructure externalProjectsStructure = new ExternalProjectsStructure(project2, this.a){

                @Override
                protected Class<? extends ExternalSystemNode>[] getVisibleNodesClasses() {
                    return classArray;
                }

                @Override
                public Object getRootElement() {
                    Object object = super.getRootElement();
                    return SelectExternalSystemNodeDialog.this.customizeProjectsTreeRoot(object);
                }
            };
            Disposer.register((Disposable)this.myDisposable, (Disposable)externalProjectsStructure);
            externalProjectsStructure.init(new ExternalProjectsViewAdapter(externalProjectsView){

                @Override
                @Nullable
                public ExternalProjectsStructure getStructure() {
                    return externalProjectsStructure;
                }

                @Override
                public void updateUpTo(ExternalSystemNode externalSystemNode) {
                    externalProjectsStructure.updateUpTo(externalSystemNode);
                }

                @Override
                public boolean getGroupTasks() {
                    return SelectExternalSystemNodeDialog.this.groupTasks != null ? SelectExternalSystemNodeDialog.this.groupTasks.booleanValue() : super.getGroupTasks();
                }

                @Override
                public boolean useTasksNode() {
                    return SelectExternalSystemNodeDialog.this.useTasksNode != null ? SelectExternalSystemNodeDialog.this.useTasksNode.booleanValue() : super.useTasksNode();
                }

                @Override
                public void handleDoubleClickOrEnter(@NotNull ExternalSystemNode externalSystemNode, @Nullable String string, InputEvent inputEvent) {
                    if (externalSystemNode == null) {
                        2.b(0);
                    }
                    SelectExternalSystemNodeDialog.this.handleDoubleClickOrEnter(externalSystemNode, string, inputEvent);
                }

                private static /* synthetic */ void b(int n2) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/externalSystem/service/ui/SelectExternalSystemNodeDialog$2", "handleDoubleClickOrEnter"));
                }
            });
            Collection collection = ProjectDataManager.getInstance().getExternalProjectsData(project2, projectSystemId);
            List list2 = ContainerUtil.mapNotNull((Collection)collection, externalProjectInfo -> externalProjectInfo.getExternalProjectStructure());
            externalProjectsStructure.updateProjects(list2);
            TreeUtil.expandAll((JTree)this.a);
            if (this.b != null) {
                final SimpleNode[] simpleNodeArray = new SimpleNode[]{null};
                externalProjectsStructure.accept(new SimpleNodeVisitor(){

                    public boolean accept(SimpleNode simpleNode) {
                        if (!SelectExternalSystemNodeDialog.this.b.shouldSelect(simpleNode)) {
                            return false;
                        }
                        simpleNodeArray[0] = simpleNode;
                        return true;
                    }
                });
                if (simpleNodeArray[0] != null) {
                    externalProjectsStructure.select(simpleNodeArray[0]);
                }
            }
        }
        this.init();
    }

    protected Object customizeProjectsTreeRoot(Object object) {
        return object;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.a;
    }

    protected void handleDoubleClickOrEnter(@NotNull ExternalSystemNode externalSystemNode, @Nullable String string, InputEvent inputEvent) {
        if (externalSystemNode == null) {
            SelectExternalSystemNodeDialog.a(6);
        }
    }

    protected SimpleNode getSelectedNode() {
        return this.a.getNodeFor(this.a.getSelectionPath());
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)this.a);
        jScrollPane.setPreferredSize((Dimension)JBUI.size((int)320, (int)400));
        return jScrollPane;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemId";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/service/ui/SelectExternalSystemNodeDialog";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "handleDoubleClickOrEnter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static interface NodeSelector {
        public boolean shouldSelect(SimpleNode var1);
    }
}

