/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.view;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractDependencyData;
import com.intellij.openapi.externalSystem.model.project.DependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.OrderAware;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProviderImpl;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.externalSystem.view.ExternalProjectsStructure;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.ExternalSystemViewContributor;
import com.intellij.openapi.externalSystem.view.ModuleNode;
import com.intellij.openapi.externalSystem.view.TasksNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemViewDefaultContributor
extends ExternalSystemViewContributor {
    private static final Key<?>[] a = new Key[]{ProjectKeys.MODULE, ProjectKeys.MODULE_DEPENDENCY, ProjectKeys.LIBRARY_DEPENDENCY, ProjectKeys.TASK};

    @Override
    @NotNull
    public ProjectSystemId getSystemId() {
        ProjectSystemId projectSystemId = ProjectSystemId.IDE;
        if (projectSystemId == null) {
            ExternalSystemViewDefaultContributor.a(0);
        }
        return projectSystemId;
    }

    @Override
    @NotNull
    public List<Key<?>> getKeys() {
        List<Key<?>> list2 = Arrays.asList(a);
        if (list2 == null) {
            ExternalSystemViewDefaultContributor.a(1);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<ExternalSystemNode<?>> createNodes(ExternalProjectsView externalProjectsView, MultiMap<Key<?>, DataNode<?>> multiMap) {
        SmartList smartList = new SmartList();
        ExternalSystemViewDefaultContributor.a(externalProjectsView, multiMap, smartList);
        Collection collection = multiMap.get((Object)ProjectKeys.TASK);
        if (!collection.isEmpty()) {
            TasksNode tasksNode = new TasksNode(externalProjectsView, collection);
            if (externalProjectsView.useTasksNode()) {
                smartList.add(tasksNode);
            } else {
                ContainerUtil.addAll((Collection)smartList, (Object[])tasksNode.getChildren());
            }
        }
        ExternalSystemViewDefaultContributor.b(externalProjectsView, multiMap, smartList);
        SmartList smartList2 = smartList;
        if (smartList2 == null) {
            ExternalSystemViewDefaultContributor.a(2);
        }
        return smartList2;
    }

    private static void b(@NotNull ExternalProjectsView externalProjectsView, @NotNull MultiMap<Key<?>, DataNode<?>> multiMap, @NotNull List<ExternalSystemNode<?>> list2) {
        if (externalProjectsView == null) {
            ExternalSystemViewDefaultContributor.a(3);
        }
        if (multiMap == null) {
            ExternalSystemViewDefaultContributor.a(4);
        }
        if (list2 == null) {
            ExternalSystemViewDefaultContributor.a(5);
        }
        Collection collection = multiMap.get((Object)ProjectKeys.MODULE_DEPENDENCY);
        Collection collection2 = multiMap.get((Object)ProjectKeys.LIBRARY_DEPENDENCY);
        if (!collection.isEmpty() || !collection2.isEmpty()) {
            DependencyDataExternalSystemNode dependencyDataExternalSystemNode;
            MyDependenciesNode myDependenciesNode = new MyDependenciesNode(externalProjectsView);
            for (DataNode dataNode : collection) {
                if (!(dataNode.getData() instanceof ModuleDependencyData)) continue;
                dependencyDataExternalSystemNode = new ModuleDependencyDataExternalSystemNode(externalProjectsView, (DataNode<ModuleDependencyData>)dataNode);
                if (dataNode.getParent() != null && dataNode.getParent().getData() instanceof AbstractDependencyData) {
                    list2.add(dependencyDataExternalSystemNode);
                    continue;
                }
                myDependenciesNode.add(dependencyDataExternalSystemNode);
            }
            for (DataNode dataNode : collection2) {
                if (!(dataNode.getData() instanceof LibraryDependencyData)) continue;
                dependencyDataExternalSystemNode = new LibraryDependencyDataExternalSystemNode(externalProjectsView, (DataNode<LibraryDependencyData>)dataNode);
                if (((LibraryData)((LibraryDependencyData)dataNode.getData()).getTarget()).isUnresolved()) {
                    dependencyDataExternalSystemNode.setErrorLevel(ExternalProjectsStructure.ErrorLevel.ERROR, "Unable to resolve " + ((LibraryData)((LibraryDependencyData)dataNode.getData()).getTarget()).getExternalName());
                } else {
                    dependencyDataExternalSystemNode.setErrorLevel(ExternalProjectsStructure.ErrorLevel.NONE, new String[0]);
                }
                if (dataNode.getParent() != null && dataNode.getParent().getData() instanceof ModuleData) {
                    myDependenciesNode.add(dependencyDataExternalSystemNode);
                    continue;
                }
                list2.add(dependencyDataExternalSystemNode);
            }
            if (myDependenciesNode.hasChildren()) {
                list2.add(myDependenciesNode);
            }
        }
    }

    private static void a(@NotNull ExternalProjectsView externalProjectsView, @NotNull MultiMap<Key<?>, DataNode<?>> multiMap, @NotNull List<ExternalSystemNode<?>> list2) {
        Collection collection;
        if (externalProjectsView == null) {
            ExternalSystemViewDefaultContributor.a(6);
        }
        if (multiMap == null) {
            ExternalSystemViewDefaultContributor.a(7);
        }
        if (list2 == null) {
            ExternalSystemViewDefaultContributor.a(8);
        }
        if (!(collection = multiMap.get((Object)ProjectKeys.MODULE)).isEmpty()) {
            AbstractExternalSystemSettings abstractExternalSystemSettings = ExternalSystemApiUtil.getSettings((Project)externalProjectsView.getProject(), (ProjectSystemId)externalProjectsView.getSystemId());
            for (DataNode dataNode : collection) {
                ModuleData moduleData = (ModuleData)dataNode.getData();
                ExternalProjectSettings externalProjectSettings = abstractExternalSystemSettings.getLinkedProjectSettings(moduleData.getLinkedExternalProjectPath());
                DataNode dataNode2 = ExternalSystemApiUtil.findParent((DataNode)dataNode, (Key)ProjectKeys.PROJECT);
                boolean bl2 = externalProjectSettings != null && moduleData.getLinkedExternalProjectPath().equals(externalProjectSettings.getExternalProjectPath()) && dataNode2 != null && ((ProjectData)dataNode2.getData()).getInternalName().equals(moduleData.getInternalName());
                ModuleNode moduleNode = new ModuleNode(externalProjectsView, (DataNode<ModuleData>)dataNode, bl2);
                list2.add(moduleNode);
            }
        }
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/view/ExternalSystemViewDefaultContributor";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectsView";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataNodes";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeys";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createNodes";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/view/ExternalSystemViewDefaultContributor";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addDependenciesNode";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addModuleNodes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LibraryDependencyDataExternalSystemNode
    extends DependencyDataExternalSystemNode<LibraryDependencyData> {
        public LibraryDependencyDataExternalSystemNode(ExternalProjectsView externalProjectsView, DataNode<LibraryDependencyData> dataNode) {
            super(externalProjectsView, null, dataNode);
        }

        protected void update(PresentationData presentationData) {
            super.update(presentationData);
            presentationData.setIcon(AllIcons.Nodes.PpLib);
            LibraryDependencyData libraryDependencyData = (LibraryDependencyData)this.getData();
            if (libraryDependencyData != null) {
                this.setNameAndTooltip(this.getName(), null, libraryDependencyData.getScope().getDisplayName());
            }
        }

        public String getName() {
            LibraryDependencyData libraryDependencyData = (LibraryDependencyData)this.getData();
            if (libraryDependencyData == null) {
                return "";
            }
            String string = libraryDependencyData.getExternalName();
            if (StringUtil.isEmpty((String)string)) {
                Set set = ((LibraryData)libraryDependencyData.getTarget()).getPaths(LibraryPathType.BINARY);
                if (set.size() == 1) {
                    String string2 = null;
                    String string3 = ExternalSystemApiUtil.toCanonicalPath((String)((String)set.iterator().next()));
                    DataNode dataNode = ExternalSystemApiUtil.findParent((DataNode)this.myDataNode, (Key)ProjectKeys.PROJECT);
                    if (dataNode != null) {
                        string2 = FileUtil.getRelativePath((String)((ProjectData)dataNode.getData()).getLinkedExternalProjectPath(), (String)string3, (char)'/');
                        string2 = string2 != null && StringUtil.startsWith((CharSequence)string2, (CharSequence)"../../") ? new File(string2).getName() : string2;
                    }
                    return (String)ObjectUtils.notNull(string2, (Object)string3);
                }
                return "<file set>";
            }
            return string;
        }
    }

    private static class ModuleDependencyDataExternalSystemNode
    extends DependencyDataExternalSystemNode<ModuleDependencyData> {
        public ModuleDependencyDataExternalSystemNode(ExternalProjectsView externalProjectsView, DataNode<ModuleDependencyData> dataNode) {
            super(externalProjectsView, null, dataNode);
        }

        protected void update(PresentationData presentationData) {
            super.update(presentationData);
            presentationData.setIcon(this.getUiAware().getProjectIcon());
            ModuleDependencyData moduleDependencyData = (ModuleDependencyData)this.getData();
            if (moduleDependencyData != null) {
                this.setNameAndTooltip(this.getName(), null, moduleDependencyData.getScope().getDisplayName());
            }
        }

        public String getName() {
            ModuleDependencyData moduleDependencyData = (ModuleDependencyData)this.getData();
            return moduleDependencyData != null ? moduleDependencyData.getExternalName() : "";
        }
    }

    private static abstract class DependencyDataExternalSystemNode<T extends DependencyData>
    extends ExternalSystemNode<T> {
        public DependencyDataExternalSystemNode(@NotNull ExternalProjectsView externalProjectsView, @Nullable ExternalSystemNode externalSystemNode, @Nullable DataNode<T> dataNode) {
            if (externalProjectsView == null) {
                DependencyDataExternalSystemNode.b(0);
            }
            super(externalProjectsView, externalSystemNode, dataNode);
        }

        @Override
        @Nullable
        public Navigatable getNavigatable() {
            return new Navigatable(){
                @Nullable
                private OrderEntry a;

                public void navigate(boolean bl2) {
                    if (this.a != null) {
                        ProjectSettingsService.getInstance((Project)myProject).openModuleDependenciesSettings(this.a.getOwnerModule(), this.a);
                    }
                }

                public boolean canNavigate() {
                    this.a = this.a();
                    return this.a != null;
                }

                public boolean canNavigateToSource() {
                    return true;
                }
            };
        }

        @Nullable
        private OrderEntry a() {
            DependencyData dependencyData = (DependencyData)this.getData();
            if (dependencyData == null) {
                return null;
            }
            Project project2 = this.getProject();
            if (project2 == null) {
                return null;
            }
            return new IdeModelsProviderImpl(project2).findIdeModuleOrderEntry(dependencyData);
        }

        @Override
        public int compareTo(@NotNull ExternalSystemNode externalSystemNode) {
            int n2;
            int n3;
            if (externalSystemNode == null) {
                DependencyDataExternalSystemNode.b(1);
            }
            DependencyData dependencyData = (DependencyData)this.getData();
            Object t2 = externalSystemNode.getData();
            if (dependencyData instanceof OrderAware && t2 instanceof OrderAware && (n3 = ((OrderAware)dependencyData).getOrder()) != (n2 = ((OrderAware)t2).getOrder())) {
                return n3 < n2 ? -1 : 1;
            }
            String string = DependencyDataExternalSystemNode.a(this);
            String string2 = DependencyDataExternalSystemNode.a(externalSystemNode);
            return StringUtil.compare((String)string, (String)string2, (boolean)true);
        }

        @NotNull
        private static String a(@NotNull ExternalSystemNode externalSystemNode) {
            Set set;
            LibraryDependencyData libraryDependencyData;
            String string;
            Object t2;
            if (externalSystemNode == null) {
                DependencyDataExternalSystemNode.b(2);
            }
            if ((t2 = externalSystemNode.getData()) instanceof LibraryDependencyData && StringUtil.isEmpty((String)(string = (libraryDependencyData = (LibraryDependencyData)t2).getExternalName())) && (set = ((LibraryData)libraryDependencyData.getTarget()).getPaths(LibraryPathType.BINARY)).size() == 1) {
                String string2 = new File((String)set.iterator().next()).getName();
                if (string2 == null) {
                    DependencyDataExternalSystemNode.b(3);
                }
                return string2;
            }
            String string3 = externalSystemNode.getName();
            if (string3 == null) {
                DependencyDataExternalSystemNode.b(4);
            }
            return string3;
        }

        private static /* synthetic */ void b(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "externalProjectsView";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/externalSystem/view/ExternalSystemViewDefaultContributor$DependencyDataExternalSystemNode";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/externalSystem/view/ExternalSystemViewDefaultContributor$DependencyDataExternalSystemNode";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDependencySimpleName";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getDependencySimpleName";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @Order(value=20)
    private static class MyDependenciesNode
    extends ExternalSystemNode {
        public MyDependenciesNode(ExternalProjectsView externalProjectsView) {
            super(externalProjectsView, null, null);
        }

        protected void update(PresentationData presentationData) {
            super.update(presentationData);
            presentationData.setIcon(AllIcons.Nodes.PpLibFolder);
        }

        public String getName() {
            return "Dependencies";
        }
    }
}

