/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.builder;

import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.builder.util.NodeFactory;
import com.intellij.openapi.graph.impl.builder.GraphBuilderImpl;
import com.intellij.openapi.graph.impl.builder.GraphDataMaps;
import com.intellij.openapi.graph.impl.builder.GraphImplUtil;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import java.awt.Point;

public class NodeFactoryImpl
extends NodeFactory {
    public <N, E> Node createNode(GraphBuilder<N, E> graphBuilder, N n2, String string) {
        Graph2D graph2D = graphBuilder.getGraph();
        Graph2DView graph2DView = graphBuilder.getView();
        GraphDataMaps graphDataMaps = ((GraphBuilderImpl)graphBuilder).getDataMaps();
        Node node = GraphImplUtil.createNode((Graph)graph2D, graphDataMaps, string, n2);
        GraphImplUtil.setNodeObject(graphDataMaps, node, n2);
        graphBuilder.getGraph().setRealizer(node, graphBuilder.getGraphPresentationModel().getNodeRealizer(n2));
        GraphViewUtil.setRenderedNodeSizes((Graph2D)graph2D, (Graph2DView)graph2DView, (Node)node);
        return node;
    }

    public <N, E> Node createNode(GraphBuilder<N, E> graphBuilder, N n2, String string, Point point) {
        Graph2D graph2D = graphBuilder.getGraph();
        Graph2DView graph2DView = graphBuilder.getView();
        Node node = this.createNode(graphBuilder, n2, string);
        graph2D.setLocation(node, graph2DView.toWorldCoordX((int)point.getX()), graph2DView.toWorldCoordY((int)point.getY()));
        return node;
    }

    public <N, E> Node createDraggedNode(GraphBuilder<N, E> graphBuilder, N n2, String string, Point point) {
        Node node = this.createNode(graphBuilder, n2, string, point);
        GraphBuilderImpl graphBuilderImpl = (GraphBuilderImpl)graphBuilder;
        GraphImplUtil.setNodeWasDragged(graphBuilderImpl.getDataMaps(), node);
        graphBuilder.updateGraph();
        return node;
    }
}

