/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.ui;

import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.SdkEditorAdditionalOptionsProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.projectRoots.ui.PathEditor;
import com.intellij.openapi.projectRoots.ui.SdkPathEditor;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ui.OrderRootTypeUIFactory;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkEditor
implements Configurable,
Place.Navigator {
    private static final Logger l = Logger.getInstance((String)"#com.intellij.openapi.projectRoots.ui.SdkEditor");
    private static final String q = "sdkTab";
    private Sdk h;
    private final Map<OrderRootType, SdkPathEditor> a = new HashMap<OrderRootType, SdkPathEditor>();
    private TextFieldWithBrowseButton d;
    private final Map<SdkType, List<AdditionalDataConfigurable>> m = new HashMap<SdkType, List<AdditionalDataConfigurable>>();
    private final Map<AdditionalDataConfigurable, JComponent> k = new HashMap<AdditionalDataConfigurable, JComponent>();
    private JPanel j;
    private final SdkModificator r = new EditedSdkModificator();
    private JPanel g;
    private TabbedPaneWrapper e;
    private final Project s;
    private final SdkModel b;
    private JLabel o;
    private String p;
    private String i;
    private String f;
    private final History c;
    private final Disposable n = Disposer.newDisposable();

    public SdkEditor(Project project2, SdkModel sdkModel, History history, ProjectJdkImpl projectJdkImpl) {
        this.s = project2;
        this.b = sdkModel;
        this.c = history;
        this.h = projectJdkImpl;
        this.c();
        this.b((Sdk)projectJdkImpl);
    }

    private void b(Sdk sdk) {
        this.h = sdk;
        if (this.h != null) {
            this.i = this.h.getName();
            this.f = this.h.getHomePath();
        } else {
            this.i = "";
            this.f = "";
        }
        for (AdditionalDataConfigurable additionalDataConfigurable : this.b()) {
            additionalDataConfigurable.setSdk(sdk);
        }
        if (this.g != null) {
            this.reset();
        }
    }

    public String getDisplayName() {
        return ProjectBundle.message((String)"sdk.configure.editor.title", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return null;
    }

    public JComponent createComponent() {
        return this.g;
    }

    private void c() {
        this.g = new JPanel(new GridBagLayout());
        this.e = new TabbedPaneWrapper(this.n);
        for (OrderRootType orderRootType : OrderRootType.getAllTypes()) {
            SdkPathEditor sdkPathEditor;
            if (this.h != null && !this.showTabForType(orderRootType) || (sdkPathEditor = ((OrderRootTypeUIFactory)OrderRootTypeUIFactory.FACTORY.getByKey((Object)orderRootType)).createPathEditor(this.h)) == null) continue;
            sdkPathEditor.setAddBaseDir(this.h.getHomeDirectory());
            this.e.addTab(sdkPathEditor.getDisplayName(), sdkPathEditor.createComponent());
            this.a.put(orderRootType, sdkPathEditor);
        }
        this.e.addChangeListener(changeEvent -> this.c.pushQueryPlace());
        this.d = this.createHomeComponent();
        this.d.getTextField().setEditable(false);
        this.o = new JLabel(this.f());
        this.g.add((Component)this.o, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, (Insets)JBUI.insets((int)2, (int)10, (int)2, (int)2), 0, 0));
        this.g.add((Component)this.d, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 10, 2, (Insets)JBUI.insets((int)2, (int)2, (int)2, (int)10), 0, 0));
        this.j = new JPanel(new BorderLayout());
        this.g.add((Component)this.j, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 10, 1, (Insets)JBUI.insets((int)2, (int)10, (int)0, (int)10), 0, 0));
        this.g.add((Component)this.e.getComponent(), new GridBagConstraints(0, -1, 2, 1, 1.0, 1.0, 10, 1, (Insets)JBUI.insetsTop((int)2), 0, 0));
    }

    protected TextFieldWithBrowseButton createHomeComponent() {
        return new TextFieldWithBrowseButton(actionEvent -> this.g());
    }

    protected boolean showTabForType(@NotNull OrderRootType orderRootType) {
        if (orderRootType == null) {
            SdkEditor.a(0);
        }
        return ((SdkType)this.h.getSdkType()).isRootTypeApplicable(orderRootType);
    }

    private String f() {
        return this.h != null ? ((SdkType)this.h.getSdkType()).getHomeFieldLabel() : ProjectBundle.message((String)"sdk.configure.general.home.path", (Object[])new Object[0]);
    }

    public boolean isModified() {
        boolean bl2 = !Comparing.equal((String)(this.h == null ? null : this.h.getName()), (String)this.i);
        bl2 = bl2 || !Comparing.equal((String)FileUtil.toSystemIndependentName((String)this.e()), (String)FileUtil.toSystemIndependentName((String)this.f));
        for (PathEditor pathEditor : this.a.values()) {
            bl2 = bl2 || pathEditor.isModified();
        }
        for (AdditionalDataConfigurable additionalDataConfigurable : this.b()) {
            bl2 = bl2 || additionalDataConfigurable.isModified();
        }
        return bl2;
    }

    public void apply() throws ConfigurationException {
        if (!Comparing.equal((String)this.i, (String)(this.h == null ? "" : this.h.getName())) && (this.h == null || this.h.getName().isEmpty())) {
            throw new ConfigurationException(ProjectBundle.message((String)"sdk.list.name.required.error", (Object[])new Object[0]));
        }
        if (this.h != null) {
            this.i = this.h.getName();
            this.f = this.h.getHomePath();
            SdkModificator sdkModificator = this.h.getSdkModificator();
            sdkModificator.setHomePath(FileUtil.toSystemDependentName((String)this.e()));
            for (SdkPathEditor sdkPathEditor : this.a.values()) {
                sdkPathEditor.apply(sdkModificator);
            }
            ApplicationManager.getApplication().runWriteAction(() -> ((SdkModificator)sdkModificator).commitChanges());
            for (AdditionalDataConfigurable additionalDataConfigurable : this.b()) {
                if (additionalDataConfigurable == null) continue;
                additionalDataConfigurable.apply();
            }
        }
    }

    public void reset() {
        if (this.h == null) {
            this.a("");
            for (SdkPathEditor sdkPathEditor : this.a.values()) {
                sdkPathEditor.reset(null);
            }
        } else {
            SdkModificator sdkModificator = this.h.getSdkModificator();
            for (OrderRootType orderRootType : this.a.keySet()) {
                this.a.get(orderRootType).reset(sdkModificator);
            }
            sdkModificator.commitChanges();
            this.a(FileUtil.toSystemDependentName((String)((String)ObjectUtils.notNull((Object)this.h.getHomePath(), (Object)""))));
        }
        this.p = null;
        this.o.setText(this.f());
        this.d();
        for (AdditionalDataConfigurable additionalDataConfigurable : this.b()) {
            additionalDataConfigurable.reset();
        }
        this.d.setEnabled(this.h != null);
        for (int i2 = 0; i2 < this.e.getTabCount(); ++i2) {
            this.e.setEnabledAt(i2, this.h != null);
        }
    }

    public void disposeUIResources() {
        for (SdkType sdkType : this.m.keySet()) {
            for (AdditionalDataConfigurable additionalDataConfigurable : this.m.get(sdkType)) {
                additionalDataConfigurable.disposeUIResources();
            }
        }
        this.m.clear();
        this.k.clear();
        Disposer.dispose((Disposable)this.n);
    }

    private String e() {
        return this.d.getText().trim();
    }

    private void a() {
        for (PathEditor pathEditor : this.a.values()) {
            pathEditor.clearList();
        }
    }

    private void a(String string) {
        Color color;
        this.d.setText(string);
        if (string != null && !string.isEmpty() && this.h != null && this.h.getSdkType().isLocalSdk(this.h)) {
            File file = new File(string);
            boolean bl2 = ((SdkType)this.h.getSdkType()).getHomeChooserDescriptor().isChooseFolders();
            color = file.exists() && file.isDirectory() == bl2 ? UIUtil.getFieldForegroundColor() : PathEditor.INVALID_COLOR;
        } else {
            color = UIUtil.getFieldForegroundColor();
        }
        this.d.getTextField().setForeground(color);
    }

    private void g() {
        SdkType sdkType = (SdkType)this.h.getSdkType();
        SdkConfigurationUtil.selectSdkHome((SdkType)sdkType, string -> this.a((String)string, sdkType));
    }

    private void a(String string, SdkType sdkType) {
        if (string == null) {
            return;
        }
        this.a(string.replace('/', File.separatorChar));
        String string2 = this.b(string);
        ((ProjectJdkImpl)this.h).setName(string2);
        try {
            Sdk sdk = (Sdk)this.h.clone();
            SdkModificator sdkModificator = sdk.getSdkModificator();
            sdkModificator.setHomePath(string);
            sdkModificator.removeAllRoots();
            sdkModificator.commitChanges();
            sdkType.setupSdkPaths(sdk, this.b);
            this.a();
            this.p = sdk.getVersionString();
            if (this.p == null) {
                Messages.showMessageDialog((String)ProjectBundle.message((String)"sdk.java.corrupt.error", (Object[])new Object[]{string}), (String)ProjectBundle.message((String)"sdk.java.corrupt.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            }
            sdkModificator = sdk.getSdkModificator();
            for (OrderRootType orderRootType : this.a.keySet()) {
                SdkPathEditor sdkPathEditor = this.a.get(orderRootType);
                sdkPathEditor.setAddBaseDir(sdk.getHomeDirectory());
                sdkPathEditor.addPaths(sdkModificator.getRoots(orderRootType));
            }
            this.b.getMulticaster().sdkHomeSelected(sdk, string);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            l.error((Throwable)cloneNotSupportedException);
        }
    }

    private String b(String string) {
        Sdk[] sdkArray;
        String string2;
        String string3 = this.h.getName();
        if (Comparing.equal((String)string3, (String)(string2 = ((SdkType)this.h.getSdkType()).suggestSdkName(string3, string)))) {
            return string3;
        }
        String string4 = string2;
        HashSet<String> hashSet = new HashSet<String>();
        for (Sdk sdk : sdkArray = this.b.getSdks()) {
            hashSet.add(sdk.getName());
        }
        int n2 = 0;
        while (hashSet.contains(string4)) {
            string4 = string2 + " (" + ++n2 + ")";
        }
        return string4;
    }

    private void d() {
        this.j.removeAll();
        for (AdditionalDataConfigurable additionalDataConfigurable : this.b()) {
            JComponent jComponent = this.k.get(additionalDataConfigurable);
            if (jComponent == null) {
                jComponent = additionalDataConfigurable.createComponent();
                this.k.put(additionalDataConfigurable, jComponent);
            }
            if (jComponent == null) continue;
            if (additionalDataConfigurable.getTabName() != null) {
                for (int i2 = 0; i2 < this.e.getTabCount(); ++i2) {
                    if (!additionalDataConfigurable.getTabName().equals(this.e.getTitleAt(i2))) continue;
                    this.e.removeTabAt(i2);
                }
                this.e.addTab(additionalDataConfigurable.getTabName(), jComponent);
                continue;
            }
            this.j.add((Component)jComponent, "Center");
        }
    }

    @NotNull
    private List<AdditionalDataConfigurable> b() {
        if (this.h == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                SdkEditor.a(1);
            }
            return list2;
        }
        List<AdditionalDataConfigurable> list3 = this.a(this.h);
        if (list3 == null) {
            SdkEditor.a(2);
        }
        return list3;
    }

    @NotNull
    private List<AdditionalDataConfigurable> a(Sdk sdk) {
        SdkType sdkType = (SdkType)sdk.getSdkType();
        ArrayList arrayList = this.m.get(sdkType);
        if (arrayList == null) {
            arrayList = Lists.newArrayList();
            this.m.put(sdkType, arrayList);
            AdditionalDataConfigurable additionalDataConfigurable = sdkType.createAdditionalDataConfigurable(this.b, this.r);
            if (additionalDataConfigurable != null) {
                arrayList.add(additionalDataConfigurable);
            }
            for (SdkEditorAdditionalOptionsProvider sdkEditorAdditionalOptionsProvider : SdkEditorAdditionalOptionsProvider.getSdkOptionsFactory(this.h.getSdkType())) {
                AdditionalDataConfigurable additionalDataConfigurable2 = sdkEditorAdditionalOptionsProvider.createOptions(this.s, this.h);
                if (additionalDataConfigurable2 == null) continue;
                arrayList.add(additionalDataConfigurable2);
            }
        }
        ArrayList arrayList2 = arrayList;
        if (arrayList2 == null) {
            SdkEditor.a(3);
        }
        return arrayList2;
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean bl2) {
        if (place == null) {
            return ActionCallback.DONE;
        }
        this.e.setSelectedTitle((String)place.getPath(q));
        return ActionCallback.DONE;
    }

    public void queryPlace(@NotNull Place place) {
        if (place == null) {
            SdkEditor.a(4);
        }
        place.putPath(q, (Object)this.e.getSelectedTitle());
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/ui/SdkEditor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/ui/SdkEditor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalDataConfigurable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "initAdditionalDataConfigurable";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showTabForType";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "queryPlace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class EditedSdkModificator
    implements SdkModificator {
        private EditedSdkModificator() {
        }

        public String getName() {
            return SdkEditor.this.h.getName();
        }

        public void setName(String string) {
            ((ProjectJdkImpl)SdkEditor.this.h).setName(string);
        }

        public String getHomePath() {
            return SdkEditor.this.e();
        }

        public void setHomePath(String string) {
            SdkEditor.this.a(string, (SdkType)SdkEditor.this.h.getSdkType());
        }

        public String getVersionString() {
            return SdkEditor.this.p != null ? SdkEditor.this.p : SdkEditor.this.h.getVersionString();
        }

        public void setVersionString(String string) {
            throw new UnsupportedOperationException();
        }

        public SdkAdditionalData getSdkAdditionalData() {
            return SdkEditor.this.h.getSdkAdditionalData();
        }

        public void setSdkAdditionalData(SdkAdditionalData sdkAdditionalData) {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public VirtualFile[] getRoots(@NotNull OrderRootType orderRootType) {
            PathEditor pathEditor;
            if (orderRootType == null) {
                EditedSdkModificator.a(0);
            }
            if ((pathEditor = (PathEditor)SdkEditor.this.a.get(orderRootType)) == null) {
                throw new IllegalStateException("no editor for root type " + orderRootType);
            }
            VirtualFile[] virtualFileArray = pathEditor.getRoots();
            if (virtualFileArray == null) {
                EditedSdkModificator.a(1);
            }
            return virtualFileArray;
        }

        public void addRoot(@NotNull VirtualFile virtualFile, @NotNull OrderRootType orderRootType) {
            if (virtualFile == null) {
                EditedSdkModificator.a(2);
            }
            if (orderRootType == null) {
                EditedSdkModificator.a(3);
            }
            ((SdkPathEditor)SdkEditor.this.a.get(orderRootType)).addPaths(new VirtualFile[]{virtualFile});
        }

        public void removeRoot(@NotNull VirtualFile virtualFile, @NotNull OrderRootType orderRootType) {
            if (virtualFile == null) {
                EditedSdkModificator.a(4);
            }
            if (orderRootType == null) {
                EditedSdkModificator.a(5);
            }
            ((SdkPathEditor)SdkEditor.this.a.get(orderRootType)).removePaths(new VirtualFile[]{virtualFile});
        }

        public void removeRoots(@NotNull OrderRootType orderRootType) {
            if (orderRootType == null) {
                EditedSdkModificator.a(6);
            }
            ((SdkPathEditor)SdkEditor.this.a.get(orderRootType)).clearList();
        }

        public void removeAllRoots() {
            for (PathEditor pathEditor : SdkEditor.this.a.values()) {
                pathEditor.clearList();
            }
        }

        public void commitChanges() {
        }

        public boolean isWritable() {
            return true;
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/projectRoots/ui/SdkEditor$EditedSdkModificator";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/projectRoots/ui/SdkEditor$EditedSdkModificator";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRoots";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getRoots";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "addRoot";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "removeRoot";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "removeRoots";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

