/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.ide.util.projectWizard.importSources.JavaModuleSourceRoot;
import com.intellij.ide.util.projectWizard.importSources.JavaSourceRootDetectionUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.progress.util.SmoothProgressAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.CommonContentEntriesEditor;
import com.intellij.openapi.roots.ui.configuration.ContentEntryEditor;
import com.intellij.openapi.roots.ui.configuration.JavaContentEntryEditor;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.SwingWorker;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class JavaContentEntriesEditor
extends CommonContentEntriesEditor {
    public JavaContentEntriesEditor(String string, ModuleConfigurationState moduleConfigurationState) {
        super(string, moduleConfigurationState, new JpsModuleSourceRootType[]{JavaSourceRootType.SOURCE, JavaSourceRootType.TEST_SOURCE, JavaResourceRootType.RESOURCE, JavaResourceRootType.TEST_RESOURCE});
    }

    protected ContentEntryEditor createContentEntryEditor(String string) {
        return new JavaContentEntryEditor(string, this.getEditHandlers()){

            protected ModifiableRootModel getModel() {
                return JavaContentEntriesEditor.this.getModel();
            }
        };
    }

    protected List<ContentEntry> addContentEntries(VirtualFile[] virtualFileArray) {
        List list2 = super.addContentEntries(virtualFileArray);
        if (!list2.isEmpty()) {
            ContentEntry[] contentEntryArray = list2.toArray(new ContentEntry[0]);
            JavaContentEntriesEditor.a(this.myProject, contentEntryArray, () -> this.addContentEntryPanels(contentEntryArray));
        }
        return list2;
    }

    private static void a(@NotNull Project project2, ContentEntry[] progressWindow, Runnable runnable) {
        Object object2;
        if (project2 == null) {
            JavaContentEntriesEditor.a(0);
        }
        HashMap<ContentEntry, Object> hashMap = new HashMap<ContentEntry, Object>();
        HashMap<File, ContentEntry> hashMap2 = new HashMap<File, ContentEntry>();
        for (Object object2 : progressWindow) {
            VirtualFile virtualFile = object2.getFile();
            if (virtualFile == null) continue;
            hashMap.put((ContentEntry)object2, null);
            hashMap2.put(VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile), (ContentEntry)object2);
        }
        ProgressWindow progressWindow2 = new ProgressWindow(true, project2);
        SmoothProgressAdapter smoothProgressAdapter = new SmoothProgressAdapter((ProgressIndicator)progressWindow2, project2);
        final Runnable runnable2 = () -> JavaContentEntriesEditor.a(hashMap2, (ProgressIndicator)smoothProgressAdapter, hashMap, progressWindow2);
        object2 = () -> JavaContentEntriesEditor.a((ContentEntry[])progressWindow, hashMap, runnable);
        new SwingWorker((Runnable)object2){
            final /* synthetic */ Runnable val$addSourcesRunnable;
            {
                this.val$addSourcesRunnable = runnable22;
            }

            public Object construct() {
                runnable2.run();
                return null;
            }

            public void finished() {
                this.val$addSourcesRunnable.run();
            }
        }.start();
    }

    private static /* synthetic */ void a(ContentEntry[] contentEntryArray, HashMap hashMap, Runnable runnable) {
        for (ContentEntry contentEntry : contentEntryArray) {
            Collection collection = (Collection)hashMap.get(contentEntry);
            if (collection == null) continue;
            for (JavaModuleSourceRoot javaModuleSourceRoot : collection) {
                VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(javaModuleSourceRoot.getDirectory());
                VirtualFile virtualFile2 = contentEntry.getFile();
                if (virtualFile == null || virtualFile2 == null || !VfsUtilCore.isAncestor((VirtualFile)virtualFile2, (VirtualFile)virtualFile, (boolean)false)) continue;
                contentEntry.addSourceFolder(virtualFile, false, javaModuleSourceRoot.getPackagePrefix());
            }
        }
        if (runnable != null) {
            runnable.run();
        }
    }

    private static /* synthetic */ void a(Map map, ProgressIndicator progressIndicator, HashMap hashMap, ProgressWindow progressWindow) {
        Runnable runnable = () -> {
            for (File file : map.keySet()) {
                progressIndicator.setText(ProjectBundle.message((String)"module.paths.searching.source.roots.progress", (Object[])new Object[]{file.getPath()}));
                Collection<JavaModuleSourceRoot> collection = JavaSourceRootDetectionUtil.suggestRoots(file);
                hashMap.put(map.get(file), collection);
            }
        };
        progressWindow.setTitle(ProjectBundle.message((String)"module.paths.searching.source.roots.title", (Object[])new Object[0]));
        ProgressManager.getInstance().runProcess(runnable, progressIndicator);
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/ui/configuration/JavaContentEntriesEditor", "addSourceRoots"));
    }
}

