/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetModel;
import com.intellij.facet.impl.ProjectFacetsConfigurator;
import com.intellij.facet.impl.ui.FacetEditorImpl;
import com.intellij.ide.actions.ImportModuleAction;
import com.intellij.ide.projectWizard.NewProjectWizard;
import com.intellij.ide.util.newProjectWizard.AbstractProjectWizard;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.roots.ui.configuration.HeaderHidingTabbedModuleEditor;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.actions.ModuleDeleteProvider;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.projectImport.ProjectImportBuilder;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModulesConfigurator
implements ModulesProvider,
ModuleEditor.ChangeListener {
    private static final Logger a = Logger.getInstance(ModulesConfigurator.class);
    private final Project e;
    private final Map<Module, ModuleEditor> c = new TreeMap<Module, ModuleEditor>((module2, module3) -> {
        String string;
        String string2 = module2.getName();
        int n2 = string2.compareToIgnoreCase(string = module3.getName());
        if (n2 != 0) {
            return n2;
        }
        return string2.compareTo(string);
    });
    private boolean i = false;
    private ModifiableModuleModel f;
    private boolean h = false;
    private ProjectFacetsConfigurator d;
    private StructureConfigurableContext g;
    private final List<ModuleEditor.ChangeListener> b = new ArrayList<ModuleEditor.ChangeListener>();

    public ModulesConfigurator(Project project2) {
        this.e = project2;
        this.f = ModuleManager.getInstance((Project)this.e).getModifiableModel();
    }

    public void setContext(StructureConfigurableContext structureConfigurableContext) {
        this.g = structureConfigurableContext;
        this.d = this.c();
    }

    public ProjectFacetsConfigurator getFacetsConfigurator() {
        return this.d;
    }

    public void disposeUIResources() {
        ApplicationManager.getApplication().runWriteAction(() -> {
            for (ModuleEditor moduleEditor : this.c.values()) {
                Disposer.dispose((Disposable)moduleEditor);
            }
            this.c.clear();
            this.f.dispose();
            if (this.d != null) {
                this.d.disposeEditors();
            }
        });
    }

    @NotNull
    public Module[] getModules() {
        Module[] moduleArray = this.f.getModules();
        if (moduleArray == null) {
            ModulesConfigurator.a(0);
        }
        return moduleArray;
    }

    @Nullable
    public Module getModule(String string) {
        Module module2 = this.f.findModuleByName(string);
        if (module2 != null) {
            return module2;
        }
        return this.f.getModuleToBeRenamed(string);
    }

    @Nullable
    public ModuleEditor getModuleEditor(Module module2) {
        return this.c.get(module2);
    }

    public ModuleRootModel getRootModel(@NotNull Module module2) {
        if (module2 == null) {
            ModulesConfigurator.a(1);
        }
        return this.getOrCreateModuleEditor(module2).getRootModel();
    }

    public ModuleEditor getOrCreateModuleEditor(Module module2) {
        a.assertTrue(this.getModule(module2.getName()) != null, (Object)"Module has been deleted");
        ModuleEditor moduleEditor = this.getModuleEditor(module2);
        if (moduleEditor == null) {
            moduleEditor = this.b(module2);
        }
        return moduleEditor;
    }

    private ModuleEditor b(Module module2) {
        final HeaderHidingTabbedModuleEditor headerHidingTabbedModuleEditor = new HeaderHidingTabbedModuleEditor(this.e, this, module2){

            @Override
            public ProjectFacetsConfigurator getFacetsConfigurator() {
                return ModulesConfigurator.this.d;
            }
        };
        this.c.put(headerHidingTabbedModuleEditor.getModule(), headerHidingTabbedModuleEditor);
        headerHidingTabbedModuleEditor.addChangeListener(this);
        Disposer.register((Disposable)headerHidingTabbedModuleEditor, (Disposable)new Disposable(){

            public void dispose() {
                headerHidingTabbedModuleEditor.removeChangeListener(ModulesConfigurator.this);
            }
        });
        return headerHidingTabbedModuleEditor;
    }

    public FacetModel getFacetModel(@NotNull Module module2) {
        if (module2 == null) {
            ModulesConfigurator.a(2);
        }
        return this.d.getOrCreateModifiableModel(module2);
    }

    public void resetModuleEditors() {
        this.f = ModuleManager.getInstance((Project)this.e).getModifiableModel();
        ApplicationManager.getApplication().runWriteAction(() -> {
            Module[] moduleArray;
            if (!this.c.isEmpty()) {
                a.error("module editors was not disposed");
                this.c.clear();
            }
            if ((moduleArray = this.f.getModules()).length > 0) {
                for (Module module2 : moduleArray) {
                    this.getOrCreateModuleEditor(module2);
                }
            }
        });
        this.d.resetEditors();
        this.i = false;
    }

    @Override
    public void moduleStateChanged(ModifiableRootModel modifiableRootModel) {
        for (ModuleEditor.ChangeListener changeListener : this.b) {
            changeListener.moduleStateChanged(modifiableRootModel);
        }
        this.g.getDaemonAnalyzer().queueUpdate(new ModuleProjectStructureElement(this.g, modifiableRootModel.getModule()));
    }

    public void addAllModuleChangeListener(ModuleEditor.ChangeListener changeListener) {
        this.b.add(changeListener);
    }

    public void apply() throws ConfigurationException {
        ModifiableRootModel modifiableRootModel;
        String string;
        Object object;
        HashMap<VirtualFile, String> hashMap = new HashMap<VirtualFile, String>();
        HashMap<VirtualFile, VirtualFile> hashMap2 = new HashMap<VirtualFile, VirtualFile>();
        for (ModuleEditor object32 : this.c.values()) {
            object = object32.getModifiableRootModel();
            ContentEntry[] contentEntryArray = object.getContentEntries();
            string = object32.getName();
            modifiableRootModel = new HashSet();
            for (ContentEntry contentEntry : contentEntryArray) {
                for (VirtualFile virtualFile : contentEntry.getSourceFolderFiles()) {
                    if (modifiableRootModel.add(virtualFile)) continue;
                    throw new ConfigurationException(ProjectBundle.message((String)"module.paths.validation.duplicate.source.root.in.same.module.error", (Object[])new Object[]{virtualFile.getPresentableUrl(), string}));
                }
            }
            for (ContentEntry contentEntry : contentEntryArray) {
                VirtualFile virtualFile = contentEntry.getFile();
                if (virtualFile == null) continue;
                String string2 = hashMap.put(virtualFile, string);
                if (string2 != null && !string2.equals(string)) {
                    throw new ConfigurationException(ProjectBundle.message((String)"module.paths.validation.duplicate.content.error", (Object[])new Object[]{virtualFile.getPresentableUrl(), string2, string}));
                }
                for (VirtualFile virtualFile2 : contentEntry.getSourceFolderFiles()) {
                    String string3;
                    String string4;
                    VirtualFile virtualFile3 = hashMap2.put(virtualFile2, virtualFile);
                    if (virtualFile3 == null) continue;
                    if (VfsUtilCore.isAncestor((VirtualFile)virtualFile3, (VirtualFile)virtualFile, (boolean)true)) {
                        string4 = (String)hashMap.get(virtualFile3);
                        string3 = (String)hashMap.get(virtualFile);
                    } else {
                        string4 = (String)hashMap.get(virtualFile);
                        string3 = (String)hashMap.get(virtualFile3);
                    }
                    throw new ConfigurationException(ProjectBundle.message((String)"module.paths.validation.duplicate.source.root.error", (Object[])new Object[]{string4, virtualFile2.getPresentableUrl(), string3}));
                }
            }
        }
        for (Map.Entry entry : hashMap2.entrySet()) {
            object = (VirtualFile)entry.getKey();
            VirtualFile virtualFile = (VirtualFile)entry.getValue();
            string = (String)hashMap.get(virtualFile);
            for (modifiableRootModel = object; modifiableRootModel != null && !modifiableRootModel.equals(virtualFile); modifiableRootModel = modifiableRootModel.getParent()) {
                String string5 = (String)hashMap.get(modifiableRootModel);
                if (string5 == null || string5.equals(string)) continue;
                throw new ConfigurationException(ProjectBundle.message((String)"module.paths.validation.source.root.belongs.to.another.module.error", (Object[])new Object[]{object.getPresentableUrl(), string, string5}));
            }
        }
        for (ModuleEditor moduleEditor : this.c.values()) {
            moduleEditor.canApply();
        }
        Iterator<Object> iterator = new THashMap();
        ProjectSdksModel projectSdksModel = ProjectStructureConfigurable.getInstance(this.e).getProjectJdksModel();
        for (Map.Entry entry : projectSdksModel.getProjectSdks().entrySet()) {
            iterator.put(entry.getValue(), entry.getKey());
        }
        object = Ref.create();
        ApplicationManager.getApplication().runWriteAction(() -> this.a(iterator, (Ref)object));
        if (!object.isNull()) {
            throw (ConfigurationException)((Object)object.get());
        }
        this.i = false;
    }

    private ProjectFacetsConfigurator c() {
        return new ProjectFacetsConfigurator(this.g, this.d);
    }

    public void setModified(boolean bl2) {
        this.i = bl2;
    }

    public ModifiableModuleModel getModuleModel() {
        return this.f;
    }

    public boolean isModuleModelCommitted() {
        return this.h;
    }

    public List<Module> deleteModules(Collection<Module> collection) {
        ArrayList<Module> arrayList = new ArrayList<Module>();
        ArrayList<ModuleEditor> arrayList2 = new ArrayList<ModuleEditor>();
        for (Module module2 : collection) {
            ModuleEditor moduleEditor = this.getModuleEditor(module2);
            if (moduleEditor == null) continue;
            arrayList.add(module2);
            arrayList2.add(moduleEditor);
        }
        if (this.a(arrayList2)) {
            return arrayList;
        }
        return Collections.emptyList();
    }

    @Nullable
    public List<Module> addModule(Component component, boolean bl2, String string) {
        if (this.e.isDefault()) {
            return null;
        }
        ProjectBuilder projectBuilder = this.a(component, bl2, string);
        if (projectBuilder != null) {
            List<Module> list2;
            ArrayList<Module> arrayList = new ArrayList<Module>();
            if (projectBuilder instanceof ProjectImportBuilder) {
                ModifiableArtifactModel modifiableArtifactModel = ProjectStructureConfigurable.getInstance(this.e).getArtifactsStructureConfigurable().getModifiableArtifactModel();
                list2 = ((ProjectImportBuilder)projectBuilder).commit(this.e, this.f, this, modifiableArtifactModel);
            } else {
                list2 = projectBuilder.commit(this.e, this.f, (ModulesProvider)this);
            }
            if (list2 != null) {
                arrayList.addAll(list2);
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                for (Module module2 : arrayList) {
                    this.getOrCreateModuleEditor(module2);
                }
            });
            return arrayList;
        }
        return null;
    }

    private Module a(final ModuleBuilder moduleBuilder) {
        try {
            return (Module)ApplicationManager.getApplication().runWriteAction((ThrowableComputable)new ThrowableComputable<Module, Exception>(){

                public Module compute() throws Exception {
                    return moduleBuilder.createModule(ModulesConfigurator.this.f);
                }
            });
        }
        catch (Exception exception) {
            Messages.showErrorDialog((String)ProjectBundle.message((String)"module.add.error.message", (Object[])new Object[]{exception.getMessage()}), (String)ProjectBundle.message((String)"module.add.error.title", (Object[])new Object[0]));
            return null;
        }
    }

    @Nullable
    public Module addModule(ModuleBuilder moduleBuilder) {
        Module module2 = this.a(moduleBuilder);
        if (module2 != null) {
            ApplicationManager.getApplication().runWriteAction(() -> this.getOrCreateModuleEditor(module2));
            this.a();
        }
        return module2;
    }

    @Nullable
    private ProjectBuilder a(Component component, boolean bl2, String string) {
        AbstractProjectWizard abstractProjectWizard;
        if (bl2) {
            abstractProjectWizard = ImportModuleAction.selectFileAndCreateWizard(this.e, component);
            if (abstractProjectWizard == null) {
                return null;
            }
            if (abstractProjectWizard.getStepCount() == 0) {
                ProjectBuilder projectBuilder = abstractProjectWizard.getProjectBuilder();
                Disposer.dispose((Disposable)abstractProjectWizard.getDisposable());
                return projectBuilder;
            }
        } else {
            abstractProjectWizard = new NewProjectWizard(this.e, component, this, string);
        }
        if (!abstractProjectWizard.showAndGet()) {
            return null;
        }
        return abstractProjectWizard.getBuilder(this.e);
    }

    private boolean a(@NotNull List<ModuleEditor> list2) {
        if (list2 == null) {
            ModulesConfigurator.a(3);
        }
        if (list2.isEmpty()) {
            return true;
        }
        String string = this.c.size() == list2.size() ? ProjectBundle.message((String)"module.remove.last.confirmation", (Object[])new Object[]{list2.size()}) : ProjectBundle.message((String)"module.remove.confirmation", (Object[])new Object[]{list2.get(0).getModule().getName(), list2.size()});
        int n2 = Messages.showYesNoDialog((Project)this.e, (String)string, (String)ProjectBundle.message((String)"module.remove.confirmation.title", (Object[])new Object[]{list2.size()}), (Icon)Messages.getQuestionIcon());
        if (n2 != 0) {
            return false;
        }
        for (ModuleEditor moduleEditor : list2) {
            this.c.remove(moduleEditor.getModule());
            Module module2 = moduleEditor.getModule();
            ArrayList arrayList = new ArrayList();
            for (ModuleEditor moduleEditor2 : this.c.values()) {
                ModifiableRootModel modifiableRootModel = moduleEditor2.getModifiableRootModelProxy();
                ContainerUtil.addIfNotNull(arrayList, (Object)modifiableRootModel);
            }
            ModuleDeleteProvider.removeModule((Module)module2, arrayList, (ModifiableModuleModel)this.f);
            Disposer.dispose((Disposable)moduleEditor);
        }
        this.a();
        return true;
    }

    private void a() {
        for (ModuleEditor moduleEditor : this.c.values()) {
            moduleEditor.moduleCountChanged();
        }
    }

    public void processModuleCompilerOutputChanged(String string) {
        for (ModuleEditor moduleEditor : this.c.values()) {
            moduleEditor.updateCompilerOutputPathChanged(string, moduleEditor.getName());
        }
    }

    public boolean isModified() {
        if (this.f.isChanged()) {
            return true;
        }
        for (ModuleEditor moduleEditor : this.c.values()) {
            if (!moduleEditor.isModified()) continue;
            return true;
        }
        return this.i || this.d.isModified();
    }

    public static boolean showArtifactSettings(@NotNull Project project2, @Nullable Artifact artifact) {
        if (project2 == null) {
            ModulesConfigurator.a(4);
        }
        ProjectStructureConfigurable projectStructureConfigurable = ProjectStructureConfigurable.getInstance(project2);
        return ShowSettingsUtil.getInstance().editConfigurable(project2, (Configurable)projectStructureConfigurable, () -> projectStructureConfigurable.select(artifact, true));
    }

    public static boolean showFacetSettingsDialog(@NotNull Facet facet, @Nullable String string) {
        if (facet == null) {
            ModulesConfigurator.a(5);
        }
        Project project2 = facet.getModule().getProject();
        ProjectStructureConfigurable projectStructureConfigurable = ProjectStructureConfigurable.getInstance(project2);
        return ShowSettingsUtil.getInstance().editConfigurable(project2, (Configurable)projectStructureConfigurable, () -> {
            if (facet == null) {
                ModulesConfigurator.a(6);
            }
            ModuleStructureConfigurable moduleStructureConfigurable = projectStructureConfigurable.getModulesConfig();
            projectStructureConfigurable.select(facet, true).doWhenDone(() -> {
                if (facet == null) {
                    ModulesConfigurator.a(7);
                }
                if (string != null) {
                    FacetEditorImpl facetEditorImpl = moduleStructureConfigurable.getFacetConfigurator().getOrCreateEditor(facet);
                    facetEditorImpl.setSelectedTabName(string);
                }
            });
        });
    }

    public static boolean showDialog(Project project2, @Nullable String string, @Nullable String string2) {
        ProjectStructureConfigurable projectStructureConfigurable = ProjectStructureConfigurable.getInstance(project2);
        return ShowSettingsUtil.getInstance().editConfigurable(project2, (Configurable)projectStructureConfigurable, () -> projectStructureConfigurable.select(string, string2, true));
    }

    public void moduleRenamed(Module module2, String string, String string2) {
        ModuleEditor moduleEditor = this.c.get(module2);
        if (moduleEditor != null) {
            moduleEditor.setModuleName(string2);
            moduleEditor.updateCompilerOutputPathChanged(ProjectStructureConfigurable.getInstance(this.e).getProjectConfig().getCompilerOutputUrl(), string2);
            this.g.getDaemonAnalyzer().queueUpdate(new ModuleProjectStructureElement(this.g, module2));
        }
    }

    public StructureConfigurableContext getContext() {
        return this.g;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void a(Map map, Ref ref) {
        ArrayList<ModifiableRootModel> arrayList = new ArrayList<ModifiableRootModel>(this.c.size());
        try {
            for (ModuleEditor moduleEditor : this.c.values()) {
                Sdk sdk;
                Sdk sdk2;
                ModifiableRootModel modifiableRootModel = moduleEditor.apply();
                if (modifiableRootModel == null) continue;
                if (!modifiableRootModel.isSdkInherited() && (sdk2 = modifiableRootModel.getSdk()) != null && (sdk = (Sdk)map.get(sdk2)) != null) {
                    modifiableRootModel.setSdk(sdk);
                }
                arrayList.add(modifiableRootModel);
            }
            this.d.applyEditors();
        }
        catch (ConfigurationException configurationException) {
            ref.set((Object)configurationException);
            return;
        }
        try {
            for (ModuleEditor moduleEditor : this.c.values()) {
                moduleEditor.resetModifiableModel();
            }
            ModifiableModelCommitter.multiCommit(arrayList, (ModifiableModuleModel)this.f);
            this.h = true;
            this.d.commitFacets();
        }
        finally {
            ModuleStructureConfigurable.getInstance(this.e).getFacetEditorFacade().clearMaps(false);
            this.d = this.c();
            this.f = ModuleManager.getInstance((Project)this.e).getModifiableModel();
            this.h = false;
        }
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/ModulesConfigurator";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedEditors";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/ModulesConfigurator";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRootModel";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFacetModel";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doRemoveModules";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showArtifactSettings";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showFacetSettingsDialog";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$showFacetSettingsDialog$8";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$7";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

