/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.impl.TypeSafeDataProviderAdapter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorContextImpl;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorEx;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorListener;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorSettings;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactPropertiesEditors;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactValidationManagerImpl;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.artifacts.ComplexElementSubstitutionParameters;
import com.intellij.openapi.roots.ui.configuration.artifacts.LayoutTree;
import com.intellij.openapi.roots.ui.configuration.artifacts.LayoutTreeComponent;
import com.intellij.openapi.roots.ui.configuration.artifacts.ToggleShowElementContentAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.AddCompositeElementAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.AddNewPackagingElementAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.ExtractArtifactAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.HideContentAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.InlineArtifactAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.LayoutTreeFindUsagesAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.LayoutTreeNavigateAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.MovePackagingElementAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.RemovePackagingElementAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.RenamePackagingElementAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.ShowAddPackagingElementPopupAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.SortElementsToggleAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.SurroundElementWithAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.LibrarySourceItem;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.ModuleOutputSourceItem;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.SourceItemsTree;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.elements.ComplexPackagingElementType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.elements.ArchivePackagingElement;
import com.intellij.packaging.impl.elements.ManifestFileUtil;
import com.intellij.packaging.ui.ManifestFileConfiguration;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ThreeStateCheckBox;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactEditorImpl
implements ArtifactEditorEx {
    private JPanel j;
    private JCheckBox o;
    private TextFieldWithBrowseButton a;
    private JPanel d;
    private JPanel q;
    private ThreeStateCheckBox b;
    private FixedSizeButton h;
    private JPanel r;
    private final ActionGroup s;
    private final Project c;
    private final ComplexElementSubstitutionParameters g;
    private final EventDispatcher<ArtifactEditorListener> l;
    private final ArtifactEditorContextImpl e;
    private final SourceItemsTree k;
    private final Artifact f;
    private final LayoutTreeComponent t;
    private TabbedPaneWrapper i;
    private ArtifactPropertiesEditors n;
    private final ArtifactValidationManagerImpl p;
    private boolean m;

    public ArtifactEditorImpl(@NotNull ArtifactsStructureConfigurableContext artifactsStructureConfigurableContext, @NotNull Artifact artifact, @NotNull ArtifactEditorSettings artifactEditorSettings) {
        if (artifactsStructureConfigurableContext == null) {
            ArtifactEditorImpl.a(0);
        }
        if (artifact == null) {
            ArtifactEditorImpl.a(1);
        }
        if (artifactEditorSettings == null) {
            ArtifactEditorImpl.a(2);
        }
        this.d();
        this.g = new ComplexElementSubstitutionParameters();
        this.l = EventDispatcher.create(ArtifactEditorListener.class);
        this.e = this.createArtifactEditorContext(artifactsStructureConfigurableContext);
        this.f = artifact;
        this.c = artifactsStructureConfigurableContext.getProject();
        this.g.setTypesToShowContent(artifactEditorSettings.getTypesToShowContent());
        this.k = new SourceItemsTree(this.e, this);
        this.t = new LayoutTreeComponent(this, this.g, this.e, this.f, artifactEditorSettings.isSortElements());
        this.n = new ArtifactPropertiesEditors(this.e, this.f, this.f);
        Disposer.register((Disposable)this, (Disposable)this.k);
        Disposer.register((Disposable)this, (Disposable)this.t);
        this.r.setBorder(new EmptyBorder(0, 10, 0, 10));
        this.o.setSelected(artifact.isBuildOnMake());
        String string = artifact.getOutputPath();
        this.a.addBrowseFolderListener(CompilerBundle.message((String)"dialog.title.output.directory.for.artifact", (Object[])new Object[0]), CompilerBundle.message((String)"chooser.description.select.output.directory.for.0.artifact", (Object[])new Object[]{this.getArtifact().getName()}), this.c, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.a.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent documentEvent) {
                ArtifactEditorImpl.this.queueValidation();
            }
        });
        this.s = this.g();
        this.h.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ActionManager.getInstance().createActionPopupMenu("unknown", ArtifactEditorImpl.this.s).getComponent().show((Component)ArtifactEditorImpl.this.h, 0, 0);
            }
        });
        this.a(string);
        this.p = new ArtifactValidationManagerImpl(this);
        this.updateShowContentCheckbox();
    }

    protected ArtifactEditorContextImpl createArtifactEditorContext(ArtifactsStructureConfigurableContext artifactsStructureConfigurableContext) {
        return new ArtifactEditorContextImpl(artifactsStructureConfigurableContext, this);
    }

    private ActionGroup g() {
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
        for (ComplexPackagingElementType complexPackagingElementType : PackagingElementFactory.getInstance().getComplexElementTypes()) {
            defaultActionGroup.add((AnAction)new ToggleShowElementContentAction(complexPackagingElementType, this));
        }
        return defaultActionGroup;
    }

    private void a(@Nullable String string) {
        this.a.setText(string != null ? FileUtil.toSystemDependentName((String)string) : null);
    }

    public void apply() {
        ModifiableArtifact modifiableArtifact = this.e.getOrCreateModifiableArtifactModel().getOrCreateModifiableArtifact(this.f);
        modifiableArtifact.setBuildOnMake(this.o.isSelected());
        modifiableArtifact.setOutputPath(this.f());
        this.n.applyProperties();
        this.t.saveElementProperties();
    }

    @Nullable
    private String f() {
        String string = FileUtil.toSystemIndependentName((String)this.a.getText().trim());
        if (string.length() == 0) {
            string = null;
        }
        return string;
    }

    public SourceItemsTree getSourceItemsTree() {
        return this.k;
    }

    public void addListener(@NotNull ArtifactEditorListener artifactEditorListener) {
        if (artifactEditorListener == null) {
            ArtifactEditorImpl.a(3);
        }
        this.l.addListener((EventListener)artifactEditorListener);
    }

    @Override
    public ArtifactEditorContextImpl getContext() {
        return this.e;
    }

    public void removeListener(@NotNull ArtifactEditorListener artifactEditorListener) {
        if (artifactEditorListener == null) {
            ArtifactEditorImpl.a(4);
        }
        this.l.removeListener((EventListener)artifactEditorListener);
    }

    @Override
    public Artifact getArtifact() {
        return this.e.getArtifactModel().getArtifactByOriginal(this.f);
    }

    @Override
    public CompositePackagingElement<?> getRootElement() {
        return this.t.getRootElement();
    }

    @Override
    public void rebuildTries() {
        this.t.rebuildTree();
        this.k.rebuildTree();
    }

    @Override
    public void queueValidation() {
        this.e.queueValidation();
    }

    public JComponent createMainComponent() {
        Serializable serializable;
        this.k.initTree();
        this.t.initTree();
        DataManager.registerDataProvider((JComponent)this.j, (DataProvider)new TypeSafeDataProviderAdapter((TypeSafeDataProvider)new MyDataProvider()));
        this.q.add((Component)this.p.getMainErrorPanel(), "Center");
        OnePixelSplitter onePixelSplitter = new OnePixelSplitter(false);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = this.t.getTreePanel();
        if (UIUtil.isUnderDarcula()) {
            jPanel2.setBorder(new EmptyBorder(3, 0, 0, 0));
        } else {
            jPanel2.setBorder(new LineBorder(UIUtil.getBorderColor()));
        }
        jPanel.add((Component)jPanel2, "Center");
        if (UIUtil.isUnderDarcula()) {
            serializable = new CompoundBorder((Border)new CustomLineBorder(0, 0, 0, 1), BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel.setBorder((Border)((Object)serializable));
        } else {
            jPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 0));
        }
        onePixelSplitter.setFirstComponent((JComponent)jPanel);
        serializable = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.add(new JLabel("Available Elements "));
        final HyperlinkLabel hyperlinkLabel = new HyperlinkLabel("");
        hyperlinkLabel.setIcon(AllIcons.General.Help_small);
        hyperlinkLabel.setUseIconAsLink(true);
        hyperlinkLabel.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent hyperlinkEvent) {
                JLabel jLabel = new JLabel(ProjectBundle.message((String)"artifact.source.items.tree.tooltip", (Object[])new Object[0]));
                jLabel.setBorder(HintUtil.createHintBorder());
                jLabel.setBackground(HintUtil.getInformationColor());
                jLabel.setOpaque(true);
                HintManager.getInstance().showHint((JComponent)jLabel, RelativePoint.getSouthWestOf((JComponent)hyperlinkLabel), 10, -1);
            }
        });
        jPanel4.add((Component)hyperlinkLabel);
        jPanel3.add((Component)jPanel4, "Center");
        ((Container)serializable).add(jPanel3, "North");
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.k), (boolean)true);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add((Component)jScrollPane, "Center");
        if (UIUtil.isUnderDarcula()) {
            jPanel5.setBorder(new EmptyBorder(3, 0, 0, 0));
        } else {
            jPanel5.setBorder(new LineBorder(UIUtil.getBorderColor()));
        }
        ((Container)serializable).add(jPanel5, "Center");
        if (UIUtil.isUnderDarcula()) {
            ((JComponent)serializable).setBorder(new CompoundBorder((Border)new CustomLineBorder(0, 1, 0, 0), BorderFactory.createEmptyBorder(0, 0, 0, 0)));
        } else {
            ((JComponent)serializable).setBorder(BorderFactory.createEmptyBorder(3, 0, 3, 3));
        }
        onePixelSplitter.setSecondComponent((JComponent)serializable);
        onePixelSplitter.getDivider().setBackground(UIUtil.getPanelBackground());
        jPanel2.setBorder((Border)JBUI.Borders.empty());
        ((JComponent)serializable).setBorder((Border)JBUI.Borders.empty());
        jPanel5.setBorder((Border)JBUI.Borders.empty());
        jPanel.setBorder((Border)JBUI.Borders.empty());
        this.b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ThreeStateCheckBox.State state = ArtifactEditorImpl.this.b.getState();
                if (state == ThreeStateCheckBox.State.SELECTED) {
                    ArtifactEditorImpl.this.g.setSubstituteAll();
                } else if (state == ThreeStateCheckBox.State.NOT_SELECTED) {
                    ArtifactEditorImpl.this.g.setSubstituteNone();
                }
                ArtifactEditorImpl.this.b.setThirdStateEnabled(false);
                ArtifactEditorImpl.this.t.rebuildTree();
                ArtifactEditorImpl.this.b();
            }
        });
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("ProjectStructureArtifactEditor", (ActionGroup)this.e(), true);
        JComponent jComponent = actionToolbar.getComponent();
        if (UIUtil.isUnderDarcula()) {
            jComponent.setBorder((Border)new CustomLineBorder(0, 0, 1, 0));
        }
        jPanel.add((Component)jComponent, "North");
        actionToolbar.updateActionsImmediately();
        jPanel3.setPreferredSize(new Dimension(-1, jComponent.getPreferredSize().height));
        this.i = new TabbedPaneWrapper((Disposable)this);
        this.i.addTab("Output Layout", (JComponent)onePixelSplitter);
        this.n.addTabs(this.i);
        this.d.add((Component)this.i.getComponent(), "Center");
        LayoutTree layoutTree = this.t.getLayoutTree();
        new ShowAddPackagingElementPopupAction(this).registerCustomShortcutSet(CommonShortcuts.getNew(), (JComponent)((Object)layoutTree));
        PopupHandler.installPopupHandler((JComponent)((Object)layoutTree), (ActionGroup)this.h(), (String)"unknown", (ActionManager)ActionManager.getInstance());
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)layoutTree));
        this.rebuildTries();
        return this.getMainComponent();
    }

    private void b() {
        this.e.getParent().getDefaultSettings().setTypesToShowContent(this.g.getTypesToSubstitute());
    }

    public void updateShowContentCheckbox() {
        ThreeStateCheckBox.State state = this.g.isAllSubstituted() ? ThreeStateCheckBox.State.SELECTED : (this.g.isNoneSubstituted() ? ThreeStateCheckBox.State.NOT_SELECTED : ThreeStateCheckBox.State.DONT_CARE);
        this.b.setThirdStateEnabled(state == ThreeStateCheckBox.State.DONT_CARE);
        this.b.setState(state);
        this.b();
    }

    public ArtifactEditorSettings createSettings() {
        return new ArtifactEditorSettings(this.t.isSortElements(), this.g.getTypesToSubstitute());
    }

    private DefaultActionGroup e() {
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
        ArrayList<AnAction> arrayList = new ArrayList<AnAction>(this.createNewElementActions());
        for (AnAction anAction : arrayList) {
            defaultActionGroup.add(anAction);
        }
        defaultActionGroup.add((AnAction)new RemovePackagingElementAction(this));
        defaultActionGroup.add((AnAction)Separator.getInstance());
        defaultActionGroup.add((AnAction)new SortElementsToggleAction(this.getLayoutTreeComponent()));
        defaultActionGroup.add((AnAction)new MovePackagingElementAction(this.t, "Move Up", "", IconUtil.getMoveUpIcon(), -1));
        defaultActionGroup.add((AnAction)new MovePackagingElementAction(this.t, "Move Down", "", IconUtil.getMoveDownIcon(), 1));
        return defaultActionGroup;
    }

    public List<AnAction> createNewElementActions() {
        ArrayList<AnAction> arrayList = new ArrayList<AnAction>();
        AddCompositeElementAction.addCompositeCreateActions(arrayList, this);
        arrayList.add((AnAction)this.a());
        return arrayList;
    }

    private DefaultActionGroup h() {
        AnAction anAction2;
        LayoutTree layoutTree = this.t.getLayoutTree();
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
        ArrayList<AnAction> arrayList = new ArrayList<AnAction>();
        AddCompositeElementAction.addCompositeCreateActions(arrayList, this);
        for (AnAction anAction2 : arrayList) {
            defaultActionGroup.add(anAction2);
        }
        defaultActionGroup.add((AnAction)this.a());
        Object object = new RemovePackagingElementAction(this);
        object.registerCustomShortcutSet(CommonShortcuts.getDelete(), (JComponent)((Object)layoutTree));
        defaultActionGroup.add(object);
        defaultActionGroup.add((AnAction)new ExtractArtifactAction(this));
        defaultActionGroup.add((AnAction)new InlineArtifactAction(this));
        defaultActionGroup.add((AnAction)new RenamePackagingElementAction(this));
        defaultActionGroup.add((AnAction)new SurroundElementWithAction(this));
        defaultActionGroup.add((AnAction)Separator.getInstance());
        defaultActionGroup.add((AnAction)new HideContentAction(this));
        defaultActionGroup.add((AnAction)new LayoutTreeNavigateAction(this.t));
        defaultActionGroup.add((AnAction)new LayoutTreeFindUsagesAction(this.t, this.c, this.e.getParent()));
        defaultActionGroup.add((AnAction)Separator.getInstance());
        anAction2 = CommonActionsManager.getInstance();
        DefaultTreeExpander defaultTreeExpander = new DefaultTreeExpander((JTree)((Object)layoutTree));
        defaultActionGroup.add(anAction2.createExpandAllAction((TreeExpander)defaultTreeExpander, (JComponent)((Object)layoutTree)));
        defaultActionGroup.add(anAction2.createCollapseAllAction((TreeExpander)defaultTreeExpander, (JComponent)((Object)layoutTree)));
        return defaultActionGroup;
    }

    @Override
    public ComplexElementSubstitutionParameters getSubstitutionParameters() {
        return this.g;
    }

    private ActionGroup a() {
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup(ProjectBundle.message((String)"artifacts.add.copy.action", (Object[])new Object[0]), true);
        defaultActionGroup.getTemplatePresentation().setIcon(IconUtil.getAddIcon());
        for (PackagingElementType packagingElementType : PackagingElementFactory.getInstance().getNonCompositeElementTypes()) {
            defaultActionGroup.add((AnAction)new AddNewPackagingElementAction(packagingElementType, this));
        }
        return defaultActionGroup;
    }

    @Override
    public JComponent getMainComponent() {
        return this.j;
    }

    @Override
    public void addNewPackagingElement(@NotNull PackagingElementType<?> packagingElementType) {
        if (packagingElementType == null) {
            ArtifactEditorImpl.a(5);
        }
        this.t.addNewPackagingElement(packagingElementType);
        this.k.rebuildTree();
    }

    @Override
    public void removeSelectedElements() {
        this.t.removeSelectedElements();
    }

    @Override
    public void removePackagingElement(@NotNull String string, @NotNull PackagingElement<?> packagingElement) {
        if (string == null) {
            ArtifactEditorImpl.a(6);
        }
        if (packagingElement == null) {
            ArtifactEditorImpl.a(7);
        }
        this.b(string, packagingElement, null);
    }

    @Override
    public void replacePackagingElement(@NotNull String string, @NotNull PackagingElement<?> packagingElement, @NotNull PackagingElement<?> packagingElement2) {
        if (string == null) {
            ArtifactEditorImpl.a(8);
        }
        if (packagingElement == null) {
            ArtifactEditorImpl.a(9);
        }
        if (packagingElement2 == null) {
            ArtifactEditorImpl.a(10);
        }
        this.b(string, packagingElement, packagingElement2);
    }

    private void b(@NotNull String string, @NotNull PackagingElement<?> packagingElement, @Nullable PackagingElement packagingElement2) {
        if (string == null) {
            ArtifactEditorImpl.a(11);
        }
        if (packagingElement == null) {
            ArtifactEditorImpl.a(12);
        }
        this.t.editLayout(() -> {
            CompositePackagingElement<?> compositePackagingElement;
            if (string == null) {
                ArtifactEditorImpl.a(18);
            }
            if (packagingElement == null) {
                ArtifactEditorImpl.a(19);
            }
            if ((compositePackagingElement = this.b(string)) == null) {
                return;
            }
            for (PackagingElement packagingElement3 : compositePackagingElement.getChildren()) {
                if (!packagingElement3.isEqualTo(packagingElement)) continue;
                compositePackagingElement.removeChild(packagingElement3);
                if (packagingElement2 == null) break;
                compositePackagingElement.addOrFindChild(packagingElement2);
                break;
            }
        });
        this.t.rebuildTree();
    }

    @Nullable
    private CompositePackagingElement<?> b(String string) {
        CompositePackagingElement compositePackagingElement = this.getRootElement();
        for (String string2 : StringUtil.split((String)string, (String)"/")) {
            if ((compositePackagingElement = compositePackagingElement.findCompositeChild(string2)) != null) continue;
            return null;
        }
        return compositePackagingElement;
    }

    public boolean isModified() {
        return this.o.isSelected() != this.f.isBuildOnMake() || !Comparing.equal((String)this.f(), (String)this.f.getOutputPath()) || this.n.isModified() || this.t.isPropertiesModified();
    }

    public void dispose() {
        this.m = true;
    }

    public boolean isDisposed() {
        return this.m;
    }

    @Override
    public LayoutTreeComponent getLayoutTreeComponent() {
        return this.t;
    }

    public void updateOutputPath(@NotNull String string, @NotNull String string2) {
        CompositePackagingElement<?> compositePackagingElement;
        String string3;
        if (string == null) {
            ArtifactEditorImpl.a(13);
        }
        if (string2 == null) {
            ArtifactEditorImpl.a(14);
        }
        if (Comparing.equal((String)(string3 = ArtifactUtil.getDefaultArtifactOutputPath(string, this.c)), (String)this.f())) {
            this.a(ArtifactUtil.getDefaultArtifactOutputPath(string2, this.c));
        }
        if ((compositePackagingElement = this.getRootElement()) instanceof ArchivePackagingElement) {
            String string4 = ArtifactUtil.suggestArtifactFileName(string);
            String string5 = ((ArchivePackagingElement)compositePackagingElement).getArchiveFileName();
            String string6 = FileUtil.getNameWithoutExtension((String)string5);
            String string7 = FileUtilRt.getExtension((String)string5);
            if (string6.equals(string4) && string7.length() > 0) {
                this.t.editLayout(() -> {
                    if (string2 == null) {
                        ArtifactEditorImpl.a(17);
                    }
                    ((ArchivePackagingElement)this.getRootElement()).setArchiveFileName(ArtifactUtil.suggestArtifactFileName(string2) + "." + string7);
                });
                this.t.updateRootNode();
            }
        }
        this.queueValidation();
    }

    public void updateLayoutTree() {
        this.t.rebuildTree();
    }

    public void putLibraryIntoDefaultLocation(@NotNull Library library) {
        if (library == null) {
            ArtifactEditorImpl.a(15);
        }
        this.t.putIntoDefaultLocations(Collections.singletonList(new LibrarySourceItem(library)));
    }

    public void putModuleIntoDefaultLocation(@NotNull Module module2) {
        if (module2 == null) {
            ArtifactEditorImpl.a(16);
        }
        this.t.putIntoDefaultLocations(Collections.singletonList(new ModuleOutputSourceItem(module2)));
    }

    public void addToClasspath(CompositePackagingElement<?> compositePackagingElement, List<String> list2) {
        this.t.saveElementProperties();
        ManifestFileConfiguration manifestFileConfiguration = this.e.getManifestFile(compositePackagingElement, this.getArtifact().getArtifactType());
        if (manifestFileConfiguration == null) {
            VirtualFile virtualFile = ManifestFileUtil.showDialogAndCreateManifest(this.e, compositePackagingElement);
            if (virtualFile == null) {
                return;
            }
            ManifestFileUtil.addManifestFileToLayout(virtualFile.getPath(), this.e, compositePackagingElement);
            manifestFileConfiguration = this.e.getManifestFile(compositePackagingElement, this.getArtifact().getArtifactType());
        }
        if (manifestFileConfiguration != null) {
            manifestFileConfiguration.addToClasspath(list2);
        }
        this.t.resetElementProperties();
    }

    public void setArtifactType(ArtifactType artifactType) {
        ModifiableArtifact modifiableArtifact = this.e.getOrCreateModifiableArtifactModel().getOrCreateModifiableArtifact(this.f);
        modifiableArtifact.setArtifactType(artifactType);
        this.n.removeTabs(this.i);
        this.n = new ArtifactPropertiesEditors(this.e, this.f, this.getArtifact());
        this.n.addTabs(this.i);
        CompositePackagingElement<?> compositePackagingElement = this.getRootElement();
        CompositePackagingElement compositePackagingElement2 = artifactType.createRootElement(this.getArtifact().getName());
        ArtifactUtil.copyChildren(compositePackagingElement, compositePackagingElement2, this.c);
        this.t.setRootElement(compositePackagingElement2);
    }

    public ArtifactValidationManagerImpl getValidationManager() {
        return this.p;
    }

    private void c() {
        this.b = new ThreeStateCheckBox();
        this.h = new FixedSizeButton(16);
    }

    public String getHelpTopic() {
        int n2 = this.i.getSelectedIndex();
        if (n2 == 0) {
            return "reference.project.structure.artifacts.output";
        }
        String string = this.n.getHelpId(this.i.getSelectedTitle());
        return string != null ? string : "reference.settingsdialog.project.structure.artifacts";
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToParent";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldArtifactName";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newArtifactName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorImpl";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addListener";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "removeListener";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addNewPackagingElement";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "removePackagingElement";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "replacePackagingElement";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "doReplaceElement";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "updateOutputPath";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "putLibraryIntoDefaultLocation";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "putModuleIntoDefaultLocation";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$updateOutputPath$1";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$doReplaceElement$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void d() {
        JPanel jPanel;
        JPanel jPanel2;
        JCheckBox jCheckBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel3;
        JPanel jPanel4;
        this.c();
        this.j = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.r = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        JLabel jLabel = new JLabel();
        this.a(jLabel, ResourceBundle.getBundle("messages/ProjectBundle").getString("label.text.output.directory"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.a = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel5, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.o = jCheckBox = new JCheckBox();
        this.a(jCheckBox, ResourceBundle.getBundle("messages/ProjectBundle").getString("checkbox.text.build.on.make"));
        jPanel5.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.d = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        ((Component)jPanel2).setEnabled(true);
        jPanel4.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.q = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel6, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        ThreeStateCheckBox threeStateCheckBox = this.b;
        threeStateCheckBox.setText("Show content of elements");
        jPanel6.add((Component)threeStateCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        FixedSizeButton fixedSizeButton = this.h;
        jPanel6.add((Component)fixedSizeButton, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel6.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.j;
    }

    private /* synthetic */ void a(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        char c2 = '\u0000';
        int n2 = -1;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (string.charAt(i2) == '&') {
                if (++i2 == string.length()) break;
                if (!bl2 && string.charAt(i2) != '&') {
                    bl2 = true;
                    c2 = string.charAt(i2);
                    n2 = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i2));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl2) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n2);
        }
    }

    private /* synthetic */ void a(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        char c2 = '\u0000';
        int n2 = -1;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (string.charAt(i2) == '&') {
                if (++i2 == string.length()) break;
                if (!bl2 && string.charAt(i2) != '&') {
                    bl2 = true;
                    c2 = string.charAt(i2);
                    n2 = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i2));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl2) {
            abstractButton.setMnemonic(c2);
            abstractButton.setDisplayedMnemonicIndex(n2);
        }
    }

    private class MyDataProvider
    implements TypeSafeDataProvider {
        private MyDataProvider() {
        }

        public void calcData(DataKey dataKey, DataSink dataSink) {
            if (ArtifactEditorEx.ARTIFACTS_EDITOR_KEY.equals((Object)dataKey)) {
                dataSink.put(ArtifactEditorEx.ARTIFACTS_EDITOR_KEY, (Object)ArtifactEditorImpl.this);
            }
        }
    }
}

