/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.classpath;

import com.intellij.CommonBundle;
import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.find.FindBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.scopes.LibraryScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablePresentation;
import com.intellij.openapi.roots.ui.CellAppearanceEx;
import com.intellij.openapi.roots.ui.OrderEntryAppearanceService;
import com.intellij.openapi.roots.ui.configuration.LibraryTableModifiableModelProvider;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.classpath.AddItemPopupAction;
import com.intellij.openapi.roots.ui.configuration.classpath.AddLibraryDependencyAction;
import com.intellij.openapi.roots.ui.configuration.classpath.AddModuleDependencyAction;
import com.intellij.openapi.roots.ui.configuration.classpath.AddNewModuleLibraryAction;
import com.intellij.openapi.roots.ui.configuration.classpath.ChangeLibraryLevelInClasspathAction;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanel;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanelAction;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathTableItem;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathTableModel;
import com.intellij.openapi.roots.ui.configuration.classpath.InlineModuleDependencyAction;
import com.intellij.openapi.roots.ui.configuration.classpath.InvalidJdkItem;
import com.intellij.openapi.roots.ui.configuration.dependencyAnalysis.AnalyzeDependenciesDialog;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryEditingUtil;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.EditExistingLibraryDialog;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ConvertModuleLibraryToRepositoryLibraryAction;
import com.intellij.openapi.roots.ui.configuration.projectRoot.FindUsagesInProjectStructureActionBase;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureLibraryTableModifiableModelProvider;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.SdkProjectStructureElement;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComboBoxTableRenderer;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.packageDependencies.DependenciesBuilder;
import com.intellij.packageDependencies.DependencyVisitorFactory;
import com.intellij.packageDependencies.actions.AnalyzeDependenciesOnSpecifiedTargetHandler;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.OrderPanelListener;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.table.JBTable;
import com.intellij.util.EventDispatcher;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.TextTransferable;
import gnu.trove.TIntArrayList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClasspathPanelImpl
extends JPanel
implements ClasspathPanel {
    private static final Logger c = Logger.getInstance((String)"#com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanelImpl");
    private final JBTable e;
    private final ClasspathTableModel f;
    private final EventDispatcher<OrderPanelListener> h = EventDispatcher.create(OrderPanelListener.class);
    private List<AddItemPopupAction<?>> b = null;
    private final AnActionButton g;
    private final ModuleConfigurationState a;
    private AnActionButton d;
    private int i = 0;

    public ClasspathPanelImpl(ModuleConfigurationState moduleConfigurationState) {
        super(new BorderLayout());
        this.a = moduleConfigurationState;
        this.f = new ClasspathTableModel(moduleConfigurationState, this.g());
        this.e = new JBTable((TableModel)((Object)this.f)){

            protected TableRowSorter<TableModel> createRowSorter(TableModel tableModel) {
                return new JBTable.DefaultColumnInfoBasedRowSorter(tableModel){

                    public void toggleSortOrder(int n2) {
                        if (this.isSortable(n2)) {
                            RowSorter.SortKey sortKey = (RowSorter.SortKey)ContainerUtil.getFirstItem((List)this.getSortKeys());
                            SortOrder sortOrder = sortKey == null || sortKey.getColumn() != n2 ? SortOrder.UNSORTED : sortKey.getSortOrder();
                            this.setSortKeys(Collections.singletonList(new RowSorter.SortKey(n2, ClasspathPanelImpl.a(sortOrder))));
                        }
                    }
                };
            }
        };
        this.e.setShowGrid(false);
        this.e.setDragEnabled(false);
        this.e.setIntercellSpacing(new Dimension(0, 0));
        this.e.setDefaultRenderer(ClasspathTableItem.class, (TableCellRenderer)((Object)new TableItemRenderer(this.g())));
        this.e.setDefaultRenderer(Boolean.class, (TableCellRenderer)new ExportFlagRenderer(this.e.getDefaultRenderer(Boolean.class)));
        ComboBox comboBox = new ComboBox((ComboBoxModel)new EnumComboBoxModel(DependencyScope.class));
        this.e.setDefaultEditor(DependencyScope.class, (TableCellEditor)new DefaultCellEditor((JComboBox<?>)comboBox));
        this.e.setDefaultRenderer(DependencyScope.class, (TableCellRenderer)new ComboBoxTableRenderer<DependencyScope>(DependencyScope.values()){

            protected String getTextFor(@NotNull DependencyScope dependencyScope) {
                if (dependencyScope == null) {
                    2.a(0);
                }
                return dependencyScope.getDisplayName();
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/roots/ui/configuration/classpath/ClasspathPanelImpl$2", "getTextFor"));
            }
        });
        this.e.setTransferHandler(new TransferHandler(){

            @Override
            @Nullable
            protected Transferable createTransferable(JComponent jComponent) {
                OrderEntry orderEntry = ClasspathPanelImpl.this.getSelectedEntry();
                if (orderEntry == null) {
                    return null;
                }
                String string = orderEntry.getPresentableName();
                return new TextTransferable(string);
            }

            @Override
            public int getSourceActions(JComponent jComponent) {
                return 1;
            }
        });
        this.e.getSelectionModel().setSelectionMode(2);
        new SpeedSearchBase<JBTable>(this.e){

            public int getSelectedIndex() {
                return ClasspathPanelImpl.this.e.getSelectedRow();
            }

            protected int convertIndexToModel(int n2) {
                return ClasspathPanelImpl.this.e.convertRowIndexToModel(n2);
            }

            public Object[] getAllElements() {
                int n2 = ClasspathPanelImpl.this.f.getRowCount();
                Object[] objectArray = new Object[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    objectArray[i2] = ClasspathPanelImpl.this.f.getItem(i2);
                }
                return objectArray;
            }

            public String getElementText(Object object) {
                return ClasspathPanelImpl.getCellAppearance((ClasspathTableItem)object, ClasspathPanelImpl.this.g(), false).getText();
            }

            public void selectElement(Object object, String string) {
                int n2 = ClasspathPanelImpl.this.f.getRowCount();
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (!object.equals(ClasspathPanelImpl.this.f.getItem(i2))) continue;
                    int n3 = ClasspathPanelImpl.this.e.convertRowIndexToView(i2);
                    ClasspathPanelImpl.this.e.getSelectionModel().setSelectionInterval(n3, n3);
                    TableUtil.scrollSelectionToVisible((JTable)ClasspathPanelImpl.this.e);
                    break;
                }
            }
        };
        this.a(0, ClasspathTableModel.EXPORT_COLUMN_NAME);
        this.a(2, DependencyScope.COMPILE.toString() + "     ");
        this.e.getTableHeader().getColumnModel().getColumn(1).setPreferredWidth(10000);
        this.e.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = ClasspathPanelImpl.this.e.getSelectedRows();
                boolean bl2 = true;
                for (int n2 : nArray) {
                    ClasspathTableItem classpathTableItem = ClasspathPanelImpl.this.c(n2);
                    if (n2 < 0 || !classpathTableItem.isExportable()) {
                        return;
                    }
                    bl2 &= classpathTableItem.isExported();
                }
                for (int n2 : nArray) {
                    ClasspathPanelImpl.this.c(n2).setExported(!bl2);
                }
                ClasspathPanelImpl.this.f.fireTableDataChanged();
                TableUtil.selectRows((JTable)ClasspathPanelImpl.this.e, (int[])nArray);
            }
        }, KeyStroke.getKeyStroke(32, 0), 0);
        this.g = new AnActionButton(ProjectBundle.message((String)"module.classpath.button.edit", (Object[])new Object[0]), null, IconUtil.getEditIcon()){

            public void actionPerformed(@NotNull AnActionEvent anActionEvent) {
                if (anActionEvent == null) {
                    6.a(0);
                }
                ClasspathPanelImpl.this.h();
            }

            public boolean isEnabled() {
                ClasspathTableItem classpathTableItem = ClasspathPanelImpl.this.a();
                return classpathTableItem != null && classpathTableItem.isEditable();
            }

            public boolean isDumbAware() {
                return true;
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/roots/ui/configuration/classpath/ClasspathPanelImpl$6", "actionPerformed"));
            }
        };
        this.add((Component)this.c(), "Center");
        if (this.e.getRowCount() > 0) {
            this.e.getSelectionModel().setSelectionInterval(0, 0);
        }
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent mouseEvent) {
                ClasspathPanelImpl.this.navigate(true);
                return true;
            }
        }.installOn((Component)this.e);
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
        AnAction anAction = new AnAction(ProjectBundle.message((String)"classpath.panel.navigate.action.text", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent anActionEvent) {
                if (anActionEvent == null) {
                    8.a(0);
                }
                ClasspathPanelImpl.this.navigate(false);
            }

            public void update(@NotNull AnActionEvent anActionEvent) {
                if (anActionEvent == null) {
                    8.a(1);
                }
                Presentation presentation = anActionEvent.getPresentation();
                presentation.setEnabled(false);
                OrderEntry orderEntry = ClasspathPanelImpl.this.getSelectedEntry();
                if (orderEntry != null && orderEntry.isValid() && !(orderEntry instanceof ModuleSourceOrderEntry)) {
                    presentation.setEnabled(true);
                }
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/classpath/ClasspathPanelImpl$8";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        anAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("EditSource").getShortcutSet(), (JComponent)this.e);
        defaultActionGroup.add((AnAction)this.g);
        defaultActionGroup.add((AnAction)this.d);
        defaultActionGroup.add(anAction);
        defaultActionGroup.add((AnAction)new InlineModuleDependencyAction(this));
        defaultActionGroup.add((AnAction)new MyFindUsagesAction());
        defaultActionGroup.add((AnAction)new AnalyzeDependencyAction());
        this.a(defaultActionGroup, "project");
        this.a(defaultActionGroup, "application");
        this.a(defaultActionGroup, "module");
        defaultActionGroup.add((AnAction)new ConvertModuleLibraryToRepositoryLibraryAction(this, this.g()));
        PopupHandler.installPopupHandler((JComponent)this.e, (ActionGroup)defaultActionGroup, (String)"unknown", (ActionManager)ActionManager.getInstance());
    }

    @NotNull
    private static SortOrder a(@NotNull SortOrder sortOrder) {
        if (sortOrder == null) {
            ClasspathPanelImpl.a(0);
        }
        switch (sortOrder) {
            case ASCENDING: {
                SortOrder sortOrder2 = SortOrder.DESCENDING;
                if (sortOrder2 == null) {
                    ClasspathPanelImpl.a(1);
                }
                return sortOrder2;
            }
            case DESCENDING: {
                SortOrder sortOrder3 = SortOrder.UNSORTED;
                if (sortOrder3 == null) {
                    ClasspathPanelImpl.a(2);
                }
                return sortOrder3;
            }
        }
        SortOrder sortOrder4 = SortOrder.ASCENDING;
        if (sortOrder4 == null) {
            ClasspathPanelImpl.a(3);
        }
        return sortOrder4;
    }

    private ClasspathTableItem<?> c(int n2) {
        return (ClasspathTableItem)this.f.getItem(this.e.convertRowIndexToModel(n2));
    }

    private void a(DefaultActionGroup defaultActionGroup, String string) {
        LibraryTablePresentation libraryTablePresentation = LibraryEditingUtil.getLibraryTablePresentation(this.getProject(), string);
        defaultActionGroup.add((AnAction)new ChangeLibraryLevelInClasspathAction(this, libraryTablePresentation.getDisplayName(true), string));
    }

    @Override
    @Nullable
    public OrderEntry getSelectedEntry() {
        ClasspathTableItem<?> classpathTableItem = this.a();
        return classpathTableItem != null ? (OrderEntry)classpathTableItem.getEntry() : null;
    }

    @Nullable
    private ClasspathTableItem<?> a() {
        if (this.e.getSelectedRowCount() != 1) {
            return null;
        }
        return this.c(this.e.getSelectedRow());
    }

    private void a(int n2, String string) {
        TableColumn tableColumn = this.e.getTableHeader().getColumnModel().getColumn(n2);
        FontMetrics fontMetrics = this.e.getFontMetrics(this.e.getFont());
        int n3 = fontMetrics.stringWidth(" " + string + " ") + JBUI.scale((int)4);
        tableColumn.setPreferredWidth(n3);
        tableColumn.setMinWidth(n3);
        tableColumn.setResizable(false);
    }

    @Override
    public void navigate(boolean bl2) {
        Sdk sdk;
        OrderEntry orderEntry = this.getSelectedEntry();
        ProjectStructureConfigurable projectStructureConfigurable = ProjectStructureConfigurable.getInstance(this.a.getProject());
        if (orderEntry instanceof ModuleOrderEntry) {
            Module module2 = ((ModuleOrderEntry)orderEntry).getModule();
            if (module2 != null) {
                projectStructureConfigurable.select(module2.getName(), null, true);
            }
        } else if (orderEntry instanceof LibraryOrderEntry) {
            if (!bl2 && !((LibraryOrderEntry)orderEntry).getLibraryLevel().equals("module")) {
                projectStructureConfigurable.select((LibraryOrderEntry)orderEntry, true);
            } else {
                this.h();
            }
        } else if (orderEntry instanceof JdkOrderEntry && (sdk = ((JdkOrderEntry)orderEntry).getJdk()) != null) {
            projectStructureConfigurable.select(sdk, true);
        }
    }

    private JComponent c() {
        boolean bl2 = false;
        final ClasspathPanelAction classpathPanelAction = new ClasspathPanelAction(this){

            @Override
            public void run() {
                ClasspathPanelImpl.this.a(TableUtil.removeSelectedItems((JTable)ClasspathPanelImpl.this.e));
            }
        };
        AnActionButton anActionButton = new AnActionButton(ProjectBundle.message((String)"classpath.panel.analyze", (Object[])new Object[0]), null, IconUtil.getAnalyzeIcon()){

            public void actionPerformed(@NotNull AnActionEvent anActionEvent) {
                if (anActionEvent == null) {
                    10.a(0);
                }
                AnalyzeDependenciesDialog.show(ClasspathPanelImpl.this.getRootModel().getModule());
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/roots/ui/configuration/classpath/ClasspathPanelImpl$10", "actionPerformed"));
            }
        };
        ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator((JTable)this.e);
        AnActionButtonUpdater anActionButtonUpdater = new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent anActionEvent) {
                for (RowSorter.SortKey sortKey : ClasspathPanelImpl.this.e.getRowSorter().getSortKeys()) {
                    if (sortKey.getSortOrder() == SortOrder.UNSORTED) continue;
                    return false;
                }
                return true;
            }
        };
        toolbarDecorator.setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                ClasspathPanelImpl.this.e();
                ListPopup listPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<AddItemPopupAction<?>>(null, ClasspathPanelImpl.this.b){

                    public Icon getIconFor(AddItemPopupAction<?> addItemPopupAction) {
                        return addItemPopupAction.getIcon();
                    }

                    public boolean hasSubstep(AddItemPopupAction<?> addItemPopupAction) {
                        return addItemPopupAction.hasSubStep();
                    }

                    public boolean isMnemonicsNavigationEnabled() {
                        return true;
                    }

                    public PopupStep onChosen(AddItemPopupAction<?> addItemPopupAction, boolean bl2) {
                        if (addItemPopupAction.hasSubStep()) {
                            return addItemPopupAction.createSubStep();
                        }
                        return this.doFinalStep(() -> addItemPopupAction.execute());
                    }

                    @NotNull
                    public String getTextFor(AddItemPopupAction<?> addItemPopupAction) {
                        String string = "&" + addItemPopupAction.getIndex() + "  " + addItemPopupAction.getTitle();
                        if (string == null) {
                            1.a(0);
                        }
                        return string;
                    }

                    private static /* synthetic */ void a(int n2) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/classpath/ClasspathPanelImpl$16$1", "getTextFor"));
                    }
                });
                listPopup.show(anActionButton.getPreferredPopupPoint());
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                classpathPanelAction.actionPerformed(null);
            }
        }).setRemoveActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent anActionEvent) {
                int[] nArray;
                for (int n2 : nArray = ClasspathPanelImpl.this.e.getSelectedRows()) {
                    if (ClasspathPanelImpl.this.c(n2).isRemovable()) continue;
                    return false;
                }
                return nArray.length > 0;
            }
        }).setMoveUpAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                ClasspathPanelImpl.this.b(-1);
            }
        }).setMoveUpActionUpdater(anActionButtonUpdater).setMoveUpActionName("Move Up (disabled if items are shown in sorted order)").setMoveDownAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                ClasspathPanelImpl.this.b(1);
            }
        }).setMoveDownActionUpdater(anActionButtonUpdater).setMoveDownActionName("Move Down (disabled if items are shown in sorted order)").addExtraAction(this.g);
        JPanel jPanel = toolbarDecorator.createPanel();
        this.d = ToolbarDecorator.findRemoveButton((JComponent)jPanel);
        return jPanel;
    }

    private void h() {
        OrderEntry orderEntry = this.getSelectedEntry();
        if (!(orderEntry instanceof LibraryOrderEntry)) {
            return;
        }
        Library library = ((LibraryOrderEntry)orderEntry).getLibrary();
        if (library == null) {
            return;
        }
        LibraryTable libraryTable = library.getTable();
        String string = libraryTable != null ? libraryTable.getTableLevel() : "module";
        LibraryTablePresentation libraryTablePresentation = LibraryEditingUtil.getLibraryTablePresentation(this.getProject(), string);
        LibraryTableModifiableModelProvider libraryTableModifiableModelProvider = this.getModifiableModelProvider(string);
        EditExistingLibraryDialog editExistingLibraryDialog = EditExistingLibraryDialog.createDialog(this, libraryTableModifiableModelProvider, library, this.a.getProject(), libraryTablePresentation, this.g());
        editExistingLibraryDialog.setContextModule(this.getRootModel().getModule());
        editExistingLibraryDialog.show();
        this.e.repaint();
        ModuleStructureConfigurable.getInstance(this.a.getProject()).getTree().repaint();
    }

    private void a(List list2) {
        Object object2;
        if (list2.isEmpty()) {
            return;
        }
        for (Object object2 : list2) {
            ClasspathTableItem classpathTableItem = (ClasspathTableItem)((Object[])object2)[1];
            Object t2 = classpathTableItem.getEntry();
            if (t2 == null) continue;
            this.getRootModel().removeOrderEntry(t2);
        }
        Object object3 = this.e.getSelectedRows();
        this.f.fireTableDataChanged();
        TableUtil.selectRows((JTable)this.e, (int[])object3);
        object2 = ModuleStructureConfigurable.getInstance(this.a.getProject()).getContext();
        ((StructureConfigurableContext)object2).getDaemonAnalyzer().queueUpdate(new ModuleProjectStructureElement((StructureConfigurableContext)object2, this.getRootModel().getModule()));
    }

    @Override
    @NotNull
    public LibraryTableModifiableModelProvider getModifiableModelProvider(@NotNull String string) {
        if (string == null) {
            ClasspathPanelImpl.a(4);
        }
        if ("module".equals(string)) {
            final LibraryTable libraryTable = this.getRootModel().getModuleLibraryTable();
            LibraryTableModifiableModelProvider libraryTableModifiableModelProvider = new LibraryTableModifiableModelProvider(){

                @Override
                public LibraryTable.ModifiableModel getModifiableModel() {
                    return libraryTable.getModifiableModel();
                }
            };
            if (libraryTableModifiableModelProvider == null) {
                ClasspathPanelImpl.a(5);
            }
            return libraryTableModifiableModelProvider;
        }
        StructureLibraryTableModifiableModelProvider structureLibraryTableModifiableModelProvider = this.g().createModifiableModelProvider(string);
        if (structureLibraryTableModifiableModelProvider == null) {
            ClasspathPanelImpl.a(6);
        }
        return structureLibraryTableModifiableModelProvider;
    }

    @Override
    public void runClasspathPanelAction(Runnable runnable) {
        try {
            this.d();
            runnable.run();
        }
        finally {
            this.b();
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.e, true));
        }
    }

    @Override
    public void addItems(List<ClasspathTableItem<?>> list2) {
        for (ClasspathTableItem<?> classpathTableItem : list2) {
            this.f.addRow(classpathTableItem);
        }
        TIntArrayList tIntArrayList = new TIntArrayList();
        for (int i2 = this.f.getRowCount() - list2.size(); i2 < this.f.getRowCount(); ++i2) {
            tIntArrayList.add(this.e.convertRowIndexToView(i2));
        }
        TableUtil.selectRows((JTable)this.e, (int[])tIntArrayList.toNativeArray());
        TableUtil.scrollSelectionToVisible((JTable)this.e);
        StructureConfigurableContext structureConfigurableContext = ModuleStructureConfigurable.getInstance(this.a.getProject()).getContext();
        structureConfigurableContext.getDaemonAnalyzer().queueUpdate(new ModuleProjectStructureElement(structureConfigurableContext, this.getRootModel().getModule()));
    }

    @Override
    public ModifiableRootModel getRootModel() {
        return this.a.getRootModel();
    }

    @Override
    public Project getProject() {
        return this.a.getProject();
    }

    @Override
    public ModuleConfigurationState getModuleConfigurationState() {
        return this.a;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    public void rootsChanged() {
        this.forceInitFromModel();
    }

    private void e() {
        if (this.b == null) {
            int n2 = 1;
            ArrayList arrayList = new ArrayList();
            StructureConfigurableContext structureConfigurableContext = this.g();
            arrayList.add(new AddNewModuleLibraryAction(this, n2++, structureConfigurableContext));
            arrayList.add(new AddLibraryDependencyAction((ClasspathPanel)this, n2++, ProjectBundle.message((String)"classpath.add.library.action", (Object[])new Object[0]), structureConfigurableContext));
            arrayList.add(new AddModuleDependencyAction(this, n2, structureConfigurableContext));
            this.b = arrayList;
        }
    }

    private StructureConfigurableContext g() {
        return ProjectStructureConfigurable.getInstance(this.a.getProject()).getContext();
    }

    private void b() {
        --this.i;
    }

    private void d() {
        ++this.i;
    }

    public void addListener(OrderPanelListener orderPanelListener) {
        this.h.addListener((EventListener)orderPanelListener);
    }

    public void removeListener(OrderPanelListener orderPanelListener) {
        this.h.removeListener((EventListener)orderPanelListener);
    }

    private void b(int n2) {
        int n3;
        c.assertTrue(n2 == -1 || n2 == 1);
        if (this.e.isEditing()) {
            this.e.getCellEditor().stopCellEditing();
        }
        ListSelectionModel listSelectionModel = this.e.getSelectionModel();
        int n4 = n3 = n2 < 0 ? 0 : this.f.getRowCount() - 1;
        while (n2 < 0 ? n3 < this.f.getRowCount() : n3 >= 0) {
            if (listSelectionModel.isSelectedIndex(n3)) {
                int n5 = this.a(n3, n2);
                listSelectionModel.removeSelectionInterval(n3, n3);
                listSelectionModel.addSelectionInterval(n5, n5);
            }
            n3 += n2 < 0 ? 1 : -1;
        }
        Rectangle rectangle = this.e.getCellRect(listSelectionModel.getMinSelectionIndex(), 0, true);
        this.e.scrollRectToVisible(rectangle);
        this.e.repaint();
    }

    public void selectOrderEntry(@NotNull OrderEntry orderEntry) {
        if (orderEntry == null) {
            ClasspathPanelImpl.a(7);
        }
        for (int i2 = 0; i2 < this.f.getRowCount(); ++i2) {
            Object obj = this.c(i2).getEntry();
            if (obj == null || !orderEntry.getPresentableName().equals(obj.getPresentableName()) || obj instanceof ExportableOrderEntry && orderEntry instanceof ExportableOrderEntry && ((ExportableOrderEntry)orderEntry).getScope() != ((ExportableOrderEntry)obj).getScope()) continue;
            this.e.getSelectionModel().setSelectionInterval(i2, i2);
            TableUtil.scrollSelectionToVisible((JTable)this.e);
        }
        IdeFocusManager.getInstance((Project)this.a.getProject()).requestFocus((Component)this.e, true);
    }

    private int a(int n2, int n3) {
        int n4 = Math.abs(n2 + n3) % this.f.getRowCount();
        this.f.exchangeRows(n2, n4);
        return n4;
    }

    public void stopEditing() {
        TableUtil.stopEditing((JTable)this.e);
    }

    public void initFromModel() {
        if (this.i == 0) {
            this.forceInitFromModel();
        }
    }

    public void forceInitFromModel() {
        HashSet hashSet = new HashSet();
        int[] object = this.e.getSelectedRows();
        int n2 = object.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = object[i2];
            ContainerUtil.addIfNotNull(hashSet, this.c(n3));
        }
        this.f.clear();
        this.f.init();
        this.f.fireTableDataChanged();
        TIntArrayList tIntArrayList = new TIntArrayList();
        for (n2 = 0; n2 < this.f.getRowCount(); ++n2) {
            if (!hashSet.contains(this.c(n2))) continue;
            tIntArrayList.add(n2);
        }
        TableUtil.selectRows((JTable)this.e, (int[])tIntArrayList.toNativeArray());
    }

    static CellAppearanceEx getCellAppearance(ClasspathTableItem<?> classpathTableItem, StructureConfigurableContext structureConfigurableContext, boolean bl2) {
        OrderEntryAppearanceService orderEntryAppearanceService = OrderEntryAppearanceService.getInstance();
        if (classpathTableItem instanceof InvalidJdkItem) {
            return orderEntryAppearanceService.forJdk(null, false, bl2, true);
        }
        Object obj = classpathTableItem.getEntry();
        assert (obj != null) : classpathTableItem;
        return orderEntryAppearanceService.forOrderEntry(structureConfigurableContext.getProject(), obj, bl2);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "order";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/classpath/ClasspathPanelImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableLevel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/classpath/ClasspathPanelImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextSortOrder";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiableModelProvider";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNextSortOrder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getModifiableModelProvider";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "selectOrderEntry";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class AnalyzeDependencyAction
    extends AnAction {
        private AnalyzeDependencyAction() {
            super("Analyze This Dependency");
        }

        public void actionPerformed(@NotNull AnActionEvent anActionEvent) {
            GlobalSearchScope globalSearchScope;
            OrderEntry orderEntry;
            if (anActionEvent == null) {
                AnalyzeDependencyAction.a(0);
            }
            if ((orderEntry = ClasspathPanelImpl.this.getSelectedEntry()) instanceof ModuleOrderEntry) {
                Module module2 = ((ModuleOrderEntry)orderEntry).getModule();
                c.assertTrue(module2 != null);
                globalSearchScope = GlobalSearchScope.moduleScope((Module)module2);
            } else {
                Library library = ((LibraryOrderEntry)orderEntry).getLibrary();
                c.assertTrue(library != null);
                globalSearchScope = new LibraryScope(ClasspathPanelImpl.this.getProject(), library);
            }
            new AnalyzeDependenciesOnSpecifiedTargetHandler(ClasspathPanelImpl.this.getProject(), new AnalysisScope(ClasspathPanelImpl.this.a.getRootModel().getModule()), globalSearchScope){

                protected boolean shouldShowDependenciesPanel(List<DependenciesBuilder> list2) {
                    for (DependenciesBuilder dependenciesBuilder : list2) {
                        for (Set set : dependenciesBuilder.getDependencies().values()) {
                            if (set.isEmpty()) continue;
                            Messages.showInfoMessage((Project)this.myProject, (String)("Dependencies were successfully collected in \"" + ToolWindowId.DEPENDENCIES + "\" toolwindow"), (String)FindBundle.message((String)"find.pointcut.applications.not.found.title", (Object[])new Object[0]));
                            return true;
                        }
                    }
                    Object object = "No code dependencies were found.";
                    if (DependencyVisitorFactory.VisitorOptions.fromSettings((Project)this.myProject).skipImports()) {
                        object = (String)object + " ";
                        object = (String)object + AnalysisScopeBundle.message((String)"dependencies.in.imports.message", (Object[])new Object[0]);
                    }
                    if (Messages.showOkCancelDialog((Project)this.myProject, (String)(object = (String)object + " Would you like to remove the dependency?"), (String)CommonBundle.getWarningTitle(), (Icon)Messages.getWarningIcon()) == 0) {
                        ClasspathPanelImpl.this.a(TableUtil.removeSelectedItems((JTable)ClasspathPanelImpl.this.e));
                    }
                    return false;
                }

                protected boolean canStartInBackground() {
                    return false;
                }
            }.analyze();
        }

        public void update(@NotNull AnActionEvent anActionEvent) {
            if (anActionEvent == null) {
                AnalyzeDependencyAction.a(1);
            }
            OrderEntry orderEntry = ClasspathPanelImpl.this.getSelectedEntry();
            anActionEvent.getPresentation().setVisible(orderEntry instanceof ModuleOrderEntry && ((ModuleOrderEntry)orderEntry).getModule() != null || orderEntry instanceof LibraryOrderEntry && ((LibraryOrderEntry)orderEntry).getLibrary() != null);
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/classpath/ClasspathPanelImpl$AnalyzeDependencyAction";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyFindUsagesAction
    extends FindUsagesInProjectStructureActionBase {
        private MyFindUsagesAction() {
            super((JComponent)ClasspathPanelImpl.this.e, ClasspathPanelImpl.this.a.getProject());
        }

        @Override
        protected boolean isEnabled() {
            return this.getSelectedElement() != null;
        }

        @Override
        protected ProjectStructureElement getSelectedElement() {
            Sdk sdk;
            OrderEntry orderEntry = ClasspathPanelImpl.this.getSelectedEntry();
            if (orderEntry instanceof LibraryOrderEntry) {
                Library library = ((LibraryOrderEntry)orderEntry).getLibrary();
                if (library != null) {
                    return new LibraryProjectStructureElement(this.getContext(), library);
                }
            } else if (orderEntry instanceof ModuleOrderEntry) {
                Module module2 = ((ModuleOrderEntry)orderEntry).getModule();
                if (module2 != null) {
                    return new ModuleProjectStructureElement(this.getContext(), module2);
                }
            } else if (orderEntry instanceof JdkOrderEntry && (sdk = ((JdkOrderEntry)orderEntry).getJdk()) != null) {
                return new SdkProjectStructureElement(this.getContext(), sdk);
            }
            return null;
        }

        @Override
        protected RelativePoint getPointToShowResults() {
            Rectangle rectangle = ClasspathPanelImpl.this.e.getCellRect(ClasspathPanelImpl.this.e.getSelectedRow(), 1, false);
            Point point = rectangle.getLocation();
            point.y += rectangle.height;
            return new RelativePoint((Component)ClasspathPanelImpl.this.e, point);
        }
    }

    private static class ExportFlagRenderer
    implements TableCellRenderer {
        private final TableCellRenderer b;
        private final JPanel a;

        public ExportFlagRenderer(TableCellRenderer tableCellRenderer) {
            this.b = tableCellRenderer;
            this.a = new JPanel();
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
            if (!jTable.isCellEditable(n2, n3)) {
                this.a.setBackground(bl2 ? jTable.getSelectionBackground() : jTable.getBackground());
                return this.a;
            }
            return this.b.getTableCellRendererComponent(jTable, object, bl2, bl3, n2, n3);
        }
    }

    private static class TableItemRenderer
    extends ColoredTableCellRenderer {
        private final Border a = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        private final StructureConfigurableContext b;

        public TableItemRenderer(StructureConfigurableContext structureConfigurableContext) {
            this.b = structureConfigurableContext;
        }

        protected void customizeCellRenderer(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
            this.setPaintFocusBorder(false);
            this.setFocusBorderAroundIcon(true);
            this.setBorder(this.a);
            if (object instanceof ClasspathTableItem) {
                ClasspathTableItem classpathTableItem = (ClasspathTableItem)object;
                ClasspathPanelImpl.getCellAppearance(classpathTableItem, this.b, bl2).customize((SimpleColoredComponent)this);
                this.setToolTipText(classpathTableItem.getTooltipText());
            }
        }
    }
}

