/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.classpath;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.classpath.AddNewLibraryDependencyAction;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanel;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryPresentationManager;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesModifiableModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.Predicate;
import com.intellij.util.ui.classpath.ChooseLibrariesDialogBase;
import com.intellij.util.ui.classpath.ChooseLibrariesFromTablesDialog;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectStructureChooseLibrariesDialog
extends ChooseLibrariesFromTablesDialog {
    private final ClasspathPanel g;
    private final StructureConfigurableContext k;
    private final Predicate<Library> h;
    private final List<Library> i = new ArrayList<Library>();
    private JButton j;

    public ProjectStructureChooseLibrariesDialog(ClasspathPanel classpathPanel, StructureConfigurableContext structureConfigurableContext, Predicate<Library> predicate) {
        super(classpathPanel.getComponent(), "Choose Libraries", classpathPanel.getProject(), true);
        this.g = classpathPanel;
        this.k = structureConfigurableContext;
        this.h = predicate;
        this.setOKButtonText("Add Selected");
        this.init();
    }

    @Override
    protected void doOKAction() {
        super.doOKAction();
        this.a(this.getSelectedLibraries());
    }

    public void doCancelAction() {
        super.doCancelAction();
        this.a(Collections.emptyList());
    }

    private void a(Collection<Library> collection) {
        for (Library library : this.i) {
            if (collection.contains(library)) continue;
            this.g.getRootModel().getModuleLibraryTable().removeLibrary(library);
        }
    }

    @Override
    protected void collectChildren(Object object, List<Object> list2) {
        if (object instanceof Application && !this.i.isEmpty()) {
            list2.add(this.g.getRootModel().getModuleLibraryTable());
        }
        super.collectChildren(object, list2);
    }

    @Override
    @NotNull
    protected Library[] getLibraries(@NotNull LibraryTable libraryTable) {
        if (libraryTable == null) {
            ProjectStructureChooseLibrariesDialog.c(0);
        }
        if (libraryTable.getTableLevel().equals("module")) {
            Library[] libraryArray = this.i.toArray(Library.EMPTY_ARRAY);
            if (libraryArray == null) {
                ProjectStructureChooseLibrariesDialog.c(1);
            }
            return libraryArray;
        }
        LibrariesModifiableModel librariesModifiableModel = this.a(libraryTable);
        if (librariesModifiableModel == null) {
            if (Library.EMPTY_ARRAY == null) {
                ProjectStructureChooseLibrariesDialog.c(2);
            }
            return Library.EMPTY_ARRAY;
        }
        Library[] libraryArray = librariesModifiableModel.getLibraries();
        if (libraryArray == null) {
            ProjectStructureChooseLibrariesDialog.c(3);
        }
        return libraryArray;
    }

    @Nullable
    private LibrariesModifiableModel a(LibraryTable libraryTable) {
        return libraryTable != null ? this.k.myLevel2Providers.get(libraryTable.getTableLevel()) : null;
    }

    @Override
    protected boolean acceptsElement(Object object) {
        if (object instanceof Library) {
            Library library = (Library)object;
            return this.h.apply((Object)library);
        }
        return true;
    }

    @NotNull
    private String a(@NotNull Library library) {
        LibrariesModifiableModel librariesModifiableModel;
        if (library == null) {
            ProjectStructureChooseLibrariesDialog.c(4);
        }
        if ((librariesModifiableModel = this.a(library.getTable())) != null && librariesModifiableModel.hasLibraryEditor(library)) {
            String string = librariesModifiableModel.getLibraryEditor(library).getName();
            if (string == null) {
                ProjectStructureChooseLibrariesDialog.c(5);
            }
            return string;
        }
        String string = library.getName();
        if (string == null) {
            ProjectStructureChooseLibrariesDialog.c(6);
        }
        return string;
    }

    @NotNull
    protected Action[] createActions() {
        if (SystemInfo.isMac) {
            Action[] actionArray = new Action[]{this.getCancelAction(), new CreateNewLibraryAction(), this.getOKAction()};
            if (actionArray == null) {
                ProjectStructureChooseLibrariesDialog.c(7);
            }
            return actionArray;
        }
        Action[] actionArray = new Action[]{this.getOKAction(), new CreateNewLibraryAction(), this.getCancelAction()};
        if (actionArray == null) {
            ProjectStructureChooseLibrariesDialog.c(8);
        }
        return actionArray;
    }

    protected JButton createJButtonForAction(Action action) {
        JButton jButton = super.createJButtonForAction(action);
        if (action instanceof CreateNewLibraryAction) {
            this.j = jButton;
        }
        return jButton;
    }

    @Override
    protected ChooseLibrariesDialogBase.LibrariesTreeNodeBase<Library> createLibraryDescriptor(NodeDescriptor nodeDescriptor, Library library) {
        String string = this.a(library);
        return new LibraryEditorDescriptor(this.getProject(), nodeDescriptor, library, string, this.k);
    }

    private static /* synthetic */ void c(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/classpath/ProjectStructureChooseLibrariesDialog";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/classpath/ProjectStructureChooseLibrariesDialog";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraries";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLibraries";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CreateNewLibraryAction
    extends DialogWrapper.DialogWrapperAction {
        private CreateNewLibraryAction() {
            super((DialogWrapper)ProjectStructureChooseLibrariesDialog.this, "New Library...");
            this.putValue("MnemonicKey", 78);
        }

        protected void doAction(ActionEvent actionEvent) {
            AddNewLibraryDependencyAction.chooseTypeAndCreate(ProjectStructureChooseLibrariesDialog.this.g, ProjectStructureChooseLibrariesDialog.this.k, ProjectStructureChooseLibrariesDialog.this.j, new AddNewLibraryDependencyAction.LibraryCreatedCallback(){

                @Override
                public void libraryCreated(@NotNull Library library) {
                    if (library == null) {
                        1.a(0);
                    }
                    if (library.getTable() == null) {
                        ProjectStructureChooseLibrariesDialog.this.i.add(library);
                    }
                    ProjectStructureChooseLibrariesDialog.this.queueUpdateAndSelect(library);
                }

                private static /* synthetic */ void a(int n2) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/ui/configuration/classpath/ProjectStructureChooseLibrariesDialog$CreateNewLibraryAction$1", "libraryCreated"));
                }
            });
        }
    }

    private static class LibraryEditorDescriptor
    extends ChooseLibrariesDialogBase.LibrariesTreeNodeBase<Library> {
        protected LibraryEditorDescriptor(Project project2, NodeDescriptor nodeDescriptor, Library library, String string, StructureConfigurableContext structureConfigurableContext) {
            super(project2, nodeDescriptor, library);
            PresentationData presentationData = this.getTemplatePresentation();
            Icon icon = LibraryPresentationManager.getInstance().getNamedLibraryIcon(library, structureConfigurableContext);
            presentationData.setIcon(icon);
            presentationData.addText(string, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }
}

