/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.ui.Util;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.NativeLibraryOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.ui.AttachRootButtonDescriptor;
import com.intellij.openapi.roots.libraries.ui.DescendentBasedRootFilter;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.libraries.ui.OrderRootTypePresentation;
import com.intellij.openapi.roots.libraries.ui.RootDetector;
import com.intellij.openapi.roots.ui.OrderRootTypeUIFactory;
import com.intellij.openapi.roots.ui.configuration.LibrarySourceRootDetectorUtil;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.JavadocQuarantineStatusCleaner;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultLibraryRootsComponentDescriptor
extends LibraryRootsComponentDescriptor {
    private static final Set<String> a = ContainerUtil.newTroveSet((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY, (Object[])new String[]{"dll", "so", "dylib"});
    public static final Condition<VirtualFile> LIBRARY_ROOT_CONDITION = virtualFile -> FileElement.isArchive((VirtualFile)virtualFile) || DefaultLibraryRootsComponentDescriptor.b(virtualFile);

    public OrderRootTypePresentation getRootTypePresentation(@NotNull OrderRootType orderRootType) {
        if (orderRootType == null) {
            DefaultLibraryRootsComponentDescriptor.a(0);
        }
        return DefaultLibraryRootsComponentDescriptor.getDefaultPresentation(orderRootType);
    }

    @NotNull
    public List<? extends AttachRootButtonDescriptor> createAttachButtons() {
        List<AttachUrlJavadocDescriptor> list2 = Collections.singletonList(new AttachUrlJavadocDescriptor());
        if (list2 == null) {
            DefaultLibraryRootsComponentDescriptor.a(1);
        }
        return list2;
    }

    @NotNull
    public List<? extends RootDetector> getRootDetectors() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new DescendentBasedRootFilter(OrderRootType.CLASSES, false, "classes", virtualFile -> StdFileTypes.CLASS.equals(virtualFile.getFileType()) || virtualFile.getFileSystem() instanceof JarFileSystem && DefaultLibraryRootsComponentDescriptor.b(virtualFile)));
        arrayList.add(DescendentBasedRootFilter.createFileTypeBasedFilter((OrderRootType)OrderRootType.CLASSES, (boolean)true, (FileType)StdFileTypes.CLASS, (String)"jar directory"));
        ContainerUtil.addAll(arrayList, (Object[])Extensions.getExtensions(LibrarySourceRootDetectorUtil.JAVA_SOURCE_ROOT_DETECTOR));
        arrayList.add(DescendentBasedRootFilter.createFileTypeBasedFilter((OrderRootType)OrderRootType.SOURCES, (boolean)true, (FileType)StdFileTypes.JAVA, (String)"source archive directory"));
        arrayList.add((Object)new JavadocRootDetector());
        arrayList.add(new DescendentBasedRootFilter(AnnotationOrderRootType.getInstance(), false, "external annotations", virtualFile -> "annotations.xml".equals(virtualFile.getName())));
        arrayList.add((Object)new NativeLibraryRootFilter());
        ArrayList<Object> arrayList2 = arrayList;
        if (arrayList2 == null) {
            DefaultLibraryRootsComponentDescriptor.a(2);
        }
        return arrayList2;
    }

    private static boolean b(VirtualFile virtualFile) {
        String string = virtualFile.getExtension();
        return string != null && a.contains(string);
    }

    @NotNull
    public FileChooserDescriptor createAttachFilesChooserDescriptor(@Nullable String string) {
        FileChooserDescriptor fileChooserDescriptor = new FileChooserDescriptor(true, true, true, false, true, true).withFileFilter(LIBRARY_ROOT_CONDITION);
        fileChooserDescriptor.setTitle(StringUtil.isEmpty((String)string) ? ProjectBundle.message((String)"library.attach.files.action", (Object[])new Object[0]) : ProjectBundle.message((String)"library.attach.files.to.library.action", (Object[])new Object[]{string}));
        fileChooserDescriptor.setDescription(ProjectBundle.message((String)"library.java.attach.files.description", (Object[])new Object[0]));
        FileChooserDescriptor fileChooserDescriptor2 = fileChooserDescriptor;
        if (fileChooserDescriptor2 == null) {
            DefaultLibraryRootsComponentDescriptor.a(3);
        }
        return fileChooserDescriptor2;
    }

    public static OrderRootTypePresentation getDefaultPresentation(OrderRootType orderRootType) {
        OrderRootTypeUIFactory orderRootTypeUIFactory = (OrderRootTypeUIFactory)OrderRootTypeUIFactory.FACTORY.getByKey((Object)orderRootType);
        return new OrderRootTypePresentation(orderRootTypeUIFactory.getNodeText(), orderRootTypeUIFactory.getIcon());
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/DefaultLibraryRootsComponentDescriptor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/DefaultLibraryRootsComponentDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createAttachButtons";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootDetectors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createAttachFilesChooserDescriptor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRootTypePresentation";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AttachUrlJavadocDescriptor
    extends AttachRootButtonDescriptor {
        private AttachUrlJavadocDescriptor() {
            super(JavadocOrderRootType.getInstance(), IconUtil.getAddLinkIcon(), ProjectBundle.message((String)"module.libraries.javadoc.url.button", (Object[])new Object[0]));
        }

        public VirtualFile[] selectFiles(@NotNull JComponent jComponent, @Nullable VirtualFile virtualFile, @Nullable Module module2, @NotNull LibraryEditor libraryEditor) {
            VirtualFile[] virtualFileArray;
            VirtualFile virtualFile2;
            if (jComponent == null) {
                AttachUrlJavadocDescriptor.a(0);
            }
            if (libraryEditor == null) {
                AttachUrlJavadocDescriptor.a(1);
            }
            if ((virtualFile2 = Util.showSpecifyJavadocUrlDialog((JComponent)jComponent)) != null) {
                VirtualFile[] virtualFileArray2 = new VirtualFile[1];
                virtualFileArray = virtualFileArray2;
                virtualFileArray2[0] = virtualFile2;
            } else {
                virtualFileArray = VirtualFile.EMPTY_ARRAY;
            }
            return virtualFileArray;
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "libraryEditor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/DefaultLibraryRootsComponentDescriptor$AttachUrlJavadocDescriptor";
            objectArray[2] = "selectFiles";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class NativeLibraryRootFilter
    extends RootDetector {
        private NativeLibraryRootFilter() {
            super(NativeLibraryOrderRootType.getInstance(), false, "native library location");
        }

        @NotNull
        public Collection<VirtualFile> detectRoots(@NotNull VirtualFile virtualFile, @NotNull ProgressIndicator progressIndicator) {
            if (virtualFile == null) {
                NativeLibraryRootFilter.a(0);
            }
            if (progressIndicator == null) {
                NativeLibraryRootFilter.a(1);
            }
            if (virtualFile.isInLocalFileSystem()) {
                if (virtualFile.isDirectory()) {
                    for (VirtualFile virtualFile2 : virtualFile.getChildren()) {
                        if (!DefaultLibraryRootsComponentDescriptor.b(virtualFile2)) continue;
                        Set<VirtualFile> set = Collections.singleton(virtualFile);
                        if (set == null) {
                            NativeLibraryRootFilter.a(2);
                        }
                        return set;
                    }
                } else if (DefaultLibraryRootsComponentDescriptor.b(virtualFile)) {
                    Set<VirtualFile> set = Collections.singleton(virtualFile.getParent());
                    if (set == null) {
                        NativeLibraryRootFilter.a(3);
                    }
                    return set;
                }
            }
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                NativeLibraryRootFilter.a(4);
            }
            return list2;
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootCandidate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progressIndicator";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/DefaultLibraryRootsComponentDescriptor$NativeLibraryRootFilter";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/DefaultLibraryRootsComponentDescriptor$NativeLibraryRootFilter";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "detectRoots";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "detectRoots";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class JavadocRootDetector
    extends RootDetector {
        private JavadocRootDetector() {
            super(JavadocOrderRootType.getInstance(), false, "JavaDocs");
        }

        @NotNull
        public Collection<VirtualFile> detectRoots(@NotNull VirtualFile virtualFile, @NotNull ProgressIndicator progressIndicator) {
            if (virtualFile == null) {
                JavadocRootDetector.a(0);
            }
            if (progressIndicator == null) {
                JavadocRootDetector.a(1);
            }
            ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
            JavadocRootDetector.a(virtualFile, arrayList, progressIndicator);
            JavadocQuarantineStatusCleaner.cleanIfNeeded(VfsUtilCore.toVirtualFileArray(arrayList));
            ArrayList<VirtualFile> arrayList2 = arrayList;
            if (arrayList2 == null) {
                JavadocRootDetector.a(2);
            }
            return arrayList2;
        }

        private static void a(VirtualFile virtualFile, final List<VirtualFile> list2, final ProgressIndicator progressIndicator) {
            VfsUtilCore.visitChildrenRecursively((VirtualFile)virtualFile, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                public boolean visitFile(@NotNull VirtualFile virtualFile) {
                    if (virtualFile == null) {
                        1.a(0);
                    }
                    progressIndicator.checkCanceled();
                    if (virtualFile.isDirectory() && virtualFile.findChild("allclasses-frame.html") != null && virtualFile.findChild("allclasses-noframe.html") != null) {
                        list2.add(virtualFile);
                        return false;
                    }
                    return true;
                }

                private static /* synthetic */ void a(int n2) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/ui/configuration/libraryEditor/DefaultLibraryRootsComponentDescriptor$JavadocRootDetector$1", "visitFile"));
                }
            });
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 2: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootCandidate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progressIndicator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/DefaultLibraryRootsComponentDescriptor$JavadocRootDetector";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/DefaultLibraryRootsComponentDescriptor$JavadocRootDetector";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "detectRoots";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "detectRoots";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

