/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IconUtilEx;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryTableTreeContentElement;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.OrderRootTypeElement;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.http.HttpFileSystem;
import com.intellij.util.PlatformIcons;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

class ItemElement
extends LibraryTableTreeContentElement<ItemElement> {
    protected final String myUrl;
    private final OrderRootType a;

    public ItemElement(@NotNull OrderRootTypeElement orderRootTypeElement, @NotNull String string, @NotNull OrderRootType orderRootType, boolean bl2, boolean bl3) {
        if (orderRootTypeElement == null) {
            ItemElement.a(0);
        }
        if (string == null) {
            ItemElement.a(1);
        }
        if (orderRootType == null) {
            ItemElement.a(2);
        }
        super(orderRootTypeElement);
        this.myUrl = string;
        this.myName = ItemElement.getPresentablePath(string).replace('/', File.separatorChar);
        this.myColor = ItemElement.getForegroundColor(bl3);
        this.setIcon(ItemElement.a(string, bl3, bl2));
        this.a = orderRootType;
    }

    private static Icon a(String string, boolean bl2, boolean bl3) {
        VirtualFile virtualFile;
        Icon icon = bl2 ? ((virtualFile = ItemElement.a(string) ? LocalFileSystem.getInstance().findFileByPath(ItemElement.getPresentablePath(string)) : VirtualFileManager.getInstance().findFileByUrl(string)) != null && virtualFile.isValid() ? (virtualFile.getFileSystem() instanceof HttpFileSystem ? PlatformIcons.WEB_ICON : (virtualFile.isDirectory() ? (bl3 ? AllIcons.Nodes.JarDirectory : PlatformIcons.DIRECTORY_CLOSED_ICON) : IconUtilEx.getIcon((Object)virtualFile, (int)0, null))) : AllIcons.Nodes.PpInvalid) : AllIcons.Nodes.PpInvalid;
        return icon;
    }

    public static String getPresentablePath(String string) {
        String string2 = VirtualFileManager.extractPath((String)string);
        if (ItemElement.a(string)) {
            string2 = string2.substring(0, string2.length() - "!/".length());
        }
        return string2;
    }

    private static boolean a(String string) {
        return VirtualFileManager.extractPath((String)string).endsWith("!/");
    }

    public OrderRootTypeElement getParent() {
        return (OrderRootTypeElement)this.getParentDescriptor();
    }

    @NotNull
    public OrderRootType getRootType() {
        OrderRootType orderRootType = this.a;
        if (orderRootType == null) {
            ItemElement.a(3);
        }
        return orderRootType;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ItemElement)) {
            return false;
        }
        ItemElement itemElement = (ItemElement)((Object)object);
        if (!this.getParent().equals((Object)itemElement.getParent())) {
            return false;
        }
        if (!this.a.equals((Object)itemElement.a)) {
            return false;
        }
        return this.myUrl.equals(itemElement.myUrl);
    }

    @NotNull
    public String getUrl() {
        String string = this.myUrl;
        if (string == null) {
            ItemElement.a(4);
        }
        return string;
    }

    public int hashCode() {
        int n2 = this.getParent().hashCode();
        n2 = 29 * n2 + this.myUrl.hashCode();
        n2 = 29 * n2 + this.a.hashCode();
        return n2;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 4: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/ItemElement";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/ItemElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

