/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.facet.impl.ProjectFacetsConfigurator;
import com.intellij.ide.util.ChooseElementsDialog;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ChooseModulesDialog;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.FacetStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.ui.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

class AddFacetOfTypeAction
extends DumbAwareAction {
    private final FacetType a;
    private final StructureConfigurableContext b;

    AddFacetOfTypeAction(FacetType facetType, StructureConfigurableContext structureConfigurableContext) {
        super(facetType.getPresentableName(), null, facetType.getIcon());
        this.a = facetType;
        this.b = structureConfigurableContext;
    }

    public void actionPerformed(AnActionEvent anActionEvent) {
        FacetType facetType = this.a;
        if (facetType == null) {
            return;
        }
        FacetTypeId facetTypeId = facetType.getUnderlyingFacetType();
        if (facetTypeId == null) {
            this.a(facetType);
        } else {
            this.a(facetType, facetTypeId);
        }
    }

    private void a(FacetType facetType, FacetTypeId<?> facetTypeId) {
        ProjectFacetsConfigurator projectFacetsConfigurator = this.b.getModulesConfigurator().getFacetsConfigurator();
        ArrayList arrayList = new ArrayList();
        for (Module object2 : this.b.getModules()) {
            if (!facetType.isSuitableModuleType(ModuleType.get((Module)object2))) continue;
            arrayList.addAll(projectFacetsConfigurator.getFacetsByType(object2, facetTypeId));
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Facet facet = (Facet)iterator.next();
            if (!facetType.isOnlyOneFacetAllowed() || !projectFacetsConfigurator.hasFacetOfType(facet.getModule(), facet, facetType.getId())) continue;
            iterator.remove();
        }
        Project project2 = this.b.getProject();
        if (arrayList.isEmpty()) {
            String string = FacetTypeRegistry.getInstance().findFacetType(facetTypeId).getPresentableName();
            Messages.showErrorDialog((Project)project2, (String)("No suitable parent " + string + " facets found"), (String)("Cannot Create " + facetType.getPresentableName() + " Facet"));
            return;
        }
        ChooseParentFacetDialog chooseParentFacetDialog = new ChooseParentFacetDialog(project2, arrayList);
        chooseParentFacetDialog.show();
        List list2 = chooseParentFacetDialog.getChosenElements();
        if (!chooseParentFacetDialog.isOK() || list2.size() != 1) {
            return;
        }
        Facet facet = (Facet)list2.get(0);
        Facet facet2 = ModuleStructureConfigurable.getInstance(project2).getFacetEditorFacade().createAndAddFacet(facetType, facet.getModule(), facet);
        ProjectStructureConfigurable.getInstance(project2).select(facet2, true);
    }

    private void a(@NotNull FacetType facetType) {
        Module module2;
        if (facetType == null) {
            AddFacetOfTypeAction.a(0);
        }
        ProjectFacetsConfigurator projectFacetsConfigurator = this.b.getModulesConfigurator().getFacetsConfigurator();
        ArrayList<Module> arrayList = new ArrayList<Module>(Arrays.asList(this.b.getModules()));
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            module2 = (Module)iterator.next();
            if (facetType.isSuitableModuleType(ModuleType.get((Module)module2)) && (!facetType.isOnlyOneFacetAllowed() || !projectFacetsConfigurator.hasFacetOfType(module2, null, facetType.getId()))) continue;
            iterator.remove();
        }
        module2 = this.b.getProject();
        if (arrayList.isEmpty()) {
            Messages.showErrorDialog((Project)module2, (String)("No suitable modules for " + facetType.getPresentableName() + " facet found."), (String)"Cannot Create Facet");
            return;
        }
        ChooseModulesDialog chooseModulesDialog = new ChooseModulesDialog((Project)module2, arrayList, "Choose Module", facetType.getPresentableName() + " facet will be added to selected module");
        chooseModulesDialog.setSingleSelectionMode();
        chooseModulesDialog.show();
        List list2 = chooseModulesDialog.getChosenElements();
        if (!chooseModulesDialog.isOK() || list2.size() != 1) {
            return;
        }
        Module module3 = (Module)list2.get(0);
        Facet facet = ModuleStructureConfigurable.getInstance((Project)module2).getFacetEditorFacade().createAndAddFacet(facetType, module3, null);
        ProjectStructureConfigurable.getInstance((Project)module2).select(facet, true);
    }

    public static AnAction[] createAddFacetActions(FacetStructureConfigurable facetStructureConfigurable) {
        ArrayList<AddFacetOfTypeAction> arrayList = new ArrayList<AddFacetOfTypeAction>();
        StructureConfigurableContext structureConfigurableContext = facetStructureConfigurable.myContext;
        for (FacetType facetType : FacetTypeRegistry.getInstance().getSortedFacetTypes()) {
            if (!AddFacetOfTypeAction.a(structureConfigurableContext, facetType)) continue;
            arrayList.add(new AddFacetOfTypeAction(facetType, structureConfigurableContext));
        }
        return arrayList.toArray(AnAction.EMPTY_ARRAY);
    }

    private static boolean a(StructureConfigurableContext structureConfigurableContext, FacetType facetType) {
        for (Module module2 : structureConfigurableContext.getModules()) {
            if (!facetType.isSuitableModuleType(ModuleType.get((Module)module2))) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/roots/ui/configuration/projectRoot/AddFacetOfTypeAction", "addFacetToModule"));
    }

    private static class ChooseParentFacetDialog
    extends ChooseElementsDialog<Facet> {
        private ChooseParentFacetDialog(Project project2, List<? extends Facet> list2) {
            super(project2, list2, "Select Parent Facet", null, true);
            this.myChooser.setSingleSelectionMode();
        }

        protected String getItemText(Facet facet) {
            return facet.getName() + " (module " + facet.getModule().getName() + ")";
        }

        protected Icon getItemIcon(Facet facet) {
            return facet.getType().getIcon();
        }
    }
}

