/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryPresentationManager;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryRootsComponent;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectStructureElementConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureLibraryTableModifiableModelProvider;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryConfigurable
extends ProjectStructureElementConfigurable<Library> {
    private LibraryRootsComponent a;
    private final Library f;
    private final StructureLibraryTableModifiableModelProvider d;
    private final StructureConfigurableContext h;
    private final Project c;
    private final LibraryProjectStructureElement g;
    private boolean b;
    private boolean e;

    protected LibraryConfigurable(StructureLibraryTableModifiableModelProvider structureLibraryTableModifiableModelProvider, Library library, StructureConfigurableContext structureConfigurableContext, Runnable runnable) {
        super(true, runnable);
        this.d = structureLibraryTableModifiableModelProvider;
        this.h = structureConfigurableContext;
        this.c = structureConfigurableContext.getProject();
        this.f = library;
        this.g = new LibraryProjectStructureElement(structureConfigurableContext, this.f);
    }

    public JComponent createOptionsPanel() {
        this.a = new LibraryRootsComponent(this.c, (Computable<LibraryEditor>)((Computable)() -> this.getLibraryEditor()));
        this.a.addListener(() -> {
            this.h.getDaemonAnalyzer().queueUpdate(this.g);
            this.updateName();
        });
        return this.a.getComponent();
    }

    public boolean isModified() {
        return this.a != null && this.a.hasChanges();
    }

    @Override
    @NotNull
    public ProjectStructureElement getProjectStructureElement() {
        LibraryProjectStructureElement libraryProjectStructureElement = this.g;
        if (libraryProjectStructureElement == null) {
            LibraryConfigurable.a(0);
        }
        return libraryProjectStructureElement;
    }

    public void apply() {
        this.a();
    }

    public void reset() {
        this.d();
    }

    public void disposeUIResources() {
        if (this.a != null) {
            Disposer.dispose((Disposable)this.a);
            this.a = null;
        }
    }

    public void setDisplayName(String string) {
        if (!this.b) {
            this.getLibraryEditor().setName(string);
            if (this.a != null) {
                this.a.onLibraryRenamed();
            }
            this.h.getDaemonAnalyzer().queueUpdateForAllElementsWithErrors();
        }
    }

    protected LibraryEditor getLibraryEditor() {
        return this.d.getModifiableModel().getLibraryEditor(this.f);
    }

    public void updateName() {
        this.b = true;
        try {
            super.updateName();
        }
        finally {
            this.b = false;
        }
    }

    public Library getEditableObject() {
        return this.f;
    }

    public String getBannerSlogan() {
        LibraryTable libraryTable = this.f.getTable();
        String string = libraryTable == null ? ProjectBundle.message((String)"module.library.display.name", (Object[])new Object[]{1}) : libraryTable.getPresentation().getDisplayName(false);
        return ProjectBundle.message((String)"project.roots.library.banner.text", (Object[])new Object[]{this.getDisplayName(), string});
    }

    public String getDisplayName() {
        if (this.d.getModifiableModel().hasLibraryEditor(this.f)) {
            return this.getLibraryEditor().getName();
        }
        return this.f.getName();
    }

    public void onSelected() {
        this.d();
    }

    public void onUnselected() {
        this.a();
    }

    private void d() {
        if (this.a != null) {
            this.a.updatePropertiesLabel();
            this.a.resetProperties();
            this.e = true;
        }
    }

    private void a() {
        if (this.a != null && this.e) {
            this.a.applyProperties();
            this.e = false;
        }
    }

    public Icon getIcon(boolean bl2) {
        return LibraryPresentationManager.getInstance().getNamedLibraryIcon(this.f, this.h);
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "preferences.jdkGlobalLibs";
    }

    public void updateComponent() {
        if (this.a != null) {
            this.a.updateRootsTree();
        }
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibraryConfigurable", "getProjectStructureElement"));
    }
}

