/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleGrouper;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectStructureElementConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.navigation.Place;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleConfigurable
extends ProjectStructureElementConfigurable<Module>
implements Place.Navigator {
    private final Module a;
    private final ModuleGrouper e;
    private final ModulesConfigurator f;
    private String b;
    private final ModuleProjectStructureElement d;
    private final StructureConfigurableContext c;

    public ModuleConfigurable(ModulesConfigurator modulesConfigurator, Module module2, Runnable runnable, ModuleGrouper moduleGrouper) {
        super(true, runnable);
        this.a = module2;
        this.e = moduleGrouper;
        this.f = modulesConfigurator;
        this.b = this.f.getModuleModel().getActualName(this.a);
        this.c = ModuleStructureConfigurable.getInstance(this.a.getProject()).getContext();
        this.d = new ModuleProjectStructureElement(this.c, this.a);
    }

    public void setDisplayName(String string) {
        ModifiableModuleModel modifiableModuleModel = this.f.getModuleModel();
        if (StringUtil.isEmpty((String)string)) {
            return;
        }
        if (Comparing.strEqual((String)string, (String)this.b)) {
            return;
        }
        try {
            modifiableModuleModel.renameModule(this.a, string);
        }
        catch (ModuleWithNameAlreadyExists moduleWithNameAlreadyExists) {
            // empty catch block
        }
        this.f.moduleRenamed(this.a, this.b, string);
        this.b = string;
        this.f.setModified(!Comparing.strEqual((String)this.b, (String)this.a.getName()));
        this.c.getDaemonAnalyzer().queueUpdateForAllElementsWithErrors();
    }

    protected void checkName(@NotNull String string2) throws ConfigurationException {
        if (string2 == null) {
            ModuleConfigurable.a(0);
        }
        super.checkName(string2);
        if (this.e.getShortenedNameByFullModuleName(string2).isEmpty()) {
            throw new ConfigurationException("Short name of a module cannot be empty");
        }
        List list2 = this.e.getGroupPathByModuleName(string2);
        if (list2.stream().anyMatch(string -> string.isEmpty())) {
            throw new ConfigurationException("Names of parent groups for a module cannot be empty");
        }
    }

    public ModuleGrouper getModuleGrouper() {
        return this.e;
    }

    @Override
    public ProjectStructureElement getProjectStructureElement() {
        return this.d;
    }

    public Module getEditableObject() {
        return this.a;
    }

    public String getBannerSlogan() {
        return ProjectBundle.message((String)"project.roots.module.banner.text", (Object[])new Object[]{this.b});
    }

    public String getDisplayName() {
        return this.b;
    }

    public Icon getIcon(boolean bl2) {
        return this.a.isDisposed() ? null : ModuleType.get((Module)this.a).getIcon();
    }

    public Module getModule() {
        return this.a;
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        ModuleEditor moduleEditor = this.getModuleEditor();
        return moduleEditor == null ? null : moduleEditor.getHelpTopic();
    }

    public JComponent createOptionsPanel() {
        ModuleEditor moduleEditor = this.getModuleEditor();
        return moduleEditor == null ? null : moduleEditor.getPanel();
    }

    public boolean isModified() {
        return false;
    }

    public void apply() throws ConfigurationException {
    }

    public ModuleEditor getModuleEditor() {
        return this.f.getModuleEditor(this.a);
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean bl2) {
        ModuleEditor moduleEditor = this.getModuleEditor();
        return moduleEditor == null ? ActionCallback.REJECTED : moduleEditor.navigateTo(place, bl2);
    }

    public void queryPlace(@NotNull Place place) {
        ModuleEditor moduleEditor;
        if (place == null) {
            ModuleConfigurable.a(1);
        }
        if ((moduleEditor = this.getModuleEditor()) != null) {
            moduleEditor.queryPlace(place);
        }
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/ModuleConfigurable";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "queryPlace";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

