/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.compiler;

import com.intellij.compiler.impl.ModuleCompileScope;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.elements.ArtifactElementType;
import com.intellij.packaging.impl.elements.ProductionModuleOutputElementType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactCompileScope {
    private static final Key<Boolean> c = Key.create((String)"force_artifact_build");
    private static final Key<Artifact[]> a = Key.create((String)"artifacts");
    private static final Key<Set<Artifact>> b = Key.create((String)"cached_artifacts");

    private ArtifactCompileScope() {
    }

    public static ModuleCompileScope createScopeForModulesInArtifacts(@NotNull Project project2, @NotNull Collection<? extends Artifact> collection) {
        if (project2 == null) {
            ArtifactCompileScope.a(0);
        }
        if (collection == null) {
            ArtifactCompileScope.a(1);
        }
        Set<Module> set = ArtifactUtil.getModulesIncludedInArtifacts(collection, project2);
        return new ModuleCompileScope(project2, set.toArray(Module.EMPTY_ARRAY), true);
    }

    public static CompileScope createArtifactsScope(@NotNull Project project2, @NotNull Collection<Artifact> collection) {
        if (project2 == null) {
            ArtifactCompileScope.a(2);
        }
        if (collection == null) {
            ArtifactCompileScope.a(3);
        }
        return ArtifactCompileScope.createArtifactsScope(project2, collection, false);
    }

    public static CompileScope createArtifactsScope(@NotNull Project project2, @NotNull Collection<Artifact> collection, boolean bl2) {
        if (project2 == null) {
            ArtifactCompileScope.a(4);
        }
        if (collection == null) {
            ArtifactCompileScope.a(5);
        }
        return ArtifactCompileScope.createScopeWithArtifacts(ArtifactCompileScope.createScopeForModulesInArtifacts(project2, collection), collection, bl2);
    }

    public static CompileScope createScopeWithArtifacts(CompileScope compileScope, @NotNull Collection<Artifact> collection) {
        if (collection == null) {
            ArtifactCompileScope.a(6);
        }
        return ArtifactCompileScope.createScopeWithArtifacts(compileScope, collection, false);
    }

    public static CompileScope createScopeWithArtifacts(CompileScope compileScope, @NotNull Collection<Artifact> collection, boolean bl2) {
        if (collection == null) {
            ArtifactCompileScope.a(7);
        }
        compileScope.putUserData(a, (Object)collection.toArray(new Artifact[0]));
        if (bl2) {
            compileScope.putUserData(c, (Object)Boolean.TRUE);
        }
        return compileScope;
    }

    public static Set<Artifact> getArtifactsToBuild(Project project2, CompileScope compileScope, boolean bl2) {
        Artifact[] artifactArray = ArtifactCompileScope.getArtifacts(compileScope);
        ArtifactManager artifactManager = ArtifactManager.getInstance((Project)project2);
        PackagingElementResolvingContext packagingElementResolvingContext = artifactManager.getResolvingContext();
        if (artifactArray != null) {
            return ArtifactCompileScope.a(Arrays.asList(artifactArray), packagingElementResolvingContext, bl2);
        }
        Set set = (Set)compileScope.getUserData(b);
        if (set != null) {
            return set;
        }
        HashSet<Artifact> hashSet = new HashSet<Artifact>();
        HashSet<Module> hashSet2 = new HashSet<Module>(Arrays.asList(compileScope.getAffectedModules()));
        List<Module> list2 = Arrays.asList(ModuleManager.getInstance((Project)project2).getModules());
        for (Artifact artifact : artifactManager.getArtifacts()) {
            if (!artifact.isBuildOnMake() || !hashSet2.containsAll(list2) && !ArtifactCompileScope.a(artifact, hashSet2, packagingElementResolvingContext)) continue;
            hashSet.add(artifact);
        }
        Set<Artifact> set2 = ArtifactCompileScope.a(hashSet, packagingElementResolvingContext, bl2);
        compileScope.putUserData(b, set2);
        return set2;
    }

    @Nullable
    public static Artifact[] getArtifacts(CompileScope compileScope) {
        return (Artifact[])compileScope.getUserData(a);
    }

    public static boolean isArtifactRebuildForced(@NotNull CompileScope compileScope) {
        if (compileScope == null) {
            ArtifactCompileScope.a(8);
        }
        return Boolean.TRUE.equals(compileScope.getUserData(c));
    }

    private static boolean a(Artifact artifact, Set<Module> set, PackagingElementResolvingContext packagingElementResolvingContext) {
        return !ArtifactUtil.processPackagingElements(artifact, ProductionModuleOutputElementType.ELEMENT_TYPE, productionModuleOutputPackagingElement -> {
            Module module2 = productionModuleOutputPackagingElement.findModule(packagingElementResolvingContext);
            return module2 == null || !set.contains(module2);
        }, packagingElementResolvingContext, true);
    }

    @NotNull
    private static Set<Artifact> a(@NotNull Collection<Artifact> collection, @NotNull PackagingElementResolvingContext packagingElementResolvingContext, boolean bl2) {
        if (collection == null) {
            ArtifactCompileScope.a(9);
        }
        if (packagingElementResolvingContext == null) {
            ArtifactCompileScope.a(10);
        }
        HashSet<Artifact> hashSet = new HashSet<Artifact>();
        for (Artifact artifact : collection) {
            ArtifactCompileScope.a(artifact, packagingElementResolvingContext, new HashSet<Artifact>(), hashSet, bl2);
        }
        HashSet<Artifact> hashSet2 = hashSet;
        if (hashSet2 == null) {
            ArtifactCompileScope.a(11);
        }
        return hashSet2;
    }

    private static void a(Artifact artifact, PackagingElementResolvingContext packagingElementResolvingContext, Set<Artifact> set, Set<Artifact> set2, boolean bl2) {
        if (!set.add(artifact)) {
            return;
        }
        if (!bl2 || !StringUtil.isEmpty((String)artifact.getOutputPath())) {
            set2.add(artifact);
        }
        ArtifactUtil.processPackagingElements(artifact, ArtifactElementType.ARTIFACT_ELEMENT_TYPE, artifactPackagingElement -> {
            Artifact artifact = artifactPackagingElement.findArtifact(packagingElementResolvingContext);
            if (artifact != null) {
                ArtifactCompileScope.a(artifact, packagingElementResolvingContext, set, set2, bl2);
            }
            return true;
        }, packagingElementResolvingContext, false);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 11: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifacts";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packaging/impl/compiler/ArtifactCompileScope";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packaging/impl/compiler/ArtifactCompileScope";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "addIncludedArtifacts";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createScopeForModulesInArtifacts";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createArtifactsScope";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createScopeWithArtifacts";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isArtifactRebuildForced";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addIncludedArtifacts";
                break;
            }
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

