/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.CommonBundle;
import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.compiler.make.ManifestBuilder;
import com.intellij.openapi.deployment.DeploymentUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.impl.elements.ArchivePackagingElement;
import com.intellij.packaging.impl.elements.DirectoryCopyPackagingElement;
import com.intellij.packaging.impl.elements.FileCopyPackagingElement;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.ManifestFileConfiguration;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.util.PathUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManifestFileUtil {
    private static final Logger a = Logger.getInstance((String)"#com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorContextImpl");
    public static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    public static final String MANIFEST_FILE_NAME = PathUtil.getFileName((String)"META-INF/MANIFEST.MF");
    public static final String MANIFEST_DIR_NAME = PathUtil.getParentPath((String)"META-INF/MANIFEST.MF");

    private ManifestFileUtil() {
    }

    @Nullable
    public static VirtualFile findManifestFile(@NotNull CompositePackagingElement<?> compositePackagingElement, PackagingElementResolvingContext packagingElementResolvingContext, ArtifactType artifactType) {
        if (compositePackagingElement == null) {
            ManifestFileUtil.a(0);
        }
        return ArtifactUtil.findSourceFileByOutputPath(compositePackagingElement, MANIFEST_PATH, packagingElementResolvingContext, artifactType);
    }

    @Nullable
    public static VirtualFile suggestManifestFileDirectory(@NotNull CompositePackagingElement<?> compositePackagingElement, PackagingElementResolvingContext packagingElementResolvingContext, ArtifactType artifactType) {
        VirtualFile virtualFile;
        if (compositePackagingElement == null) {
            ManifestFileUtil.a(1);
        }
        if ((virtualFile = ArtifactUtil.findSourceFileByOutputPath(compositePackagingElement, MANIFEST_DIR_NAME, packagingElementResolvingContext, artifactType)) != null) {
            return virtualFile;
        }
        final Ref ref = Ref.create(null);
        final Ref ref2 = Ref.create(null);
        ArtifactUtil.processElementsWithSubstitutions(compositePackagingElement.getChildren(), packagingElementResolvingContext, artifactType, PackagingElementPath.EMPTY, new PackagingElementProcessor<PackagingElement<?>>(){

            @Override
            public boolean process(@NotNull PackagingElement<?> packagingElement, @NotNull PackagingElementPath packagingElementPath) {
                VirtualFile virtualFile;
                if (packagingElement == null) {
                    1.a(0);
                }
                if (packagingElementPath == null) {
                    1.a(1);
                }
                if (packagingElement instanceof FileCopyPackagingElement) {
                    VirtualFile virtualFile2 = ((FileCopyPackagingElement)packagingElement).findFile();
                    if (virtualFile2 != null) {
                        ref2.set((Object)virtualFile2);
                    }
                } else if (packagingElement instanceof DirectoryCopyPackagingElement && (virtualFile = ((DirectoryCopyPackagingElement)packagingElement).findFile()) != null) {
                    ref.set((Object)virtualFile);
                    return false;
                }
                return true;
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/packaging/impl/elements/ManifestFileUtil$1";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (!ref.isNull()) {
            return (VirtualFile)ref.get();
        }
        Project project2 = packagingElementResolvingContext.getProject();
        return ManifestFileUtil.a(project2, (VirtualFile)ref2.get());
    }

    @Nullable
    public static VirtualFile suggestManifestFileDirectory(@NotNull Project project2, @Nullable Module module2) {
        OrderEnumerator orderEnumerator;
        VirtualFile[] virtualFileArray;
        if (project2 == null) {
            ManifestFileUtil.a(2);
        }
        if ((virtualFileArray = (orderEnumerator = module2 != null ? OrderEnumerator.orderEntries((Module)module2) : OrderEnumerator.orderEntries((Project)project2)).withoutDepModules().withoutLibraries().withoutSdk().productionOnly().sources().getRoots()).length > 0) {
            return virtualFileArray[0];
        }
        return ManifestFileUtil.a(project2, null);
    }

    @Nullable
    private static VirtualFile a(@NotNull Project project2, @Nullable VirtualFile virtualFile) {
        if (project2 == null) {
            ManifestFileUtil.a(3);
        }
        VirtualFile[] virtualFileArray = ProjectRootManager.getInstance((Project)project2).getContentRoots();
        if (virtualFile == null && virtualFileArray.length > 0) {
            return virtualFileArray[0];
        }
        if (virtualFile != null) {
            for (VirtualFile virtualFile2 : virtualFileArray) {
                if (!VfsUtil.isAncestor((VirtualFile)virtualFile2, (VirtualFile)virtualFile, (boolean)false)) continue;
                return virtualFile2;
            }
        }
        return project2.getBaseDir();
    }

    public static Manifest readManifest(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            ManifestFileUtil.a(4);
        }
        try {
            Manifest manifest;
            try (InputStream inputStream = virtualFile.getInputStream();){
                manifest = new Manifest(inputStream);
            }
            return manifest;
        }
        catch (IOException iOException) {
            return new Manifest();
        }
    }

    public static void updateManifest(@NotNull VirtualFile virtualFile, @Nullable String string, @Nullable List<String> list2, boolean bl2) {
        if (virtualFile == null) {
            ManifestFileUtil.a(5);
        }
        Manifest manifest = ManifestFileUtil.readManifest(virtualFile);
        Attributes attributes = manifest.getMainAttributes();
        if (string != null) {
            attributes.put(Attributes.Name.MAIN_CLASS, string);
        } else if (bl2) {
            attributes.remove(Attributes.Name.MAIN_CLASS);
        }
        if (list2 != null && !list2.isEmpty()) {
            List<String> list3;
            if (bl2) {
                list3 = list2;
            } else {
                list3 = new ArrayList<String>();
                String string2 = (String)attributes.get(Attributes.Name.CLASS_PATH);
                if (!StringUtil.isEmpty((String)string2)) {
                    list3.addAll(StringUtil.split((String)string2, (String)" "));
                }
                for (String string3 : list2) {
                    if (list3.contains(string3)) continue;
                    list3.add(string3);
                }
            }
            attributes.put(Attributes.Name.CLASS_PATH, StringUtil.join(list3, (String)" "));
        } else if (bl2) {
            attributes.remove(Attributes.Name.CLASS_PATH);
        }
        ManifestBuilder.setVersionAttribute((Attributes)attributes);
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (virtualFile == null) {
                ManifestFileUtil.a(16);
            }
            try (OutputStream outputStream = virtualFile.getOutputStream(ManifestFileUtil.class);){
                manifest.write(outputStream);
            }
            catch (IOException iOException) {
                a.info((Throwable)iOException);
            }
        });
    }

    @NotNull
    public static ManifestFileConfiguration createManifestFileConfiguration(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            ManifestFileUtil.a(6);
        }
        String string = virtualFile.getPath();
        Manifest manifest = ManifestFileUtil.readManifest(virtualFile);
        String string2 = manifest.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
        String string3 = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
        ArrayList arrayList = new ArrayList();
        if (string3 != null) {
            arrayList.addAll(StringUtil.split((String)string3, (String)" "));
        }
        ManifestFileConfiguration manifestFileConfiguration = new ManifestFileConfiguration(string, arrayList, string2, virtualFile.isWritable());
        if (manifestFileConfiguration == null) {
            ManifestFileUtil.a(7);
        }
        return manifestFileConfiguration;
    }

    public static List<String> getClasspathForElements(List<? extends PackagingElement<?>> list2, PackagingElementResolvingContext packagingElementResolvingContext, ArtifactType artifactType) {
        final ArrayList<String> arrayList = new ArrayList<String>();
        PackagingElementProcessor packagingElementProcessor = new PackagingElementProcessor<PackagingElement<?>>(){

            @Override
            public boolean process(@NotNull PackagingElement<?> packagingElement, @NotNull PackagingElementPath packagingElementPath) {
                if (packagingElement == null) {
                    2.a(0);
                }
                if (packagingElementPath == null) {
                    2.a(1);
                }
                if (packagingElement instanceof FileCopyPackagingElement) {
                    String string = ((FileCopyPackagingElement)packagingElement).getOutputFileName();
                    arrayList.add(DeploymentUtil.appendToPath((String)packagingElementPath.getPathString(), (String)string));
                } else if (packagingElement instanceof DirectoryCopyPackagingElement) {
                    arrayList.add(packagingElementPath.getPathString());
                } else if (packagingElement instanceof ArchivePackagingElement) {
                    String string = ((ArchivePackagingElement)packagingElement).getName();
                    arrayList.add(DeploymentUtil.appendToPath((String)packagingElementPath.getPathString(), (String)string));
                }
                return true;
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/packaging/impl/elements/ManifestFileUtil$2";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        for (PackagingElement<?> packagingElement : list2) {
            ArtifactUtil.processPackagingElements(packagingElement, null, packagingElementProcessor, packagingElementResolvingContext, true, artifactType);
        }
        return arrayList;
    }

    @Nullable
    public static VirtualFile showDialogAndCreateManifest(ArtifactEditorContext artifactEditorContext, CompositePackagingElement<?> compositePackagingElement) {
        FileChooserDescriptor fileChooserDescriptor = ManifestFileUtil.createDescriptorForManifestDirectory();
        VirtualFile virtualFile = ManifestFileUtil.suggestManifestFileDirectory(compositePackagingElement, (PackagingElementResolvingContext)artifactEditorContext, artifactEditorContext.getArtifactType());
        VirtualFile virtualFile2 = FileChooser.chooseFile((FileChooserDescriptor)fileChooserDescriptor, (Project)artifactEditorContext.getProject(), (VirtualFile)virtualFile);
        if (virtualFile2 == null) {
            return null;
        }
        return ManifestFileUtil.createManifestFile(virtualFile2, artifactEditorContext.getProject());
    }

    @Nullable
    public static VirtualFile createManifestFile(final @NotNull VirtualFile virtualFile, @NotNull Project project2) {
        if (virtualFile == null) {
            ManifestFileUtil.a(8);
        }
        if (project2 == null) {
            ManifestFileUtil.a(9);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        final Ref ref = Ref.create(null);
        VirtualFile virtualFile2 = (VirtualFile)new WriteAction<VirtualFile>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void run(@NotNull Result<VirtualFile> result2) {
                if (result2 == null) {
                    3.a(0);
                }
                VirtualFile virtualFile3 = virtualFile;
                try {
                    if (!virtualFile3.getName().equals(MANIFEST_DIR_NAME)) {
                        virtualFile3 = VfsUtil.createDirectoryIfMissing((VirtualFile)virtualFile3, (String)MANIFEST_DIR_NAME);
                    }
                    VirtualFile virtualFile2 = virtualFile3.createChildData((Object)this, MANIFEST_FILE_NAME);
                    try (OutputStream outputStream = virtualFile2.getOutputStream((Object)this);){
                        Manifest manifest = new Manifest();
                        ManifestBuilder.setVersionAttribute((Attributes)manifest.getMainAttributes());
                        manifest.write(outputStream);
                    }
                    result2.setResult((Object)virtualFile2);
                }
                catch (IOException iOException) {
                    ref.set((Object)iOException);
                }
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/packaging/impl/elements/ManifestFileUtil$3", "run"));
            }
        }.execute().getResultObject();
        IOException iOException = (IOException)ref.get();
        if (iOException != null) {
            a.info((Throwable)iOException);
            Messages.showErrorDialog((Project)project2, (String)iOException.getMessage(), (String)CommonBundle.getErrorTitle());
            return null;
        }
        return virtualFile2;
    }

    public static FileChooserDescriptor createDescriptorForManifestDirectory() {
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        fileChooserDescriptor.setTitle("Select Directory for META-INF/MANIFEST.MF file");
        return fileChooserDescriptor;
    }

    public static void addManifestFileToLayout(@NotNull String string, @NotNull ArtifactEditorContext artifactEditorContext, @NotNull CompositePackagingElement<?> compositePackagingElement) {
        if (string == null) {
            ManifestFileUtil.a(10);
        }
        if (artifactEditorContext == null) {
            ManifestFileUtil.a(11);
        }
        if (compositePackagingElement == null) {
            ManifestFileUtil.a(12);
        }
        artifactEditorContext.editLayout(artifactEditorContext.getArtifact(), () -> {
            VirtualFile virtualFile;
            if (compositePackagingElement == null) {
                ManifestFileUtil.a(13);
            }
            if (artifactEditorContext == null) {
                ManifestFileUtil.a(14);
            }
            if (string == null) {
                ManifestFileUtil.a(15);
            }
            if ((virtualFile = ManifestFileUtil.findManifestFile(compositePackagingElement, (PackagingElementResolvingContext)artifactEditorContext, artifactEditorContext.getArtifactType())) == null || !FileUtil.pathsEqual((String)virtualFile.getPath(), (String)string)) {
                PackagingElementFactory.getInstance().addFileCopy(compositePackagingElement, MANIFEST_DIR_NAME, string, MANIFEST_FILE_NAME);
            }
        });
    }

    @Nullable
    public static PsiClass selectMainClass(Project project2, @Nullable String string) {
        TreeClassChooserFactory treeClassChooserFactory = TreeClassChooserFactory.getInstance((Project)project2);
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)project2);
        PsiClass psiClass = string != null ? JavaPsiFacade.getInstance((Project)project2).findClass(string, globalSearchScope) : null;
        TreeClassChooser treeClassChooser = treeClassChooserFactory.createWithInnerClassesScopeChooser("Select Main Class", globalSearchScope, (ClassFilter)new MainClassFilter(), psiClass);
        treeClassChooser.showDialog();
        return treeClassChooser.getSelected();
    }

    public static void setupMainClassField(final Project project2, final TextFieldWithBrowseButton textFieldWithBrowseButton) {
        textFieldWithBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PsiClass psiClass = ManifestFileUtil.selectMainClass(project2, textFieldWithBrowseButton.getText());
                if (psiClass != null) {
                    textFieldWithBrowseButton.setText(psiClass.getQualifiedName());
                }
            }
        });
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 7: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manifestFile";
                break;
            }
            case 5: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packaging/impl/elements/ManifestFileUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packaging/impl/elements/ManifestFileUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createManifestFileConfiguration";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findManifestFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "suggestManifestFileDirectory";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "suggestBaseDir";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readManifest";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateManifest";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createManifestFileConfiguration";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createManifestFile";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addManifestFileToLayout";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addManifestFileToLayout$1";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateManifest$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MainClassFilter
    implements ClassFilter {
        private MainClassFilter() {
        }

        public boolean isAccepted(PsiClass psiClass) {
            return (Boolean)ReadAction.compute(() -> PsiMethodUtil.MAIN_CLASS.value((Object)psiClass) && PsiMethodUtil.hasMainMethod((PsiClass)psiClass));
        }
    }
}

