/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.ui.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Clock;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.impl.artifacts.ArtifactBySourceFileFinder;
import com.intellij.packaging.impl.ui.actions.PackageFileWorker;
import com.intellij.util.text.SyncDateFormat;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class PackageFileAction
extends AnAction {
    private static final SyncDateFormat a = new SyncDateFormat((DateFormat)new SimpleDateFormat("h:mm:ss a"));

    public PackageFileAction() {
        super(CompilerBundle.message((String)"action.name.package.file", (Object[])new Object[0]), CompilerBundle.message((String)"action.description.package.file", (Object[])new Object[0]), null);
    }

    public void update(AnActionEvent anActionEvent) {
        List<VirtualFile> list2;
        boolean bl2 = false;
        Project project2 = (Project)anActionEvent.getData(CommonDataKeys.PROJECT);
        if (project2 != null && !(list2 = PackageFileAction.a(anActionEvent, project2)).isEmpty()) {
            bl2 = true;
            anActionEvent.getPresentation().setText(list2.size() == 1 ? CompilerBundle.message((String)"action.name.package.file", (Object[])new Object[0]) : CompilerBundle.message((String)"action.name.package.files", (Object[])new Object[0]));
        }
        anActionEvent.getPresentation().setVisible(bl2);
    }

    @NotNull
    private static List<VirtualFile> a(@NotNull AnActionEvent anActionEvent, @NotNull Project project2) {
        VirtualFile[] virtualFileArray;
        if (anActionEvent == null) {
            PackageFileAction.a(0);
        }
        if (project2 == null) {
            PackageFileAction.a(1);
        }
        if ((virtualFileArray = (VirtualFile[])anActionEvent.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY)) == null) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                PackageFileAction.a(2);
            }
            return list2;
        }
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        CompilerManager compilerManager = CompilerManager.getInstance((Project)project2);
        block0: for (VirtualFile virtualFile : virtualFileArray) {
            if (virtualFile == null || virtualFile.isDirectory() || projectFileIndex.isUnderSourceRootOfType(virtualFile, JavaModuleSourceRootTypes.SOURCES) && compilerManager.isCompilableFileType(virtualFile.getFileType())) {
                List<VirtualFile> list3 = Collections.emptyList();
                if (list3 == null) {
                    PackageFileAction.a(3);
                }
                return list3;
            }
            Collection<? extends Artifact> collection = ArtifactBySourceFileFinder.getInstance(project2).findArtifacts(virtualFile);
            for (Artifact artifact : collection) {
                if (StringUtil.isEmpty((String)artifact.getOutputPath())) continue;
                arrayList.add(virtualFile);
                continue block0;
            }
        }
        ArrayList<VirtualFile> arrayList2 = arrayList;
        if (arrayList2 == null) {
            PackageFileAction.a(4);
        }
        return arrayList2;
    }

    public void actionPerformed(AnActionEvent anActionEvent) {
        Project project2 = (Project)anActionEvent.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        List<VirtualFile> list2 = PackageFileAction.a(anActionEvent, project2);
        Artifact[] artifactArray = ArtifactManager.getInstance((Project)project2).getArtifacts();
        PackageFileWorker.startPackagingFiles(project2, list2, artifactArray, () -> PackageFileAction.a(project2, list2));
    }

    private static void a(Project project2, List<VirtualFile> list2) {
        if (!list2.isEmpty()) {
            Object object2;
            StringBuilder stringBuilder = new StringBuilder();
            for (Object object2 : list2) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append("'").append(object2.getName()).append("'");
            }
            String string = a.format(Clock.getTime());
            object2 = CompilerBundle.message((String)"status.text.file.has.been.packaged", (Object[])new Object[]{list2.size(), stringBuilder, string});
            StatusBar statusBar = WindowManager.getInstance().getStatusBar(project2);
            if (statusBar != null) {
                statusBar.setInfo((String)object2);
            }
        }
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packaging/impl/ui/actions/PackageFileAction";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packaging/impl/ui/actions/PackageFileAction";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesToPackage";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFilesToPackage";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

