/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LocalTimeCounter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class FormatterTestCase
extends LightPlatformTestCase {
    protected boolean doReformatRangeTest;
    protected TextRange myTextRange;
    protected EditorImpl myEditor;
    protected PsiFile myFile;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        FormatterTestCase.assertFalse((boolean)CodeStyleSettingsManager.getInstance((Project)FormatterTestCase.getProject()).USE_PER_PROJECT_SETTINGS);
    }

    protected void doTest(String string) throws Exception {
        this.a(this.getTestName(true), string);
    }

    protected void doTest() throws Exception {
        this.doTest(null);
    }

    private void a(String string, String string2) throws Exception {
        this.doTest(string + "." + this.getFileExtension(), string + "_after." + this.getFileExtension(), string2);
    }

    protected void doTest(String string, String string2, String string3) throws Exception {
        this.doTextTest(this.loadFile(string, null), this.loadFile(string2, string3));
    }

    protected final void doTest(@NonNls String string, @NonNls String string2) throws Exception {
        this.doTextTest(this.loadFile(string + "." + this.getFileExtension(), null), this.loadFile(string2 + "." + this.getFileExtension(), null));
    }

    protected void doTextTest(@NonNls String string, @NonNls String string2) throws IncorrectOperationException {
        this.doTextTest(string, string2, CheckPolicy.BOTH);
    }

    protected void doTextTest(String string, String string2, @NotNull CheckPolicy checkPolicy) throws IncorrectOperationException {
        if (checkPolicy == null) {
            FormatterTestCase.c(0);
        }
        String string3 = "before." + this.getFileExtension();
        PsiFile psiFile = this.createFileFromText(string, string3, PsiFileFactory.getInstance((Project)FormatterTestCase.getProject()));
        if (checkPolicy.isCheckDocument()) {
            this.checkDocument(psiFile, string, string2);
        }
        if (checkPolicy.isCheckPsi()) {
            // empty if block
        }
    }

    protected PsiFile createFileFromText(String string, String string2, PsiFileFactory psiFileFactory) {
        return psiFileFactory.createFileFromText(string2, this.getFileType(string2), (CharSequence)string, LocalTimeCounter.currentTime(), true, false);
    }

    protected FileType getFileType(String string) {
        return FileTypeManager.getInstance().getFileTypeByFileName(string);
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            if (this.myFile != null) {
                ((UndoManagerImpl)UndoManager.getInstance((Project)FormatterTestCase.getProject())).clearUndoRedoQueueInTests(this.myFile.getVirtualFile());
                FileEditorManager.getInstance((Project)FormatterTestCase.getProject()).closeFile(this.myFile.getVirtualFile());
            }
        }
        finally {
            this.myEditor = null;
            this.myFile = null;
            super.tearDown();
        }
    }

    private void a(PsiFile psiFile, String string) {
        CommandProcessor.getInstance().executeCommand(FormatterTestCase.getProject(), () -> ApplicationManager.getApplication().runWriteAction(() -> {
            Document document = PsiDocumentManager.getInstance((Project)FormatterTestCase.getProject()).getDocument(psiFile);
            document.replaceString(0, document.getTextLength(), (CharSequence)string);
            PsiDocumentManager.getInstance((Project)FormatterTestCase.getProject()).commitDocument(document);
        }), "test", null);
    }

    protected boolean doCheckDocumentUpdate() {
        return false;
    }

    protected void checkDocument(PsiFile psiFile, String string, String string2) {
        Document document = PsiDocumentManager.getInstance((Project)FormatterTestCase.getProject()).getDocument(psiFile);
        if (this.doCheckDocumentUpdate()) {
            EditorImpl editorImpl = (EditorImpl)FileEditorManager.getInstance((Project)FormatterTestCase.getProject()).openTextEditor(new OpenFileDescriptor(FormatterTestCase.getProject(), psiFile.getVirtualFile(), 0), false);
            editorImpl.putUserData(EditorImpl.DO_DOCUMENT_UPDATE_TEST, (Object)Boolean.TRUE);
            if (this.myFile != null) {
                FileEditorManager.getInstance((Project)FormatterTestCase.getProject()).closeFile(this.myFile.getVirtualFile());
            }
            this.myEditor = editorImpl;
            this.myFile = psiFile;
        } else {
            Object var5_6 = null;
        }
        WriteCommandAction.runWriteCommandAction((Project)FormatterTestCase.getProject(), () -> {
            document.replaceString(0, document.getTextLength(), (CharSequence)string);
            PsiDocumentManager.getInstance((Project)FormatterTestCase.getProject()).commitDocument(document);
            FormatterTestCase.assertEquals((String)psiFile.getText(), (String)document.getText());
            try {
                if (this.doReformatRangeTest) {
                    CodeStyleManager.getInstance((Project)FormatterTestCase.getProject()).reformatRange((PsiElement)psiFile, psiFile.getTextRange().getStartOffset(), psiFile.getTextRange().getEndOffset());
                } else if (this.myTextRange != null) {
                    CodeStyleManager.getInstance((Project)FormatterTestCase.getProject()).reformatText(psiFile, this.myTextRange.getStartOffset(), this.myTextRange.getEndOffset());
                } else {
                    CodeStyleManager.getInstance((Project)FormatterTestCase.getProject()).reformatText(psiFile, psiFile.getTextRange().getStartOffset(), psiFile.getTextRange().getEndOffset());
                }
            }
            catch (IncorrectOperationException incorrectOperationException) {
                FormatterTestCase.fail();
            }
        });
        FormatterTestCase.assertEquals((String)string2, (String)document.getText());
        PsiDocumentManager.getInstance((Project)FormatterTestCase.getProject()).commitDocument(document);
        FormatterTestCase.assertEquals((String)string2, (String)psiFile.getText());
    }

    private void b(PsiFile psiFile, String string) {
        CommandProcessor.getInstance().executeCommand(FormatterTestCase.getProject(), () -> ApplicationManager.getApplication().runWriteAction(() -> this.performFormatting(psiFile)), "", (Object)"");
        String string2 = psiFile.getText();
        FormatterTestCase.assertEquals((String)string, (String)string2);
    }

    protected void performFormatting(PsiFile psiFile) {
        try {
            if (this.myTextRange == null) {
                CodeStyleManager.getInstance((Project)FormatterTestCase.getProject()).reformat((PsiElement)psiFile);
            } else {
                CodeStyleManager.getInstance((Project)FormatterTestCase.getProject()).reformatRange((PsiElement)psiFile, this.myTextRange.getStartOffset(), this.myTextRange.getEndOffset());
            }
        }
        catch (IncorrectOperationException incorrectOperationException) {
            FormatterTestCase.fail();
        }
    }

    protected void performFormattingWithDocument(PsiFile psiFile) {
        try {
            if (this.myTextRange == null) {
                CodeStyleManager.getInstance((Project)FormatterTestCase.getProject()).reformatText(psiFile, 0, psiFile.getTextLength());
            } else {
                CodeStyleManager.getInstance((Project)FormatterTestCase.getProject()).reformatText(psiFile, this.myTextRange.getStartOffset(), this.myTextRange.getEndOffset());
            }
        }
        catch (IncorrectOperationException incorrectOperationException) {
            FormatterTestCase.fail();
        }
    }

    protected String loadFile(String string, String string2) throws Exception {
        String string3 = this.getTestDataPath() + File.separatorChar + this.getBasePath() + File.separatorChar + string;
        String string4 = FileUtil.loadFile((File)new File(string3));
        string4 = StringUtil.convertLineSeparators((String)string4);
        if (string2 == null) {
            return this.prepareText(string4);
        }
        String string5 = "<<<" + string2 + ">>>";
        String string6 = "<<</" + string2 + ">>>";
        int n2 = string4.indexOf(string5);
        FormatterTestCase.assertTrue((n2 >= 0 ? 1 : 0) != 0);
        int n3 = string4.indexOf(string6);
        FormatterTestCase.assertTrue((n3 >= 0 ? 1 : 0) != 0);
        return this.prepareText(string4.substring(n2 + string5.length(), n3).trim());
    }

    protected String getTestDataPath() {
        return PathManagerEx.getTestDataPath();
    }

    protected String prepareText(String string) {
        return string;
    }

    protected abstract String getBasePath();

    protected abstract String getFileExtension();

    protected static CommonCodeStyleSettings getSettings(Language language) {
        return CodeStyle.getSettings((Project)FormatterTestCase.getProject()).getCommonSettings(language);
    }

    protected CodeStyleSettings getSettings() {
        return CodeStyle.getSettings((Project)FormatterTestCase.getProject());
    }

    protected void doSanityTestForDirectory(File file, boolean bl2) throws IOException, IncorrectOperationException {
        ArrayList<File> arrayList = new ArrayList<File>();
        this.a(file, arrayList, bl2);
        if (!arrayList.isEmpty()) {
            FormatterTestCase.fail((String)("Failed for files: " + this.a(arrayList)));
        }
    }

    private void a(File file, List<File> list2, boolean bl2) throws IOException, IncorrectOperationException {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                this.b(file2, list2, bl2);
                this.a(file2, list2, bl2);
            }
        }
    }

    protected void doSanityTest(boolean bl2) throws IOException, IncorrectOperationException {
        File file = new File(this.getTestDataPath() + File.separatorChar + this.getBasePath(), "sanity");
        File[] fileArray = file.listFiles();
        ArrayList<File> arrayList = new ArrayList<File>();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                this.b(file2, arrayList, bl2);
            }
            if (!arrayList.isEmpty()) {
                FormatterTestCase.fail((String)("Failed for files: " + this.a(arrayList)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void b(File file, List<File> list2, boolean bl2) throws IOException, IncorrectOperationException {
        if (file.isFile() && file.getName().endsWith(this.getFileExtension())) {
            byte[] byArray = FileUtil.loadFileBytes((File)file);
            String string = new String(byArray);
            String string2 = "before." + this.getFileExtension();
            PsiFile psiFile = PsiFileFactory.getInstance((Project)FormatterTestCase.getProject()).createFileFromText(string2, this.getFileType(string2), (CharSequence)StringUtil.convertLineSeparators((String)string), LocalTimeCounter.currentTime(), true);
            try {
                CommandProcessor.getInstance().executeCommand(FormatterTestCase.getProject(), () -> ApplicationManager.getApplication().runWriteAction(() -> {
                    try {
                        if (bl2) {
                            this.performFormatting(psiFile);
                        } else {
                            this.performFormattingWithDocument(psiFile);
                        }
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        list2.add(file);
                    }
                    System.out.println(file.getPath() + ": finished");
                }), "", null);
            }
            finally {
                VirtualFile virtualFile = psiFile.getVirtualFile();
                if (virtualFile != null) {
                    ((UndoManagerImpl)UndoManager.getInstance((Project)FormatterTestCase.getProject())).clearUndoRedoQueueInTests(virtualFile);
                    ((UndoManagerImpl)UndoManager.getGlobalInstance()).clearUndoRedoQueueInTests(virtualFile);
                }
            }
        }
    }

    private String a(List<File> list2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (File file : list2) {
            stringBuffer.append(file.getPath());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private static /* synthetic */ void c(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkPolicy", "com/intellij/psi/formatter/FormatterTestCase", "doTextTest"));
    }

    static enum CheckPolicy {
        PSI(true, false),
        DOCUMENT(false, true),
        BOTH(true, true);

        private final boolean a;
        private final boolean b;

        private CheckPolicy(boolean bl2, boolean bl3) {
            this.b = bl3;
            this.a = bl2;
        }

        public boolean isCheckPsi() {
            return this.a;
        }

        public boolean isCheckDocument() {
            return this.b;
        }
    }
}

