/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ssh.ProxyCommand;
import com.intellij.ssh.SessionConfig;
import com.intellij.ssh.SshSession;
import com.intellij.ssh.SshTransportException;
import com.intellij.ssh.config.OpenSSHClientConfig;
import com.intellij.ssh.config.OpenSSHConfigUtil;
import com.intellij.ssh.impl.agent.CompositeIdentityRepository;
import com.intellij.ssh.legacy.SftpIdentityInfo;
import com.intellij.ssh.legacy.SftpIdentityRepositoryFactory;
import com.intellij.ssh.sockets.SocketUtils;
import com.jcraft.jsch.ConfigRepository;
import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SocketFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000\u0098\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0012\n\u0002\b\u0004\u001a-\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010&H\u0000\u00a2\u0006\u0002\u0010(\u001a(\u0010)\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00012\u0006\u0010-\u001a\u00020\u0001H\u0002\u001a\u0018\u0010.\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010/\u001a\u00020'H\u0002\u001a(\u00100\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u00101\u001a\u00020\u00012\u0006\u0010,\u001a\u00020\u00012\u0006\u0010-\u001a\u00020\u0001H\u0002\u001a/\u00102\u001a\u00020\u00062\b\u00103\u001a\u0004\u0018\u00010\u00012\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010&2\b\u00104\u001a\u0004\u0018\u000105\u00a2\u0006\u0002\u00106\u001a\u0006\u00107\u001a\u000208\u001a\u0010\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0000\u001a\u001a\u0010=\u001a\u00020\u00012\b\u0010>\u001a\u0004\u0018\u00010\u00012\u0006\u0010?\u001a\u00020\u0001H\u0000\u001a\b\u0010@\u001a\u00020$H\u0002\u001a\u0018\u0010A\u001a\u00020 2\u0006\u0010B\u001a\u00020\u00012\u0006\u0010C\u001a\u00020DH\u0002\u001a\"\u0010E\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\b\u0010F\u001a\u0004\u0018\u00010$H\u0002\u001a\u0018\u0010G\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010F\u001a\u00020$H\u0002\u001a\u001c\u0010H\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010+\u0012\u0004\u0012\u00020J0I2\u0006\u0010;\u001a\u00020<\u001a\u0016\u0010K\u001a\u00020\u00062\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020O\u001a$\u0010P\u001a\u00020 *\u00020J2\u0006\u0010*\u001a\u00020+2\u0006\u0010Q\u001a\u00020\u00012\u0006\u0010?\u001a\u00020\u0001H\u0002\u001a\n\u0010R\u001a\u00020 *\u00020:\u001a#\u0010S\u001a\u0004\u0018\u00010 *\u00020J2\u0006\u0010T\u001a\u00020+2\u0006\u0010U\u001a\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010V\u001a\u000e\u0010W\u001a\u0004\u0018\u00010\u0001*\u00020XH\u0000\u001a\u001b\u0010Y\u001a\u0004\u0018\u00010\u0006*\u00020+2\u0006\u0010Q\u001a\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010Z\u001a\f\u0010[\u001a\u00020\u0001*\u00020\\H\u0000\u001a\u000e\u0010]\u001a\u00020^*\u0004\u0018\u00010_H\u0002\u001a\u0016\u0010`\u001a\u0004\u0018\u00010\u0001*\u00020+2\u0006\u0010a\u001a\u00020\u0001H\u0002\u001a\f\u0010b\u001a\u00020\u0001*\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0005\u001a\u00020\u0006X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u000b\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\"\u000e\u0010\u000e\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0011\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0012\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0013\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0014\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0015\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0016\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0017\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0018\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0019\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001a\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u001b\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\r\"\u0014\u0010\u001d\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\r\u00a8\u0006c"}, d2={"CLEAR_ALL_FORWARDINGS", "", "CONNECT_TIMEOUT", "DEFAULT_HOST_KEY_ALGORITHMS", "DEFAULT_KEX_ALGORITHMS", "DEFAULT_SERVER_ALIVE_COUNT_MAX", "", "getDEFAULT_SERVER_ALIVE_COUNT_MAX", "()I", "DEPLOYMENT_LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "EXEC_CHANNEL_TYPE", "getEXEC_CHANNEL_TYPE", "()Ljava/lang/String;", "FORWARD_AGENT", "HOST_KEY_ALGORITHMS", "HOST_KEY_ALIAS", "KEX_ALGORITHMS", "LOCAL_FORWARD", "LOG", "MAX_AUTH_TRIES", "PROXY_COMMAND", "PROXY_COMMAND_NONE", "PROXY_JUMP", "REMOTE_FORWARD", "SERVER_ALIVE_COUNT_MAX", "SERVER_ALIVE_INTERVAL", "SFTP_CHANNEL_TYPE", "getSFTP_CHANNEL_TYPE", "SHELL_CHANNEL_TYPE", "getSHELL_CHANNEL_TYPE", "addIdentities", "", "jsch", "Lcom/jcraft/jsch/JSch;", "sshDir", "Ljava/io/File;", "identities", "", "Lcom/intellij/ssh/legacy/SftpIdentityInfo;", "(Lcom/jcraft/jsch/JSch;Ljava/io/File;[Lcom/intellij/ssh/legacy/SftpIdentityInfo;)V", "addIdentitiesFromHostConfig", "hostConfig", "Lcom/jcraft/jsch/ConfigRepository$Config;", "remoteHost", "remoteUser", "addIdentity", "info", "addIdentityFromOpenSSHConfig", "identityFile", "calcIdentitiesHashCode", "password", "identityRepositoryFactory", "Lcom/intellij/ssh/legacy/SftpIdentityRepositoryFactory;", "(Ljava/lang/String;[Lcom/intellij/ssh/legacy/SftpIdentityInfo;Lcom/intellij/ssh/legacy/SftpIdentityRepositoryFactory;)I", "createConfig", "Ljava/util/Properties;", "createSshSession", "Lcom/intellij/ssh/SshSession;", "sessionConfig", "Lcom/intellij/ssh/SessionConfig;", "extendCSVParameter", "value", "defaultValue", "findSshDir", "logPortForwardingException", "portForwarding", "e", "Lcom/jcraft/jsch/JSchException;", "setKnownHosts", "knownHostsFile", "setKnownHostsFile", "setUpSession", "Lkotlin/Pair;", "Lcom/jcraft/jsch/Session;", "toTimeoutInMillis", "timeout", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "applyCSVParameter", "key", "applyPortForwardings", "checkConfig", "config", "s", "(Lcom/jcraft/jsch/Session;Lcom/jcraft/jsch/ConfigRepository$Config;Ljava/lang/String;)Lkotlin/Unit;", "getEffectiveProxyCommand", "Lcom/intellij/ssh/config/OpenSSHClientConfig$HostConfig;", "getIntValue", "(Lcom/jcraft/jsch/ConfigRepository$Config;Ljava/lang/String;)Ljava/lang/Integer;", "id", "", "isNullOrEmpty", "", "", "resolveHostName", "host", "unquoteSingleArgumentValue", "intellij.platform.ssh"})
@JvmName(name="SshConnectionUtil")
public final class SshConnectionUtil {
    private static final String a = "ServerAliveCountMax";
    private static final String h = "ServerAliveInterval";
    private static final String e = "ConnectTimeout";
    private static final String f = "ClearAllForwardings";
    private static final String k = "MaxAuthTries";
    private static final String q = "HostKeyAlias";
    private static final String d = "ForwardAgent";
    private static final String s = "LocalForward";
    private static final String l = "RemoteForward";
    @NotNull
    public static final String PROXY_COMMAND = "ProxyCommand";
    @NotNull
    public static final String PROXY_JUMP = "ProxyJump";
    private static final String r = "none";
    private static final String m = "KexAlgorithms";
    private static final String b = "ecdh-sha2-nistp256,ecdh-sha2-nistp384,ecdh-sha2-nistp521,diffie-hellman-group14-sha1,diffie-hellman-group-exchange-sha256,diffie-hellman-group-exchange-sha1";
    private static final String c = "HostKeyAlgorithms";
    private static final String i = "ecdsa-sha2-nistp256,ecdsa-sha2-nistp384,ecdsa-sha2-nistp521,ssh-ed25519,ssh-rsa";
    private static final int t = 1000;
    private static final Logger n;
    private static final Logger o;
    @NotNull
    private static final String p = "shell";
    @NotNull
    private static final String g = "exec";
    @NotNull
    private static final String j = "sftp";

    public static final int getDEFAULT_SERVER_ALIVE_COUNT_MAX() {
        return t;
    }

    public static final int calcIdentitiesHashCode(@Nullable String string, @Nullable SftpIdentityInfo[] sftpIdentityInfoArray, @Nullable SftpIdentityRepositoryFactory sftpIdentityRepositoryFactory) {
        int n2;
        String string2 = string;
        int n3 = string2 != null ? string2.hashCode() : 0;
        int n4 = 31 * n3;
        if (sftpIdentityInfoArray != null) {
            SftpIdentityInfo[] sftpIdentityInfoArray2 = sftpIdentityInfoArray;
            int n5 = n4;
            SftpIdentityInfo[] sftpIdentityInfoArray3 = sftpIdentityInfoArray2;
            int n6 = Arrays.hashCode(sftpIdentityInfoArray3);
            n4 = n5;
            n2 = n6;
        } else {
            n2 = 0;
        }
        n3 = n4 + n2;
        SftpIdentityRepositoryFactory sftpIdentityRepositoryFactory2 = sftpIdentityRepositoryFactory;
        n3 = 31 * n3 + (sftpIdentityRepositoryFactory2 != null ? sftpIdentityRepositoryFactory2.hashCode() : 0);
        return n3;
    }

    private static final boolean a(@Nullable byte[] byArray) {
        return byArray == null || byArray.length == 0;
    }

    @NotNull
    public static final SshSession createSshSession(@NotNull SessionConfig sessionConfig) {
        Intrinsics.checkParameterIsNotNull((Object)sessionConfig, (String)"sessionConfig");
        Pair<ConfigRepository.Config, Session> pair2 = SshConnectionUtil.setUpSession(sessionConfig);
        ConfigRepository.Config config = (ConfigRepository.Config)pair2.component1();
        Session session = (Session)pair2.component2();
        session.connect();
        return new SshSession(session, config);
    }

    @NotNull
    public static final Pair<ConfigRepository.Config, Session> setUpSession(@NotNull SessionConfig sessionConfig) {
        Object object;
        OpenSSHClientConfig.HostConfig hostConfig;
        block39: {
            String string;
            Object object3;
            Object object4;
            Properties properties;
            IdentityRepository identityRepository;
            Object object5;
            Object object6;
            SftpIdentityInfo[] sftpIdentityInfoArray;
            block38: {
                Object object2;
                Object object7;
                SocketFactory socketFactory;
                Intrinsics.checkParameterIsNotNull((Object)sessionConfig, (String)"sessionConfig");
                JSch jSch = new JSch();
                File file = SshConnectionUtil.a();
                SshConnectionUtil.a(jSch, file, sessionConfig.getKnownHostsFile());
                sftpIdentityInfoArray = sessionConfig.getIdentities();
                if (sftpIdentityInfoArray != null) {
                    SshConnectionUtil.addIdentities(jSch, file, sftpIdentityInfoArray);
                }
                OpenSSHClientConfig openSSHClientConfig = sessionConfig.getOpenSSHConfig();
                hostConfig = openSSHClientConfig != null ? openSSHClientConfig.getConfig(sessionConfig.getHost()) : null;
                jSch.setConfigRepository((ConfigRepository)null);
                Object object8 = hostConfig;
                if (object8 == null || (object8 = SshConnectionUtil.b((ConfigRepository.Config)object8, sessionConfig.getHost())) == null) {
                    object8 = object6 = sessionConfig.getHost();
                }
                if (sftpIdentityInfoArray == null && sessionConfig.getPassword() == null) {
                    OpenSSHClientConfig.HostConfig hostConfig2 = hostConfig;
                    if (hostConfig2 != null) {
                        object = object5 = hostConfig2;
                        SshConnectionUtil.a(jSch, (ConfigRepository.Config)object, (String)object6, sessionConfig.getUsername());
                    }
                }
                if ((object5 = sessionConfig.getIdentityRepositoryFactory()) != null && (object = object5.create(jSch)) != null) {
                    IdentityRepository identityRepository2 = identityRepository = jSch.getIdentityRepository();
                    Intrinsics.checkExpressionValueIsNotNull((Object)identityRepository2, (String)"localIdentityRepository");
                    jSch.setIdentityRepository((IdentityRepository)new CompositeIdentityRepository(identityRepository2, (IdentityRepository)object));
                }
                object = jSch.getSession(sessionConfig.getUsername(), (String)object6, sessionConfig.getPort());
                if (sessionConfig.getPassword() != null) {
                    object.setPassword(sessionConfig.getPassword());
                }
                if (sessionConfig.getUserInfo() != null) {
                    Object object9 = object;
                    Intrinsics.checkExpressionValueIsNotNull((Object)object9, (String)"session");
                    object9.setUserInfo(sessionConfig.getUserInfo());
                }
                if (sessionConfig.getProxy() != null) {
                    object.setProxy(sessionConfig.getProxy());
                }
                if ((socketFactory = sessionConfig.getSocketFactory()) == null) {
                    socketFactory = identityRepository = SocketUtils.getSftpSocketFactory(sessionConfig.getHost());
                }
                if (identityRepository != null) {
                    object.setSocketFactory((SocketFactory)identityRepository);
                }
                if (hostConfig != null) {
                    Object object10 = object;
                    Intrinsics.checkExpressionValueIsNotNull((Object)object10, (String)"session");
                    SshConnectionUtil.a((Session)object10, (ConfigRepository.Config)hostConfig, m, b);
                    SshConnectionUtil.a((Session)object, (ConfigRepository.Config)hostConfig, c, i);
                    SshConnectionUtil.a((Session)object, hostConfig, "cipher.c2s");
                    SshConnectionUtil.a((Session)object, hostConfig, "cipher.s2c");
                    SshConnectionUtil.a((Session)object, hostConfig, "mac.c2s");
                    SshConnectionUtil.a((Session)object, hostConfig, "mac.s2c");
                    SshConnectionUtil.a((Session)object, hostConfig, "compression.c2s");
                    SshConnectionUtil.a((Session)object, hostConfig, "compression.s2c");
                    SshConnectionUtil.a((Session)object, hostConfig, "compression_level");
                    SshConnectionUtil.a((Session)object, hostConfig, k);
                    SshConnectionUtil.a((Session)object, hostConfig, f);
                    SshConnectionUtil.a((Session)object, hostConfig, d);
                }
                if ((properties = sessionConfig.getConfig()) != null && properties.size() > 0) {
                    object.setConfig(properties);
                }
                if ((object7 = hostConfig) != null && (object7 = ((OpenSSHClientConfig.HostConfig)object7).getValue(q)) != null) {
                    object3 = object4 = object7;
                    Object object11 = object;
                    Intrinsics.checkExpressionValueIsNotNull((Object)object11, (String)"session");
                    object11.setHostKeyAlias((String)object3);
                }
                if ((object2 = sessionConfig.getServerAliveInterval()) == null) {
                    OpenSSHClientConfig.HostConfig hostConfig3 = hostConfig;
                    object2 = object4 = hostConfig3 != null ? SshConnectionUtil.a(hostConfig3, h) : null;
                }
                if (object4 != null) {
                    Object object12 = object;
                    Intrinsics.checkExpressionValueIsNotNull((Object)object12, (String)"session");
                    object12.setServerAliveInterval(((Integer)object4).intValue());
                }
                Object object13 = object;
                Intrinsics.checkExpressionValueIsNotNull((Object)object13, (String)"session");
                Integer n2 = sessionConfig.getServerAliveCountMax();
                if (n2 == null) {
                    OpenSSHClientConfig.HostConfig hostConfig4 = hostConfig;
                    n2 = hostConfig4 != null ? SshConnectionUtil.a(hostConfig4, a) : null;
                }
                object13.setServerAliveCountMax(n2 != null ? n2 : t);
                Object object14 = sessionConfig.getTimeout();
                if (object14 == null) {
                    OpenSSHClientConfig.HostConfig hostConfig5 = hostConfig;
                    object14 = object3 = hostConfig5 != null ? SshConnectionUtil.a(hostConfig5, e) : null;
                }
                if (object3 != null) {
                    object.setTimeout(((Integer)object3).intValue());
                }
                OpenSSHClientConfig.HostConfig hostConfig6 = hostConfig;
                String string2 = string = hostConfig6 != null ? SshConnectionUtil.getEffectiveProxyCommand(hostConfig6) : null;
                if (string != null && Intrinsics.areEqual((Object)SshConnectionUtil.a(string), (Object)r) ^ true) {
                    String string3 = object.getUserName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"session.userName");
                    object.setProxy((Proxy)new ProxyCommand(string, string3));
                }
                object.setDaemonThread(sessionConfig.getDaemonThread());
                Logger logger = n;
                Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LOG");
                if (logger.isDebugEnabled()) break block38;
                Logger logger2 = o;
                Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"DEPLOYMENT_LOG");
                if (!logger2.isDebugEnabled()) break block39;
            }
            String string4 = "Setting up ssh connection to " + (String)object6 + ':' + sessionConfig.getPort() + " for " + sessionConfig.getUsername();
            if (sessionConfig.getPassword() != null) {
                string4 = string4 + ", with password";
            }
            if (object5 != null) {
                string4 = string4 + ", with identityRepositoryFactory " + object5;
            }
            if (sftpIdentityInfoArray != null) {
                string4 = string4 + ", with identities";
                int n3 = sftpIdentityInfoArray.length;
                for (int i2 = 0; i2 < n3; ++i2) {
                    SftpIdentityInfo object22 = sftpIdentityInfoArray[i2];
                    string4 = string4 + " {" + object22.getPrivateKey() + ", " + object22.getPublicKey() + ", " + (object22.getPassPhrase() == null ? "no" : "***") + '}';
                }
            }
            if (sftpIdentityInfoArray == null && sessionConfig.getPassword() == null) {
                string4 = string4 + ", without identities and password, adding identities from OpenSSH config";
            }
            if (sessionConfig.getProxy() != null) {
                string4 = string4 + ", with proxy " + sessionConfig.getProxy();
            }
            if (identityRepository != null) {
                string4 = string4 + ", with socketFactory " + identityRepository;
            }
            if (object4 != null) {
                string4 = string4 + ", with keepAliveTimeout " + object4;
            }
            string4 = string4 + ", with serverAliveCountMax " + object.getServerAliveCountMax();
            string4 = string4 + ", with timeout " + object3;
            if (string != null) {
                string4 = string4 + ", with proxyCommand " + string;
            }
            string4 = string4 + ", with daemonThread " + sessionConfig.getDaemonThread();
            if (hostConfig != null) {
                string4 = string4 + "\nWith openSSH config ";
                for (String string5 : new String[]{m, c, "cipher.c2s", "cipher.s2c", "mac.c2s", "mac.s2c", "compression.c2s", "compression.s2c", "compression_level", k, f, d}) {
                    String string6;
                    if (hostConfig.getValue(string5) == null) continue;
                    String string7 = string6;
                    string4 = string4 + ", " + string5 + '=' + string7;
                }
                String string8 = hostConfig.getValue(q);
                if (string8 != null) {
                    String string9;
                    String object16 = string9 = string8;
                    string4 = string4 + " with hostKeyAlias " + object16;
                }
            }
            if (properties != null && properties.size() > 0) {
                string4 = string4 + "\nWith config";
                Map map = properties;
                for (Map.Entry entry : map.entrySet()) {
                    string4 = string4 + ' ' + entry.getKey() + " = " + entry.getValue() + ',';
                }
            }
            Logger logger = n;
            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LOG");
            if (logger.isDebugEnabled()) {
                n.debug(string4);
            } else {
                o.debug(string4);
            }
        }
        return new Pair((Object)hostConfig, object);
    }

    @Nullable
    public static final String getEffectiveProxyCommand(@NotNull OpenSSHClientConfig.HostConfig hostConfig) {
        Intrinsics.checkParameterIsNotNull((Object)hostConfig, (String)"$receiver");
        Iterator iterator = hostConfig.stream().iterator();
        while (iterator.hasNext()) {
            Pair pair2 = (Pair)iterator.next();
            String string = (String)pair2.component1();
            String string2 = (String)pair2.component2();
            if (StringsKt.equals((String)PROXY_COMMAND, (String)string, (boolean)true)) {
                return string2;
            }
            if (!StringsKt.equals((String)PROXY_JUMP, (String)string, (boolean)true)) continue;
            String string3 = OpenSSHConfigUtil.toProxyCommand(OpenSSHConfigUtil.parseJump(string2));
            n.debug("Setting implicit ProxyCommand from ProxyJump: " + string3);
            return string3;
        }
        return null;
    }

    private static final void a(@NotNull Session session, ConfigRepository.Config config, String string, String string2) {
        session.setConfig(string, SshConnectionUtil.extendCSVParameter(config.getValue(string), string2));
    }

    @NotNull
    public static final String extendCSVParameter(@Nullable String string, @NotNull String string2) {
        String string3;
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"defaultValue");
        if (string == null) {
            string3 = string2;
        } else if (StringsKt.startsWith$default((String)string, (String)"+", (boolean)false, (int)2, null)) {
            String string4 = string;
            int n2 = 1;
            String string5 = string4.substring(n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            String string6 = string5;
            string3 = string2 + "," + string6;
        } else {
            string3 = string;
        }
        return string3;
    }

    private static final String b(@NotNull ConfigRepository.Config config, String string) {
        String string2;
        String string3 = config.getValue("HostName");
        if (string3 != null) {
            String string4;
            String string5 = string4 = string3;
            string2 = OpenSSHConfigUtil.resolveHostName(string5, string);
        } else {
            string2 = null;
        }
        return string2;
    }

    public static final void applyPortForwardings(@NotNull SshSession sshSession) {
        String[] stringArray;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)sshSession, (String)"$receiver");
        if (Intrinsics.areEqual((Object)sshSession.getRawSession().getConfig(f), (Object)"yes")) {
            return;
        }
        String[] stringArray2 = sshSession.getHostConfig$intellij_platform_ssh();
        if (stringArray2 != null && (stringArray2 = stringArray2.getValues(s)) != null) {
            for (Object object : (Object[])stringArray2) {
                string = (String)object;
                try {
                    sshSession.getRawSession().setPortForwardingL(string);
                }
                catch (JSchException jSchException) {
                    SshConnectionUtil.a("" + s + " \"" + string + '\"', jSchException);
                }
            }
        }
        if ((stringArray = sshSession.getHostConfig$intellij_platform_ssh()) != null && (stringArray = stringArray.getValues(l)) != null) {
            for (Object object : (Object[])stringArray) {
                string = (String)object;
                try {
                    sshSession.getRawSession().setPortForwardingR(string);
                }
                catch (JSchException jSchException) {
                    SshConnectionUtil.a("" + l + " \"" + string + '\"', jSchException);
                }
            }
        }
    }

    private static final void a(String string, JSchException jSchException) {
        String string2 = jSchException.getMessage();
        if (string2 == null || !StringsKt.contains$default((CharSequence)string2, (CharSequence)" is already registered.", (boolean)false, (int)2, null)) {
            Logger logger = n;
            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LOG");
            if (logger.isDebugEnabled()) {
                n.debug("Failed to apply OpenSSH " + string, (Throwable)jSchException);
            } else {
                n.info("Failed to apply OpenSSH " + string + ": " + jSchException.getMessage());
            }
        }
    }

    private static final Unit a(@NotNull Session session, ConfigRepository.Config config, String string) {
        Unit unit;
        String string2 = config.getValue(string);
        if (string2 != null) {
            String string3;
            String string4 = string3 = string2;
            session.setConfig(string, string4);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private static final void a(JSch jSch, ConfigRepository.Config config, String string, String string2) {
        Object object;
        String[] stringArray = config.getValues("IdentityFile");
        Intrinsics.checkExpressionValueIsNotNull((Object)stringArray, (String)"identities");
        Object object2 = object = (Object[])stringArray;
        Collection collection = new ArrayList(((Object[])object).length);
        for (Object object3 : object2) {
            String string3 = (String)object3;
            Collection collection2 = collection;
            String string4 = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"it");
            String string5 = SshConnectionUtil.a(string4);
            collection2.add(string5);
        }
        object = (List)collection;
        object2 = object.iterator();
        while (object2.hasNext()) {
            collection = object2.next();
            String string6 = (String)((Object)collection);
            SshConnectionUtil.a(jSch, string6, string, string2);
        }
    }

    private static final String a(@NotNull String string) {
        String string2 = StringUtil.unquoteString((String)string, (char)'\"');
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"StringUtil.unquoteString(this, '\"')");
        return string2;
    }

    private static final void a(JSch jSch, String string, String string2, String string3) {
        try {
            String string4 = OpenSSHConfigUtil.resolveIdentityFile(string, string2, string3);
            jSch.addIdentity(string4);
        }
        catch (Exception exception) {
            Logger logger = n;
            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LOG");
            if (logger.isDebugEnabled()) {
                n.debug("Identity file " + string + " cannot be added and will be ignored", (Throwable)exception);
            }
            n.info("Identity file " + string + " cannot be added and will be ignored: " + exception.getMessage());
        }
    }

    @NotNull
    public static final Properties createConfig() {
        Properties properties = new Properties();
        properties.setProperty("compression.s2c", "zlib,none");
        properties.setProperty("compression.c2s", "zlib,none");
        properties.setProperty("HashKnownHosts", "no");
        properties.setProperty("StrictHostKeyChecking", "no");
        return properties;
    }

    public static final int toTimeoutInMillis(long l2, @NotNull TimeUnit timeUnit) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)timeUnit), (String)"timeUnit");
        long l3 = TimeUnit.MILLISECONDS.convert(l2, timeUnit);
        if (l3 < 0L) {
            throw (Throwable)new IllegalArgumentException("Invalid timeout value: " + l3);
        }
        if (l3 > (long)Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l3;
    }

    @NotNull
    public static final String getSHELL_CHANNEL_TYPE() {
        return p;
    }

    @NotNull
    public static final String getEXEC_CHANNEL_TYPE() {
        return g;
    }

    @NotNull
    public static final String getSFTP_CHANNEL_TYPE() {
        return j;
    }

    @NotNull
    public static final String id(@NotNull Object object) {
        Intrinsics.checkParameterIsNotNull((Object)object, (String)"$receiver");
        return '@' + Integer.toHexString(object.hashCode());
    }

    public static final void addIdentities(@NotNull JSch jSch, @NotNull File file, @Nullable SftpIdentityInfo[] sftpIdentityInfoArray) {
        Intrinsics.checkParameterIsNotNull((Object)jSch, (String)"jsch");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"sshDir");
        if (sftpIdentityInfoArray != null) {
            int n2 = 0;
            int n3 = ((Object[])sftpIdentityInfoArray).length;
            int n4 = n3 - 1;
            if (n2 <= n4) {
                while (true) {
                    SftpIdentityInfo sftpIdentityInfo = sftpIdentityInfoArray[n2];
                    SshConnectionUtil.a(jSch, sftpIdentityInfo);
                    if (n2 != n4) {
                        ++n2;
                        continue;
                    }
                    break;
                }
            }
        } else {
            File file2 = new File(file, "id_rsa");
            if (file2.isFile() && file2.canRead()) {
                SshConnectionUtil.a(jSch, new SftpIdentityInfo(file2, null, null, 6, null));
            }
        }
    }

    private static final void a(JSch jSch, SftpIdentityInfo sftpIdentityInfo) {
        try {
            String string = sftpIdentityInfo.getPrivateKey() != null ? sftpIdentityInfo.getPrivateKey().getAbsolutePath() : null;
            String string2 = sftpIdentityInfo.getPublicKey() != null ? sftpIdentityInfo.getPublicKey().getAbsolutePath() : null;
            jSch.addIdentity(string, string2, sftpIdentityInfo.getPassPhrase());
        }
        catch (JSchException jSchException) {
            throw (Throwable)new SshTransportException("Failed to load identity file", jSchException);
        }
    }

    private static final File a() {
        File file;
        String string = System.getProperty("vfs.sftp.sshdir");
        if (string != null && (file = new File(string)).exists()) {
            return file;
        }
        file = new File(System.getProperty("user.home"), ".ssh");
        if (file.exists()) {
            return file;
        }
        if (SystemInfo.isWindows) {
            String string2 = System.getProperty("user.name");
            file = new File("C:\\cygwin\\home\\" + string2 + "\\.ssh");
            if (file.exists()) {
                return file;
            }
        }
        return new File("");
    }

    private static final void a(JSch jSch, File file, File file2) {
        if (file2 != null) {
            SshConnectionUtil.a(jSch, file2);
        } else {
            File file3 = new File(file, "known_hosts");
            if (file3.isFile() && file3.canRead()) {
                SshConnectionUtil.a(jSch, file3);
            }
        }
    }

    private static final void a(JSch jSch, File file) {
        try {
            jSch.setKnownHosts(file.getAbsolutePath());
        }
        catch (JSchException jSchException) {
            throw (Throwable)new SshTransportException("Using of known_hosts file " + file.getAbsolutePath() + " failed", jSchException);
        }
    }

    private static final Integer a(@NotNull ConfigRepository.Config config, String string) {
        Void void_;
        String string2 = config.getValue(string);
        if (string2 != null) {
            String string3;
            String string4 = string3 = string2;
            try {
                Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            void_ = null;
        } else {
            void_ = null;
        }
        return (Integer)((Object)void_);
    }

    static {
        a = a;
        h = h;
        e = e;
        f = f;
        k = k;
        q = q;
        d = d;
        s = s;
        l = l;
        t = 1000;
        n = Logger.getInstance((String)"#com.intellij.ssh.SshConnectionUtil");
        o = Logger.getInstance((String)"#com.jetbrains.plugins.webDeployment");
        p = p;
        g = g;
        j = j;
    }
}

