/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.sockets;

import com.intellij.ssh.ForceDisconnectListener;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;

public abstract class ItemHolder<T>
implements ForceDisconnectListener {
    private final Collection<T> b = new ArrayList<T>();
    private boolean a;

    @Override
    public synchronized void forceDisconnect() {
        this.a = true;
        for (T t2 : this.b) {
            this.close(t2);
        }
    }

    protected abstract void close(T var1);

    public synchronized void add(T t2) throws IOException {
        if (this.a) {
            this.close(t2);
            throw new IOException("Connection closed");
        }
        this.b.add(t2);
    }

    public static ItemHolder<Socket> createDefaultSocketHolder() {
        return new ItemHolder<Socket>(){

            @Override
            protected void close(Socket socket) {
                if (!socket.isClosed()) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        };
    }

    public static ItemHolder<ServerSocket> createDefaultServerSocketHolder() {
        return new ItemHolder<ServerSocket>(){

            @Override
            protected void close(ServerSocket serverSocket) {
                if (!serverSocket.isClosed()) {
                    try {
                        serverSocket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        };
    }
}

