/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.sockets;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ssh.ForceDisconnectListener;
import com.intellij.ssh.sockets.ItemHolder;
import com.intellij.ssh.sockets.SocketUtils;
import com.intellij.util.EventDispatcher;
import com.jcraft.jsch.SocketFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.jetbrains.annotations.Nullable;

public class MySftpSocketFactory
implements SocketFactory {
    private static final Logger a = Logger.getInstance(MySftpSocketFactory.class);
    private final ItemHolder<Socket> b;

    public MySftpSocketFactory(@Nullable EventDispatcher<ForceDisconnectListener> eventDispatcher) {
        if (eventDispatcher != null) {
            this.b = ItemHolder.createDefaultSocketHolder();
            eventDispatcher.addListener(this.b);
        } else {
            this.b = null;
        }
    }

    public Socket createSocket(String string, int n2) throws IOException {
        Socket socket;
        InetAddress inetAddress = InetAddress.getByName(string);
        InetAddress inetAddress2 = SocketUtils.getProperAddressIfNeeded(inetAddress);
        if (inetAddress2 != null) {
            a.debug("Patched sftp socket for " + inetAddress2);
            socket = MySftpSocketFactory.a(inetAddress2, n2);
        } else {
            a.debug("Default sftp socket for " + string);
            socket = MySftpSocketFactory.a(string, n2);
        }
        if (this.b != null) {
            this.b.add(socket);
        }
        return socket;
    }

    private static Socket a(String string, int n2) throws IOException {
        return new Socket(string, n2);
    }

    private static Socket a(InetAddress inetAddress, int n2) throws IOException {
        return new Socket(inetAddress, n2);
    }

    public InputStream getInputStream(Socket socket) throws IOException {
        return socket.getInputStream();
    }

    public OutputStream getOutputStream(Socket socket) throws IOException {
        return socket.getOutputStream();
    }

    public boolean equals(Object object) {
        return object instanceof MySftpSocketFactory;
    }

    public int hashCode() {
        return 0;
    }
}

