/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.ui;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.remote.AuthType;
import com.intellij.remote.MutableRemoteCredentials;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.RSyncUtil;
import com.intellij.ssh.ui.SshUIUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.ActionLink;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SshCredentialsEditor
extends SettingsEditor<MutableRemoteCredentials>
implements PanelWithAnchor {
    protected JPanel myMainPanel;
    protected JBLabel myHostLabel;
    protected JBLabel myPasswordLabel;
    protected JBCheckBox mySavePasswordCheckBox;
    protected JTextField myUsernameField;
    protected TextFieldWithBrowseButton myPrivateKeyFileField;
    protected JLabel myPassphraseLabel;
    protected JPasswordField myPassphraseField;
    protected JCheckBox mySavePassphraseCheckbox;
    protected JPasswordField myPasswordField;
    protected JLabel myPrivateKeyFileLabel;
    protected JComboBox<AuthType> myAuthTypeCombo;
    protected JTextField myHostField;
    protected JTextField myPortField;
    protected ActionLink myRSyncLink;
    protected JLabel myExternalToolsSuggestionLabel;
    private final Map<String, JComponent> a;
    private ParentComponent b;
    private final MessageBusConnection c;
    @Nullable
    private JComponent d;

    public SshCredentialsEditor() {
        this.d();
        this.myPasswordField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent documentEvent) {
                SshCredentialsEditor.this.b();
            }
        });
        this.myPrivateKeyFileLabel.setLabelFor(this.myPrivateKeyFileField.getTextField());
        this.myPrivateKeyFileField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent documentEvent) {
                SshCredentialsEditor.this.a();
            }
        });
        this.myAuthTypeCombo.setModel((ComboBoxModel<AuthType>)new CollectionComboBoxModel(Arrays.asList(AuthType.PASSWORD, AuthType.KEY_PAIR, AuthType.OPEN_SSH), (Object)AuthType.PASSWORD));
        this.myAuthTypeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SshCredentialsEditor.this.c();
                JTextField jTextField = SshCredentialsEditor.this.myAuthTypeCombo.getSelectedItem() == AuthType.PASSWORD ? SshCredentialsEditor.this.myPasswordField : SshCredentialsEditor.this.myPrivateKeyFileField.getTextField();
                IdeFocusManager.findInstanceByComponent((Component)jTextField).requestFocus((Component)jTextField, false);
            }
        });
        this.myAuthTypeCombo.setRenderer((ListCellRenderer<AuthType>)new ColoredListCellRenderer<AuthType>(){

            protected void customizeCellRenderer(@NotNull JList<? extends AuthType> jList, AuthType authType, int n2, boolean bl2, boolean bl3) {
                if (jList == null) {
                    4.a(0);
                }
                SshUIUtil.append((ColoredTextContainer)this, authType);
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ssh/ui/SshCredentialsEditor$4", "customizeCellRenderer"));
            }
        });
        this.c();
        this.a = new HashMap<String, JComponent>();
        this.a.put("HOST", this.myHostField);
        this.a.put("PORT", this.myPortField);
        this.a.put("USERNAME", this.myUsernameField);
        this.a.put("PRIVATE_KEY_FILE", (JComponent)this.myPrivateKeyFileField);
        this.myExternalToolsSuggestionLabel.setIcon(UIUtil.getBalloonWarningIcon());
        this.b();
        AppListener appListener = new AppListener();
        this.c = ApplicationManager.getApplication().getMessageBus().connect();
        this.c.subscribe(ApplicationActivationListener.TOPIC, (Object)appListener);
        Disposer.register((Disposable)this, (Disposable)this.c);
    }

    public void createUIComponents() {
        this.myRSyncLink = new ActionLink("RSync", new AnAction(){

            public void actionPerformed(AnActionEvent anActionEvent) {
                BrowserUtil.open((String)"https://confluence.jetbrains.com/display/RUBYDEV/Faster+Remote+Gem+Downloading+with+Rsync");
            }
        });
    }

    public void setContainer(ParentComponent parentComponent) {
        this.b = parentComponent;
        Disposable disposable = parentComponent.getDisposable();
        Disposer.register((Disposable)disposable, (Disposable)this);
    }

    private void a() {
        if (StringUtil.isNotEmpty((String)this.myPrivateKeyFileField.getText())) {
            boolean bl2 = true;
            File file = new File(this.myPrivateKeyFileField.getText());
            if (file.isFile() && file.canRead()) {
                try {
                    KeyPair keyPair = KeyPair.load((JSch)new JSch(), (String)file.getAbsolutePath());
                    bl2 = keyPair == null || keyPair.isEncrypted();
                }
                catch (JSchException jSchException) {
                    // empty catch block
                }
            }
            if (bl2) {
                if (!this.myPassphraseField.isEnabled()) {
                    this.myPassphraseField.setText(null);
                    this.myPassphraseField.setEnabled(true);
                    this.mySavePassphraseCheckbox.setEnabled(true);
                }
            } else {
                this.myPassphraseField.setText(null);
                this.myPassphraseField.setEnabled(false);
                this.mySavePassphraseCheckbox.setSelected(false);
                this.mySavePassphraseCheckbox.setEnabled(false);
            }
        } else {
            this.myPasswordField.setEnabled(true);
            this.mySavePasswordCheckBox.setEnabled(true);
        }
    }

    private void c() {
        if (this.myAuthTypeCombo.getSelectedItem() == AuthType.PASSWORD) {
            this.myPasswordLabel.setVisible(true);
            this.myPasswordField.setVisible(true);
            this.mySavePasswordCheckBox.setVisible(true);
            this.myPrivateKeyFileLabel.setVisible(false);
            this.myPrivateKeyFileField.setText("");
            int n2 = this.myPrivateKeyFileLabel.getPreferredSize().width;
            this.myPasswordLabel.setMinimumSize(new Dimension(n2, this.myPasswordLabel.getMinimumSize().height));
            this.myPrivateKeyFileField.setVisible(false);
            this.myPassphraseLabel.setVisible(false);
            this.myPassphraseField.setText(null);
            this.myPassphraseField.setVisible(false);
            this.mySavePassphraseCheckbox.setVisible(false);
            this.mySavePassphraseCheckbox.setSelected(false);
        } else if (this.myAuthTypeCombo.getSelectedItem() == AuthType.KEY_PAIR) {
            this.myPasswordLabel.setVisible(false);
            this.myPasswordField.setText(null);
            this.myPasswordField.setVisible(false);
            this.mySavePasswordCheckBox.setSelected(false);
            this.mySavePasswordCheckBox.setVisible(false);
            this.myPrivateKeyFileLabel.setVisible(true);
            this.myPrivateKeyFileField.setVisible(true);
            this.myPassphraseLabel.setVisible(true);
            this.myPassphraseField.setVisible(true);
            this.mySavePassphraseCheckbox.setVisible(true);
            this.myPassphraseField.setEnabled(true);
            this.mySavePassphraseCheckbox.setEnabled(true);
        } else {
            this.myPasswordLabel.setVisible(false);
            this.myPasswordField.setText(null);
            this.myPasswordField.setVisible(false);
            this.mySavePasswordCheckBox.setSelected(false);
            this.mySavePasswordCheckBox.setVisible(false);
            this.myPrivateKeyFileLabel.setVisible(false);
            this.myPrivateKeyFileField.setText("");
            this.myPrivateKeyFileField.setVisible(false);
            this.myPassphraseLabel.setVisible(false);
            this.myPassphraseField.setText(null);
            this.myPassphraseField.setVisible(false);
            this.mySavePassphraseCheckbox.setVisible(false);
            this.mySavePassphraseCheckbox.setSelected(false);
        }
        if (this.b != null) {
            this.b.updateSize();
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myHostField;
    }

    private void a(@NotNull AuthType authType) {
        if (authType == null) {
            SshCredentialsEditor.a(0);
        }
        this.myAuthTypeCombo.setSelectedItem(authType);
        this.c();
    }

    public void resetEditorFrom(@NotNull MutableRemoteCredentials mutableRemoteCredentials) {
        if (mutableRemoteCredentials == null) {
            SshCredentialsEditor.a(1);
        }
        this.resetEditor((RemoteCredentials)mutableRemoteCredentials);
    }

    public void resetEditor(RemoteCredentials remoteCredentials) {
        this.myHostField.setText(remoteCredentials.getHost());
        this.myPortField.setText(remoteCredentials.getLiteralPort());
        this.myUsernameField.setText(remoteCredentials.getUserName());
        this.a(remoteCredentials.getAuthType());
        if (remoteCredentials.getAuthType() == AuthType.KEY_PAIR) {
            this.myPrivateKeyFileField.setText(remoteCredentials.getPrivateKeyFile());
            this.myPassphraseField.setText(remoteCredentials.getPassphrase());
            this.mySavePassphraseCheckbox.setSelected(remoteCredentials.isStorePassphrase());
        } else if (remoteCredentials.getAuthType() == AuthType.PASSWORD) {
            this.myPasswordField.setText(remoteCredentials.getPassword());
            this.mySavePasswordCheckBox.setSelected(remoteCredentials.isStorePassword());
        }
    }

    protected void applyEditorTo(@NotNull MutableRemoteCredentials mutableRemoteCredentials) throws ConfigurationException {
        if (mutableRemoteCredentials == null) {
            SshCredentialsEditor.a(2);
        }
        mutableRemoteCredentials.setHost(this.myHostField.getText());
        mutableRemoteCredentials.setLiteralPort(this.myPortField.getText());
        String string = this.myUsernameField.getText();
        if (string != null) {
            string = string.trim();
        }
        mutableRemoteCredentials.setUserName(string);
        if (this.myAuthTypeCombo.getSelectedItem() == AuthType.KEY_PAIR) {
            mutableRemoteCredentials.setAuthType(AuthType.KEY_PAIR);
            mutableRemoteCredentials.setPassword(null);
            mutableRemoteCredentials.setStorePassword(false);
            mutableRemoteCredentials.setPassphrase(new String(this.myPassphraseField.getPassword()));
            mutableRemoteCredentials.setStorePassphrase(this.mySavePassphraseCheckbox.isSelected());
            mutableRemoteCredentials.setPrivateKeyFile(this.myPrivateKeyFileField.getText());
        } else if (this.myAuthTypeCombo.getSelectedItem() == AuthType.OPEN_SSH) {
            mutableRemoteCredentials.setAuthType(AuthType.OPEN_SSH);
            mutableRemoteCredentials.setPassword(null);
            mutableRemoteCredentials.setStorePassword(false);
            mutableRemoteCredentials.setPassphrase(null);
            mutableRemoteCredentials.setStorePassphrase(false);
            mutableRemoteCredentials.setPrivateKeyFile(null);
        } else {
            mutableRemoteCredentials.setAuthType(AuthType.PASSWORD);
            mutableRemoteCredentials.setPassword(new String(this.myPasswordField.getPassword()));
            mutableRemoteCredentials.setStorePassword(this.mySavePasswordCheckBox.isSelected());
            mutableRemoteCredentials.setPassphrase(null);
            mutableRemoteCredentials.setStorePassphrase(false);
            mutableRemoteCredentials.setPrivateKeyFile(null);
        }
    }

    @NotNull
    public JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            SshCredentialsEditor.a(3);
        }
        return jPanel;
    }

    public void setEnabled(boolean bl2) {
        UIUtil.setEnabled((Component)this.myMainPanel, (boolean)bl2, (boolean)true);
    }

    private void b() {
        List<String> list2 = RSyncUtil.externalToolSuggestion();
        String string = StringUtil.pluralize((String)"utility", (int)list2.size());
        this.myExternalToolsSuggestionLabel.setText(String.format("To reduce download time install %s:", string));
        this.myExternalToolsSuggestionLabel.setVisible(list2.size() > 0);
        this.myRSyncLink.setVisible(list2.contains("rsync"));
    }

    @Nullable
    public ValidationInfo createValidationInfo(@NotNull Pair<String, String> pair2) {
        String string;
        if (pair2 == null) {
            SshCredentialsEditor.a(4);
        }
        JComponent jComponent = (string = (String)pair2.getSecond()) == null ? null : this.a.get(string);
        return new ValidationInfo((String)pair2.getFirst(), jComponent);
    }

    @Nullable
    public JComponent getAnchor() {
        return this.d;
    }

    public void setAnchor(@Nullable JComponent jComponent) {
        this.d = jComponent;
        this.myHostLabel.setAnchor(jComponent);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authType";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ssh/ui/SshCredentialsEditor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessageAndField";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ssh/ui/SshCredentialsEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setAuthTypeCombo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createValidationInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void d() {
        JLabel jLabel;
        JCheckBox jCheckBox;
        JBCheckBox jBCheckBox;
        JTextField jTextField;
        JPasswordField jPasswordField;
        JLabel jLabel2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel3;
        JPasswordField jPasswordField2;
        JBLabel jBLabel;
        JTextField jTextField2;
        JTextField jTextField3;
        JBLabel jBLabel2;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(8, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myHostLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("Host:");
        jBLabel2.setDisplayedMnemonic('H');
        jBLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 1, 1, 3, 0, 3, 7, 3, null, null, null));
        this.myHostField = jTextField3 = new JTextField();
        jPanel2.add((Component)jTextField3, new GridConstraints(0, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Port:");
        jLabel4.setDisplayedMnemonic('P');
        jLabel4.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel4, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPortField = jTextField2 = new JTextField();
        jTextField2.setText("");
        jPanel2.add((Component)jTextField2, new GridConstraints(0, 2, 1, 1, 8, 0, 2, 0, null, new Dimension(50, 22), null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("User name:");
        jLabel5.setDisplayedMnemonic('U');
        jLabel5.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel5, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("Authentication type:");
        jLabel6.setDisplayedMnemonic('Y');
        jLabel6.setDisplayedMnemonicIndex(16);
        jPanel.add((Component)jLabel6, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myAuthTypeCombo = jComboBox;
        jPanel.add(jComboBox, new GridConstraints(2, 1, 1, 2, 8, 1, 2, 0, null, null, null));
        this.myPasswordLabel = jBLabel = new JBLabel();
        jBLabel.setText("Password:");
        jBLabel.setDisplayedMnemonic('A');
        jBLabel.setDisplayedMnemonicIndex(1);
        jPanel.add((Component)jBLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPasswordField = jPasswordField2 = new JPasswordField();
        jPanel.add((Component)jPasswordField2, new GridConstraints(3, 1, 1, 1, 8, 0, 2, 0, null, new Dimension(200, -1), null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myPrivateKeyFileLabel = jLabel3 = new JLabel();
        jLabel3.setText("Private key file:");
        jLabel3.setDisplayedMnemonic('K');
        jLabel3.setDisplayedMnemonicIndex(8);
        jPanel.add((Component)jLabel3, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPrivateKeyFileField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(4, 1, 1, 3, 0, 1, 7, 0, null, null, null));
        this.myPassphraseLabel = jLabel2 = new JLabel();
        jLabel2.setText("Passphrase:");
        jLabel2.setDisplayedMnemonic('A');
        jLabel2.setDisplayedMnemonicIndex(1);
        jPanel.add((Component)jLabel2, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPassphraseField = jPasswordField = new JPasswordField();
        jPanel.add((Component)jPasswordField, new GridConstraints(5, 1, 1, 1, 8, 0, 2, 0, null, new Dimension(200, 22), null));
        this.myUsernameField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 0, 2, 0, null, new Dimension(200, -1), null));
        this.mySavePasswordCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Save password");
        jBCheckBox.setMnemonic('E');
        jBCheckBox.setDisplayedMnemonicIndex(3);
        jPanel.add((Component)jBCheckBox, new GridConstraints(3, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySavePassphraseCheckbox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Save passphrase");
        jCheckBox.setMnemonic('E');
        jCheckBox.setDisplayedMnemonicIndex(3);
        jPanel.add((Component)jCheckBox, new GridConstraints(5, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(7, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(6, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        this.myExternalToolsSuggestionLabel = jLabel = new JLabel();
        jLabel.setText("To reduce download time install utilities:");
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ActionLink actionLink = this.myRSyncLink;
        actionLink.setText("RSync");
        jPanel3.add((Component)actionLink, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel3.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        jBLabel2.setLabelFor(jTextField3);
        jLabel4.setLabelFor(jTextField2);
        jLabel5.setLabelFor(jTextField);
        jLabel6.setLabelFor(jComboBox);
        jBLabel.setLabelFor(jPasswordField2);
        jLabel3.setLabelFor((Component)textFieldWithBrowseButton);
        jLabel2.setLabelFor(jPasswordField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private class AppListener
    implements ApplicationActivationListener {
        private AppListener() {
        }

        public void applicationActivated(IdeFrame ideFrame) {
            SshCredentialsEditor.this.b();
        }
    }

    public static interface ParentComponent {
        public void updateSize();

        @NotNull
        public Disposable getDisposable();
    }
}

