/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.task.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskManager;
import com.intellij.task.ProjectTaskNotification;
import com.intellij.task.ProjectTaskResult;
import com.intellij.task.ProjectTaskRunner;
import com.intellij.task.impl.AbstractProjectTask;
import com.intellij.task.impl.ArtifactBuildTaskImpl;
import com.intellij.task.impl.InternalProjectTaskRunner;
import com.intellij.task.impl.ModuleBuildTaskImpl;
import com.intellij.task.impl.ModuleFilesBuildTaskImpl;
import com.intellij.task.impl.ProjectTaskList;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectTaskManagerImpl
extends ProjectTaskManager {
    private final ProjectTaskRunner a;

    public ProjectTaskManagerImpl(@NotNull Project project2) {
        if (project2 == null) {
            ProjectTaskManagerImpl.a(0);
        }
        super(project2);
        this.a = new InternalProjectTaskRunner();
    }

    public void build(@NotNull Module[] moduleArray, @Nullable ProjectTaskNotification projectTaskNotification) {
        if (moduleArray == null) {
            ProjectTaskManagerImpl.a(1);
        }
        this.run(this.createModulesBuildTask(moduleArray, true, true, false), projectTaskNotification);
    }

    public void rebuild(@NotNull Module[] moduleArray, @Nullable ProjectTaskNotification projectTaskNotification) {
        if (moduleArray == null) {
            ProjectTaskManagerImpl.a(2);
        }
        this.run(this.createModulesBuildTask(moduleArray, false, false, false), projectTaskNotification);
    }

    public void compile(@NotNull VirtualFile[] virtualFileArray, @Nullable ProjectTaskNotification projectTaskNotification) {
        if (virtualFileArray == null) {
            ProjectTaskManagerImpl.a(3);
        }
        List list2 = Arrays.stream(virtualFileArray).collect(Collectors.groupingBy(virtualFile -> ProjectFileIndex.SERVICE.getInstance((Project)this.myProject).getModuleForFile(virtualFile, false))).entrySet().stream().map(entry -> new ModuleFilesBuildTaskImpl((Module)entry.getKey(), false, (Collection)entry.getValue())).collect(Collectors.toList());
        this.run(new ProjectTaskList(list2), projectTaskNotification);
    }

    public void build(@NotNull Artifact[] artifactArray, @Nullable ProjectTaskNotification projectTaskNotification) {
        if (artifactArray == null) {
            ProjectTaskManagerImpl.a(4);
        }
        this.a(artifactArray, projectTaskNotification, true);
    }

    public void rebuild(@NotNull Artifact[] artifactArray, @Nullable ProjectTaskNotification projectTaskNotification) {
        if (artifactArray == null) {
            ProjectTaskManagerImpl.a(5);
        }
        this.a(artifactArray, projectTaskNotification, false);
    }

    public void buildAllModules(@Nullable ProjectTaskNotification projectTaskNotification) {
        this.run(this.createAllModulesBuildTask(true, this.myProject), projectTaskNotification);
    }

    public void rebuildAllModules(@Nullable ProjectTaskNotification projectTaskNotification) {
        this.run(this.createAllModulesBuildTask(false, this.myProject), projectTaskNotification);
    }

    public ProjectTask createAllModulesBuildTask(boolean bl2, Project project2) {
        return this.createModulesBuildTask(ModuleManager.getInstance((Project)project2).getModules(), bl2, false, false);
    }

    public ProjectTask createModulesBuildTask(Module module2, boolean bl2, boolean bl3, boolean bl4) {
        return this.createModulesBuildTask((Module[])ContainerUtil.ar((Object[])new Module[]{module2}), bl2, bl3, bl4);
    }

    public ProjectTask createModulesBuildTask(Module[] moduleArray, boolean bl2, boolean bl3, boolean bl4) {
        return moduleArray.length == 1 ? new ModuleBuildTaskImpl(moduleArray[0], bl2, bl3, bl4) : new ProjectTaskList(ContainerUtil.map((Collection)ContainerUtil.list((Object[])moduleArray), module2 -> new ModuleBuildTaskImpl((Module)module2, bl2, bl3, bl4)));
    }

    public ProjectTask createArtifactsBuildTask(boolean bl2, Artifact ... artifactArray) {
        return artifactArray.length == 1 ? new ArtifactBuildTaskImpl(artifactArray[0], bl2) : new ProjectTaskList(ContainerUtil.map((Collection)ContainerUtil.list((Object[])artifactArray), artifact -> new ArtifactBuildTaskImpl((Artifact)artifact, bl2)));
    }

    public void run(@NotNull ProjectTask projectTask, @Nullable ProjectTaskNotification projectTaskNotification) {
        if (projectTask == null) {
            ProjectTaskManagerImpl.a(6);
        }
        this.run(new ProjectTaskContext(), projectTask, projectTaskNotification);
    }

    public void run(@NotNull ProjectTaskContext projectTaskContext, @NotNull ProjectTask projectTask, final @Nullable ProjectTaskNotification projectTaskNotification) {
        if (projectTaskContext == null) {
            ProjectTaskManagerImpl.a(7);
        }
        if (projectTask == null) {
            ProjectTaskManagerImpl.a(8);
        }
        SmartList smartList = new SmartList();
        Consumer consumer = arg_0 -> this.a((List)smartList, arg_0);
        ProjectTaskManagerImpl.a((Collection<? extends ProjectTask>)(projectTask instanceof ProjectTaskList ? (ProjectTaskList)projectTask : Collections.singleton(projectTask)), (Consumer<Collection<? extends ProjectTask>>)consumer);
        if (smartList.isEmpty()) {
            ProjectTaskManagerImpl.a(projectTaskNotification);
            return;
        }
        final AtomicInteger atomicInteger = new AtomicInteger(smartList.size());
        final AtomicInteger atomicInteger2 = new AtomicInteger();
        final AtomicInteger atomicInteger3 = new AtomicInteger();
        final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        ProjectTaskNotification projectTaskNotification2 = projectTaskNotification == null ? null : new ProjectTaskNotification(){

            public void finished(@NotNull ProjectTaskResult projectTaskResult) {
                if (projectTaskResult == null) {
                    1.a(0);
                }
                int n2 = atomicInteger.decrementAndGet();
                int n3 = atomicInteger2.addAndGet(projectTaskResult.getErrors());
                int n4 = atomicInteger3.addAndGet(projectTaskResult.getWarnings());
                if (projectTaskResult.isAborted()) {
                    atomicBoolean.set(true);
                }
                if (n2 == 0) {
                    projectTaskNotification.finished(new ProjectTaskResult(atomicBoolean.get(), n3, n4));
                }
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executionResult", "com/intellij/task/impl/ProjectTaskManagerImpl$1", "finished"));
            }
        };
        smartList.forEach(pair2 -> {
            if (projectTaskContext == null) {
                ProjectTaskManagerImpl.a(13);
            }
            if (((Collection)pair2.second).isEmpty()) {
                ProjectTaskManagerImpl.a(projectTaskNotification2);
            } else {
                ((ProjectTaskRunner)pair2.first).run(this.myProject, projectTaskContext, projectTaskNotification2, (Collection)pair2.second);
            }
        });
    }

    private static void a(@Nullable ProjectTaskNotification projectTaskNotification) {
        if (projectTaskNotification != null) {
            projectTaskNotification.finished(new ProjectTaskResult(false, 0, 0));
        }
    }

    private static void a(@NotNull Collection<? extends ProjectTask> collection, @NotNull Consumer<Collection<? extends ProjectTask>> consumer) {
        if (collection == null) {
            ProjectTaskManagerImpl.a(9);
        }
        if (consumer == null) {
            ProjectTaskManagerImpl.a(10);
        }
        for (ProjectTask projectTask : collection) {
            Collection<ProjectTask> collection2 = projectTask instanceof AbstractProjectTask ? ((AbstractProjectTask)projectTask).getDependsOn() : (projectTask instanceof ProjectTaskList ? (ProjectTaskList)projectTask : Collections.singleton(projectTask));
            ProjectTaskManagerImpl.a(collection2, consumer);
        }
        consumer.consume(collection);
    }

    @NotNull
    private static ProjectTaskRunner[] a() {
        ProjectTaskRunner[] projectTaskRunnerArray = (ProjectTaskRunner[])ProjectTaskRunner.EP_NAME.getExtensions();
        if (projectTaskRunnerArray == null) {
            ProjectTaskManagerImpl.a(11);
        }
        return projectTaskRunnerArray;
    }

    private void a(@NotNull Artifact[] artifactArray, @Nullable ProjectTaskNotification projectTaskNotification, boolean bl2) {
        if (artifactArray == null) {
            ProjectTaskManagerImpl.a(12);
        }
        this.run(this.createArtifactsBuildTask(bl2, artifactArray), projectTaskNotification);
    }

    private /* synthetic */ void a(List list2, Collection collection) {
        Map<ProjectTaskRunner, List<ProjectTask>> map = collection.stream().collect(Collectors.groupingBy(projectTask -> {
            for (ProjectTaskRunner projectTaskRunner : ProjectTaskManagerImpl.a()) {
                if (!projectTaskRunner.canRun(projectTask)) continue;
                return projectTaskRunner;
            }
            return this.a;
        }));
        for (Map.Entry<ProjectTaskRunner, List<ProjectTask>> entry : map.entrySet()) {
            list2.add(Pair.create((Object)entry.getKey(), entry.getValue()));
        }
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 11: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 4: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifacts";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectTask";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/task/impl/ProjectTaskManagerImpl";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/task/impl/ProjectTaskManagerImpl";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTaskRunners";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "rebuild";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "compile";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "visitTasks";
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doBuild";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$run$6";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

