/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.impl.ComponentManagerImpl;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.FileEditorProviderManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.fixtures.LightPlatformCodeInsightFixtureTestCase;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.DockManager;
import com.intellij.util.JdomKt;
import com.intellij.util.ui.UIUtil;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;

public abstract class FileEditorManagerTestCase
extends LightPlatformCodeInsightFixtureTestCase {
    protected FileEditorManagerImpl myManager;
    private FileEditorManager k;
    private Set<DockContainer> l;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        DockManager dockManager = DockManager.getInstance((Project)this.getProject());
        this.l = dockManager.getContainers();
        this.myManager = new FileEditorManagerImpl(this.getProject(), dockManager);
        this.k = (FileEditorManager)((ComponentManagerImpl)this.getProject()).registerComponentInstance(FileEditorManager.class, (Object)this.myManager);
        ((FileEditorProviderManagerImpl)FileEditorProviderManager.getInstance()).clearSelectedProviders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tearDown() throws Exception {
        try {
            for (DockContainer dockContainer : DockManager.getInstance((Project)this.getProject()).getContainers()) {
                if (this.l.contains(dockContainer)) continue;
                Disposer.dispose((Disposable)dockContainer);
            }
            this.l = null;
            ((ComponentManagerImpl)this.getProject()).registerComponentInstance(FileEditorManager.class, (Object)this.k);
            this.myManager.closeAllFiles();
            for (VirtualFile virtualFile : EditorHistoryManager.getInstance((Project)this.getProject()).getFiles()) {
                EditorHistoryManager.getInstance((Project)this.getProject()).removeFile(virtualFile);
            }
            ((FileEditorProviderManagerImpl)FileEditorProviderManager.getInstance()).clearSelectedProviders();
        }
        finally {
            this.myManager = null;
            this.k = null;
            super.tearDown();
        }
    }

    protected VirtualFile getFile(String string) {
        String string2 = this.getTestDataPath() + string;
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(string2);
        FileEditorManagerTestCase.assertNotNull((String)("Can't find " + string2), (Object)virtualFile);
        return virtualFile;
    }

    protected void openFiles(@NotNull String string) throws IOException, JDOMException, InterruptedException, ExecutionException {
        if (string == null) {
            FileEditorManagerTestCase.b(0);
        }
        Element element = JdomKt.loadElement((CharSequence)string);
        ExpandMacroToPathMap expandMacroToPathMap = new ExpandMacroToPathMap();
        expandMacroToPathMap.addMacroExpand("PROJECT_DIR", this.getTestDataPath());
        expandMacroToPathMap.substitute(element, true, true);
        this.myManager.loadState(element);
        Future future = ApplicationManager.getApplication().executeOnPooledThread(() -> this.myManager.getMainSplitters().openFiles());
        while (true) {
            try {
                future.get(100L, TimeUnit.MILLISECONDS);
                return;
            }
            catch (TimeoutException timeoutException) {
                UIUtil.dispatchAllInvocationEvents();
                continue;
            }
            break;
        }
    }

    private static /* synthetic */ void b(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "femSerialisedText", "com/intellij/testFramework/FileEditorManagerTestCase", "openFiles"));
    }
}

