/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandler;
import com.intellij.ide.DataManager;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.TrailingSpacesStripper;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.testFramework.EditorTestUtil;
import com.intellij.testFramework.FileBasedTestCaseHelper;
import com.intellij.testFramework.FileBasedTestCaseHelperEx;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.Parameterized;
import com.intellij.testFramework.TestDataPath;
import com.intellij.testFramework.VfsTestUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.After;
import org.junit.Before;
import org.junit.runners.Parameterized;

public abstract class LightPlatformCodeInsightTestCase
extends LightPlatformTestCase {
    protected static Editor myEditor;
    protected static PsiFile myFile;
    protected static VirtualFile myVFile;
    @Parameterized.Parameter(value=0)
    public String myFileSuffix;
    @Parameterized.Parameter(value=1)
    public String myTestDataPath;

    @Override
    protected void runTest() throws Throwable {
        if (this.isRunInWriteAction()) {
            WriteCommandAction.runWriteCommandAction((Project)LightPlatformCodeInsightTestCase.getProject(), () -> {
                this.doRunTest();
                return null;
            });
        } else {
            new WriteCommandAction.Simple(LightPlatformCodeInsightTestCase.getProject(), new PsiFile[0]){

                protected void run() throws Throwable {
                    LightPlatformCodeInsightTestCase.this.doRunTest();
                }
            }.performCommand();
        }
    }

    protected void doRunTest() throws Throwable {
        super.runTest();
    }

    protected boolean isRunInWriteAction() {
        return false;
    }

    protected void configureByFile(@NonNls @NotNull String string) {
        if (string == null) {
            LightPlatformCodeInsightTestCase.c(0);
        }
        try {
            String string2 = this.getTestDataPath() + string;
            File file = new File(string2);
            LightPlatformCodeInsightTestCase.a(string2, file);
            String string3 = FileUtilRt.loadFile((File)file, (String)"UTF-8", (boolean)true);
            LightPlatformCodeInsightTestCase.configureFromFileText(file.getName(), string3);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private static void a(String string, File file) throws IOException {
        string = FileUtil.toSystemDependentName((String)FileUtil.toCanonicalPath((String)string));
        if (!file.getCanonicalPath().endsWith(string)) {
            throw new RuntimeException("Search for: " + string + "; but found: " + file.getCanonicalPath());
        }
    }

    @NonNls
    @NotNull
    protected String getTestDataPath() {
        if (this.myTestDataPath != null) {
            String string = this.myTestDataPath;
            if (string == null) {
                LightPlatformCodeInsightTestCase.c(1);
            }
            return string;
        }
        String string = PathManagerEx.getTestDataPath();
        if (string == null) {
            LightPlatformCodeInsightTestCase.c(2);
        }
        return string;
    }

    @NotNull
    protected VirtualFile getVirtualFile(@NonNls @NotNull String string) {
        if (string == null) {
            LightPlatformCodeInsightTestCase.c(3);
        }
        String string2 = this.getTestDataPath() + string;
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(string2.replace(File.separatorChar, '/'));
        LightPlatformCodeInsightTestCase.assertNotNull((String)("file " + string2 + " not found"), (Object)virtualFile);
        VirtualFile virtualFile2 = virtualFile;
        if (virtualFile2 == null) {
            LightPlatformCodeInsightTestCase.c(4);
        }
        return virtualFile2;
    }

    @NotNull
    protected static Document configureFromFileText(@NonNls @NotNull String string, @NonNls @NotNull String string2) {
        if (string == null) {
            LightPlatformCodeInsightTestCase.c(5);
        }
        if (string2 == null) {
            LightPlatformCodeInsightTestCase.c(6);
        }
        Document document = LightPlatformCodeInsightTestCase.configureFromFileText(string, string2, false);
        if (document == null) {
            LightPlatformCodeInsightTestCase.c(7);
        }
        return document;
    }

    @NotNull
    protected static Document configureFromFileText(final @NonNls @NotNull String string, final @NonNls @NotNull String string2, final boolean bl2) {
        if (string == null) {
            LightPlatformCodeInsightTestCase.c(8);
        }
        if (string2 == null) {
            LightPlatformCodeInsightTestCase.c(9);
        }
        Document document = (Document)new WriteCommandAction<Document>(null, new PsiFile[0]){

            protected void run(@NotNull Result<Document> result2) {
                Document document;
                if (result2 == null) {
                    2.a(0);
                }
                DocumentImpl documentImpl = new DocumentImpl(string2);
                EditorTestUtil.CaretAndSelectionState caretAndSelectionState = EditorTestUtil.extractCaretAndSelectionMarkers((Document)documentImpl);
                if (bl2) {
                    TestCase.assertTrue((String)("No caret specified in " + string), (boolean)caretAndSelectionState.hasExplicitCaret());
                }
                String string3 = documentImpl.getText();
                try {
                    document = LightPlatformCodeInsightTestCase.c(string, string3);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                EditorTestUtil.setCaretsAndSelection(myEditor, caretAndSelectionState);
                LightPlatformCodeInsightTestCase.setupEditorForInjectedLanguage();
                result2.setResult((Object)document);
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/LightPlatformCodeInsightTestCase$2", "run"));
            }
        }.execute().getResultObject();
        if (document == null) {
            LightPlatformCodeInsightTestCase.c(10);
        }
        return document;
    }

    @NotNull
    protected static Editor configureFromFileTextWithoutPSI(final @NonNls @NotNull String string) {
        if (string == null) {
            LightPlatformCodeInsightTestCase.c(11);
        }
        Editor editor = (Editor)new WriteCommandAction<Editor>(LightPlatformCodeInsightTestCase.getProject(), new PsiFile[0]){

            protected void run(@NotNull Result<Editor> result2) {
                if (result2 == null) {
                    3.a(0);
                }
                Document document = EditorFactory.getInstance().createDocument((CharSequence)string);
                EditorTestUtil.CaretAndSelectionState caretAndSelectionState = EditorTestUtil.extractCaretAndSelectionMarkers(document);
                String string2 = document.getText();
                Document document2 = EditorFactory.getInstance().createDocument((CharSequence)string2);
                Editor editor = EditorFactory.getInstance().createEditor(document2, this.getProject());
                ((EditorImpl)editor).setCaretActive();
                EditorTestUtil.setCaretsAndSelection(editor, caretAndSelectionState);
                result2.setResult((Object)editor);
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/LightPlatformCodeInsightTestCase$3", "run"));
            }
        }.execute().getResultObject();
        if (editor == null) {
            LightPlatformCodeInsightTestCase.c(12);
        }
        return editor;
    }

    @NotNull
    protected static Editor createEditor(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            LightPlatformCodeInsightTestCase.c(13);
        }
        PsiDocumentManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).commitAllDocuments();
        Editor editor = FileEditorManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).openTextEditor(new OpenFileDescriptor(LightPlatformCodeInsightTestCase.getProject(), virtualFile, 0), false);
        DaemonCodeAnalyzer.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).restart();
        LightPlatformCodeInsightTestCase.assertNotNull((Object)editor);
        ((EditorImpl)editor).setCaretActive();
        Editor editor2 = editor;
        if (editor2 == null) {
            LightPlatformCodeInsightTestCase.c(14);
        }
        return editor2;
    }

    @NotNull
    private static Document c(@NotNull String string, @NotNull String string2) throws IOException {
        if (string == null) {
            LightPlatformCodeInsightTestCase.c(15);
        }
        if (string2 == null) {
            LightPlatformCodeInsightTestCase.c(16);
        }
        EncodingProjectManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).setEncoding(null, CharsetToolkit.UTF8_CHARSET);
        EncodingProjectManager.getInstance((Project)ProjectManager.getInstance().getDefaultProject()).setEncoding(null, CharsetToolkit.UTF8_CHARSET);
        PostprocessReformattingAspect.getInstance((Project)ourProject).doPostponedFormatting();
        LightPlatformCodeInsightTestCase.G();
        myEditor = LightPlatformCodeInsightTestCase.createSaveAndOpenFile(string, string2);
        myVFile = FileDocumentManager.getInstance().getFile(myEditor.getDocument());
        myFile = LightPlatformCodeInsightTestCase.getPsiManager().findFile(myVFile);
        Document document = myEditor.getDocument();
        if (document == null) {
            LightPlatformCodeInsightTestCase.c(17);
        }
        return document;
    }

    @NotNull
    protected static Editor createSaveAndOpenFile(@NotNull String string, @NotNull String string2) throws IOException {
        if (string == null) {
            LightPlatformCodeInsightTestCase.c(18);
        }
        if (string2 == null) {
            LightPlatformCodeInsightTestCase.c(19);
        }
        Editor editor = (Editor)WriteCommandAction.runWriteCommandAction((Project)LightPlatformCodeInsightTestCase.getProject(), () -> {
            if (string == null) {
                LightPlatformCodeInsightTestCase.c(59);
            }
            if (string2 == null) {
                LightPlatformCodeInsightTestCase.c(60);
            }
            VirtualFile virtualFile = VfsTestUtil.createFile(LightPlatformCodeInsightTestCase.getSourceRoot(), string);
            VfsUtil.saveText((VirtualFile)virtualFile, (String)string2);
            FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
            Document document = fileDocumentManager.getDocument(virtualFile);
            LightPlatformCodeInsightTestCase.assertNotNull((String)("Can't create document for '" + string + "'"), (Object)document);
            fileDocumentManager.reloadFromDisk(document);
            document.insertString(0, (CharSequence)" ");
            document.deleteString(0, 1);
            PsiFile psiFile = LightPlatformCodeInsightTestCase.getPsiManager().findFile(virtualFile);
            LightPlatformCodeInsightTestCase.assertNotNull((String)("Can't create PsiFile for '" + string + "'. Unknown file type most probably."), (Object)psiFile);
            LightPlatformCodeInsightTestCase.assertTrue((boolean)psiFile.isPhysical());
            Editor editor = LightPlatformCodeInsightTestCase.createEditor(virtualFile);
            virtualFile.setCharset(CharsetToolkit.UTF8_CHARSET);
            PsiDocumentManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).commitAllDocuments();
            return editor;
        });
        if (editor == null) {
            LightPlatformCodeInsightTestCase.c(20);
        }
        return editor;
    }

    @NotNull
    protected static VirtualFile createAndSaveFile(@NotNull String string, @NotNull String string2) throws IOException {
        if (string == null) {
            LightPlatformCodeInsightTestCase.c(21);
        }
        if (string2 == null) {
            LightPlatformCodeInsightTestCase.c(22);
        }
        VirtualFile virtualFile = (VirtualFile)WriteCommandAction.runWriteCommandAction((Project)LightPlatformCodeInsightTestCase.getProject(), () -> {
            if (string == null) {
                LightPlatformCodeInsightTestCase.c(57);
            }
            if (string2 == null) {
                LightPlatformCodeInsightTestCase.c(58);
            }
            VirtualFile virtualFile = VfsTestUtil.createFile(LightPlatformCodeInsightTestCase.getSourceRoot(), string);
            VfsUtil.saveText((VirtualFile)virtualFile, (String)string2);
            return virtualFile;
        });
        if (virtualFile == null) {
            LightPlatformCodeInsightTestCase.c(23);
        }
        return virtualFile;
    }

    protected static void setupEditorForInjectedLanguage() {
        if (myEditor != null) {
            Editor editor = myEditor instanceof EditorWindow ? ((EditorWindow)myEditor).getDelegate() : myEditor;
            PsiFile psiFile = myFile == null ? null : InjectedLanguageManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).getTopLevelFile((PsiElement)myFile);
            Ref ref = new Ref();
            editor.getCaretModel().runForEachCaret(caret -> {
                Editor editor2 = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit((Editor)editor, (PsiFile)psiFile);
                if (caret == editor.getCaretModel().getPrimaryCaret() && editor2 instanceof EditorWindow) {
                    ref.set((Object)((EditorWindow)editor2));
                }
            });
            if (!ref.isNull()) {
                myEditor = (Editor)ref.get();
                myFile = ((EditorWindow)ref.get()).getInjectedFile();
            }
        }
    }

    private static void G() throws IOException {
        if (myVFile != null) {
            WriteAction.run(() -> {
                PsiDocumentManager.getInstance((Project)ourProject).commitAllDocuments();
                FileEditorManager.getInstance((Project)ourProject).closeFile(myVFile);
                myVFile.delete((Object)ourProject);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tearDown() throws Exception {
        try {
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject());
            for (VirtualFile virtualFile : fileEditorManager.getOpenFiles()) {
                fileEditorManager.closeFile(virtualFile);
            }
            LightPlatformCodeInsightTestCase.G();
            myEditor = null;
            myFile = null;
            myVFile = null;
        }
        finally {
            super.tearDown();
        }
    }

    protected void checkResultByFile(@NonNls @NotNull String string) {
        if (string == null) {
            LightPlatformCodeInsightTestCase.c(24);
        }
        this.checkResultByFile(null, string, false);
    }

    protected void checkResultByFile(@Nullable String string, @NotNull String string2, boolean bl2) {
        String string3;
        Object object;
        if (string2 == null) {
            LightPlatformCodeInsightTestCase.c(25);
        }
        LightPlatformCodeInsightTestCase.bringRealEditorBack();
        ((PostprocessReformattingAspect)LightPlatformCodeInsightTestCase.getProject().getComponent(PostprocessReformattingAspect.class)).doPostponedFormatting();
        if (bl2) {
            object = myEditor;
            TrailingSpacesStripper.strip((Document)object.getDocument(), (boolean)false, (boolean)true);
            EditorUtil.fillVirtualSpaceUntilCaret((Editor)object);
        }
        PsiDocumentManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).commitAllDocuments();
        object = this.getTestDataPath() + string2;
        File file = new File((String)object);
        LightPlatformCodeInsightTestCase.assertTrue((String)LightPlatformCodeInsightTestCase.b("Cannot find file " + (String)object, string), (boolean)file.exists());
        try {
            LightPlatformCodeInsightTestCase.a((String)object, file);
            string3 = FileUtil.loadFile((File)file, (Charset)CharsetToolkit.UTF8_CHARSET);
        }
        catch (IOException iOException) {
            LOG.error((Throwable)iOException);
            throw new RuntimeException(iOException);
        }
        this.checkResultByText(string, StringUtil.convertLineSeparators((String)string3), bl2, this.getTestDataPath() + "/" + string2);
    }

    protected void checkResultByText(@NonNls @NotNull String string) {
        if (string == null) {
            LightPlatformCodeInsightTestCase.c(26);
        }
        this.checkResultByText(null, string, false, null);
    }

    protected void checkResultByText(String string, @NotNull String string2, boolean bl2) {
        if (string2 == null) {
            LightPlatformCodeInsightTestCase.c(27);
        }
        this.checkResultByText(string, string2, bl2, null);
    }

    protected void checkResultByText(String string, @NotNull String string2, boolean bl2, String string3) {
        if (string2 == null) {
            LightPlatformCodeInsightTestCase.c(28);
        }
        LightPlatformCodeInsightTestCase.bringRealEditorBack();
        PsiDocumentManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).commitAllDocuments();
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (string2 == null) {
                LightPlatformCodeInsightTestCase.c(56);
            }
            Document document = EditorFactory.getInstance().createDocument((CharSequence)string2);
            if (bl2) {
                ((DocumentImpl)document).stripTrailingSpaces(LightPlatformCodeInsightTestCase.getProject());
            }
            EditorTestUtil.CaretAndSelectionState caretAndSelectionState = EditorTestUtil.extractCaretAndSelectionMarkers(document);
            PostprocessReformattingAspect.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).doPostponedFormatting();
            String string4 = document.getText();
            PsiDocumentManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).commitAllDocuments();
            String string5 = myFile.getText();
            String string6 = LightPlatformCodeInsightTestCase.b("Text mismatch", string);
            if (string3 != null && !string4.equals(string5)) {
                throw new FileComparisonFailure(string6, string4, string5, string3);
            }
            LightPlatformCodeInsightTestCase.assertEquals((String)string6, (String)string4, (String)string5);
            EditorTestUtil.verifyCaretAndSelectionState(myEditor, caretAndSelectionState, string);
        });
    }

    protected static void checkResultByTextWithoutPSI(String string, @NotNull Editor editor, @NotNull String string2, boolean bl2, String string3) {
        if (editor == null) {
            LightPlatformCodeInsightTestCase.c(29);
        }
        if (string2 == null) {
            LightPlatformCodeInsightTestCase.c(30);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (string2 == null) {
                LightPlatformCodeInsightTestCase.c(54);
            }
            if (editor == null) {
                LightPlatformCodeInsightTestCase.c(55);
            }
            Document document = EditorFactory.getInstance().createDocument((CharSequence)string2);
            if (bl2) {
                ((DocumentImpl)document).stripTrailingSpaces(LightPlatformCodeInsightTestCase.getProject());
            }
            EditorTestUtil.CaretAndSelectionState caretAndSelectionState = EditorTestUtil.extractCaretAndSelectionMarkers(document);
            String string4 = document.getText();
            String string5 = editor.getDocument().getText();
            String string6 = LightPlatformCodeInsightTestCase.b("Text mismatch", string);
            if (string3 != null && !string4.equals(string5)) {
                throw new FileComparisonFailure(string6, string4, string5, string3);
            }
            LightPlatformCodeInsightTestCase.assertEquals((String)string6, (String)string4, (String)string5);
            EditorTestUtil.verifyCaretAndSelectionState(editor, caretAndSelectionState, string);
        });
    }

    @NotNull
    private static String b(@NonNls @NotNull String string, String string2) {
        if (string == null) {
            LightPlatformCodeInsightTestCase.c(31);
        }
        if (string2 == null) {
            String string3 = string;
            if (string3 == null) {
                LightPlatformCodeInsightTestCase.c(32);
            }
            return string3;
        }
        String string4 = string2 + " [" + string + "]";
        if (string4 == null) {
            LightPlatformCodeInsightTestCase.c(33);
        }
        return string4;
    }

    protected static Editor getEditor() {
        return myEditor;
    }

    protected static PsiFile getFile() {
        return myFile;
    }

    protected static VirtualFile getVFile() {
        return myVFile;
    }

    protected static void bringRealEditorBack() {
        PsiDocumentManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).commitAllDocuments();
        if (myEditor instanceof EditorWindow) {
            Document document = ((DocumentWindow)myEditor.getDocument()).getDelegate();
            myFile = PsiDocumentManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).getPsiFile(document);
            myEditor = ((EditorWindow)myEditor).getDelegate();
            myVFile = myFile.getVirtualFile();
        }
    }

    protected void caretRight() {
        LightPlatformCodeInsightTestCase.caretRight(LightPlatformCodeInsightTestCase.getEditor());
    }

    public static void caretRight(@NotNull Editor editor) {
        if (editor == null) {
            LightPlatformCodeInsightTestCase.c(34);
        }
        LightPlatformCodeInsightTestCase.executeAction("EditorRight", editor);
    }

    protected void caretUp() {
        LightPlatformCodeInsightTestCase.caretUp(LightPlatformCodeInsightTestCase.getEditor());
    }

    public static void caretUp(@NotNull Editor editor) {
        if (editor == null) {
            LightPlatformCodeInsightTestCase.c(35);
        }
        LightPlatformCodeInsightTestCase.executeAction("EditorUp", editor);
    }

    protected void deleteLine() {
        LightPlatformCodeInsightTestCase.deleteLine(LightPlatformCodeInsightTestCase.getEditor(), LightPlatformCodeInsightTestCase.getProject());
    }

    public static void deleteLine(@NotNull Editor editor, Project project2) {
        if (editor == null) {
            LightPlatformCodeInsightTestCase.c(36);
        }
        LightPlatformCodeInsightTestCase.executeAction("EditorDeleteLine", editor, project2);
    }

    protected void type(@NonNls @NotNull String string) {
        if (string == null) {
            LightPlatformCodeInsightTestCase.c(37);
        }
        for (char c2 : string.toCharArray()) {
            this.type(c2);
        }
    }

    protected void type(char c2) {
        LightPlatformCodeInsightTestCase.type(c2, LightPlatformCodeInsightTestCase.getEditor(), LightPlatformCodeInsightTestCase.getProject());
    }

    public static void type(char c2, @NotNull Editor editor, Project project2) {
        if (editor == null) {
            LightPlatformCodeInsightTestCase.c(38);
        }
        if (c2 == '\n') {
            LightPlatformCodeInsightTestCase.executeAction("EditorEnter", editor, project2);
        } else {
            EditorActionManager editorActionManager = EditorActionManager.getInstance();
            DataContext dataContext = DataManager.getInstance().getDataContext();
            TypedAction typedAction = editorActionManager.getTypedAction();
            typedAction.actionPerformed(editor, c2, dataContext);
        }
    }

    protected void backspace() {
        LightPlatformCodeInsightTestCase.backspace(LightPlatformCodeInsightTestCase.getEditor(), LightPlatformCodeInsightTestCase.getProject());
    }

    public static void backspace(@NotNull Editor editor, Project project2) {
        if (editor == null) {
            LightPlatformCodeInsightTestCase.c(39);
        }
        LightPlatformCodeInsightTestCase.executeAction("EditorBackSpace", editor, project2);
    }

    protected void ctrlShiftF7() {
        HighlightUsagesHandler.invoke((Project)LightPlatformCodeInsightTestCase.getProject(), (Editor)LightPlatformCodeInsightTestCase.getEditor(), (PsiFile)LightPlatformCodeInsightTestCase.getFile());
    }

    protected void ctrlW() {
        LightPlatformCodeInsightTestCase.ctrlW(LightPlatformCodeInsightTestCase.getEditor(), LightPlatformCodeInsightTestCase.getProject());
    }

    public static void ctrlW(@NotNull Editor editor, Project project2) {
        if (editor == null) {
            LightPlatformCodeInsightTestCase.c(40);
        }
        LightPlatformCodeInsightTestCase.executeAction("EditorSelectWord", editor, project2);
    }

    public void ctrlD() {
        LightPlatformCodeInsightTestCase.ctrlD(LightPlatformCodeInsightTestCase.getEditor(), LightPlatformCodeInsightTestCase.getProject());
    }

    public static void ctrlD(@NotNull Editor editor, Project project2) {
        if (editor == null) {
            LightPlatformCodeInsightTestCase.c(41);
        }
        LightPlatformCodeInsightTestCase.executeAction("EditorDuplicate", editor, project2);
    }

    protected void delete() {
        LightPlatformCodeInsightTestCase.delete(LightPlatformCodeInsightTestCase.getEditor(), LightPlatformCodeInsightTestCase.getProject());
    }

    public static void delete(@NotNull Editor editor, Project project2) {
        if (editor == null) {
            LightPlatformCodeInsightTestCase.c(42);
        }
        LightPlatformCodeInsightTestCase.executeAction("EditorDelete", editor, project2);
    }

    protected static void home() {
        LightPlatformCodeInsightTestCase.executeAction("EditorLineStart");
    }

    protected static void end() {
        LightPlatformCodeInsightTestCase.executeAction("EditorLineEnd");
    }

    protected static void homeWithSelection() {
        LightPlatformCodeInsightTestCase.executeAction("EditorLineStartWithSelection");
    }

    protected static void endWithSelection() {
        LightPlatformCodeInsightTestCase.executeAction("EditorLineEndWithSelection");
    }

    protected static void copy() {
        LightPlatformCodeInsightTestCase.executeAction("EditorCopy");
    }

    protected static void paste() {
        LightPlatformCodeInsightTestCase.executeAction("EditorPaste");
    }

    protected static void moveCaretToPreviousWordWithSelection() {
        LightPlatformCodeInsightTestCase.executeAction("EditorPreviousWordWithSelection");
    }

    protected static void moveCaretToNextWordWithSelection() {
        LightPlatformCodeInsightTestCase.executeAction("EditorNextWordWithSelection");
    }

    protected static void previousWord() {
        LightPlatformCodeInsightTestCase.executeAction("EditorPreviousWord");
    }

    protected static void nextWord() {
        LightPlatformCodeInsightTestCase.executeAction("EditorNextWord");
    }

    protected static void cutLineBackward() {
        LightPlatformCodeInsightTestCase.executeAction("EditorCutLineBackward");
    }

    protected static void cutToLineEnd() {
        LightPlatformCodeInsightTestCase.executeAction("EditorCutLineEnd");
    }

    protected static void deleteToLineStart() {
        LightPlatformCodeInsightTestCase.executeAction("EditorDeleteToLineStart");
    }

    protected static void deleteToLineEnd() {
        LightPlatformCodeInsightTestCase.executeAction("EditorDeleteToLineEnd");
    }

    protected static void killToWordStart() {
        LightPlatformCodeInsightTestCase.executeAction("EditorKillToWordStart");
    }

    protected static void killToWordEnd() {
        LightPlatformCodeInsightTestCase.executeAction("EditorKillToWordEnd");
    }

    protected static void killRegion() {
        LightPlatformCodeInsightTestCase.executeAction("EditorKillRegion");
    }

    protected static void killRingSave() {
        LightPlatformCodeInsightTestCase.executeAction("EditorKillRingSave");
    }

    protected static void unindent() {
        LightPlatformCodeInsightTestCase.executeAction("EditorUnindentSelection");
    }

    protected static void selectLine() {
        LightPlatformCodeInsightTestCase.executeAction("EditorSelectLine");
    }

    protected static void left() {
        LightPlatformCodeInsightTestCase.executeAction("EditorLeft");
    }

    protected static void right() {
        LightPlatformCodeInsightTestCase.executeAction("EditorRight");
    }

    protected static void leftWithSelection() {
        LightPlatformCodeInsightTestCase.executeAction("EditorLeftWithSelection");
    }

    protected static void rightWithSelection() {
        LightPlatformCodeInsightTestCase.executeAction("EditorRightWithSelection");
    }

    protected static void up() {
        LightPlatformCodeInsightTestCase.executeAction("EditorUp");
    }

    protected static void down() {
        LightPlatformCodeInsightTestCase.executeAction("EditorDown");
    }

    protected static void lineComment() {
        LightPlatformCodeInsightTestCase.executeAction("CommentByLineComment");
    }

    protected static void executeAction(@NonNls @NotNull String string) {
        if (string == null) {
            LightPlatformCodeInsightTestCase.c(43);
        }
        LightPlatformCodeInsightTestCase.executeAction(string, LightPlatformCodeInsightTestCase.getEditor());
    }

    protected static void executeAction(@NonNls @NotNull String string, @NotNull Editor editor) {
        if (string == null) {
            LightPlatformCodeInsightTestCase.c(44);
        }
        if (editor == null) {
            LightPlatformCodeInsightTestCase.c(45);
        }
        LightPlatformCodeInsightTestCase.executeAction(string, editor, LightPlatformCodeInsightTestCase.getProject());
    }

    public static void executeAction(@NonNls @NotNull String string, @NotNull Editor editor, Project project2) {
        if (string == null) {
            LightPlatformCodeInsightTestCase.c(46);
        }
        if (editor == null) {
            LightPlatformCodeInsightTestCase.c(47);
        }
        CommandProcessor.getInstance().executeCommand(project2, () -> {
            if (editor == null) {
                LightPlatformCodeInsightTestCase.c(52);
            }
            if (string == null) {
                LightPlatformCodeInsightTestCase.c(53);
            }
            EditorTestUtil.executeAction(editor, string);
        }, "", null, editor.getDocument());
    }

    @NotNull
    protected static DataContext getCurrentEditorDataContext() {
        DataContext dataContext = DataManager.getInstance().getDataContext();
        DataContext dataContext2 = string -> {
            if (CommonDataKeys.EDITOR.is(string)) {
                return LightPlatformCodeInsightTestCase.getEditor();
            }
            if (CommonDataKeys.PROJECT.is(string)) {
                return LightPlatformCodeInsightTestCase.getProject();
            }
            if (CommonDataKeys.PSI_FILE.is(string)) {
                return LightPlatformCodeInsightTestCase.getFile();
            }
            if (CommonDataKeys.PSI_ELEMENT.is(string)) {
                PsiFile psiFile = LightPlatformCodeInsightTestCase.getFile();
                if (psiFile == null) {
                    return null;
                }
                Editor editor = LightPlatformCodeInsightTestCase.getEditor();
                if (editor == null) {
                    return null;
                }
                return psiFile.findElementAt(editor.getCaretModel().getOffset());
            }
            return dataContext.getData(string);
        };
        if (dataContext2 == null) {
            LightPlatformCodeInsightTestCase.c(48);
        }
        return dataContext2;
    }

    @Parameterized.Parameters(name="{0}")
    public static List<Object[]> params() throws Throwable {
        return Collections.emptyList();
    }

    @Parameterized.Parameters(name="{0}")
    public static List<Object[]> params(@NotNull Class<?> clazz) throws Throwable {
        Object object;
        File[] fileArray;
        LightPlatformCodeInsightTestCase lightPlatformCodeInsightTestCase;
        if (clazz == null) {
            LightPlatformCodeInsightTestCase.c(49);
        }
        if (!((lightPlatformCodeInsightTestCase = (LightPlatformCodeInsightTestCase)((Object)clazz.newInstance())) instanceof FileBasedTestCaseHelper)) {
            LightPlatformCodeInsightTestCase.fail((String)"Parameterized test should implement FileBasedTestCaseHelper");
        }
        try {
            PathManagerEx.replaceLookupStrategy(clazz, Parameterized.class);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        FileBasedTestCaseHelper fileBasedTestCaseHelper = (FileBasedTestCaseHelper)((Object)lightPlatformCodeInsightTestCase);
        String string = lightPlatformCodeInsightTestCase.getTestDataPath();
        File file = null;
        if (fileBasedTestCaseHelper instanceof FileBasedTestCaseHelperEx) {
            file = new File(string, ((FileBasedTestCaseHelperEx)fileBasedTestCaseHelper).getRelativeBasePath());
        } else {
            fileArray = clazz.getAnnotation(TestDataPath.class);
            if (fileArray == null) {
                LightPlatformCodeInsightTestCase.fail((String)"TestCase should implement com.intellij.testFramework.FileBasedTestCaseHelperEx or be annotated with com.intellij.testFramework.TestDataPath");
            } else {
                object = StringUtil.trimStart((String)StringUtil.trimStart((String)fileArray.value(), (String)"$CONTENT_ROOT"), (String)"$PROJECT_ROOT");
                String string2 = new File(string).getName();
                int n2 = ((String)object).indexOf(string2);
                string = string.replace(File.separatorChar, '/') + (String)(n2 > 0 ? ((String)object).substring(n2 + string2.length()) : object);
                file = new File(string);
            }
        }
        fileArray = file.listFiles();
        if (fileArray == null) {
            LightPlatformCodeInsightTestCase.fail((String)("Test files not found in " + file.getPath()));
        }
        object = new ArrayList();
        for (File file2 : fileArray) {
            String string3 = fileBasedTestCaseHelper.getFileSuffix(file2.getName());
            if (string3 == null) continue;
            object.add(new Object[]{string3, string});
        }
        return object;
    }

    public String getName() {
        if (this.myFileSuffix != null) {
            return "test" + this.myFileSuffix;
        }
        return super.getName();
    }

    @Before
    public void before() throws Throwable {
        Throwable[] throwableArray = new Throwable[1];
        this.invokeTestRunnable(() -> {
            try {
                this.setUp();
            }
            catch (Throwable throwable) {
                throwableArray[0] = throwable;
            }
        });
        if (throwableArray[0] != null) {
            throw throwableArray[0];
        }
    }

    @After
    public void after() throws Throwable {
        Throwable[] throwableArray = new Throwable[1];
        this.invokeTestRunnable(() -> {
            try {
                this.tearDown();
            }
            catch (Throwable throwable) {
                throwableArray[0] = throwable;
            }
        });
        if (throwableArray[0] != null) {
            throw throwableArray[0];
        }
    }

    protected void runSingleTest(@NotNull Runnable runnable) throws Throwable {
        if (runnable == null) {
            LightPlatformCodeInsightTestCase.c(50);
        }
        Throwable[] throwableArray = new Throwable[1];
        this.invokeTestRunnable(() -> {
            if (runnable == null) {
                LightPlatformCodeInsightTestCase.c(51);
            }
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                throwableArray[0] = throwable;
            }
        });
        if (throwableArray[0] != null) {
            throw throwableArray[0];
        }
    }

    private static /* synthetic */ void c(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 20: 
            case 23: 
            case 32: 
            case 33: 
            case 48: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 20: 
            case 23: 
            case 32: 
            case 33: 
            case 48: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 20: 
            case 23: 
            case 32: 
            case 33: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/LightPlatformCodeInsightTestCase";
                break;
            }
            case 5: 
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 16: 
            case 19: 
            case 22: 
            case 30: 
            case 54: 
            case 58: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileText";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 18: 
            case 21: 
            case 57: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedFilePath";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedFileText";
                break;
            }
            case 29: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 45: 
            case 47: 
            case 52: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "engineMessage";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 43: 
            case 44: 
            case 46: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 50: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testRunnable";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/LightPlatformCodeInsightTestCase";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestDataPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
            case 7: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "configureFromFileText";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "configureFromFileTextWithoutPSI";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "setupFileEditorAndDocument";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createSaveAndOpenFile";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndSaveFile";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentEditorDataContext";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "configureByFile";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 20: 
            case 23: 
            case 32: 
            case 33: 
            case 48: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "configureFromFileText";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "configureFromFileTextWithoutPSI";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setupFileEditorAndDocument";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createSaveAndOpenFile";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createAndSaveFile";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "checkResultByFile";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "checkResultByText";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "checkResultByTextWithoutPSI";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "caretRight";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "caretUp";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "deleteLine";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "type";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "backspace";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "ctrlW";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "ctrlD";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "delete";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "executeAction";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "params";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "runSingleTest";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runSingleTest$11";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "lambda$executeAction$7";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "lambda$checkResultByTextWithoutPSI$6";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "lambda$checkResultByText$5";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createAndSaveFile$2";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createSaveAndOpenFile$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 20: 
            case 23: 
            case 32: 
            case 33: 
            case 48: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

