/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public class SdkLeakTracker {
    @NotNull
    private final Sdk[] a;

    public SdkLeakTracker() {
        ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
        this.a = projectJdkTable == null ? new Sdk[]{} : projectJdkTable.getAllJdks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForJdkTableLeaks() {
        Sdk[] sdkArray;
        ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
        if (projectJdkTable != null && (sdkArray = projectJdkTable.getAllJdks()).length != 0) {
            THashSet tHashSet = new THashSet(Arrays.asList(sdkArray));
            THashSet tHashSet2 = new THashSet(Arrays.asList(this.a));
            tHashSet.removeAll((Collection<?>)tHashSet2);
            try {
                if (!tHashSet.isEmpty()) {
                    Assert.fail((String)("Leaked SDKs: " + tHashSet));
                }
            }
            finally {
                for (Sdk sdk : tHashSet) {
                    WriteAction.run(() -> projectJdkTable.removeJdk(sdk));
                }
            }
        }
    }
}

