/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.testFramework.UtilKt;
import com.intellij.util.PathUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public class VfsTestUtil {
    public static final Key<String> TEST_DATA_FILE_PATH = Key.create((String)"TEST_DATA_FILE_PATH");

    private VfsTestUtil() {
    }

    @NotNull
    public static VirtualFile createFile(@NotNull VirtualFile virtualFile, @NotNull String string) {
        if (virtualFile == null) {
            VfsTestUtil.a(0);
        }
        if (string == null) {
            VfsTestUtil.a(1);
        }
        VirtualFile virtualFile2 = VfsTestUtil.createFile(virtualFile, string, "");
        if (virtualFile2 == null) {
            VfsTestUtil.a(2);
        }
        return virtualFile2;
    }

    @NotNull
    public static VirtualFile createFile(@NotNull VirtualFile virtualFile, @NotNull String string, @NotNull String string2) {
        if (virtualFile == null) {
            VfsTestUtil.a(3);
        }
        if (string == null) {
            VfsTestUtil.a(4);
        }
        if (string2 == null) {
            VfsTestUtil.a(5);
        }
        VirtualFile virtualFile2 = VfsTestUtil.a(virtualFile, string, string2, false);
        if (virtualFile2 == null) {
            VfsTestUtil.a(6);
        }
        return virtualFile2;
    }

    @NotNull
    public static VirtualFile createDir(@NotNull VirtualFile virtualFile, @NotNull String string) {
        if (virtualFile == null) {
            VfsTestUtil.a(7);
        }
        if (string == null) {
            VfsTestUtil.a(8);
        }
        VirtualFile virtualFile2 = VfsTestUtil.a(virtualFile, string, "", true);
        if (virtualFile2 == null) {
            VfsTestUtil.a(9);
        }
        return virtualFile2;
    }

    @NotNull
    private static VirtualFile a(VirtualFile virtualFile, String string, String string2, boolean bl2) {
        VirtualFile virtualFile2;
        try {
            virtualFile2 = (VirtualFile)WriteAction.compute(() -> {
                String string32;
                VirtualFile virtualFile2 = virtualFile;
                for (String string32 : StringUtil.tokenize((String)PathUtil.getParentPath((String)string), (String)"/")) {
                    VirtualFile virtualFile3 = virtualFile2.findChild(string32);
                    if (virtualFile3 == null || !virtualFile3.isValid()) {
                        virtualFile3 = virtualFile2.createChildDirectory(VfsTestUtil.class, string32);
                    }
                    virtualFile2 = virtualFile3;
                }
                virtualFile2.getChildren();
                String string4 = PathUtil.getFileName((String)string);
                if (bl2) {
                    string32 = virtualFile2.createChildDirectory(VfsTestUtil.class, string4);
                } else {
                    string32 = virtualFile2.findChild(string4);
                    if (string32 == null) {
                        string32 = virtualFile2.createChildData(VfsTestUtil.class, string4);
                    }
                    VfsUtil.saveText((VirtualFile)string32, (String)string2);
                    FileDocumentManager.getInstance().reloadFiles(new VirtualFile[]{string32});
                }
                return string32;
            });
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        if (virtualFile2 == null) {
            VfsTestUtil.a(10);
        }
        return virtualFile2;
    }

    public static void deleteFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            VfsTestUtil.a(11);
        }
        UtilKt.deleteFile(virtualFile);
    }

    public static void clearContent(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            VfsTestUtil.a(12);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (virtualFile == null) {
                VfsTestUtil.a(23);
            }
            try {
                VfsUtil.saveText((VirtualFile)virtualFile, (String)"");
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        });
    }

    public static void overwriteTestData(@NotNull String string, @NotNull String string2) {
        if (string == null) {
            VfsTestUtil.a(13);
        }
        if (string2 == null) {
            VfsTestUtil.a(14);
        }
        try {
            FileUtil.writeToFile((File)new File(string), (String)string2);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    @NotNull
    public static VirtualFile findFileByCaseSensitivePath(@NotNull String string) {
        if (string == null) {
            VfsTestUtil.a(15);
        }
        String string2 = FileUtil.toSystemIndependentName((String)string);
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(string2);
        Assert.assertNotNull((String)("file " + string + " not found"), (Object)virtualFile);
        String string3 = virtualFile.getPath();
        if (!SystemInfo.isFileSystemCaseSensitive && !string2.equals(string3) && string2.equalsIgnoreCase(string3)) {
            Assert.fail((String)("Please correct case-sensitivity of path to prevent test failure on case-sensitive file systems:\n     path " + string2 + "\nreal path " + string3));
        }
        VirtualFile virtualFile2 = virtualFile;
        if (virtualFile2 == null) {
            VfsTestUtil.a(16);
        }
        return virtualFile2;
    }

    public static void assertFilePathEndsWithCaseSensitivePath(@NotNull VirtualFile virtualFile, @NotNull String string) {
        if (virtualFile == null) {
            VfsTestUtil.a(17);
        }
        if (string == null) {
            VfsTestUtil.a(18);
        }
        String string2 = FileUtil.toSystemIndependentName((String)string);
        String string3 = virtualFile.getPath();
        if (!SystemInfo.isFileSystemCaseSensitive && !string3.endsWith(string2) && StringUtil.endsWithIgnoreCase((String)string3, (String)string2)) {
            String string4 = string3.substring(string3.length() - string2.length());
            Assert.fail((String)("Please correct case-sensitivity of path to prevent test failure on case-sensitive file systems:\n     path " + string + "\nreal path " + string4));
        }
    }

    @NotNull
    public static List<VFileEvent> getEvents(@NotNull Runnable runnable) {
        if (runnable == null) {
            VfsTestUtil.a(19);
        }
        final ArrayList<VFileEvent> arrayList = new ArrayList<VFileEvent>();
        MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect();
        messageBusConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> list2) {
                if (list2 == null) {
                    1.a(0);
                }
                arrayList.addAll(list2);
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/testFramework/VfsTestUtil$1", "after"));
            }
        });
        try {
            runnable.run();
        }
        finally {
            messageBusConnection.disconnect();
        }
        ArrayList<VFileEvent> arrayList2 = arrayList;
        if (arrayList2 == null) {
            VfsTestUtil.a(20);
        }
        return arrayList2;
    }

    @NotNull
    public static List<String> print(@NotNull List<? extends VFileEvent> list2) {
        if (list2 == null) {
            VfsTestUtil.a(21);
        }
        List<String> list3 = list2.stream().map(VfsTestUtil::a).collect(Collectors.toList());
        if (list3 == null) {
            VfsTestUtil.a(22);
        }
        return list3;
    }

    private static String a(VFileEvent vFileEvent) {
        int n2 = 63;
        if (vFileEvent instanceof VFileCreateEvent) {
            n2 = 67;
        } else if (vFileEvent instanceof VFileDeleteEvent) {
            n2 = 68;
        } else if (vFileEvent instanceof VFileContentChangeEvent) {
            n2 = 85;
        } else if (vFileEvent instanceof VFilePropertyChangeEvent) {
            n2 = 80;
        }
        return (char)n2 + " : " + vFileEvent.getPath();
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 10: 
            case 16: 
            case 20: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 10: 
            case 16: 
            case 20: 
            case 22: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 10: 
            case 16: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/VfsTestUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: 
            case 12: 
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actual";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "absolutePath";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffixPath";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/VfsTestUtil";
                break;
            }
            case 2: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createFile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createDir";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileOrDir";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findFileByCaseSensitivePath";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvents";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "print";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 10: 
            case 16: 
            case 20: 
            case 22: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createDir";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "deleteFile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "clearContent";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "overwriteTestData";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findFileByCaseSensitivePath";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "assertFilePathEndsWithCaseSensitivePath";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getEvents";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$clearContent$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 10: 
            case 16: 
            case 20: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

