/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.highlighting.actions.HighlightUsagesAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.IntentionListStep;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionToolProvider;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerListener;
import com.intellij.find.FindManager;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.newStructureView.StructureViewComponent;
import com.intellij.ide.util.gotoByName.ChooseByNameBase;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.GotoClassModel2;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.internal.DumpLookupElementWeights;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageStructureViewBuilder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.mock.MockProgressIndicator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.SchemeMetaInfo;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.readOnlyHandler.ReadonlyStatusHandlerImpl;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.impl.VirtualFilePointerTracker;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.impl.cache.impl.todo.TodoIndex;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.StubTextInconsistencyException;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesProcessor;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.rename.RenameHandlerRegistry;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.testFramework.EditorTestUtil;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.ExpectedHighlightingData;
import com.intellij.testFramework.FileTreeAccessFilter;
import com.intellij.testFramework.HighlightTestInfo;
import com.intellij.testFramework.InspectionTestUtil;
import com.intellij.testFramework.InspectionsKt;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.PlatformTestCase;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.PsiTestUtil;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.TestActionEvent;
import com.intellij.testFramework.TestRunnerUtil;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.testFramework.fixtures.CodeInsightTestUtil;
import com.intellij.testFramework.fixtures.HeavyIdeaTestFixture;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.impl.BaseFixture;
import com.intellij.testFramework.fixtures.impl.GlobalInspectionContextForTests;
import com.intellij.testFramework.fixtures.impl.LightTempDirTestFixtureImpl;
import com.intellij.testFramework.fixtures.impl.TempDirTestFixtureImpl;
import com.intellij.testFramework.utils.inlays.CaretAndInlaysInfo;
import com.intellij.testFramework.utils.inlays.InlayHintsChecker;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import com.intellij.ui.breadcrumbs.BreadcrumbsUtil;
import com.intellij.ui.components.breadcrumbs.Crumb;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.io.ReadOnlyAttributeUtil;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JList;
import junit.framework.ComparisonFailure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class CodeInsightTestFixtureImpl
extends BaseFixture
implements CodeInsightTestFixture {
    private static final Function<IntentionAction, String> d = intentionAction -> '\"' + intentionAction.getText() + '\"';
    private static final String j = "rainbow";
    private static final String r = "fold";
    private final IdeaProjectTestFixture m;
    private final TempDirTestFixture n;
    private PsiManagerImpl o;
    private VirtualFile q;
    private Editor k;
    private String i;
    private boolean f;
    private VirtualFileFilter e;
    private ChooseByNameBase l;
    private boolean h;
    private boolean g;
    private VirtualFilePointerTracker p;

    public CodeInsightTestFixtureImpl(@NotNull IdeaProjectTestFixture ideaProjectTestFixture, @NotNull TempDirTestFixture tempDirTestFixture) {
        if (ideaProjectTestFixture == null) {
            CodeInsightTestFixtureImpl.d(0);
        }
        if (tempDirTestFixture == null) {
            CodeInsightTestFixtureImpl.d(1);
        }
        this.e = new FileTreeAccessFilter();
        this.g = true;
        this.m = ideaProjectTestFixture;
        this.n = tempDirTestFixture;
    }

    private static void a(GutterMark gutterMark, int n3, @NotNull SortedMap<Integer, List<GutterMark>> sortedMap) {
        if (sortedMap == null) {
            CodeInsightTestFixtureImpl.d(2);
        }
        if (gutterMark == null) {
            return;
        }
        List list2 = sortedMap.computeIfAbsent(n3, n2 -> new SmartList());
        list2.add(gutterMark);
    }

    private static void a(@NotNull List<HighlightInfo> list2) {
        if (list2 == null) {
            CodeInsightTestFixtureImpl.d(3);
        }
        Collections.sort(list2, (highlightInfo, highlightInfo2) -> {
            int n2 = highlightInfo2.startOffset - highlightInfo.startOffset;
            return n2 != 0 ? n2 : highlightInfo.getSeverity().myVal - highlightInfo2.getSeverity().myVal;
        });
        HighlightInfo highlightInfo3 = null;
        Iterator<HighlightInfo> iterator = list2.iterator();
        while (iterator.hasNext()) {
            HighlightInfo highlightInfo4 = iterator.next();
            if (highlightInfo3 != null && highlightInfo4.getSeverity() == HighlightInfoType.SYMBOL_TYPE_SEVERITY && highlightInfo4.getDescription() == null && highlightInfo4.startOffset == highlightInfo3.startOffset && highlightInfo4.endOffset == highlightInfo3.endOffset) {
                iterator.remove();
            }
            highlightInfo3 = highlightInfo4.type == HighlightInfoType.INJECTED_LANGUAGE_FRAGMENT ? highlightInfo4 : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static List<HighlightInfo> instantiateAndRun(@NotNull PsiFile psiFile, @NotNull Editor editor, @NotNull int[] nArray, boolean bl2) {
        if (psiFile == null) {
            CodeInsightTestFixtureImpl.d(4);
        }
        if (editor == null) {
            CodeInsightTestFixtureImpl.d(5);
        }
        if (nArray == null) {
            CodeInsightTestFixtureImpl.d(6);
        }
        Project project2 = psiFile.getProject();
        CodeInsightTestFixtureImpl.ensureIndexesUpToDate(project2);
        DaemonCodeAnalyzerImpl daemonCodeAnalyzerImpl = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)project2);
        TextEditor textEditor = TextEditorProvider.getInstance().getTextEditor(editor);
        DaemonCodeAnalyzerSettings daemonCodeAnalyzerSettings = DaemonCodeAnalyzerSettings.getInstance();
        ProcessCanceledException processCanceledException = null;
        int n2 = 1000;
        for (int i2 = 0; i2 < n2; ++i2) {
            Serializable serializable;
            Serializable serializable2;
            int n3 = daemonCodeAnalyzerSettings.AUTOREPARSE_DELAY;
            try {
                daemonCodeAnalyzerSettings.AUTOREPARSE_DELAY = 0;
                ArrayList arrayList = new ArrayList();
                EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> {
                    if (psiFile == null) {
                        CodeInsightTestFixtureImpl.d(205);
                    }
                    if (editor == null) {
                        CodeInsightTestFixtureImpl.d(206);
                    }
                    if (nArray == null) {
                        CodeInsightTestFixtureImpl.d(207);
                    }
                    arrayList.addAll(daemonCodeAnalyzerImpl.runPasses(psiFile, editor.getDocument(), Collections.singletonList(textEditor), nArray, bl2, null));
                }));
                arrayList.addAll(DaemonCodeAnalyzerEx.getInstanceEx((Project)project2).getFileLevelHighlights(project2, psiFile));
                serializable2 = arrayList;
                serializable = serializable2;
            }
            catch (ProcessCanceledException processCanceledException2) {
                serializable2 = processCanceledException2.getCause();
                if (serializable2 != null && serializable2.getClass() != Throwable.class) {
                    throw processCanceledException2;
                }
                PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
                UIUtil.dispatchAllInvocationEvents();
                processCanceledException = processCanceledException2;
                continue;
            }
            finally {
                daemonCodeAnalyzerSettings.AUTOREPARSE_DELAY = n3;
            }
            if (serializable == null) {
                CodeInsightTestFixtureImpl.d(7);
            }
            return serializable;
        }
        throw new AssertionError("Unable to highlight after " + n2 + " retries", processCanceledException);
    }

    public static void ensureIndexesUpToDate(@NotNull Project project2) {
        if (project2 == null) {
            CodeInsightTestFixtureImpl.d(8);
        }
        if (!DumbService.isDumb((Project)project2)) {
            ReadAction.run(() -> {
                if (project2 == null) {
                    CodeInsightTestFixtureImpl.d(204);
                }
                FileBasedIndex.getInstance().ensureUpToDate(StubUpdatingIndex.INDEX_ID, project2, null);
                FileBasedIndex.getInstance().ensureUpToDate(TodoIndex.NAME, project2, null);
            });
        }
    }

    @NotNull
    public static List<IntentionAction> getAvailableIntentions(@NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (editor == null) {
            CodeInsightTestFixtureImpl.d(9);
        }
        if (psiFile == null) {
            CodeInsightTestFixtureImpl.d(10);
        }
        List list2 = (List)ReadAction.compute(() -> {
            if (editor == null) {
                CodeInsightTestFixtureImpl.d(202);
            }
            if (psiFile == null) {
                CodeInsightTestFixtureImpl.d(203);
            }
            return CodeInsightTestFixtureImpl.a(editor, psiFile);
        });
        if (list2 == null) {
            CodeInsightTestFixtureImpl.d(11);
        }
        return list2;
    }

    @NotNull
    private static List<IntentionAction> a(@NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (editor == null) {
            CodeInsightTestFixtureImpl.d(12);
        }
        if (psiFile == null) {
            CodeInsightTestFixtureImpl.d(13);
        }
        ShowIntentionsPass.IntentionsInfo intentionsInfo = new ShowIntentionsPass.IntentionsInfo();
        ShowIntentionsPass.getActionsToShow((Editor)editor, (PsiFile)psiFile, (ShowIntentionsPass.IntentionsInfo)intentionsInfo, (int)-1);
        ArrayList<IntentionAction> arrayList = new ArrayList<IntentionAction>();
        IntentionListStep intentionListStep = new IntentionListStep(null, intentionsInfo, editor, psiFile, psiFile.getProject());
        for (Map.Entry object2 : intentionListStep.getActionsWithSubActions().entrySet()) {
            arrayList.add((IntentionAction)object2.getKey());
            arrayList.addAll((Collection)object2.getValue());
        }
        List list2 = DaemonCodeAnalyzerEx.getInstanceEx((Project)psiFile.getProject()).getFileLevelHighlights(psiFile.getProject(), psiFile);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            HighlightInfo highlightInfo = (HighlightInfo)iterator.next();
            for (Pair pair2 : highlightInfo.quickFixActionRanges) {
                HighlightInfo.IntentionActionDescriptor intentionActionDescriptor = (HighlightInfo.IntentionActionDescriptor)pair2.first;
                if (!intentionActionDescriptor.getAction().isAvailable(psiFile.getProject(), editor, psiFile)) continue;
                arrayList.add(intentionActionDescriptor.getAction());
                List list3 = intentionActionDescriptor.getOptions((PsiElement)psiFile, editor);
                if (list3 == null) continue;
                for (IntentionAction intentionAction : list3) {
                    if (!intentionAction.isAvailable(psiFile.getProject(), editor, psiFile)) continue;
                    arrayList.add(intentionAction);
                }
            }
        }
        ArrayList<IntentionAction> arrayList2 = arrayList;
        if (arrayList2 == null) {
            CodeInsightTestFixtureImpl.d(14);
        }
        return arrayList2;
    }

    @Override
    @NotNull
    public String getTempDirPath() {
        String string = this.n.getTempDirPath();
        if (string == null) {
            CodeInsightTestFixtureImpl.d(15);
        }
        return string;
    }

    @Override
    @NotNull
    public TempDirTestFixture getTempDirFixture() {
        TempDirTestFixture tempDirTestFixture = this.n;
        if (tempDirTestFixture == null) {
            CodeInsightTestFixtureImpl.d(16);
        }
        return tempDirTestFixture;
    }

    @Override
    @NotNull
    public VirtualFile copyFileToProject(@NotNull String string) {
        if (string == null) {
            CodeInsightTestFixtureImpl.d(17);
        }
        VirtualFile virtualFile = this.copyFileToProject(string, string);
        if (virtualFile == null) {
            CodeInsightTestFixtureImpl.d(18);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile copyFileToProject(@NotNull String string, @NotNull String string2) {
        if (string == null) {
            CodeInsightTestFixtureImpl.d(19);
        }
        if (string2 == null) {
            CodeInsightTestFixtureImpl.d(20);
        }
        String string3 = this.getTestDataPath();
        File file = FileUtil.findFirstThatExist((String[])new String[]{string3 + '/' + string, string});
        VirtualFile virtualFile = this.n.getFile(string2);
        if (file == null && virtualFile != null && string2.equals(string)) {
            VirtualFile virtualFile2 = virtualFile;
            if (virtualFile2 == null) {
                CodeInsightTestFixtureImpl.d(21);
            }
            return virtualFile2;
        }
        CodeInsightTestFixtureImpl.a(file);
        Assert.assertNotNull((String)("Cannot find source file: " + string + "; test data path: " + string3), (Object)file);
        Assert.assertTrue((String)("Not a file: " + file), (boolean)file.isFile());
        if (virtualFile == null) {
            virtualFile = this.n.createFile(string2);
            VfsTestUtil.assertFilePathEndsWithCaseSensitivePath(virtualFile, string);
            virtualFile.putUserData(VfsTestUtil.TEST_DATA_FILE_PATH, (Object)file.getAbsolutePath());
        }
        CodeInsightTestFixtureImpl.a(file, virtualFile);
        VirtualFile virtualFile3 = virtualFile;
        if (virtualFile3 == null) {
            CodeInsightTestFixtureImpl.d(22);
        }
        return virtualFile3;
    }

    private static void a(@Nullable File file) {
        if (file == null) {
            return;
        }
        try {
            String string = file.getName();
            File file2 = file.getCanonicalFile();
            String string2 = file2.getName();
            if (string.equalsIgnoreCase(string2) && !string.equals(string2)) {
                Assert.fail((String)("Please correct case-sensitivity of path to prevent test failure on case-sensitive file systems:\n     path " + file.getPath() + "\nreal path " + file2.getPath()));
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    private static void a(final File file, final VirtualFile virtualFile) {
        new WriteAction(){

            protected void run(@NotNull Result result2) throws IOException {
                if (result2 == null) {
                    1.a(0);
                }
                virtualFile.setBinaryContent(FileUtil.loadFileBytes((File)file));
                FileDocumentManager.getInstance().reloadFiles(new VirtualFile[]{virtualFile});
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$1", "run"));
            }
        }.execute();
    }

    @Override
    @NotNull
    public VirtualFile copyDirectoryToProject(@NotNull String string, @NotNull String string2) {
        if (string == null) {
            CodeInsightTestFixtureImpl.d(23);
        }
        if (string2 == null) {
            CodeInsightTestFixtureImpl.d(24);
        }
        String string3 = this.getTestDataPath();
        File file = new File(string3 + "/" + string);
        if (this.n instanceof LightTempDirTestFixtureImpl) {
            VirtualFile virtualFile = this.n.copyAll(file.getPath(), string2);
            if (virtualFile == null) {
                CodeInsightTestFixtureImpl.d(25);
            }
            return virtualFile;
        }
        File file2 = new File(this.getTempDirPath() + "/" + string2);
        try {
            FileUtil.copyDir((File)file, (File)file2);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2);
        Assert.assertNotNull((Object)virtualFile);
        virtualFile.refresh(false, true);
        VirtualFile virtualFile2 = virtualFile;
        if (virtualFile2 == null) {
            CodeInsightTestFixtureImpl.d(26);
        }
        return virtualFile2;
    }

    @Override
    public void enableInspections(InspectionProfileEntry ... inspectionProfileEntryArray) {
        if (inspectionProfileEntryArray == null) {
            CodeInsightTestFixtureImpl.d(27);
        }
        this.assertInitialized();
        InspectionsKt.enableInspectionTools(this.getProject(), this.m.getTestRootDisposable(), inspectionProfileEntryArray);
    }

    @Override
    @SafeVarargs
    public final void enableInspections(Class<? extends LocalInspectionTool> ... classArray) {
        if (classArray == null) {
            CodeInsightTestFixtureImpl.d(28);
        }
        this.enableInspections(Arrays.asList(classArray));
    }

    @Override
    public void enableInspections(@NotNull Collection<Class<? extends LocalInspectionTool>> collection) {
        if (collection == null) {
            CodeInsightTestFixtureImpl.d(29);
        }
        List<InspectionProfileEntry> list2 = InspectionTestUtil.instantiateTools(collection);
        this.enableInspections(list2.toArray(new InspectionProfileEntry[0]));
    }

    @Override
    public void disableInspections(InspectionProfileEntry ... inspectionProfileEntryArray) {
        if (inspectionProfileEntryArray == null) {
            CodeInsightTestFixtureImpl.d(30);
        }
        InspectionsKt.disableInspections(this.getProject(), inspectionProfileEntryArray);
    }

    @Override
    public void enableInspections(InspectionToolProvider ... inspectionToolProviderArray) {
        if (inspectionToolProviderArray == null) {
            CodeInsightTestFixtureImpl.d(31);
        }
        List<Class<? extends LocalInspectionTool>> list2 = Stream.of(inspectionToolProviderArray).flatMap(inspectionToolProvider -> Stream.of(inspectionToolProvider.getInspectionClasses())).filter(LocalInspectionTool.class::isAssignableFrom).map(clazz -> {
            Class clazz2 = clazz;
            return clazz2;
        }).collect(Collectors.toList());
        this.enableInspections(list2);
    }

    @Override
    public long testHighlighting(boolean bl2, boolean bl3, boolean bl4, String ... stringArray) {
        if (stringArray == null) {
            CodeInsightTestFixtureImpl.d(32);
        }
        if (stringArray.length > 0) {
            this.a(stringArray);
        }
        return this.a(bl2, bl3, bl4);
    }

    @Override
    public long testHighlightingAllFiles(boolean bl2, boolean bl3, boolean bl4, String ... stringArray) {
        if (stringArray == null) {
            CodeInsightTestFixtureImpl.d(33);
        }
        return this.a(bl2, bl3, bl4, Stream.of(stringArray).map(this::copyFileToProject));
    }

    @Override
    public long testHighlightingAllFiles(boolean bl2, boolean bl3, boolean bl4, VirtualFile ... virtualFileArray) {
        if (virtualFileArray == null) {
            CodeInsightTestFixtureImpl.d(34);
        }
        return this.a(bl2, bl3, bl4, Stream.of(virtualFileArray));
    }

    private long a(boolean bl2, boolean bl3, boolean bl4, Stream<VirtualFile> stream2) {
        List list2 = stream2.map(virtualFile -> {
            PsiFile psiFile = this.o.findFile(virtualFile);
            Assert.assertNotNull((Object)psiFile);
            Document document = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(psiFile);
            Assert.assertNotNull((Object)document);
            ExpectedHighlightingData expectedHighlightingData = new ExpectedHighlightingData(document, bl2, bl4, bl3, psiFile);
            expectedHighlightingData.init();
            return Trinity.create((Object)psiFile, (Object)this.createEditor((VirtualFile)virtualFile), (Object)expectedHighlightingData);
        }).collect(Collectors.toList());
        long l2 = 0L;
        for (Trinity trinity : list2) {
            this.k = (Editor)trinity.second;
            this.q = ((PsiFile)trinity.first).getVirtualFile();
            l2 += this.a((ExpectedHighlightingData)trinity.third);
        }
        return l2;
    }

    @Override
    public long checkHighlighting(boolean bl2, boolean bl3, boolean bl4) {
        return this.checkHighlighting(bl2, bl3, bl4, false);
    }

    @Override
    public long checkHighlighting(boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        return this.a(bl2, bl3, bl4, bl5);
    }

    @Override
    public long checkHighlighting() {
        return this.checkHighlighting(true, false, true);
    }

    @Override
    public long testHighlighting(String ... stringArray) {
        if (stringArray == null) {
            CodeInsightTestFixtureImpl.d(35);
        }
        return this.testHighlighting(true, false, true, stringArray);
    }

    @Override
    public long testHighlighting(boolean bl2, boolean bl3, boolean bl4, @NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            CodeInsightTestFixtureImpl.d(36);
        }
        this.openFileInEditor(virtualFile);
        return this.a(bl2, bl3, bl4);
    }

    @Override
    @NotNull
    public HighlightTestInfo testFile(String ... stringArray) {
        if (stringArray == null) {
            CodeInsightTestFixtureImpl.d(37);
        }
        HighlightTestInfo highlightTestInfo = new HighlightTestInfo(this.m.getTestRootDisposable(), stringArray){

            @Override
            public HighlightTestInfo doTest() {
                CodeInsightTestFixtureImpl.this.configureByFiles(this.filePaths);
                ExpectedHighlightingData expectedHighlightingData = new ExpectedHighlightingData(CodeInsightTestFixtureImpl.this.k.getDocument(), this.checkWarnings, this.checkWeakWarnings, this.checkInfos, CodeInsightTestFixtureImpl.this.getFile());
                if (this.checkSymbolNames) {
                    expectedHighlightingData.checkSymbolNames();
                }
                expectedHighlightingData.init();
                CodeInsightTestFixtureImpl.this.a(expectedHighlightingData);
                return this;
            }
        };
        if (highlightTestInfo == null) {
            CodeInsightTestFixtureImpl.d(38);
        }
        return highlightTestInfo;
    }

    @Override
    public void openFileInEditor(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            CodeInsightTestFixtureImpl.d(39);
        }
        this.q = virtualFile;
        this.k = this.createEditor(virtualFile);
    }

    @Override
    public void testInspection(@NotNull String string, @NotNull InspectionToolWrapper inspectionToolWrapper) {
        if (string == null) {
            CodeInsightTestFixtureImpl.d(40);
        }
        if (inspectionToolWrapper == null) {
            CodeInsightTestFixtureImpl.d(41);
        }
        VirtualFile virtualFile = this.copyDirectoryToProject(new File(string, "src").getPath(), "");
        PsiDirectory psiDirectory = this.getPsiManager().findDirectory(virtualFile);
        Assert.assertNotNull((Object)psiDirectory);
        AnalysisScope analysisScope = new AnalysisScope(psiDirectory);
        analysisScope.invalidate();
        GlobalInspectionContextForTests globalInspectionContextForTests = InspectionsKt.createGlobalContextForTool(analysisScope, this.getProject(), Collections.singletonList(inspectionToolWrapper));
        InspectionTestUtil.runTool(inspectionToolWrapper, analysisScope, globalInspectionContextForTests);
        InspectionTestUtil.compareToolResults((GlobalInspectionContextImpl)globalInspectionContextForTests, inspectionToolWrapper, false, new File(this.getTestDataPath(), string).getPath());
    }

    @Override
    @Nullable
    public PsiReference getReferenceAtCaretPosition(String ... stringArray) {
        if (stringArray == null) {
            CodeInsightTestFixtureImpl.d(42);
        }
        if (stringArray.length > 0) {
            this.a(stringArray);
        }
        return this.getFile().findReferenceAt(this.k.getCaretModel().getOffset());
    }

    @Override
    @NotNull
    public PsiReference getReferenceAtCaretPositionWithAssertion(String ... stringArray) {
        if (stringArray == null) {
            CodeInsightTestFixtureImpl.d(43);
        }
        PsiReference psiReference = this.getReferenceAtCaretPosition(stringArray);
        Assert.assertNotNull((String)("no reference found at " + this.k.getCaretModel().getLogicalPosition()), (Object)psiReference);
        PsiReference psiReference2 = psiReference;
        if (psiReference2 == null) {
            CodeInsightTestFixtureImpl.d(44);
        }
        return psiReference2;
    }

    @Override
    @NotNull
    public List<IntentionAction> getAvailableIntentions(String ... stringArray) {
        if (stringArray == null) {
            CodeInsightTestFixtureImpl.d(45);
        }
        if (stringArray.length > 0) {
            this.a(stringArray);
        }
        List<IntentionAction> list2 = this.getAvailableIntentions();
        if (list2 == null) {
            CodeInsightTestFixtureImpl.d(46);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<IntentionAction> getAllQuickFixes(String ... stringArray) {
        if (stringArray == null) {
            CodeInsightTestFixtureImpl.d(47);
        }
        if (stringArray.length != 0) {
            this.a(stringArray);
        }
        List<HighlightInfo> list2 = this.doHighlighting();
        ArrayList<IntentionAction> arrayList = new ArrayList<IntentionAction>();
        for (HighlightInfo highlightInfo : list2) {
            if (highlightInfo.quickFixActionRanges == null) continue;
            for (Pair pair2 : highlightInfo.quickFixActionRanges) {
                arrayList.add(((HighlightInfo.IntentionActionDescriptor)pair2.getFirst()).getAction());
            }
        }
        ArrayList<IntentionAction> arrayList2 = arrayList;
        if (arrayList2 == null) {
            CodeInsightTestFixtureImpl.d(48);
        }
        return arrayList2;
    }

    @Override
    @NotNull
    public List<IntentionAction> getAvailableIntentions() {
        this.doHighlighting();
        List<IntentionAction> list2 = CodeInsightTestFixtureImpl.getAvailableIntentions(this.s(), this.k());
        if (list2 == null) {
            CodeInsightTestFixtureImpl.d(49);
        }
        return list2;
    }

    @NotNull
    private Editor s() {
        Editor editor = InjectedLanguageUtil.getTopLevelEditor((Editor)this.getEditor());
        if (editor == null) {
            CodeInsightTestFixtureImpl.d(50);
        }
        return editor;
    }

    private PsiFile k() {
        return Objects.requireNonNull(PsiUtilBase.getPsiFileInEditor((Editor)this.s(), (Project)this.getProject()));
    }

    @Override
    @NotNull
    public List<IntentionAction> filterAvailableIntentions(@NotNull String string) {
        if (string == null) {
            CodeInsightTestFixtureImpl.d(51);
        }
        List<IntentionAction> list2 = this.getAvailableIntentions().stream().filter(intentionAction -> {
            if (string == null) {
                CodeInsightTestFixtureImpl.d(201);
            }
            return intentionAction.getText().startsWith(string);
        }).collect(Collectors.toList());
        if (list2 == null) {
            CodeInsightTestFixtureImpl.d(52);
        }
        return list2;
    }

    @Override
    @NotNull
    public IntentionAction findSingleIntention(@NotNull String string) {
        List<IntentionAction> list2;
        if (string == null) {
            CodeInsightTestFixtureImpl.d(53);
        }
        if ((list2 = this.filterAvailableIntentions(string)).isEmpty()) {
            Assert.fail((String)("\"" + string + "\" not in [" + StringUtil.join(this.getAvailableIntentions(), d, (String)", ") + "]"));
        } else if (list2.size() > 1) {
            Assert.fail((String)("Too many intentions found for \"" + string + "\": [" + StringUtil.join(list2, d, (String)", ") + "]"));
        }
        IntentionAction intentionAction = UsefulTestCase.assertOneElement(list2);
        if (intentionAction == null) {
            CodeInsightTestFixtureImpl.d(54);
        }
        return intentionAction;
    }

    @Override
    public IntentionAction getAvailableIntention(@NotNull String string, String ... stringArray) {
        List<IntentionAction> list2;
        IntentionAction intentionAction;
        if (string == null) {
            CodeInsightTestFixtureImpl.d(55);
        }
        if (stringArray == null) {
            CodeInsightTestFixtureImpl.d(56);
        }
        if ((intentionAction = CodeInsightTestUtil.findIntentionByText(list2 = this.getAvailableIntentions(stringArray), string)) == null) {
            System.out.println(string + " not found among " + StringUtil.join(list2, IntentionAction::getText, (String)","));
        }
        return intentionAction;
    }

    @Override
    public void launchAction(@NotNull IntentionAction intentionAction) {
        if (intentionAction == null) {
            CodeInsightTestFixtureImpl.d(57);
        }
        CodeInsightTestFixtureImpl.invokeIntention(intentionAction, this.k(), this.s(), intentionAction.getText());
    }

    @Override
    public void testCompletion(@NotNull String[] stringArray, @NotNull String string) {
        if (stringArray == null) {
            CodeInsightTestFixtureImpl.d(58);
        }
        if (string == null) {
            CodeInsightTestFixtureImpl.d(59);
        }
        this.testCompletionTyping(stringArray, "", string);
    }

    @Override
    public void testCompletionTyping(@NotNull String[] stringArray, @NotNull String string, @NotNull String string2) {
        if (stringArray == null) {
            CodeInsightTestFixtureImpl.d(60);
        }
        if (string == null) {
            CodeInsightTestFixtureImpl.d(61);
        }
        if (string2 == null) {
            CodeInsightTestFixtureImpl.d(62);
        }
        this.assertInitialized();
        this.configureByFiles(stringArray);
        this.complete(CompletionType.BASIC);
        this.type(string);
        try {
            this.checkResultByFile(string2);
        }
        catch (RuntimeException runtimeException) {
            System.out.println("LookupElementStrings = " + this.getLookupElementStrings());
            throw runtimeException;
        }
    }

    protected void assertInitialized() {
        Assert.assertNotNull((String)"setUp() hasn't been called", (Object)this.o);
    }

    @Override
    public void testCompletion(@NotNull String string, @NotNull String string2, String ... stringArray) {
        if (string == null) {
            CodeInsightTestFixtureImpl.d(63);
        }
        if (string2 == null) {
            CodeInsightTestFixtureImpl.d(64);
        }
        if (stringArray == null) {
            CodeInsightTestFixtureImpl.d(65);
        }
        this.testCompletionTyping(string, "", string2, stringArray);
    }

    @Override
    public void testCompletionTyping(@NotNull String string, @NotNull String string2, @NotNull String string3, String ... stringArray) {
        if (string == null) {
            CodeInsightTestFixtureImpl.d(66);
        }
        if (string2 == null) {
            CodeInsightTestFixtureImpl.d(67);
        }
        if (string3 == null) {
            CodeInsightTestFixtureImpl.d(68);
        }
        if (stringArray == null) {
            CodeInsightTestFixtureImpl.d(69);
        }
        this.testCompletionTyping((String[])ArrayUtil.reverseArray((Object[])ArrayUtil.append((Object[])stringArray, (Object)string)), string2, string3);
    }

    @Override
    public void testCompletionVariants(@NotNull String string, String ... stringArray) {
        if (string == null) {
            CodeInsightTestFixtureImpl.d(70);
        }
        if (stringArray == null) {
            CodeInsightTestFixtureImpl.d(71);
        }
        this.assertInitialized();
        List<String> list2 = this.getCompletionVariants(string);
        Assert.assertNotNull(list2);
        UsefulTestCase.assertSameElements(list2, stringArray);
    }

    @Override
    public List<String> getCompletionVariants(String ... stringArray) {
        if (stringArray == null) {
            CodeInsightTestFixtureImpl.d(72);
        }
        this.assertInitialized();
        this.configureByFiles(stringArray);
        LookupElement[] lookupElementArray = this.complete(CompletionType.BASIC);
        Assert.assertNotNull((String)"No lookup was shown, probably there was only one lookup element that was inserted automatically", (Object)lookupElementArray);
        return this.getLookupElementStrings();
    }

    @Override
    @Nullable
    public List<String> getLookupElementStrings() {
        this.assertInitialized();
        Object[] objectArray = this.getLookupElements();
        if (objectArray == null) {
            return null;
        }
        return ContainerUtil.map((Object[])objectArray, LookupElement::getLookupString);
    }

    @Override
    public void finishLookup(char c2) {
        Runnable runnable = () -> {
            LookupImpl lookupImpl = (LookupImpl)LookupManager.getActiveLookup((Editor)this.getEditor());
            Assert.assertNotNull((Object)lookupImpl);
            lookupImpl.finishLookup(c2);
        };
        CommandProcessor.getInstance().executeCommand(this.getProject(), runnable, null, null);
    }

    @Override
    public void testRename(@NotNull String string, @NotNull String string2, @NotNull String string3, String ... stringArray) {
        if (string == null) {
            CodeInsightTestFixtureImpl.d(73);
        }
        if (string2 == null) {
            CodeInsightTestFixtureImpl.d(74);
        }
        if (string3 == null) {
            CodeInsightTestFixtureImpl.d(75);
        }
        if (stringArray == null) {
            CodeInsightTestFixtureImpl.d(76);
        }
        this.assertInitialized();
        this.configureByFiles((String[])ArrayUtil.reverseArray((Object[])ArrayUtil.append((Object[])stringArray, (Object)string)));
        this.testRename(string2, string3);
    }

    @Override
    public void testRename(@NotNull String string, @NotNull String string2) {
        if (string == null) {
            CodeInsightTestFixtureImpl.d(77);
        }
        if (string2 == null) {
            CodeInsightTestFixtureImpl.d(78);
        }
        this.renameElementAtCaret(string2);
        this.checkResultByFile(string);
    }

    @Override
    @NotNull
    public PsiElement getElementAtCaret() {
        this.assertInitialized();
        Editor editor = this.getCompletionEditor();
        int n2 = 3;
        PsiElement psiElement = TargetElementUtil.findTargetElement((Editor)editor, (int)n2);
        if (psiElement == null && editor instanceof EditorWindow) {
            psiElement = TargetElementUtil.findTargetElement((Editor)((EditorWindow)editor).getDelegate(), (int)n2);
        }
        if (psiElement == null) {
            Assert.fail((String)("element not found in file " + this.q.getName() + " at caret position offset " + this.k.getCaretModel().getOffset() + ", psi structure:\n" + DebugUtil.psiToString((PsiElement)this.getFile(), (boolean)true, (boolean)true)));
        }
        PsiElement psiElement2 = psiElement;
        if (psiElement2 == null) {
            CodeInsightTestFixtureImpl.d(79);
        }
        return psiElement2;
    }

    @Override
    public void renameElementAtCaret(@NotNull String string) {
        if (string == null) {
            CodeInsightTestFixtureImpl.d(80);
        }
        this.renameElement(this.getElementAtCaret(), string);
    }

    @Override
    public void renameElementAtCaretUsingHandler(@NotNull String string) {
        if (string == null) {
            CodeInsightTestFixtureImpl.d(81);
        }
        DataContext dataContext = ((EditorEx)this.k).getDataContext();
        DataContext dataContext2 = string2 -> {
            if (string == null) {
                CodeInsightTestFixtureImpl.d(200);
            }
            return PsiElementRenameHandler.DEFAULT_NAME.getName().equals(string2) ? string : dataContext.getData(string2);
        };
        RenameHandler renameHandler = RenameHandlerRegistry.getInstance().getRenameHandler(dataContext2);
        Assert.assertNotNull((String)"No handler for this context", (Object)renameHandler);
        renameHandler.invoke(this.getProject(), this.k, this.getFile(), dataContext2);
    }

    @Override
    public void renameElement(@NotNull PsiElement psiElement, @NotNull String string) {
        if (psiElement == null) {
            CodeInsightTestFixtureImpl.d(82);
        }
        if (string == null) {
            CodeInsightTestFixtureImpl.d(83);
        }
        boolean bl2 = false;
        boolean bl3 = false;
        this.renameElement(psiElement, string, false, false);
    }

    @Override
    public void renameElement(@NotNull PsiElement psiElement, @NotNull String string, boolean bl2, boolean bl3) {
        PsiElement psiElement2;
        if (psiElement == null) {
            CodeInsightTestFixtureImpl.d(84);
        }
        if (string == null) {
            CodeInsightTestFixtureImpl.d(85);
        }
        if ((psiElement2 = RenamePsiElementProcessor.forElement((PsiElement)psiElement).substituteElementToRename(psiElement, this.k)) == null) {
            return;
        }
        new RenameProcessor(this.getProject(), psiElement2, string, bl2, bl3).run();
    }

    @Override
    public <T extends PsiElement> T findElementByText(@NotNull String string, @NotNull Class<T> clazz) {
        if (string == null) {
            CodeInsightTestFixtureImpl.d(86);
        }
        if (clazz == null) {
            CodeInsightTestFixtureImpl.d(87);
        }
        Document document = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(this.getFile());
        Assert.assertNotNull((Object)document);
        int n2 = document.getText().indexOf(string);
        Assert.assertTrue((String)string, (n2 >= 0 ? 1 : 0) != 0);
        return (T)PsiTreeUtil.getParentOfType((PsiElement)this.getFile().findElementAt(n2), clazz);
    }

    @Override
    public void type(char c2) {
        this.assertInitialized();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            EditorActionManager editorActionManager = EditorActionManager.getInstance();
            if (c2 == '\b') {
                this.performEditorAction("EditorBackSpace");
                return;
            }
            if (c2 == '\n') {
                if (this.b("EditorChooseLookupItem")) {
                    return;
                }
                if (this.b("NextTemplateVariable")) {
                    return;
                }
                this.performEditorAction("EditorEnter");
                return;
            }
            if (c2 == '\t') {
                if (this.b("EditorChooseLookupItemReplace")) {
                    return;
                }
                if (this.b("ExpandLiveTemplateByTab")) {
                    return;
                }
                if (this.b("NextTemplateVariable")) {
                    return;
                }
                if (this.b("EditorTab")) {
                    return;
                }
            }
            if (c2 == '\r' && this.b("EditorChooseLookupItemCompleteStatement")) {
                return;
            }
            ActionManagerEx.getInstanceEx().fireBeforeEditorTyping(c2, this.t());
            editorActionManager.getTypedAction().actionPerformed(this.getEditor(), c2, this.t());
        });
    }

    @NotNull
    private DataContext t() {
        DataContext dataContext = ((EditorEx)this.k).getDataContext();
        if (dataContext == null) {
            CodeInsightTestFixtureImpl.d(88);
        }
        return dataContext;
    }

    @Override
    public void type(@NotNull String string) {
        if (string == null) {
            CodeInsightTestFixtureImpl.d(89);
        }
        for (int i2 = 0; i2 < string.length(); ++i2) {
            this.type(string.charAt(i2));
        }
    }

    @Override
    public void performEditorAction(@NotNull String string) {
        if (string == null) {
            CodeInsightTestFixtureImpl.d(90);
        }
        this.assertInitialized();
        this.b(string);
    }

    private boolean b(@NotNull String string) {
        if (string == null) {
            CodeInsightTestFixtureImpl.d(91);
        }
        DataContext dataContext = this.t();
        ActionManagerEx actionManagerEx = ActionManagerEx.getInstanceEx();
        AnAction anAction = actionManagerEx.getAction(string);
        AnActionEvent anActionEvent = new AnActionEvent(null, dataContext, "unknown", new Presentation(), (ActionManager)actionManagerEx, 0);
        anAction.beforeActionPerformedUpdate(anActionEvent);
        if (!anActionEvent.getPresentation().isEnabled()) {
            return false;
        }
        actionManagerEx.fireBeforeActionPerformed(anAction, dataContext, anActionEvent);
        ActionUtil.performActionDumbAware((AnAction)anAction, (AnActionEvent)anActionEvent);
        actionManagerEx.fireAfterActionPerformed(anAction, dataContext, anActionEvent);
        return true;
    }

    @Override
    @NotNull
    public Presentation testAction(@NotNull AnAction anAction) {
        if (anAction == null) {
            CodeInsightTestFixtureImpl.d(92);
        }
        TestActionEvent testActionEvent = new TestActionEvent(anAction);
        anAction.beforeActionPerformedUpdate((AnActionEvent)testActionEvent);
        if (testActionEvent.getPresentation().isEnabled() && testActionEvent.getPresentation().isVisible()) {
            anAction.actionPerformed((AnActionEvent)testActionEvent);
        }
        Presentation presentation = testActionEvent.getPresentation();
        if (presentation == null) {
            CodeInsightTestFixtureImpl.d(93);
        }
        return presentation;
    }

    @Override
    @NotNull
    public Collection<UsageInfo> testFindUsages(String ... stringArray) {
        if (stringArray == null) {
            CodeInsightTestFixtureImpl.d(94);
        }
        this.assertInitialized();
        this.configureByFiles(stringArray);
        int n2 = 3;
        PsiElement psiElement = TargetElementUtil.findTargetElement((Editor)this.getEditor(), (int)n2);
        Assert.assertNotNull((String)"Cannot find referenced element", (Object)psiElement);
        Collection<UsageInfo> collection = this.findUsages(psiElement);
        if (collection == null) {
            CodeInsightTestFixtureImpl.d(95);
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<UsageInfo> findUsages(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            CodeInsightTestFixtureImpl.d(96);
        }
        Collection<UsageInfo> collection = this.findUsages(psiElement, null);
        if (collection == null) {
            CodeInsightTestFixtureImpl.d(97);
        }
        return collection;
    }

    @NotNull
    public Collection<UsageInfo> findUsages(@NotNull PsiElement psiElement, @Nullable SearchScope searchScope) {
        if (psiElement == null) {
            CodeInsightTestFixtureImpl.d(98);
        }
        Project project2 = this.getProject();
        FindUsagesHandler findUsagesHandler = ((FindManagerImpl)FindManager.getInstance((Project)project2)).getFindUsagesManager().getFindUsagesHandler(psiElement, false);
        CommonProcessors.CollectProcessor collectProcessor = new CommonProcessors.CollectProcessor();
        Assert.assertNotNull((String)("Cannot find handler for: " + psiElement), (Object)findUsagesHandler);
        PsiElement[] psiElementArray = (PsiElement[])ArrayUtil.mergeArrays((Object[])findUsagesHandler.getPrimaryElements(), (Object[])findUsagesHandler.getSecondaryElements());
        FindUsagesOptions findUsagesOptions = findUsagesHandler.getFindUsagesOptions(null);
        if (searchScope != null) {
            findUsagesOptions.searchScope = searchScope;
        }
        for (PsiElement psiElement2 : psiElementArray) {
            findUsagesHandler.processElementUsages(psiElement2, (Processor)collectProcessor, findUsagesOptions);
        }
        Collection collection = collectProcessor.getResults();
        if (collection == null) {
            CodeInsightTestFixtureImpl.d(99);
        }
        return collection;
    }

    @Override
    @NotNull
    public RangeHighlighter[] testHighlightUsages(String ... stringArray) {
        if (stringArray == null) {
            CodeInsightTestFixtureImpl.d(100);
        }
        this.configureByFiles(stringArray);
        this.testAction((AnAction)new HighlightUsagesAction());
        Editor editor = this.getEditor();
        RangeHighlighter[] rangeHighlighterArray = editor.getMarkupModel().getAllHighlighters();
        if (rangeHighlighterArray == null) {
            CodeInsightTestFixtureImpl.d(101);
        }
        return rangeHighlighterArray;
    }

    @Override
    public void moveFile(@NotNull String string, @NotNull String string2, String ... stringArray) {
        if (string == null) {
            CodeInsightTestFixtureImpl.d(102);
        }
        if (string2 == null) {
            CodeInsightTestFixtureImpl.d(103);
        }
        if (stringArray == null) {
            CodeInsightTestFixtureImpl.d(104);
        }
        this.assertInitialized();
        Project project2 = this.getProject();
        this.configureByFiles((String[])ArrayUtil.reverseArray((Object[])ArrayUtil.append((Object[])stringArray, (Object)string)));
        VirtualFile virtualFile = this.findFileInTempDir(string2);
        Assert.assertNotNull((String)("Directory " + string2 + " not found"), (Object)virtualFile);
        Assert.assertTrue((String)(string2 + " is not a directory"), (boolean)virtualFile.isDirectory());
        PsiDirectory psiDirectory = this.o.findDirectory(virtualFile);
        new MoveFilesOrDirectoriesProcessor(project2, new PsiElement[]{this.getFile()}, psiDirectory, false, false, null, null).run();
    }

    @Override
    @Nullable
    public GutterMark findGutter(@NotNull String string) {
        if (string == null) {
            CodeInsightTestFixtureImpl.d(105);
        }
        this.a(new String[]{string});
        CommonProcessors.FindFirstProcessor findFirstProcessor = new CommonProcessors.FindFirstProcessor();
        this.doHighlighting();
        CodeInsightTestFixtureImpl.processGuttersAtCaret(this.k, this.getProject(), (Processor<GutterMark>)findFirstProcessor);
        return (GutterMark)findFirstProcessor.getFoundValue();
    }

    @Override
    @NotNull
    public List<GutterMark> findGuttersAtCaret() {
        CommonProcessors.CollectProcessor collectProcessor = new CommonProcessors.CollectProcessor();
        this.doHighlighting();
        CodeInsightTestFixtureImpl.processGuttersAtCaret(this.k, this.getProject(), (Processor<GutterMark>)collectProcessor);
        ArrayList<GutterMark> arrayList = new ArrayList<GutterMark>(collectProcessor.getResults());
        if (arrayList == null) {
            CodeInsightTestFixtureImpl.d(106);
        }
        return arrayList;
    }

    public static boolean processGuttersAtCaret(Editor editor, Project project2, @NotNull Processor<GutterMark> processor) {
        RangeHighlighter[] rangeHighlighterArray;
        if (processor == null) {
            CodeInsightTestFixtureImpl.d(107);
        }
        int n2 = editor.getCaretModel().getOffset();
        for (RangeHighlighter rangeHighlighter : rangeHighlighterArray = DocumentMarkupModel.forDocument((Document)editor.getDocument(), (Project)project2, (boolean)true).getAllHighlighters()) {
            GutterIconRenderer gutterIconRenderer = rangeHighlighter.getGutterIconRenderer();
            if (gutterIconRenderer == null || editor.getDocument().getLineNumber(n2) != editor.getDocument().getLineNumber(rangeHighlighter.getStartOffset()) || processor.process((Object)gutterIconRenderer)) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public List<GutterMark> findAllGutters(@NotNull String string) {
        if (string == null) {
            CodeInsightTestFixtureImpl.d(108);
        }
        this.a(new String[]{string});
        List<GutterMark> list2 = this.findAllGutters();
        if (list2 == null) {
            CodeInsightTestFixtureImpl.d(109);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<GutterMark> findAllGutters() {
        Project project2 = this.getProject();
        TreeMap<Integer, List<GutterMark>> treeMap = new TreeMap<Integer, List<GutterMark>>();
        List<HighlightInfo> list2 = this.doHighlighting();
        RangeHighlighter[] rangeHighlighterArray = list2.iterator();
        while (rangeHighlighterArray.hasNext()) {
            RangeHighlighter[] rangeHighlighterArray2 = rangeHighlighterArray.next();
            CodeInsightTestFixtureImpl.a(rangeHighlighterArray2.getGutterIconRenderer(), rangeHighlighterArray2.startOffset, treeMap);
        }
        for (RangeHighlighter rangeHighlighter : rangeHighlighterArray = DocumentMarkupModel.forDocument((Document)this.k.getDocument(), (Project)project2, (boolean)true).getAllHighlighters()) {
            if (!rangeHighlighter.isValid()) continue;
            CodeInsightTestFixtureImpl.a((GutterMark)rangeHighlighter.getGutterIconRenderer(), rangeHighlighter.getStartOffset(), treeMap);
        }
        List list3 = ContainerUtil.concat(treeMap.values());
        if (list3 == null) {
            CodeInsightTestFixtureImpl.d(110);
        }
        return list3;
    }

    @Override
    public PsiFile addFileToProject(@NotNull String string, @NotNull String string2) {
        if (string == null) {
            CodeInsightTestFixtureImpl.d(111);
        }
        if (string2 == null) {
            CodeInsightTestFixtureImpl.d(112);
        }
        this.assertInitialized();
        return this.addFileToProject(this.getTempDirPath(), string, string2);
    }

    protected PsiFile addFileToProject(final @NotNull String string, final @NotNull String string2, final @NotNull String string3) {
        if (string == null) {
            CodeInsightTestFixtureImpl.d(113);
        }
        if (string2 == null) {
            CodeInsightTestFixtureImpl.d(114);
        }
        if (string3 == null) {
            CodeInsightTestFixtureImpl.d(115);
        }
        VirtualFile virtualFile = (VirtualFile)new WriteCommandAction<VirtualFile>(this.getProject(), new PsiFile[0]){

            protected void run(@NotNull Result<VirtualFile> result2) {
                if (result2 == null) {
                    3.a(0);
                }
                try {
                    if (CodeInsightTestFixtureImpl.this.n instanceof LightTempDirTestFixtureImpl) {
                        result2.setResult((Object)CodeInsightTestFixtureImpl.this.n.createFile(string2, string3));
                    } else {
                        result2.setResult((Object)((HeavyIdeaTestFixture)CodeInsightTestFixtureImpl.this.m).addFileToProject(string, string2, string3).getViewProvider().getVirtualFile());
                    }
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                finally {
                    PsiManager.getInstance((Project)this.getProject()).dropPsiCaches();
                }
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$3", "run"));
            }
        }.execute().getResultObject();
        return (PsiFile)ReadAction.compute(() -> PsiManager.getInstance((Project)this.getProject()).findFile(virtualFile));
    }

    public <T> void registerExtension(ExtensionsArea extensionsArea, ExtensionPointName<T> extensionPointName, T t2) {
        this.assertInitialized();
        ExtensionPoint extensionPoint = extensionsArea.getExtensionPoint(extensionPointName);
        extensionPoint.registerExtension(t2);
        Disposer.register((Disposable)this.m.getTestRootDisposable(), () -> extensionPoint.unregisterExtension(t2));
    }

    @Override
    @NotNull
    public PsiManager getPsiManager() {
        PsiManagerImpl psiManagerImpl = this.o;
        if (psiManagerImpl == null) {
            CodeInsightTestFixtureImpl.d(116);
        }
        return psiManagerImpl;
    }

    @Override
    public LookupElement[] complete(@NotNull CompletionType completionType) {
        if (completionType == null) {
            CodeInsightTestFixtureImpl.d(117);
        }
        return this.complete(completionType, 1);
    }

    @Override
    public LookupElement[] complete(@NotNull CompletionType completionType, int n2) {
        if (completionType == null) {
            CodeInsightTestFixtureImpl.d(118);
        }
        this.assertInitialized();
        this.f = false;
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (completionType == null) {
                CodeInsightTestFixtureImpl.d(198);
            }
            CommandProcessor.getInstance().executeCommand(this.getProject(), () -> {
                if (completionType == null) {
                    CodeInsightTestFixtureImpl.d(199);
                }
                CodeCompletionHandlerBase codeCompletionHandlerBase = new CodeCompletionHandlerBase(completionType){

                    protected void completionFinished(CompletionProgressIndicator completionProgressIndicator, boolean bl2) {
                        CodeInsightTestFixtureImpl.this.f = completionProgressIndicator.getLookup().getItems().isEmpty();
                        super.completionFinished(completionProgressIndicator, bl2);
                    }
                };
                Editor editor = this.getCompletionEditor();
                Assert.assertNotNull((Object)editor);
                codeCompletionHandlerBase.invokeCompletion(this.getProject(), editor, n2);
                PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
            }, null, null, this.getEditor().getDocument());
        });
        return this.getLookupElements();
    }

    @Nullable
    protected Editor getCompletionEditor() {
        return InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit((Editor)this.k, (PsiFile)this.getFile());
    }

    @Override
    @Nullable
    public LookupElement[] completeBasic() {
        return this.complete(CompletionType.BASIC);
    }

    @Override
    @NotNull
    public final List<LookupElement> completeBasicAllCarets(@Nullable Character c2) {
        Object object2;
        CaretModel caretModel = this.k.getCaretModel();
        List list2 = caretModel.getAllCarets();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(list2.size());
        for (Object object2 : list2) {
            arrayList.add(object2.getOffset());
        }
        caretModel.removeSecondaryCarets();
        Collections.reverse(arrayList);
        ArrayList arrayList2 = new ArrayList();
        object2 = arrayList.iterator();
        while (object2.hasNext()) {
            int n2 = (Integer)object2.next();
            caretModel.moveToOffset(n2);
            LookupElement[] lookupElementArray = this.completeBasic();
            if (c2 != null) {
                this.type(c2.charValue());
            }
            if (lookupElementArray == null) continue;
            arrayList2.addAll(Arrays.asList(lookupElementArray));
        }
        Object object3 = arrayList2;
        if (object3 == null) {
            CodeInsightTestFixtureImpl.d(119);
        }
        return object3;
    }

    @Override
    public void saveText(final @NotNull VirtualFile virtualFile, final @NotNull String string) {
        if (virtualFile == null) {
            CodeInsightTestFixtureImpl.d(120);
        }
        if (string == null) {
            CodeInsightTestFixtureImpl.d(121);
        }
        new WriteAction(){

            protected void run(@NotNull Result result2) throws Throwable {
                if (result2 == null) {
                    5.a(0);
                }
                VfsUtil.saveText((VirtualFile)virtualFile, (String)string);
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$5", "run"));
            }
        }.execute().throwException();
    }

    @Override
    @Nullable
    public LookupElement[] getLookupElements() {
        LookupImpl lookupImpl = this.getLookup();
        if (lookupImpl == null) {
            return this.f ? LookupElement.EMPTY_ARRAY : null;
        }
        List list2 = lookupImpl.getItems();
        return list2.toArray(LookupElement.EMPTY_ARRAY);
    }

    @Override
    public void checkResult(@NotNull String string) {
        if (string == null) {
            CodeInsightTestFixtureImpl.d(122);
        }
        this.checkResult(string, false);
    }

    @Override
    public void checkResult(final @NotNull String string, final boolean bl2) {
        if (string == null) {
            CodeInsightTestFixtureImpl.d(123);
        }
        new WriteCommandAction(this.getProject(), new PsiFile[0]){

            protected void run(@NotNull Result result2) {
                if (result2 == null) {
                    6.a(0);
                }
                PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
                EditorUtil.fillVirtualSpaceUntilCaret((Editor)CodeInsightTestFixtureImpl.this.s());
                CodeInsightTestFixtureImpl.this.a("TEXT", bl2, SelectionAndCaretMarkupLoader.a(string), CodeInsightTestFixtureImpl.this.p().getText());
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$6", "run"));
            }
        }.execute();
    }

    @Override
    public void checkResult(final @NotNull String string, final @NotNull String string2, final boolean bl2) {
        if (string == null) {
            CodeInsightTestFixtureImpl.d(124);
        }
        if (string2 == null) {
            CodeInsightTestFixtureImpl.d(125);
        }
        new WriteCommandAction(this.getProject(), new PsiFile[0]){

            protected void run(@NotNull Result result2) {
                if (result2 == null) {
                    7.a(0);
                }
                PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
                PsiFile psiFile = CodeInsightTestFixtureImpl.this.d(string);
                CodeInsightTestFixtureImpl.this.a("TEXT", bl2, SelectionAndCaretMarkupLoader.a(string2), psiFile.getText());
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$7", "run"));
            }
        }.execute();
    }

    @Override
    public void checkResultByFile(@NotNull String string) {
        if (string == null) {
            CodeInsightTestFixtureImpl.d(126);
        }
        this.checkResultByFile(string, false);
    }

    @Override
    public void checkResultByFile(@NotNull String string, boolean bl2) {
        if (string == null) {
            CodeInsightTestFixtureImpl.d(127);
        }
        this.assertInitialized();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (string == null) {
                CodeInsightTestFixtureImpl.d(197);
            }
            this.a(string, this.p(), bl2);
        });
    }

    @Override
    public void checkResultByFile(@NotNull String string, @NotNull String string2, boolean bl2) {
        if (string == null) {
            CodeInsightTestFixtureImpl.d(128);
        }
        if (string2 == null) {
            CodeInsightTestFixtureImpl.d(129);
        }
        this.assertInitialized();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (string2 == null) {
                CodeInsightTestFixtureImpl.d(195);
            }
            if (string == null) {
                CodeInsightTestFixtureImpl.d(196);
            }
            this.a(string2, this.d(string), bl2);
        });
    }

    private PsiFile d(String string) {
        String string2 = string.replace(File.separatorChar, '/');
        VirtualFile virtualFile = this.findFileInTempDir(string2);
        Assert.assertNotNull((String)("could not find results file " + string2), (Object)virtualFile);
        PsiFile psiFile = this.o.findFile(virtualFile);
        Assert.assertNotNull((String)virtualFile.getPath(), (Object)psiFile);
        return psiFile;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        TestRunnerUtil.replaceIdeEventQueueSafely();
        EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> {
            this.m.setUp();
            this.n.setUp();
            VirtualFile virtualFile = this.n.getFile("");
            Assert.assertNotNull((Object)virtualFile);
            PlatformTestCase.synchronizeTempDirVfs(virtualFile);
            this.o = (PsiManagerImpl)PsiManager.getInstance((Project)this.getProject());
            InspectionsKt.configureInspections((InspectionProfileEntry[])LocalInspectionTool.EMPTY_ARRAY, this.getProject(), this.m.getTestRootDisposable());
            DaemonCodeAnalyzerImpl daemonCodeAnalyzerImpl = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)this.getProject());
            daemonCodeAnalyzerImpl.prepareForTest();
            DaemonCodeAnalyzerSettings.getInstance().setImportHintEnabled(false);
            CodeInsightTestFixtureImpl.ensureIndexesUpToDate(this.getProject());
            ((StartupManagerImpl)StartupManagerEx.getInstanceEx((Project)this.getProject())).runPostStartupActivities();
        }));
        for (Module module2 : ModuleManager.getInstance((Project)this.getProject()).getModules()) {
            ModuleRootManager.getInstance((Module)module2).orderEntries().getAllLibrariesAndSdkClassesRoots();
        }
        if (this.shouldTrackVirtualFilePointers()) {
            this.p = new VirtualFilePointerTracker();
        }
    }

    protected boolean shouldTrackVirtualFilePointers() {
        return true;
    }

    @Override
    public void tearDown() throws Exception {
        new RunAll(new ThrowableRunnable[0]).append(() -> EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> {
            AutoPopupController.getInstance((Project)this.getProject()).cancelAllRequests();
            DaemonCodeAnalyzerSettings.getInstance().setImportHintEnabled(true);
            this.l();
            ((DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)this.getProject())).cleanupAfterTest();
            WriteAction.run(() -> ProjectRootManagerEx.getInstanceEx((Project)this.getProject()).makeRootsChange(EmptyRunnable.getInstance(), false, true));
        }))).append(() -> {
            this.k = null;
            this.q = null;
            this.o = null;
            this.l = null;
        }).append(() -> this.disposeRootDisposable()).append(() -> EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> this.m.tearDown()))).append(() -> EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> this.n.tearDown()))).append(() -> super.tearDown()).append(() -> {
            if (this.p != null) {
                this.p.assertPointersAreDisposed();
            }
        }).run();
    }

    private void l() {
        LookupManager.getInstance((Project)this.getProject()).hideActiveLookup();
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        FileEditorManagerEx.getInstanceEx((Project)this.getProject()).closeAllFiles();
        for (VirtualFile virtualFile : EditorHistoryManager.getInstance((Project)this.getProject()).getFiles()) {
            EditorHistoryManager.getInstance((Project)this.getProject()).removeFile(virtualFile);
        }
    }

    @NotNull
    private PsiFile[] a(String ... stringArray) {
        if (stringArray == null) {
            CodeInsightTestFixtureImpl.d(130);
        }
        this.assertInitialized();
        this.q = null;
        this.k = null;
        PsiFile[] psiFileArray = new PsiFile[stringArray.length];
        for (int i2 = stringArray.length - 1; i2 >= 0; --i2) {
            psiFileArray[i2] = this.a(stringArray[i2]);
        }
        if (psiFileArray == null) {
            CodeInsightTestFixtureImpl.d(131);
        }
        return psiFileArray;
    }

    @Override
    public PsiFile configureByFile(@NotNull String string) {
        if (string == null) {
            CodeInsightTestFixtureImpl.d(132);
        }
        this.a(new String[]{string});
        return this.getFile();
    }

    @Override
    @NotNull
    public PsiFile[] configureByFiles(String ... stringArray) {
        if (stringArray == null) {
            CodeInsightTestFixtureImpl.d(133);
        }
        PsiFile[] psiFileArray = this.a(stringArray);
        if (psiFileArray == null) {
            CodeInsightTestFixtureImpl.d(134);
        }
        return psiFileArray;
    }

    @Override
    public PsiFile configureByText(final @NotNull FileType fileType, @NotNull String string) {
        if (fileType == null) {
            CodeInsightTestFixtureImpl.d(135);
        }
        if (string == null) {
            CodeInsightTestFixtureImpl.d(136);
        }
        this.assertInitialized();
        final String string2 = fileType.getDefaultExtension();
        final FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        if (fileTypeManager.getFileTypeByExtension(string2) != fileType) {
            new WriteCommandAction(this.getProject(), new PsiFile[0]){

                protected void run(@NotNull Result result2) {
                    if (result2 == null) {
                        8.a(0);
                    }
                    fileTypeManager.associateExtension(fileType, string2);
                }

                private static /* synthetic */ void a(int n2) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$8", "run"));
                }
            }.execute();
        }
        String string3 = "aaa." + string2;
        return this.configureByText(string3, string);
    }

    @Override
    public PsiFile configureByText(final @NotNull String string, final @NotNull String string2) {
        if (string == null) {
            CodeInsightTestFixtureImpl.d(137);
        }
        if (string2 == null) {
            CodeInsightTestFixtureImpl.d(138);
        }
        this.assertInitialized();
        VirtualFile virtualFile = (VirtualFile)new WriteCommandAction<VirtualFile>(this.getProject(), new PsiFile[0]){

            protected void run(@NotNull Result<VirtualFile> result2) throws Throwable {
                VirtualFile virtualFile;
                Object object;
                if (result2 == null) {
                    9.a(0);
                }
                if (CodeInsightTestFixtureImpl.this.n instanceof LightTempDirTestFixtureImpl) {
                    object = LightPlatformTestCase.getSourceRoot();
                    object.refresh(false, false);
                    virtualFile = object.findOrCreateChildData((Object)this, string);
                    Assert.assertNotNull((String)(string + " not found in " + object.getPath()), (Object)virtualFile);
                } else if (CodeInsightTestFixtureImpl.this.n instanceof TempDirTestFixtureImpl) {
                    object = ((TempDirTestFixtureImpl)CodeInsightTestFixtureImpl.this.n).createTempFile(string);
                    virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile((File)object);
                    Assert.assertNotNull((String)(object + " not found"), (Object)virtualFile);
                } else {
                    virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(CodeInsightTestFixtureImpl.this.getTempDirPath(), string));
                    Assert.assertNotNull((String)(string + " not found in " + CodeInsightTestFixtureImpl.this.getTempDirPath()), (Object)virtualFile);
                }
                CodeInsightTestFixtureImpl.this.prepareVirtualFile(virtualFile);
                object = FileDocumentManager.getInstance().getCachedDocument(virtualFile);
                if (object != null) {
                    PsiDocumentManager.getInstance((Project)this.getProject()).doPostponedOperationsAndUnblockDocument((Document)object);
                    FileDocumentManager.getInstance().saveDocument((Document)object);
                }
                VfsUtil.saveText((VirtualFile)virtualFile, (String)string2);
                result2.setResult((Object)virtualFile);
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$9", "run"));
            }
        }.execute().getResultObject();
        this.c(virtualFile, SelectionAndCaretMarkupLoader.b(virtualFile));
        return this.getFile();
    }

    @Override
    public Document getDocument(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            CodeInsightTestFixtureImpl.d(139);
        }
        this.assertInitialized();
        return PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(psiFile);
    }

    private PsiFile a(@NotNull String string) {
        if (string == null) {
            CodeInsightTestFixtureImpl.d(140);
        }
        this.assertInitialized();
        VirtualFile virtualFile = this.copyFileToProject(string);
        return this.a(virtualFile);
    }

    @Override
    public PsiFile configureFromTempProjectFile(@NotNull String string) {
        VirtualFile virtualFile;
        if (string == null) {
            CodeInsightTestFixtureImpl.d(141);
        }
        if ((virtualFile = this.findFileInTempDir(string)) == null) {
            throw new IllegalArgumentException("Could not find file in temp dir: " + string);
        }
        return this.a(virtualFile);
    }

    @Override
    public void configureFromExistingVirtualFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            CodeInsightTestFixtureImpl.d(142);
        }
        this.a(virtualFile);
    }

    private PsiFile a(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            CodeInsightTestFixtureImpl.d(143);
        }
        return this.c(virtualFile, SelectionAndCaretMarkupLoader.b(virtualFile));
    }

    private PsiFile c(@NotNull VirtualFile virtualFile, @NotNull SelectionAndCaretMarkupLoader selectionAndCaretMarkupLoader) {
        if (virtualFile == null) {
            CodeInsightTestFixtureImpl.d(144);
        }
        if (selectionAndCaretMarkupLoader == null) {
            CodeInsightTestFixtureImpl.d(145);
        }
        this.assertInitialized();
        EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> {
            if (virtualFile == null) {
                CodeInsightTestFixtureImpl.d(191);
            }
            if (selectionAndCaretMarkupLoader == null) {
                CodeInsightTestFixtureImpl.d(192);
            }
            if (!virtualFile.getFileType().isBinary()) {
                try {
                    WriteAction.run(() -> {
                        if (virtualFile == null) {
                            CodeInsightTestFixtureImpl.d(193);
                        }
                        if (selectionAndCaretMarkupLoader == null) {
                            CodeInsightTestFixtureImpl.d(194);
                        }
                        virtualFile.setBinaryContent(selectionAndCaretMarkupLoader.b.getBytes(virtualFile.getCharset()));
                    });
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
            this.q = virtualFile;
            this.k = this.createEditor(virtualFile);
            if (this.k == null) {
                Assert.fail((String)("editor couldn't be created for: " + virtualFile.getPath() + ", use copyFileToProject() instead of configureByFile()"));
            }
            EditorTestUtil.setCaretsAndSelection(this.k, selectionAndCaretMarkupLoader.a);
            Module module2 = this.getModule();
            if (module2 != null) {
                for (Facet facet : FacetManager.getInstance((Module)module2).getAllFacets()) {
                    ((FacetManagerListener)module2.getMessageBus().syncPublisher(FacetManager.FACETS_TOPIC)).facetConfigurationChanged(facet);
                }
            }
            PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
            if (this.g) {
                this.c();
            }
        }));
        return this.getFile();
    }

    protected void prepareVirtualFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            CodeInsightTestFixtureImpl.d(146);
        }
    }

    private void c() {
        Editor editor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit((Editor)this.k, (PsiFile)this.getFile());
        if (editor instanceof EditorWindow) {
            this.q = ((EditorWindow)editor).getInjectedFile().getViewProvider().getVirtualFile();
            this.k = editor;
        }
    }

    @Override
    public VirtualFile findFileInTempDir(@NotNull String string) {
        if (string == null) {
            CodeInsightTestFixtureImpl.d(147);
        }
        if (this.n instanceof LightTempDirTestFixtureImpl) {
            return this.n.getFile(string);
        }
        String string2 = this.getTempDirPath() + "/" + string;
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(string2.replace(File.separatorChar, '/'));
        Assert.assertNotNull((String)("file " + string2 + " not found"), (Object)virtualFile);
        VfsTestUtil.assertFilePathEndsWithCaseSensitivePath(virtualFile, string);
        return virtualFile;
    }

    @Nullable
    protected Editor createEditor(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            CodeInsightTestFixtureImpl.d(148);
        }
        Project project2 = this.getProject();
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project2);
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        Editor editor = fileEditorManager.openTextEditor(new OpenFileDescriptor(project2, virtualFile), false);
        EditorTestUtil.waitForLoading(editor);
        if (editor != null) {
            DaemonCodeAnalyzer.getInstance((Project)this.getProject()).restart();
        }
        return editor;
    }

    private long a(boolean bl2, boolean bl3, boolean bl4) {
        return this.a(bl2, bl3, bl4, false);
    }

    private long a(boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        ExpectedHighlightingData expectedHighlightingData = new ExpectedHighlightingData(this.k.getDocument(), bl2, bl4, bl3, bl5, this.p());
        expectedHighlightingData.init();
        return this.a(expectedHighlightingData);
    }

    private PsiFile p() {
        VirtualFile virtualFile = this.q instanceof VirtualFileWindow ? ((VirtualFileWindow)this.q).getDelegate() : this.q;
        return (PsiFile)ReadAction.compute(() -> PsiManager.getInstance((Project)this.getProject()).findFile(virtualFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long a(@NotNull ExpectedHighlightingData expectedHighlightingData) {
        List<HighlightInfo> list2;
        if (expectedHighlightingData == null) {
            CodeInsightTestFixtureImpl.d(149);
        }
        Project project2 = this.getProject();
        EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> PsiDocumentManager.getInstance((Project)project2).commitAllDocuments()));
        PsiFileImpl psiFileImpl = (PsiFileImpl)this.p();
        FileElement fileElement = psiFileImpl.calcTreeElement();
        if (!DumbService.isDumb((Project)project2)) {
            CacheManager.SERVICE.getInstance((Project)project2).getFilesWithWord("XXX", (short)2, GlobalSearchScope.allScope((Project)project2), true);
        }
        long l2 = System.currentTimeMillis();
        VirtualFileFilter virtualFileFilter = this.e;
        Disposable disposable = Disposer.newDisposable();
        if (virtualFileFilter != null) {
            PsiManagerEx.getInstanceEx((Project)project2).setAssertOnFileLoadingFilter(virtualFileFilter, disposable);
        }
        try {
            list2 = this.doHighlighting();
            CodeInsightTestFixtureImpl.a(list2);
        }
        finally {
            Disposer.dispose((Disposable)disposable);
        }
        long l3 = System.currentTimeMillis() - l2;
        expectedHighlightingData.checkResult(list2, psiFileImpl.getText());
        if (expectedHighlightingData.hasLineMarkers()) {
            Document document = this.getDocument(this.getFile());
            expectedHighlightingData.checkLineMarkers(DaemonCodeAnalyzerImpl.getLineMarkers((Document)document, (Project)this.getProject()), document.getText());
        }
        fileElement.hashCode();
        return l3;
    }

    public void setVirtualFileFilter(@Nullable VirtualFileFilter virtualFileFilter) {
        this.e = virtualFileFilter;
    }

    @Override
    @NotNull
    public List<HighlightInfo> doHighlighting() {
        Project project2 = this.getProject();
        EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> PsiDocumentManager.getInstance((Project)project2).commitAllDocuments()));
        PsiFile psiFile = this.getFile();
        Editor editor = this.getEditor();
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
            psiFile = InjectedLanguageManager.getInstance((Project)psiFile.getProject()).getTopLevelFile((PsiElement)psiFile);
        }
        Assert.assertNotNull((Object)psiFile);
        List<HighlightInfo> list2 = CodeInsightTestFixtureImpl.instantiateAndRun(psiFile, editor, ArrayUtil.EMPTY_INT_ARRAY, this.h);
        if (list2 == null) {
            CodeInsightTestFixtureImpl.d(150);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<HighlightInfo> doHighlighting(@NotNull HighlightSeverity highlightSeverity) {
        if (highlightSeverity == null) {
            CodeInsightTestFixtureImpl.d(151);
        }
        List list2 = ContainerUtil.filter(this.doHighlighting(), highlightInfo -> {
            if (highlightSeverity == null) {
                CodeInsightTestFixtureImpl.d(190);
            }
            return highlightInfo.getSeverity().compareTo(highlightSeverity) >= 0;
        });
        if (list2 == null) {
            CodeInsightTestFixtureImpl.d(152);
        }
        return list2;
    }

    @Override
    @NotNull
    public String getTestDataPath() {
        String string = this.i;
        if (string == null) {
            CodeInsightTestFixtureImpl.d(153);
        }
        return string;
    }

    @Override
    public void setTestDataPath(@NotNull String string) {
        if (string == null) {
            CodeInsightTestFixtureImpl.d(154);
        }
        this.i = string;
    }

    @Override
    public Project getProject() {
        return this.m.getProject();
    }

    @Override
    public Module getModule() {
        return this.m.getModule();
    }

    @Override
    public Editor getEditor() {
        return this.k;
    }

    @Override
    public int getCaretOffset() {
        return this.k.getCaretModel().getOffset();
    }

    @Override
    public PsiFile getFile() {
        return this.q != null ? (PsiFile)ReadAction.compute(() -> PsiManager.getInstance((Project)this.getProject()).findFile(this.q)) : null;
    }

    @Override
    public void allowTreeAccessForFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            CodeInsightTestFixtureImpl.d(155);
        }
        assert (this.e instanceof FileTreeAccessFilter) : "configured filter does not support this method";
        ((FileTreeAccessFilter)this.e).allowTreeAccessForFile(virtualFile);
    }

    @Override
    public void allowTreeAccessForAllFiles() {
        assert (this.e instanceof FileTreeAccessFilter) : "configured filter does not support this method";
        ((FileTreeAccessFilter)this.e).allowTreeAccessForAllFiles();
    }

    private void a(@NotNull String string, @NotNull PsiFile psiFile, boolean bl2) {
        if (string == null) {
            CodeInsightTestFixtureImpl.d(156);
        }
        if (psiFile == null) {
            CodeInsightTestFixtureImpl.d(157);
        }
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        if (!bl2) {
            EditorUtil.fillVirtualSpaceUntilCaret((Editor)this.s());
        }
        String string2 = psiFile.getText();
        String string3 = this.getTestDataPath() + "/" + string;
        String string4 = Optional.ofNullable(psiFile.getVirtualFile()).map(virtualFile -> virtualFile.getCharset().name()).orElse(null);
        this.a(string, bl2, SelectionAndCaretMarkupLoader.b(string3, string4), string2);
    }

    private void a(@NotNull String string, boolean bl2, @NotNull SelectionAndCaretMarkupLoader selectionAndCaretMarkupLoader, @NotNull String string2) {
        if (string == null) {
            CodeInsightTestFixtureImpl.d(158);
        }
        if (selectionAndCaretMarkupLoader == null) {
            CodeInsightTestFixtureImpl.d(159);
        }
        if (string2 == null) {
            CodeInsightTestFixtureImpl.d(160);
        }
        this.assertInitialized();
        Project project2 = this.getProject();
        Editor editor = this.getEditor();
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
        }
        UsefulTestCase.doPostponedFormatting(this.getProject());
        if (bl2) {
            string2 = this.c(string2);
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        String string3 = selectionAndCaretMarkupLoader.b;
        if (bl2) {
            string3 = this.c(string3);
        }
        if (!Comparing.equal((String)string3, (String)(string2 = StringUtil.convertLineSeparators((String)string2)))) {
            if (selectionAndCaretMarkupLoader.c != null) {
                throw new FileComparisonFailure(string, string3, string2, selectionAndCaretMarkupLoader.c);
            }
            throw new ComparisonFailure(string, string3, string2);
        }
        EditorTestUtil.verifyCaretAndSelectionState(editor, selectionAndCaretMarkupLoader.a, string);
    }

    @NotNull
    private String c(@NotNull String string) {
        if (string == null) {
            CodeInsightTestFixtureImpl.d(161);
        }
        Document document = EditorFactory.getInstance().createDocument((CharSequence)string);
        ((DocumentImpl)document).stripTrailingSpaces(this.getProject());
        String string2 = string = document.getText();
        if (string2 == null) {
            CodeInsightTestFixtureImpl.d(162);
        }
        return string2;
    }

    public void canChangeDocumentDuringHighlighting(boolean bl2) {
        this.h = bl2;
    }

    @NotNull
    public String getFoldingDescription(boolean bl2) {
        Editor editor = this.s();
        CodeFoldingManager.getInstance((Project)this.getProject()).buildInitialFoldings(editor);
        String string = CodeInsightTestFixtureImpl.getTagsFromSegments(editor.getDocument().getText(), Arrays.asList(editor.getFoldingModel().getAllFoldRegions()), r, foldRegion -> "text='" + foldRegion.getPlaceholderText() + "'" + (bl2 ? " expand='" + foldRegion.isExpanded() + "'" : ""));
        if (string == null) {
            CodeInsightTestFixtureImpl.d(163);
        }
        return string;
    }

    @NotNull
    public static <T extends Segment> String getTagsFromSegments(@NotNull String string, @NotNull Collection<T> collection, @NotNull String string2, @Nullable Function<T, String> function) {
        if (string == null) {
            CodeInsightTestFixtureImpl.d(164);
        }
        if (collection == null) {
            CodeInsightTestFixtureImpl.d(165);
        }
        if (string2 == null) {
            CodeInsightTestFixtureImpl.d(166);
        }
        LinkedList<Border> linkedList = new LinkedList<Border>();
        for (Object object : collection) {
            String object2 = function == null ? null : (String)function.fun(object);
            linkedList.add(new Border(true, object.getStartOffset(), object2));
            linkedList.add(new Border(false, object.getEndOffset(), ""));
        }
        Collections.sort(linkedList);
        StringBuilder stringBuilder = new StringBuilder(string);
        for (Border border : linkedList) {
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append('<');
            if (border.b) {
                stringBuilder2.append(string2);
                if (border.a != null) {
                    stringBuilder2.append(' ').append(border.a);
                }
            } else {
                stringBuilder2.append('/').append(string2);
            }
            stringBuilder2.append('>');
            stringBuilder.insert(border.c, stringBuilder2);
        }
        String string3 = stringBuilder.toString();
        if (string3 == null) {
            CodeInsightTestFixtureImpl.d(167);
        }
        return string3;
    }

    private void a(@NotNull String string, @Nullable String string2, boolean bl2) {
        Object object;
        String string3;
        File file;
        if (string == null) {
            CodeInsightTestFixtureImpl.d(168);
        }
        try {
            file = new File(string);
            string3 = FileUtil.loadFile((File)file);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        Assert.assertNotNull((Object)string3);
        string3 = StringUtil.replace((String)string3, (String)"\r", (String)"");
        String string4 = string3.replaceAll("<fold\\stext='[^']*'(\\sexpand='[^']*')*>", "").replace("</fold>", "");
        if (string2 == null) {
            this.configureByText(FileTypeManager.getInstance().getFileTypeByFileName(string), string4);
        } else {
            try {
                FileUtil.writeToFile((File)new File(string2), (String)string4);
                object = LocalFileSystem.getInstance().refreshAndFindFileByPath(string2);
                Assert.assertNotNull((Object)object);
                this.configureFromExistingVirtualFile((VirtualFile)object);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        object = this.getFoldingDescription(bl2);
        if (!string3.equals(object)) {
            throw new FileComparisonFailure(file.getName(), string3, (String)object, file.getPath());
        }
    }

    @Override
    public void testFoldingWithCollapseStatus(@NotNull String string) {
        if (string == null) {
            CodeInsightTestFixtureImpl.d(169);
        }
        this.a(string, (String)null, true);
    }

    @Override
    public void testFoldingWithCollapseStatus(@NotNull String string, @Nullable String string2) {
        if (string == null) {
            CodeInsightTestFixtureImpl.d(170);
        }
        this.a(string, string2, true);
    }

    @Override
    public void testFolding(@NotNull String string) {
        if (string == null) {
            CodeInsightTestFixtureImpl.d(171);
        }
        this.a(string, (String)null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testRainbow(@NotNull String string, @NotNull String string2, boolean bl2, boolean bl3) {
        if (string == null) {
            CodeInsightTestFixtureImpl.d(172);
        }
        if (string2 == null) {
            CodeInsightTestFixtureImpl.d(173);
        }
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        boolean bl4 = RainbowHighlighter.isRainbowEnabled((TextAttributesScheme)editorColorsScheme, null);
        try {
            RainbowHighlighter.setRainbowEnabled((SchemeMetaInfo)editorColorsScheme, null, (Boolean)bl2);
            this.configureByText(string, string2.replaceAll("<rainbow(\\scolor='[^']*')?>", "").replace("</rainbow>", ""));
            List list2 = ContainerUtil.filter(this.doHighlighting(), highlightInfo -> highlightInfo.type == RainbowHighlighter.RAINBOW_ELEMENT);
            Assert.assertEquals((Object)string2, (Object)CodeInsightTestFixtureImpl.getTagsFromSegments(this.k.getDocument().getText(), list2, j, highlightInfo -> {
                if (!bl3) {
                    return null;
                }
                TextAttributes textAttributes = highlightInfo.getTextAttributes(null, null);
                String string = textAttributes == null ? "null" : (textAttributes.getForegroundColor() == null ? "null" : Integer.toHexString(textAttributes.getForegroundColor().getRGB()));
                return "color='" + string + "'";
            }));
        }
        finally {
            RainbowHighlighter.setRainbowEnabled((SchemeMetaInfo)editorColorsScheme, null, (Boolean)bl4);
        }
    }

    @Override
    public void testInlays() {
        InlayHintsChecker inlayHintsChecker = new InlayHintsChecker(this);
        try {
            inlayHintsChecker.setUp();
            inlayHintsChecker.checkInlays();
        }
        finally {
            inlayHintsChecker.tearDown();
        }
    }

    @Override
    public void checkResultWithInlays(String string) {
        DocumentImpl documentImpl = new DocumentImpl(string);
        InlayHintsChecker inlayHintsChecker = new InlayHintsChecker(this);
        CaretAndInlaysInfo caretAndInlaysInfo = inlayHintsChecker.extractInlaysAndCaretInfo((Document)documentImpl);
        this.checkResult(documentImpl.getText());
        inlayHintsChecker.verifyInlaysAndCaretInfo(caretAndInlaysInfo, string);
    }

    @Override
    public void assertPreferredCompletionItems(int n2, String ... stringArray) {
        if (stringArray == null) {
            CodeInsightTestFixtureImpl.d(174);
        }
        LookupImpl lookupImpl = this.getLookup();
        Assert.assertNotNull((String)"No lookup is shown", (Object)lookupImpl);
        JList jList = lookupImpl.getList();
        List<String> list2 = this.getLookupElementStrings();
        Assert.assertNotNull(list2);
        List<String> list3 = list2.subList(0, Math.min(stringArray.length, list2.size()));
        if (!list3.equals(Arrays.asList(stringArray))) {
            UsefulTestCase.assertOrderedEquals(DumpLookupElementWeights.getLookupElementWeights((LookupImpl)lookupImpl, (boolean)false), stringArray);
        }
        if (n2 != jList.getSelectedIndex()) {
            System.out.println(DumpLookupElementWeights.getLookupElementWeights((LookupImpl)lookupImpl, (boolean)false));
        }
        Assert.assertEquals((long)n2, (long)jList.getSelectedIndex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void testStructureView(@NotNull Consumer<StructureViewComponent> consumer) {
        if (consumer == null) {
            CodeInsightTestFixtureImpl.d(175);
        }
        Assert.assertNotNull((String)"configure first", (Object)this.q);
        FileEditor fileEditor = FileEditorManager.getInstance((Project)this.getProject()).getSelectedEditor(this.q);
        Assert.assertNotNull((String)("editor not opened for " + this.q), (Object)this.q);
        StructureViewBuilder structureViewBuilder = LanguageStructureViewBuilder.INSTANCE.getStructureViewBuilder(this.getFile());
        Assert.assertNotNull((String)("no builder for " + this.q), (Object)structureViewBuilder);
        StructureViewComponent structureViewComponent = null;
        try {
            structureViewComponent = (StructureViewComponent)structureViewBuilder.createStructureView(fileEditor, this.getProject());
            PlatformTestUtil.waitForPromise(structureViewComponent.rebuildAndUpdate());
            consumer.consume((Object)structureViewComponent);
            if (structureViewComponent == null) return;
        }
        catch (Throwable throwable) {
            if (structureViewComponent == null) throw throwable;
            Disposer.dispose(structureViewComponent);
            throw throwable;
        }
        Disposer.dispose((Disposable)structureViewComponent);
    }

    @Override
    public void setCaresAboutInjection(boolean bl2) {
        this.g = bl2;
    }

    public LookupImpl getLookup() {
        return (LookupImpl)LookupManager.getActiveLookup((Editor)this.k);
    }

    @Override
    @NotNull
    public List<Object> getGotoClassResults(@NotNull String string, boolean bl2, @Nullable PsiElement psiElement) {
        if (string == null) {
            CodeInsightTestFixtureImpl.d(176);
        }
        ChooseByNameBase chooseByNameBase = this.a(psiElement);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        chooseByNameBase.getProvider().filterElements(chooseByNameBase, chooseByNameBase.transformPattern(string), bl2, (ProgressIndicator)new MockProgressIndicator(), (Processor)new CommonProcessors.CollectProcessor(arrayList));
        ArrayList<Object> arrayList2 = arrayList;
        if (arrayList2 == null) {
            CodeInsightTestFixtureImpl.d(177);
        }
        return arrayList2;
    }

    @Override
    @NotNull
    public List<Crumb> getBreadcrumbsAtCaret() {
        PsiElement psiElement = this.getFile().findElementAt(this.getCaretOffset());
        if (psiElement == null) {
            List<Crumb> list2 = Collections.emptyList();
            if (list2 == null) {
                CodeInsightTestFixtureImpl.d(178);
            }
            return list2;
        }
        Language language = psiElement.getContainingFile().getLanguage();
        BreadcrumbsProvider breadcrumbsProvider = BreadcrumbsUtil.getInfoProvider((Language)language);
        if (breadcrumbsProvider == null) {
            List<Crumb> list3 = Collections.emptyList();
            if (list3 == null) {
                CodeInsightTestFixtureImpl.d(179);
            }
            return list3;
        }
        ArrayList<Crumb.Impl> arrayList = new ArrayList<Crumb.Impl>();
        while (psiElement != null) {
            if (breadcrumbsProvider.acceptElement(psiElement)) {
                arrayList.add(new Crumb.Impl(breadcrumbsProvider.getElementIcon(psiElement), breadcrumbsProvider.getElementInfo(psiElement), breadcrumbsProvider.getElementTooltip(psiElement)));
            }
            psiElement = breadcrumbsProvider.getParent(psiElement);
        }
        List list4 = ContainerUtil.reverse(arrayList);
        if (list4 == null) {
            CodeInsightTestFixtureImpl.d(180);
        }
        return list4;
    }

    @NotNull
    private ChooseByNameBase a(@Nullable PsiElement psiElement) {
        Project project2 = this.getProject();
        if (psiElement != null) {
            ChooseByNamePopup chooseByNamePopup = ChooseByNamePopup.createPopup((Project)project2, (ChooseByNameModel)new GotoClassModel2(project2), (PsiElement)psiElement);
            if (chooseByNamePopup == null) {
                CodeInsightTestFixtureImpl.d(181);
            }
            return chooseByNamePopup;
        }
        if (this.l == null) {
            this.l = ChooseByNamePopup.createPopup((Project)project2, (ChooseByNameModel)new GotoClassModel2(project2), (PsiElement)null);
        }
        ChooseByNameBase chooseByNameBase = this.l;
        if (chooseByNameBase == null) {
            CodeInsightTestFixtureImpl.d(182);
        }
        return chooseByNameBase;
    }

    protected void bringRealEditorBack() {
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        if (this.k instanceof EditorWindow) {
            Document document = ((DocumentWindow)this.k.getDocument()).getDelegate();
            this.q = FileDocumentManager.getInstance().getFile(document);
            this.k = ((EditorWindow)this.k).getDelegate();
        }
    }

    public static boolean invokeIntention(@NotNull IntentionAction intentionAction, PsiFile psiFile, Editor editor, String string) {
        if (intentionAction == null) {
            CodeInsightTestFixtureImpl.d(183);
        }
        Project project2 = psiFile.getProject();
        ReadonlyStatusHandlerImpl readonlyStatusHandlerImpl = (ReadonlyStatusHandlerImpl)ReadonlyStatusHandler.getInstance((Project)project2);
        VirtualFile virtualFile = Objects.requireNonNull(InjectedLanguageManager.getInstance((Project)psiFile.getProject()).getTopLevelFile((PsiElement)psiFile)).getVirtualFile();
        CodeInsightTestFixtureImpl.b(virtualFile, true);
        readonlyStatusHandlerImpl.setClearReadOnlyInTests(true);
        AtomicBoolean atomicBoolean = new AtomicBoolean();
        try {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (intentionAction == null) {
                    CodeInsightTestFixtureImpl.d(189);
                }
                try {
                    atomicBoolean.set(ShowIntentionActionsHandler.chooseActionAndInvoke((PsiFile)psiFile, (Editor)editor, (IntentionAction)intentionAction, (String)string));
                }
                catch (StubTextInconsistencyException stubTextInconsistencyException) {
                    PsiTestUtil.compareStubTexts(stubTextInconsistencyException);
                }
            });
            UIUtil.dispatchAllInvocationEvents();
            CodeInsightTestFixtureImpl.a(project2, virtualFile);
        }
        catch (AssertionError assertionError) {
            ExceptionUtil.rethrowUnchecked((Throwable)ExceptionUtil.getRootCause((Throwable)((Object)assertionError)));
            throw assertionError;
        }
        finally {
            readonlyStatusHandlerImpl.setClearReadOnlyInTests(false);
            CodeInsightTestFixtureImpl.b(virtualFile, false);
        }
        return atomicBoolean.get();
    }

    private static void a(Project project2, VirtualFile virtualFile) {
        PsiFile psiFile;
        PsiFile psiFile2 = psiFile = virtualFile.isValid() ? PsiManager.getInstance((Project)project2).findFile(virtualFile) : null;
        if (psiFile != null) {
            PsiTestUtil.checkStubsMatchText(psiFile);
        }
    }

    private static void b(VirtualFile virtualFile, boolean bl2) {
        try {
            WriteAction.run(() -> ReadOnlyAttributeUtil.setReadOnlyAttribute((VirtualFile)virtualFile, (boolean)bl2));
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    @NotNull
    public Disposable getProjectDisposable() {
        Disposable disposable = this.m.getTestRootDisposable();
        if (disposable == null) {
            CodeInsightTestFixtureImpl.d(184);
        }
        return disposable;
    }

    @Deprecated
    public static GlobalInspectionContextForTests createGlobalContextForTool(@NotNull AnalysisScope analysisScope, @NotNull Project project2, @NotNull InspectionManagerEx inspectionManagerEx, InspectionToolWrapper ... inspectionToolWrapperArray) {
        if (analysisScope == null) {
            CodeInsightTestFixtureImpl.d(185);
        }
        if (project2 == null) {
            CodeInsightTestFixtureImpl.d(186);
        }
        if (inspectionManagerEx == null) {
            CodeInsightTestFixtureImpl.d(187);
        }
        if (inspectionToolWrapperArray == null) {
            CodeInsightTestFixtureImpl.d(188);
        }
        return InspectionsKt.createGlobalContextForTool(analysisScope, project2, Arrays.asList(inspectionToolWrapperArray));
    }

    private static /* synthetic */ void d(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 38: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 54: 
            case 79: 
            case 88: 
            case 93: 
            case 95: 
            case 97: 
            case 99: 
            case 101: 
            case 106: 
            case 109: 
            case 110: 
            case 116: 
            case 119: 
            case 131: 
            case 134: 
            case 150: 
            case 152: 
            case 153: 
            case 162: 
            case 163: 
            case 167: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 184: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 7: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 38: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 54: 
            case 79: 
            case 88: 
            case 93: 
            case 95: 
            case 97: 
            case 99: 
            case 101: 
            case 106: 
            case 109: 
            case 110: 
            case 116: 
            case 119: 
            case 131: 
            case 134: 
            case 150: 
            case 152: 
            case 153: 
            case 162: 
            case 163: 
            case 167: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 184: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFixture";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempDirTestFixture";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 4: 
            case 10: 
            case 13: 
            case 36: 
            case 39: 
            case 120: 
            case 132: 
            case 139: 
            case 146: 
            case 148: 
            case 155: 
            case 203: 
            case 205: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 9: 
            case 12: 
            case 202: 
            case 206: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: 
            case 207: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toIgnore";
                break;
            }
            case 7: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 38: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 54: 
            case 79: 
            case 88: 
            case 93: 
            case 95: 
            case 97: 
            case 99: 
            case 101: 
            case 106: 
            case 109: 
            case 110: 
            case 116: 
            case 119: 
            case 131: 
            case 134: 
            case 150: 
            case 152: 
            case 153: 
            case 162: 
            case 163: 
            case 167: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 184: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl";
                break;
            }
            case 8: 
            case 186: 
            case 204: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 17: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePath";
                break;
            }
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPath";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspections";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 32: 
            case 35: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 56: 
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 34: 
            case 100: 
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 37: 
            case 102: 
            case 105: 
            case 108: 
            case 124: 
            case 128: 
            case 140: 
            case 141: 
            case 147: 
            case 196: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testDir";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 51: 
            case 53: 
            case 201: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hint";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intentionName";
                break;
            }
            case 57: 
            case 92: 
            case 183: 
            case 189: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 58: 
            case 60: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesBefore";
                break;
            }
            case 59: 
            case 62: 
            case 64: 
            case 68: 
            case 74: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileAfter";
                break;
            }
            case 61: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toType";
                break;
            }
            case 63: 
            case 66: 
            case 70: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileBefore";
                break;
            }
            case 65: 
            case 69: 
            case 76: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalFiles";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedItems";
                break;
            }
            case 75: 
            case 78: 
            case 80: 
            case 81: 
            case 83: 
            case 85: 
            case 200: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 82: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 86: 
            case 121: 
            case 122: 
            case 123: 
            case 125: 
            case 136: 
            case 138: 
            case 164: 
            case 173: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 90: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNames";
                break;
            }
            case 96: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElement";
                break;
            }
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 111: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 112: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileText";
                break;
            }
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 117: 
            case 118: 
            case 198: 
            case 199: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 126: 
            case 127: 
            case 129: 
            case 156: 
            case 158: 
            case 195: 
            case 197: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedFile";
                break;
            }
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 137: 
            case 172: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 143: 
            case 144: 
            case 191: 
            case 193: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copy";
                break;
            }
            case 145: 
            case 159: 
            case 192: 
            case 194: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 149: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 151: 
            case 190: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minimalSeverity";
                break;
            }
            case 154: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPath";
                break;
            }
            case 157: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFile";
                break;
            }
            case 160: 
            case 161: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualText";
                break;
            }
            case 165: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segments";
                break;
            }
            case 166: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 168: 
            case 169: 
            case 170: 
            case 171: {
                objectArray2 = objectArray3;
                objectArray3[0] = "verificationFileName";
                break;
            }
            case 174: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
            case 175: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 176: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 185: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 187: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionManager";
                break;
            }
            case 188: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrappers";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "instantiateAndRun";
                break;
            }
            case 11: 
            case 46: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableIntentions";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetAvailableIntentions";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDirPath";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDirFixture";
                break;
            }
            case 18: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFileToProject";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "copyDirectoryToProject";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "testFile";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceAtCaretPositionWithAssertion";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllQuickFixes";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getHostEditor";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "filterAvailableIntentions";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "findSingleIntention";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementAtCaret";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorDataContext";
                break;
            }
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "testAction";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "testFindUsages";
                break;
            }
            case 97: 
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "testHighlightUsages";
                break;
            }
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "findGuttersAtCaret";
                break;
            }
            case 109: 
            case 110: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllGutters";
                break;
            }
            case 116: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiManager";
                break;
            }
            case 119: {
                objectArray = objectArray2;
                objectArray2[1] = "completeBasicAllCarets";
                break;
            }
            case 131: {
                objectArray = objectArray2;
                objectArray2[1] = "configureByFilesInner";
                break;
            }
            case 134: {
                objectArray = objectArray2;
                objectArray2[1] = "configureByFiles";
                break;
            }
            case 150: 
            case 152: {
                objectArray = objectArray2;
                objectArray2[1] = "doHighlighting";
                break;
            }
            case 153: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestDataPath";
                break;
            }
            case 162: {
                objectArray = objectArray2;
                objectArray2[1] = "stripTrailingSpaces";
                break;
            }
            case 163: {
                objectArray = objectArray2;
                objectArray2[1] = "getFoldingDescription";
                break;
            }
            case 167: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagsFromSegments";
                break;
            }
            case 177: {
                objectArray = objectArray2;
                objectArray2[1] = "getGotoClassResults";
                break;
            }
            case 178: 
            case 179: 
            case 180: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreadcrumbsAtCaret";
                break;
            }
            case 181: 
            case 182: {
                objectArray = objectArray2;
                objectArray2[1] = "getMockChooseByNamePopup";
                break;
            }
            case 184: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectDisposable";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addGutterIconRenderer";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicatedRangesForInjected";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "instantiateAndRun";
                break;
            }
            case 7: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 38: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 54: 
            case 79: 
            case 88: 
            case 93: 
            case 95: 
            case 97: 
            case 99: 
            case 101: 
            case 106: 
            case 109: 
            case 110: 
            case 116: 
            case 119: 
            case 131: 
            case 134: 
            case 150: 
            case 152: 
            case 153: 
            case 162: 
            case 163: 
            case 167: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 184: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "ensureIndexesUpToDate";
                break;
            }
            case 9: 
            case 10: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableIntentions";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doGetAvailableIntentions";
                break;
            }
            case 17: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "copyFileToProject";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "copyDirectoryToProject";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "enableInspections";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "disableInspections";
                break;
            }
            case 32: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "testHighlighting";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "testHighlightingAllFiles";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "testFile";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "openFileInEditor";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "testInspection";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceAtCaretPosition";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceAtCaretPositionWithAssertion";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getAllQuickFixes";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "filterAvailableIntentions";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "findSingleIntention";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableIntention";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "launchAction";
                break;
            }
            case 58: 
            case 59: 
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "testCompletion";
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 66: 
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "testCompletionTyping";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "testCompletionVariants";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getCompletionVariants";
                break;
            }
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "testRename";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "renameElementAtCaret";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "renameElementAtCaretUsingHandler";
                break;
            }
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "renameElement";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "findElementByText";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "type";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "performEditorAction";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "_performEditorAction";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "testAction";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "testFindUsages";
                break;
            }
            case 96: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "testHighlightUsages";
                break;
            }
            case 102: 
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "moveFile";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "findGutter";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "processGuttersAtCaret";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "findAllGutters";
                break;
            }
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "addFileToProject";
                break;
            }
            case 117: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "complete";
                break;
            }
            case 120: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "saveText";
                break;
            }
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 158: 
            case 159: 
            case 160: {
                objectArray = objectArray;
                objectArray[2] = "checkResult";
                break;
            }
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 156: 
            case 157: {
                objectArray = objectArray;
                objectArray[2] = "checkResultByFile";
                break;
            }
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "configureByFilesInner";
                break;
            }
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "configureByFile";
                break;
            }
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "configureByFiles";
                break;
            }
            case 135: 
            case 136: 
            case 137: 
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "configureByText";
                break;
            }
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "getDocument";
                break;
            }
            case 140: 
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "configureByFileInner";
                break;
            }
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "configureFromTempProjectFile";
                break;
            }
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "configureFromExistingVirtualFile";
                break;
            }
            case 144: 
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "configureInner";
                break;
            }
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "prepareVirtualFile";
                break;
            }
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "findFileInTempDir";
                break;
            }
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "collectAndCheckHighlighting";
                break;
            }
            case 151: {
                objectArray = objectArray;
                objectArray[2] = "doHighlighting";
                break;
            }
            case 154: {
                objectArray = objectArray;
                objectArray[2] = "setTestDataPath";
                break;
            }
            case 155: {
                objectArray = objectArray;
                objectArray[2] = "allowTreeAccessForFile";
                break;
            }
            case 161: {
                objectArray = objectArray;
                objectArray[2] = "stripTrailingSpaces";
                break;
            }
            case 164: 
            case 165: 
            case 166: {
                objectArray = objectArray;
                objectArray[2] = "getTagsFromSegments";
                break;
            }
            case 168: {
                objectArray = objectArray;
                objectArray[2] = "testFoldingRegions";
                break;
            }
            case 169: 
            case 170: {
                objectArray = objectArray;
                objectArray[2] = "testFoldingWithCollapseStatus";
                break;
            }
            case 171: {
                objectArray = objectArray;
                objectArray[2] = "testFolding";
                break;
            }
            case 172: 
            case 173: {
                objectArray = objectArray;
                objectArray[2] = "testRainbow";
                break;
            }
            case 174: {
                objectArray = objectArray;
                objectArray[2] = "assertPreferredCompletionItems";
                break;
            }
            case 175: {
                objectArray = objectArray;
                objectArray[2] = "testStructureView";
                break;
            }
            case 176: {
                objectArray = objectArray;
                objectArray[2] = "getGotoClassResults";
                break;
            }
            case 183: {
                objectArray = objectArray;
                objectArray[2] = "invokeIntention";
                break;
            }
            case 185: 
            case 186: 
            case 187: 
            case 188: {
                objectArray = objectArray;
                objectArray[2] = "createGlobalContextForTool";
                break;
            }
            case 189: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invokeIntention$42";
                break;
            }
            case 190: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doHighlighting$36";
                break;
            }
            case 191: 
            case 192: {
                objectArray = objectArray;
                objectArray[2] = "lambda$configureInner$32";
                break;
            }
            case 193: 
            case 194: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$31";
                break;
            }
            case 195: 
            case 196: {
                objectArray = objectArray;
                objectArray[2] = "lambda$checkResultByFile$18";
                break;
            }
            case 197: {
                objectArray = objectArray;
                objectArray[2] = "lambda$checkResultByFile$17";
                break;
            }
            case 198: {
                objectArray = objectArray;
                objectArray[2] = "lambda$complete$16";
                break;
            }
            case 199: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$15";
                break;
            }
            case 200: {
                objectArray = objectArray;
                objectArray[2] = "lambda$renameElementAtCaretUsingHandler$11";
                break;
            }
            case 201: {
                objectArray = objectArray;
                objectArray[2] = "lambda$filterAvailableIntentions$9";
                break;
            }
            case 202: 
            case 203: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getAvailableIntentions$5";
                break;
            }
            case 204: {
                objectArray = objectArray;
                objectArray[2] = "lambda$ensureIndexesUpToDate$4";
                break;
            }
            case 205: 
            case 206: 
            case 207: {
                objectArray = objectArray;
                objectArray[2] = "lambda$instantiateAndRun$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 38: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 54: 
            case 79: 
            case 88: 
            case 93: 
            case 95: 
            case 97: 
            case 99: 
            case 101: 
            case 106: 
            case 109: 
            case 110: 
            case 116: 
            case 119: 
            case 131: 
            case 134: 
            case 150: 
            case 152: 
            case 153: 
            case 162: 
            case 163: 
            case 167: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 184: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Border
    implements Comparable<Border> {
        private final boolean b;
        private final int c;
        private final String a;

        private Border(boolean bl2, int n2, String string) {
            this.b = bl2;
            this.c = n2;
            this.a = string;
        }

        @Override
        public int compareTo(@NotNull Border border) {
            if (border == null) {
                Border.a(0);
            }
            return this.c < border.c ? 1 : -1;
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$Border", "compareTo"));
        }
    }

    private static class SelectionAndCaretMarkupLoader {
        private final String c;
        private final String b;
        private final EditorTestUtil.CaretAndSelectionState a;

        private SelectionAndCaretMarkupLoader(@NotNull String string, String string2) {
            if (string == null) {
                SelectionAndCaretMarkupLoader.a(0);
            }
            this.c = string2;
            Document document = EditorFactory.getInstance().createDocument((CharSequence)string);
            this.a = EditorTestUtil.extractCaretAndSelectionMarkers(document);
            this.b = document.getText();
        }

        @NotNull
        private static SelectionAndCaretMarkupLoader b(@NotNull String string, String string2) {
            if (string == null) {
                SelectionAndCaretMarkupLoader.a(1);
            }
            SelectionAndCaretMarkupLoader selectionAndCaretMarkupLoader = SelectionAndCaretMarkupLoader.a((ThrowableComputable<String, IOException>)((ThrowableComputable)() -> {
                if (string == null) {
                    SelectionAndCaretMarkupLoader.a(10);
                }
                return FileUtil.loadFile((File)new File(string), (String)string2);
            }), string);
            if (selectionAndCaretMarkupLoader == null) {
                SelectionAndCaretMarkupLoader.a(2);
            }
            return selectionAndCaretMarkupLoader;
        }

        @NotNull
        private static SelectionAndCaretMarkupLoader b(@NotNull VirtualFile virtualFile) {
            if (virtualFile == null) {
                SelectionAndCaretMarkupLoader.a(3);
            }
            SelectionAndCaretMarkupLoader selectionAndCaretMarkupLoader = SelectionAndCaretMarkupLoader.a((ThrowableComputable<String, IOException>)((ThrowableComputable)() -> {
                if (virtualFile == null) {
                    SelectionAndCaretMarkupLoader.a(9);
                }
                return VfsUtilCore.loadText((VirtualFile)virtualFile);
            }), virtualFile.getPath());
            if (selectionAndCaretMarkupLoader == null) {
                SelectionAndCaretMarkupLoader.a(4);
            }
            return selectionAndCaretMarkupLoader;
        }

        @NotNull
        private static SelectionAndCaretMarkupLoader a(@NotNull ThrowableComputable<String, IOException> throwableComputable, String string) {
            SelectionAndCaretMarkupLoader selectionAndCaretMarkupLoader;
            block3: {
                if (throwableComputable == null) {
                    SelectionAndCaretMarkupLoader.a(5);
                }
                try {
                    selectionAndCaretMarkupLoader = new SelectionAndCaretMarkupLoader(StringUtil.convertLineSeparators((String)((String)throwableComputable.compute())), string);
                    if (selectionAndCaretMarkupLoader != null) break block3;
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                SelectionAndCaretMarkupLoader.a(6);
            }
            return selectionAndCaretMarkupLoader;
        }

        @NotNull
        private static SelectionAndCaretMarkupLoader a(@NotNull String string) {
            if (string == null) {
                SelectionAndCaretMarkupLoader.a(7);
            }
            SelectionAndCaretMarkupLoader selectionAndCaretMarkupLoader = new SelectionAndCaretMarkupLoader(string, null);
            if (selectionAndCaretMarkupLoader == null) {
                SelectionAndCaretMarkupLoader.a(8);
            }
            return selectionAndCaretMarkupLoader;
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileText";
                    break;
                }
                case 1: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$SelectionAndCaretMarkupLoader";
                    break;
                }
                case 3: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/testFramework/fixtures/impl/CodeInsightTestFixtureImpl$SelectionAndCaretMarkupLoader";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fromFile";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fromIoSource";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fromText";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "fromFile";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "fromIoSource";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "fromText";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$fromFile$1";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$fromFile$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

