/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.ide.IdeView;
import com.intellij.idea.IdeaTestApplication;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.impl.jar.JarFileSystemImpl;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.testFramework.EditorListenerTracker;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.PlatformTestCase;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.SdkLeakTracker;
import com.intellij.testFramework.ThreadTracker;
import com.intellij.testFramework.builders.ModuleFixtureBuilder;
import com.intellij.testFramework.fixtures.HeavyIdeaTestFixture;
import com.intellij.testFramework.fixtures.impl.BaseFixture;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.lang.CompoundRuntimeException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

class HeavyIdeaTestFixtureImpl
extends BaseFixture
implements HeavyIdeaTestFixture {
    private Project k;
    private final Set<File> i;
    private IdeaTestApplication l;
    private final Set<ModuleFixtureBuilder> e;
    private EditorListenerTracker f;
    private ThreadTracker d;
    private final String g;
    private final boolean h;
    private SdkLeakTracker j;

    HeavyIdeaTestFixtureImpl(@NotNull String string, boolean bl2) {
        if (string == null) {
            HeavyIdeaTestFixtureImpl.a(0);
        }
        this.i = new HashSet<File>();
        this.e = new LinkedHashSet<ModuleFixtureBuilder>();
        this.g = string;
        this.h = bl2;
    }

    void addModuleFixtureBuilder(ModuleFixtureBuilder moduleFixtureBuilder) {
        this.e.add(moduleFixtureBuilder);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.i();
        this.k();
        EncodingManager.getInstance();
        this.f = new EditorListenerTracker();
        this.d = new ThreadTracker();
        InjectedLanguageManagerImpl.pushInjectors((Project)this.getProject());
        this.j = new SdkLeakTracker();
    }

    @Override
    public void tearDown() throws Exception {
        RunAll runAll = new RunAll(new ThrowableRunnable[0]).append(() -> LightPlatformTestCase.doTearDown(this.getProject(), this.l)).append(() -> {
            for (ModuleFixtureBuilder moduleFixtureBuilder : this.e) {
                moduleFixtureBuilder.getFixture().tearDown();
            }
        }).append(() -> EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> PlatformTestCase.closeAndDisposeProjectAndCheckThatNoOpenProjects(this.getProject())))).append(() -> InjectedLanguageManagerImpl.checkInjectorsAreDisposed((Project)this.getProject())).append(() -> {
            this.k = null;
        });
        ((JarFileSystemImpl)JarFileSystem.getInstance()).cleanupForNextTest();
        for (File file : this.i) {
            runAll = runAll.append(() -> {
                List list2 = Files.walk(file.toPath(), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(path -> {
                    try {
                        Files.delete(path);
                        return null;
                    }
                    catch (IOException iOException) {
                        return iOException;
                    }
                }).filter(Objects::nonNull).collect(Collectors.toList());
                CompoundRuntimeException.throwIfNotEmpty(list2);
            });
        }
        runAll.append(() -> super.tearDown()).append(() -> this.f.checkListenersLeak()).append(() -> this.d.checkLeak()).append(LightPlatformTestCase::checkEditorsReleased).append(() -> this.j.checkForJdkTableLeaks()).append(() -> PlatformTestCase.cleanupApplicationCaches(null)).run();
    }

    private void k() throws IOException {
        File file = FileUtil.createTempDirectory((String)this.g, (String)"");
        PlatformTestCase.synchronizeTempDirVfs((VirtualFile)ObjectUtils.assertNotNull((Object)LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file)));
        this.i.add(file);
        String string = this.generateProjectPath(file);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        new Throwable(string).printStackTrace(new PrintStream(byteArrayOutputStream));
        this.k = PlatformTestCase.createProject(string, byteArrayOutputStream.toString());
        EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> {
            ProjectManagerEx.getInstanceEx().openTestProject(this.k);
            for (ModuleFixtureBuilder moduleFixtureBuilder : this.e) {
                moduleFixtureBuilder.getFixture().setUp();
            }
            LightPlatformTestCase.clearUncommittedDocuments(this.k);
            ((FileTypeManagerImpl)FileTypeManager.getInstance()).drainReDetectQueue();
        }));
    }

    @NotNull
    protected String generateProjectPath(@NotNull File file) {
        if (file == null) {
            HeavyIdeaTestFixtureImpl.a(1);
        }
        String string = this.h ? "" : ".ipr";
        String string2 = FileUtil.toSystemIndependentName((String)file.getPath()) + "/" + this.g + string;
        if (string2 == null) {
            HeavyIdeaTestFixtureImpl.a(2);
        }
        return string2;
    }

    private void i() {
        this.l = IdeaTestApplication.getInstance();
        this.l.setDataProvider(new MyDataProvider());
    }

    @Override
    public Project getProject() {
        Assert.assertNotNull((String)"setUp() should be called first", (Object)this.k);
        return this.k;
    }

    @Override
    public Module getModule() {
        Module[] moduleArray = ModuleManager.getInstance((Project)this.getProject()).getModules();
        return moduleArray.length == 0 ? null : moduleArray[0];
    }

    @Override
    public PsiFile addFileToProject(@NotNull @NonNls String string, final @NotNull @NonNls String string2, final @NotNull @NonNls String string3) throws IOException {
        if (string == null) {
            HeavyIdeaTestFixtureImpl.a(3);
        }
        if (string2 == null) {
            HeavyIdeaTestFixtureImpl.a(4);
        }
        if (string3 == null) {
            HeavyIdeaTestFixtureImpl.a(5);
        }
        final VirtualFile virtualFile = VfsUtil.createDirectories((String)(string + "/" + PathUtil.getParentPath((String)string2)));
        final VirtualFile[] virtualFileArray = new VirtualFile[1];
        new WriteCommandAction.Simple(this.getProject(), new PsiFile[0]){

            protected void run() throws Throwable {
                virtualFileArray[0] = virtualFile.createChildData((Object)this, StringUtil.getShortName((String)string2, (char)'/'));
                VfsUtil.saveText((VirtualFile)virtualFileArray[0], (String)string3);
                PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
            }
        }.execute();
        return (PsiFile)ReadAction.compute(() -> PsiManager.getInstance((Project)this.getProject()).findFile(virtualFileArray[0]));
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempDirectory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/fixtures/impl/HeavyIdeaTestFixtureImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileText";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/fixtures/impl/HeavyIdeaTestFixtureImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "generateProjectPath";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "generateProjectPath";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addFileToProject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyDataProvider
    implements DataProvider {
        private MyDataProvider() {
        }

        @Nullable
        public Object getData(@NonNls String string) {
            VirtualFile[] virtualFileArray;
            if (CommonDataKeys.PROJECT.is(string)) {
                return HeavyIdeaTestFixtureImpl.this.k;
            }
            if (CommonDataKeys.EDITOR.is(string) || OpenFileDescriptor.NAVIGATE_IN_EDITOR.is(string)) {
                if (HeavyIdeaTestFixtureImpl.this.k == null) {
                    return null;
                }
                return FileEditorManager.getInstance((Project)HeavyIdeaTestFixtureImpl.this.k).getSelectedTextEditor();
            }
            Editor editor = (Editor)this.getData(CommonDataKeys.EDITOR.getName());
            if (editor != null) {
                FileEditorManagerEx fileEditorManagerEx = FileEditorManagerEx.getInstanceEx((Project)HeavyIdeaTestFixtureImpl.this.k);
                return fileEditorManagerEx.getData(string, editor, editor.getCaretModel().getCurrentCaret());
            }
            if (LangDataKeys.IDE_VIEW.is(string) && (virtualFileArray = ProjectRootManager.getInstance((Project)HeavyIdeaTestFixtureImpl.this.k).getContentRoots()).length > 0) {
                final PsiDirectory psiDirectory = PsiManager.getInstance((Project)HeavyIdeaTestFixtureImpl.this.k).findDirectory(virtualFileArray[0]);
                return new IdeView(){

                    @NotNull
                    public PsiDirectory[] getDirectories() {
                        PsiDirectory[] psiDirectoryArray = new PsiDirectory[]{psiDirectory};
                        if (psiDirectoryArray == null) {
                            1.a(0);
                        }
                        return psiDirectoryArray;
                    }

                    public PsiDirectory getOrChooseDirectory() {
                        return psiDirectory;
                    }

                    private static /* synthetic */ void a(int n2) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/HeavyIdeaTestFixtureImpl$MyDataProvider$1", "getDirectories"));
                    }
                };
            }
            return null;
        }
    }
}

