/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.utils.inlays;

import com.intellij.codeInsight.daemon.impl.ParameterHintsPresentationManager;
import com.intellij.codeInsight.hints.settings.ParameterNameHintsSettings;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiFile;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.testFramework.utils.inlays.CaretAndInlaysInfo;
import com.intellij.testFramework.utils.inlays.ParamHintInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.ComparisonFailure;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J \u0010\u0010\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\u0006\u0010\u0014\u001a\u00020\bJ\u0006\u0010\u0015\u001a\u00020\bJ\u0016\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/testFramework/utils/inlays/InlayHintsChecker;", "", "myFixture", "Lcom/intellij/testFramework/fixtures/CodeInsightTestFixture;", "(Lcom/intellij/testFramework/fixtures/CodeInsightTestFixture;)V", "isParamHintsEnabledBefore", "", "checkInlays", "", "extractInlaysAndCaretInfo", "Lcom/intellij/testFramework/utils/inlays/CaretAndInlaysInfo;", "document", "Lcom/intellij/openapi/editor/Document;", "getActualInlays", "", "Lcom/intellij/testFramework/utils/inlays/ParamHintInfo;", "removeText", "realStartOffset", "", "matchedLength", "setUp", "tearDown", "verifyInlaysAndCaretInfo", "expectedInlaysAndCaret", "originalText", "", "Companion", "intellij.platform.testFramework"})
public final class InlayHintsChecker {
    private boolean d;
    private final CodeInsightTestFixture a;
    @NotNull
    private static final Pattern c;
    private static final ParameterNameHintsSettings b;
    public static final Companion Companion;

    public final void setUp() {
        EditorSettingsExternalizable editorSettingsExternalizable;
        EditorSettingsExternalizable editorSettingsExternalizable2 = editorSettingsExternalizable = EditorSettingsExternalizable.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorSettingsExternalizable2, (String)"settings");
        this.d = editorSettingsExternalizable2.isShowParameterNameHints();
        editorSettingsExternalizable.setShowParameterNameHints(true);
    }

    public final void tearDown() {
        EditorSettingsExternalizable editorSettingsExternalizable = EditorSettingsExternalizable.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorSettingsExternalizable, (String)"EditorSettingsExternalizable.getInstance()");
        editorSettingsExternalizable.setShowParameterNameHints(this.d);
        ParameterNameHintsSettings parameterNameHintsSettings = ParameterNameHintsSettings.Companion.getInstance();
        parameterNameHintsSettings.loadState(InlayHintsChecker.Companion.a().getState());
    }

    public final void checkInlays() {
        Document document;
        PsiFile psiFile = this.a.getFile();
        Document document2 = document = this.a.getDocument(psiFile);
        Intrinsics.checkExpressionValueIsNotNull((Object)document2, (String)"document");
        String string = document2.getText();
        CaretAndInlaysInfo caretAndInlaysInfo = this.extractInlaysAndCaretInfo(document);
        this.a.doHighlighting();
        String string2 = string;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"originalText");
        this.verifyInlaysAndCaretInfo(caretAndInlaysInfo, string2);
    }

    public final void verifyInlaysAndCaretInfo(@NotNull CaretAndInlaysInfo caretAndInlaysInfo, @NotNull String string) {
        Object object;
        Iterable<Pair> iterable;
        block17: {
            Object object2;
            Object object3;
            Object object4;
            Object e2;
            Object object5;
            List<ParamHintInfo> list2;
            Document document;
            PsiFile psiFile;
            block16: {
                boolean bl2;
                block14: {
                    Intrinsics.checkParameterIsNotNull((Object)caretAndInlaysInfo, (String)"expectedInlaysAndCaret");
                    Intrinsics.checkParameterIsNotNull((Object)string, (String)"originalText");
                    psiFile = this.a.getFile();
                    document = this.a.getDocument(psiFile);
                    list2 = this.a();
                    List<ParamHintInfo> list3 = caretAndInlaysInfo.getInlays();
                    if (caretAndInlaysInfo.getInlays().size() != list2.size()) break block16;
                    iterable = CollectionsKt.zip((Iterable)list2, (Iterable)list3);
                    if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object iterator2 : iterable) {
                            object5 = (Pair)iterator2;
                            if (!(Intrinsics.areEqual((Object)((ParamHintInfo)object5.getFirst()), (Object)((ParamHintInfo)object5.getSecond())) ^ true)) continue;
                            bl2 = true;
                            break block14;
                        }
                        bl2 = false;
                    }
                }
                if (!bl2) break block17;
            }
            iterable = new ArrayList();
            object = list2;
            Iterator n4 = object.iterator();
            while (n4.hasNext()) {
                String string2;
                StringBuilder stringBuilder;
                Pair pair2;
                object5 = n4.next();
                e2 = (ParamHintInfo)object5;
                Integer pair3 = ((ParamHintInfo)e2).getOffset();
                object4 = pair2;
                object3 = pair2;
                object2 = iterable;
                StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
                stringBuilder2.append("<");
                stringBuilder2.append(((ParamHintInfo)e2).getHighlighted() ? "H" : "h");
                stringBuilder2.append(((ParamHintInfo)e2).getCurrent() ? "INT" : "int");
                stringBuilder2.append(" text=\"");
                stringBuilder2.append(((ParamHintInfo)e2).getText());
                stringBuilder2.append("\"/>");
                Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder.toString(), (String)"StringBuilder().apply(builderAction).toString()");
                object4((Object)pair3, (Object)string2);
                object2.add(object3);
            }
            if (caretAndInlaysInfo.getCaretOffset() != null) {
                int n2;
                int object7;
                int n5;
                block15: {
                    Editor editor = this.a.getEditor();
                    Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"myFixture.editor");
                    CaretModel caretModel = editor.getCaretModel();
                    Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"myFixture.editor.caretModel");
                    n5 = caretModel.getOffset();
                    Editor editor2 = this.a.getEditor();
                    Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"myFixture.editor");
                    CaretModel caretModel2 = editor2.getCaretModel();
                    Intrinsics.checkExpressionValueIsNotNull((Object)caretModel2, (String)"myFixture.editor.caretModel");
                    object7 = caretModel2.getVisualPosition().column - this.a.getEditor().offsetToVisualPosition((int)n5).column;
                    e2 = iterable;
                    int n3 = 0;
                    object4 = e2.iterator();
                    while (object4.hasNext()) {
                        object3 = object4.next();
                        object2 = object3;
                        if (((Number)object2.getFirst()).intValue() == n5) {
                            n2 = n3;
                            break block15;
                        }
                        ++n3;
                    }
                    n2 = -1;
                }
                int n6 = n2;
                int n7 = n6 == -1 ? -CollectionsKt.binarySearch$default(iterable, (int)0, (int)0, (Function1)((Function1)new Function1<Pair<? extends Integer, ? extends String>, Integer>(n5){
                    final /* synthetic */ int $actualCaretOffset;

                    public final int invoke(@NotNull Pair<Integer, String> pair2) {
                        Intrinsics.checkParameterIsNotNull(pair2, (String)"it");
                        return ((Number)pair2.getFirst()).intValue() - this.$actualCaretOffset;
                    }
                    {
                        this.$actualCaretOffset = n2;
                        super(1);
                    }
                }), (int)3, null) - 1 : n6 + object7;
                iterable.add(n7, (Pair)new Pair((Object)n5, (Object)"<caret>"));
            }
            Document document2 = document;
            Intrinsics.checkExpressionValueIsNotNull((Object)document2, (String)"document");
            StringBuilder stringBuilder = new StringBuilder(document2.getText());
            Iterable iterable2 = CollectionsKt.asReversedMutable(iterable);
            for (Object e3 : iterable2) {
                Pair pair3 = (Pair)e3;
                stringBuilder.insert(((Number)pair3.getFirst()).intValue(), (String)pair3.getSecond());
            }
            PsiFile psiFile2 = psiFile;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile2, (String)"file");
            String string3 = (String)VfsTestUtil.TEST_DATA_FILE_PATH.get((UserDataHolder)psiFile2.getVirtualFile());
            if (string3 != null) {
                String string4 = string3;
                object5 = string4;
                throw (Throwable)new FileComparisonFailure("Hints differ", string, stringBuilder.toString(), (String)object5);
            }
            throw (Throwable)new ComparisonFailure("Hints differ", string, stringBuilder.toString());
        }
        if (caretAndInlaysInfo.getCaretOffset() != null) {
            Integer n8 = caretAndInlaysInfo.getCaretOffset();
            Editor editor = this.a.getEditor();
            Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"myFixture.editor");
            CaretModel caretModel = editor.getCaretModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"myFixture.editor.caretModel");
            Assert.assertEquals((String)"Unexpected caret offset", (Object)n8, (Object)caretModel.getOffset());
            iterable = this.a.getEditor().offsetToVisualPosition(caretAndInlaysInfo.getCaretOffset().intValue());
            VisualPosition visualPosition = new VisualPosition(((VisualPosition)iterable).line, ((VisualPosition)iterable).column + caretAndInlaysInfo.getInlaysBeforeCaret());
            Editor editor3 = this.a.getEditor();
            Intrinsics.checkExpressionValueIsNotNull((Object)editor3, (String)"myFixture.editor");
            CaretModel caretModel3 = editor3.getCaretModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)caretModel3, (String)"myFixture.editor.caretModel");
            Assert.assertEquals((String)"Unexpected caret visual position", (Object)visualPosition, (Object)caretModel3.getVisualPosition());
            Editor editor4 = this.a.getEditor();
            Intrinsics.checkExpressionValueIsNotNull((Object)editor4, (String)"myFixture.editor");
            object = editor4.getSelectionModel();
            if (caretAndInlaysInfo.getSelection() == null) {
                Assert.assertFalse((boolean)object.hasSelection());
            } else {
                TextRange textRange = caretAndInlaysInfo.getSelection();
                Object object6 = object;
                Intrinsics.checkExpressionValueIsNotNull((Object)object6, (String)"selectionModel");
                Assert.assertEquals((String)"Unexpected selection", (Object)textRange, (Object)new TextRange(object6.getSelectionStart(), object.getSelectionEnd()));
            }
        }
    }

    private final List<ParamHintInfo> a() {
        Inlay inlay;
        Editor editor;
        Editor editor2 = editor = this.a.getEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"editor");
        InlayModel inlayModel = editor2.getInlayModel();
        Document document = editor.getDocument();
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"editor.document");
        List list2 = inlayModel.getInlineElementsInRange(0, document.getTextLength());
        ParameterHintsPresentationManager parameterHintsPresentationManager = ParameterHintsPresentationManager.getInstance();
        List list3 = list2;
        Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"allInlays");
        Iterable iterable = list3;
        Iterable iterable2 = iterable;
        Object object = new ArrayList();
        for (Object t2 : iterable2) {
            inlay = (Inlay)t2;
            if (!parameterHintsPresentationManager.isParameterHint(inlay)) continue;
            object.add(t2);
        }
        iterable = (List)object;
        iterable2 = iterable;
        object = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        for (Object t2 : iterable2) {
            inlay = (Inlay)t2;
            Collection collection = object;
            Inlay inlay2 = inlay;
            Intrinsics.checkExpressionValueIsNotNull((Object)inlay2, (String)"it");
            int n2 = inlay2.getOffset();
            String string = parameterHintsPresentationManager.getHintText(inlay);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"hintManager.getHintText(it)");
            ParamHintInfo paramHintInfo = new ParamHintInfo(n2, string, parameterHintsPresentationManager.isHighlighted(inlay), parameterHintsPresentationManager.isCurrent(inlay));
            collection.add(paramHintInfo);
        }
        iterable = (List)object;
        iterable2 = iterable;
        object = new Comparator<T>(){

            public final int compare(T t2, T t3) {
                ParamHintInfo paramHintInfo = (ParamHintInfo)t2;
                Comparable comparable = Integer.valueOf(paramHintInfo.getOffset());
                paramHintInfo = (ParamHintInfo)t3;
                Comparable comparable2 = comparable;
                Integer n2 = paramHintInfo.getOffset();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n2);
            }
        };
        return CollectionsKt.sortedWith((Iterable)iterable2, (Comparator)object);
    }

    @NotNull
    public final CaretAndInlaysInfo extractInlaysAndCaretInfo(@NotNull Document document) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        String string = document.getText();
        Matcher matcher = Companion.getPattern().matcher(string);
        List list2 = new ArrayList();
        int n2 = 0;
        Integer n3 = null;
        int n4 = 0;
        Integer n5 = null;
        Integer n6 = null;
        while (matcher.find()) {
            Object object;
            Iterable iterable;
            int n7 = matcher.start();
            int n8 = matcher.end() - n7;
            int n9 = n7 - n2;
            if (matcher.group(1) != null) {
                Object object2;
                ParamHintInfo paramHintInfo;
                n3 = n9;
                iterable = CollectionsKt.asReversedMutable((List)list2);
                object = new ArrayList();
                Iterator<Object> iterator2 = iterable.iterator();
                while (iterator2.hasNext() && (paramHintInfo = (ParamHintInfo)(object2 = iterator2.next())).getOffset() == n3.intValue()) {
                    ((ArrayList)object).add(object2);
                }
                iterable = (List)object;
                for (Iterator<Object> iterator2 : iterable) {
                    object2 = (ParamHintInfo)((Object)iterator2);
                    int n10 = n4;
                    n4 = n10 + 1;
                }
            } else if (matcher.group(2) != null) {
                n5 = n9;
            } else if (matcher.group(3) != null) {
                n6 = n9;
            } else {
                iterable = list2;
                String string2 = matcher.group(5);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"matcher.group(5)");
                String string3 = matcher.group(4);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"matcher.group(4)");
                boolean bl2 = StringsKt.startsWith$default((String)string3, (String)"H", (boolean)false, (int)2, null);
                String string4 = matcher.group(4);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"matcher.group(4)");
                object = new ParamHintInfo(n9, string2, bl2, StringsKt.endsWith$default((String)string4, (String)"INT", (boolean)false, (int)2, null));
                iterable.add(object);
            }
            this.a(document, n9, n8);
            n2 += matcher.end() - n7;
        }
        return new CaretAndInlaysInfo(n3, n4, n5 == null || n6 == null ? null : new TextRange(n5.intValue(), n6.intValue()), list2);
    }

    private final void a(Document document, int n2, int n3) {
        WriteCommandAction.runWriteCommandAction((Project)this.a.getProject(), (Runnable)new Runnable(document, n2, n3){
            final /* synthetic */ Document $document;
            final /* synthetic */ int $realStartOffset;
            final /* synthetic */ int $matchedLength;

            public final void run() {
                this.$document.replaceString(this.$realStartOffset, this.$realStartOffset + this.$matchedLength, (CharSequence)"");
            }
            {
                this.$document = document;
                this.$realStartOffset = n2;
                this.$matchedLength = n3;
            }
        });
    }

    public InlayHintsChecker(@NotNull CodeInsightTestFixture codeInsightTestFixture) {
        Intrinsics.checkParameterIsNotNull((Object)codeInsightTestFixture, (String)"myFixture");
        this.a = codeInsightTestFixture;
    }

    static {
        Companion = new Companion(null);
        Pattern pattern = Pattern.compile("(<caret>)|(<selection>)|(</selection>)|<(hint|HINT|Hint|hINT)\\s+text=\"([^\"\n\r]+)\"\\s*/>");
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"Pattern.compile(\"(<caret\u2026=\\\"([^\\\"\\n\\r]+)\\\"\\\\s*/>\")");
        c = pattern;
        b = new ParameterNameHintsSettings();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/testFramework/utils/inlays/InlayHintsChecker$Companion;", "", "()V", "default", "Lcom/intellij/codeInsight/hints/settings/ParameterNameHintsSettings;", "getDefault", "()Lcom/intellij/codeInsight/hints/settings/ParameterNameHintsSettings;", "pattern", "Ljava/util/regex/Pattern;", "getPattern", "()Ljava/util/regex/Pattern;", "intellij.platform.testFramework"})
    public static final class Companion {
        @NotNull
        public final Pattern getPattern() {
            return c;
        }

        private final ParameterNameHintsSettings a() {
            return b;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

