/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import java.text.MessageFormat;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;

public class JDOMCompare {
    private JDOMCompare() {
    }

    public static String diffElements(Element element, Element element2) {
        return JDOMCompare.diffElements(element, element2, "", 0);
    }

    public static String diffElements(Element element, Element element2, String string, int n2) {
        String string2;
        String string3 = element.getName();
        string = MessageFormat.format("{0}/{1}[{2}]", string, string3, n2);
        String string4 = element2.getName();
        if (!element.getName().equals(string4)) {
            return MessageFormat.format("Tag mismatch at {0}: expected={1}, actual={2}", string, string3, string4);
        }
        String string5 = element.getText().trim();
        String string6 = element2.getText().trim();
        if (string5 != null) {
            if (string6 == null) {
                return MessageFormat.format("Text content missing at {0}: expected={1}", string, string5);
            }
            if (!string5.equals(string6)) {
                return MessageFormat.format("Text content mismatch at {0}: expected={1}, actual={2}", string, string5, string6);
            }
        } else if (string6 != null) {
            return MessageFormat.format("Text content unexpected at {0}: actual={1}", string, string6);
        }
        if ((string2 = JDOMCompare.diffAttributes(element, element2, string, "missing")) != null) {
            return string2;
        }
        string2 = JDOMCompare.diffAttributes(element2, element, string, "unexpected");
        if (string2 != null) {
            return string2;
        }
        List list2 = element.getChildren();
        List list3 = element2.getChildren();
        for (int i2 = 0; i2 != list2.size(); ++i2) {
            Element element3 = (Element)list2.get(i2);
            if (i2 >= list3.size()) {
                return MessageFormat.format("Too few children at {0}, expected={1}, actual={2}, first missing tag={3}", string, list2.size(), list3.size(), element3.getName());
            }
            string2 = JDOMCompare.diffElements(element3, (Element)list3.get(i2), string, i2);
            if (string2 == null) continue;
            return string2;
        }
        if (list2.size() != list3.size()) {
            return MessageFormat.format("Too many children at {0}, expected={1}, actual={2}, first unexpected tag={3}", string, list2.size(), list3.size(), ((Element)list3.get(list2.size())).getName());
        }
        return null;
    }

    public static String diffAttributes(Element element, Element element2, String string, String string2) {
        for (Object e2 : element.getAttributes()) {
            Attribute attribute = (Attribute)e2;
            String string3 = attribute.getName();
            String string4 = attribute.getValue();
            String string5 = element2.getAttributeValue(string3);
            if (string5 == null) {
                return MessageFormat.format("Attribute {2} at {0}/@{1}", string, string3, string2);
            }
            if (string4.equals(string5)) continue;
            return MessageFormat.format("Attribute value mismatch at {0}/@{1}, expected={2}, actual={3}", string, string3, string4, string5);
        }
        return null;
    }
}

