/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.NamedEnumUtil;
import com.intellij.util.xml.NonExhaustiveEnum;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.xml.util.XmlUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnumConverter<T extends Enum>
extends ResolvingConverter<T> {
    private static final ConcurrentMap<Class, EnumConverter> b = ConcurrentFactoryMap.createMap(clazz -> new EnumConverter(clazz));
    private final Class<T> a;

    private EnumConverter(Class<T> clazz) {
        this.a = clazz;
    }

    public static <T extends Enum> EnumConverter<T> createEnumConverter(Class<T> clazz) {
        return (EnumConverter)((Object)b.get(clazz));
    }

    private String a(T t2) {
        return NamedEnumUtil.getEnumValueByElement(t2);
    }

    public final T fromString(String string, ConvertContext convertContext) {
        return (T)(string == null ? null : NamedEnumUtil.getEnumElementByValue(this.a, (String)string));
    }

    public final String toString(T t2, ConvertContext convertContext) {
        return t2 == null ? null : this.a(t2);
    }

    public String getErrorMessage(@Nullable String string, ConvertContext convertContext) {
        return CodeInsightBundle.message((String)"error.unknown.enum.value.message", (Object[])new Object[]{string});
    }

    @NotNull
    public Collection<? extends T> getVariants(ConvertContext convertContext) {
        XmlTag xmlTag;
        XmlElement xmlElement = convertContext.getXmlElement();
        if (xmlElement instanceof XmlTag && (xmlTag = XmlUtil.getSchemaSimpleContent((XmlTag)((XmlTag)xmlElement))) != null && XmlUtil.collectEnumerationValues((XmlTag)xmlTag, new HashSet())) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                EnumConverter.a(0);
            }
            return list2;
        }
        List<T> list3 = Arrays.asList(this.a.getEnumConstants());
        if (list3 == null) {
            EnumConverter.a(1);
        }
        return list3;
    }

    public boolean isExhaustive() {
        return !ReflectionUtil.isAssignable(NonExhaustiveEnum.class, this.a);
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/EnumConverter", "getVariants"));
    }
}

