/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.highlighting.DomElementsHighlightingUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomElementProblemDescriptorImpl
implements DomElementProblemDescriptor {
    private static final Logger a = Logger.getInstance((String)"#com.intellij.util.xml.highlighting.DomElementProblemDescriptorImpl");
    private final DomElement d;
    private final HighlightSeverity c;
    private final String e;
    private final LocalQuickFix[] f;
    private List<Annotation> g;
    private Pair<TextRange, PsiElement> b;
    public static final Pair<TextRange, PsiElement> NO_PROBLEM = new Pair(null, null);
    private final ProblemHighlightType h;

    public DomElementProblemDescriptorImpl(@NotNull DomElement domElement, String string, HighlightSeverity highlightSeverity) {
        if (domElement == null) {
            DomElementProblemDescriptorImpl.a(0);
        }
        this(domElement, string, highlightSeverity, LocalQuickFix.EMPTY_ARRAY);
    }

    public DomElementProblemDescriptorImpl(@NotNull DomElement domElement, String string, HighlightSeverity highlightSeverity, @Nullable TextRange textRange) {
        if (domElement == null) {
            DomElementProblemDescriptorImpl.a(1);
        }
        this(domElement, string, highlightSeverity, textRange, null, LocalQuickFix.EMPTY_ARRAY);
    }

    public DomElementProblemDescriptorImpl(@NotNull DomElement domElement, String string, HighlightSeverity highlightSeverity, LocalQuickFix ... localQuickFixArray) {
        if (domElement == null) {
            DomElementProblemDescriptorImpl.a(2);
        }
        if (localQuickFixArray == null) {
            DomElementProblemDescriptorImpl.a(3);
        }
        this(domElement, string, highlightSeverity, (TextRange)null, (ProblemHighlightType)null, localQuickFixArray);
    }

    public DomElementProblemDescriptorImpl(@NotNull DomElement domElement, String string, HighlightSeverity highlightSeverity, @Nullable TextRange textRange, ProblemHighlightType problemHighlightType, LocalQuickFix ... localQuickFixArray) {
        if (domElement == null) {
            DomElementProblemDescriptorImpl.a(4);
        }
        if (localQuickFixArray == null) {
            DomElementProblemDescriptorImpl.a(5);
        }
        this.d = domElement;
        XmlElement xmlElement = domElement.getXmlElement();
        if (xmlElement == null || !ApplicationManager.getApplication().isUnitTestMode()) {
            // empty if block
        }
        this.c = highlightSeverity;
        this.e = string;
        LocalQuickFix[] localQuickFixArray2 = this.f = ArrayUtil.contains(null, (Object[])localQuickFixArray) ? (LocalQuickFix[])ContainerUtil.mapNotNull((Object[])localQuickFixArray, (Function)FunctionUtil.id(), (Object[])LocalQuickFix.EMPTY_ARRAY) : localQuickFixArray;
        if (textRange != null) {
            PsiElement psiElement = this.b();
            a.assertTrue(psiElement != null, (Object)"Problems with explicit text range can't be created for DOM elements without underlying XML element");
            assert (psiElement.isValid());
            this.b = Pair.create((Object)textRange, (Object)psiElement);
        }
        this.h = problemHighlightType;
    }

    @NotNull
    public DomElement getDomElement() {
        DomElement domElement = this.d;
        if (domElement == null) {
            DomElementProblemDescriptorImpl.a(6);
        }
        return domElement;
    }

    @NotNull
    public HighlightSeverity getHighlightSeverity() {
        HighlightSeverity highlightSeverity = this.c;
        if (highlightSeverity == null) {
            DomElementProblemDescriptorImpl.a(7);
        }
        return highlightSeverity;
    }

    @NotNull
    public String getDescriptionTemplate() {
        String string = this.e == null ? "" : this.e;
        if (string == null) {
            DomElementProblemDescriptorImpl.a(8);
        }
        return string;
    }

    @NotNull
    public LocalQuickFix[] getFixes() {
        if (this.f == null) {
            DomElementProblemDescriptorImpl.a(9);
        }
        return this.f;
    }

    @NotNull
    public final List<Annotation> getAnnotations() {
        if (this.g == null) {
            this.g = ContainerUtil.createMaybeSingletonList((Object)DomElementsHighlightingUtil.createAnnotation(this));
        }
        List<Annotation> list2 = this.g;
        if (list2 == null) {
            DomElementProblemDescriptorImpl.a(10);
        }
        return list2;
    }

    public void highlightWholeElement() {
        PsiElement psiElement = this.b();
        if (psiElement instanceof XmlAttributeValue) {
            assert (psiElement.isValid()) : psiElement;
            PsiElement psiElement2 = psiElement.getParent();
            this.b = Pair.create((Object)new TextRange(0, psiElement2.getTextLength()), (Object)psiElement2);
        } else if (psiElement != null) {
            assert (psiElement.isValid()) : psiElement;
            XmlTag xmlTag = (XmlTag)(psiElement instanceof XmlTag ? psiElement : psiElement.getParent());
            this.b = new Pair((Object)new TextRange(0, xmlTag.getTextLength()), (Object)xmlTag);
        }
    }

    public Pair<TextRange, PsiElement> getProblemRange() {
        PsiElement psiElement;
        if (this.b == null) {
            this.b = this.computeProblemRange();
        }
        if ((psiElement = (PsiElement)this.b.second) != null) {
            PsiUtilCore.ensureValid((PsiElement)psiElement);
        }
        return this.b;
    }

    @NotNull
    protected Pair<TextRange, PsiElement> computeProblemRange() {
        PsiElement psiElement = this.b();
        if (psiElement != null) {
            String string;
            assert (psiElement.isValid()) : psiElement;
            if (psiElement instanceof XmlTag) {
                Pair pair2 = DomUtil.getProblemRange((XmlTag)((XmlTag)psiElement));
                if (pair2 == null) {
                    DomElementProblemDescriptorImpl.a(11);
                }
                return pair2;
            }
            int n2 = psiElement.getTextRange().getLength();
            TextRange textRange = TextRange.from((int)0, (int)n2);
            if (psiElement instanceof XmlAttributeValue && StringUtil.isNotEmpty((String)(string = ((XmlAttributeValue)psiElement).getValue()))) {
                textRange = TextRange.from((int)psiElement.getText().indexOf(string), (int)string.length());
            }
            Pair pair3 = Pair.create((Object)textRange, (Object)psiElement);
            if (pair3 == null) {
                DomElementProblemDescriptorImpl.a(12);
            }
            return pair3;
        }
        XmlTag xmlTag = this.a();
        if (xmlTag != null) {
            Pair pair4 = DomUtil.getProblemRange((XmlTag)xmlTag);
            if (pair4 == null) {
                DomElementProblemDescriptorImpl.a(13);
            }
            return pair4;
        }
        Pair<TextRange, PsiElement> pair5 = NO_PROBLEM;
        if (pair5 == null) {
            DomElementProblemDescriptorImpl.a(14);
        }
        return pair5;
    }

    public String toString() {
        return this.d + "; " + this.e;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DomElementProblemDescriptorImpl domElementProblemDescriptorImpl = (DomElementProblemDescriptorImpl)object;
        if (this.d != null ? !this.d.equals(domElementProblemDescriptorImpl.d) : domElementProblemDescriptorImpl.d != null) {
            return false;
        }
        if (!this.e.equals(domElementProblemDescriptorImpl.e)) {
            return false;
        }
        return this.c.equals((Object)domElementProblemDescriptorImpl.c);
    }

    public int hashCode() {
        int n2 = this.d != null ? this.d.hashCode() : 0;
        n2 = 31 * n2 + this.c.hashCode();
        n2 = 31 * n2 + this.e.hashCode();
        return n2;
    }

    @Nullable
    private PsiElement b() {
        XmlText[] xmlTextArray;
        if (this.d instanceof DomFileElement) {
            return ((DomFileElement)this.d).getFile();
        }
        if (this.d instanceof GenericAttributeValue) {
            GenericAttributeValue genericAttributeValue = (GenericAttributeValue)this.d;
            XmlAttributeValue xmlAttributeValue = genericAttributeValue.getXmlAttributeValue();
            return xmlAttributeValue != null && StringUtil.isNotEmpty((String)xmlAttributeValue.getText()) ? xmlAttributeValue : genericAttributeValue.getXmlElement();
        }
        XmlTag xmlTag = this.d.getXmlTag();
        if (this.d instanceof GenericValue && xmlTag != null && (xmlTextArray = xmlTag.getValue().getTextElements()).length > 0) {
            return xmlTextArray[0];
        }
        return xmlTag;
    }

    @Nullable
    private XmlTag a() {
        for (DomElement domElement = this.d.getParent(); domElement != null; domElement = domElement.getParent()) {
            if (domElement.getXmlTag() == null) continue;
            return domElement.getXmlTag();
        }
        return null;
    }

    @Nullable
    public ProblemHighlightType getHighlightType() {
        return this.h;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domElement";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/highlighting/DomElementProblemDescriptorImpl";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/highlighting/DomElementProblemDescriptorImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDomElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightSeverity";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptionTemplate";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixes";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "computeProblemRange";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

