/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.TrafficLightRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomChangeAdapter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomEventListener;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManagerImpl;
import com.intellij.util.xml.highlighting.DomElementsProblemsHolder;
import com.intellij.util.xml.highlighting.DomHighlightStatus;
import com.intellij.util.xml.ui.CommittablePanel;
import com.intellij.util.xml.ui.Highlightable;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class DomElementsErrorPanel
extends JPanel
implements CommittablePanel,
Highlightable {
    private static final int a = 241;
    private final Project d;
    private final DomElement[] e;
    private final DomElementsTrafficLightRenderer f;
    private final DomElementAnnotationsManagerImpl c;
    private final Alarm b = new Alarm();

    public DomElementsErrorPanel(DomElement ... domElementArray) {
        assert (domElementArray.length > 0);
        this.e = domElementArray;
        DomManager domManager = domElementArray[0].getManager();
        this.d = domManager.getProject();
        this.c = (DomElementAnnotationsManagerImpl)DomElementAnnotationsManager.getInstance((Project)this.d);
        this.setPreferredSize(DomElementsErrorPanel.b());
        this.f = new DomElementsTrafficLightRenderer(DomUtil.getFile((DomElement)domElementArray[0]));
        Disposer.register((Disposable)this, (Disposable)this.f);
        this.a();
        domManager.addDomEventListener((DomEventListener)new DomChangeAdapter(){

            protected void elementChanged(DomElement domElement) {
                DomElementsErrorPanel.this.a();
            }
        }, (Disposable)this);
    }

    public void updateHighlighting() {
        this.g();
    }

    private boolean e() {
        for (DomElement domElement : this.e) {
            if (domElement.isValid()) continue;
            return false;
        }
        return true;
    }

    private void g() {
        this.b.cancelAllRequests();
        if (!this.e()) {
            return;
        }
        this.repaint();
        this.setToolTipText(this.f.getTooltipMessage());
        if (!this.c()) {
            this.a();
        }
    }

    private boolean c() {
        return !this.e() || this.c.isHighlightingFinished(this.e);
    }

    private void a() {
        ApplicationManager.getApplication().invokeLater(() -> this.b.addRequest(() -> {
            if (this.d.isOpen() && !this.d.isDisposed()) {
                this.g();
            }
        }, 241));
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.f.paint(this, graphics, new Rectangle(0, 0, this.getWidth(), this.getHeight()));
    }

    public void dispose() {
        this.b.cancelAllRequests();
    }

    public JComponent getComponent() {
        return this;
    }

    public void commit() {
    }

    public void reset() {
        this.g();
    }

    private static Dimension b() {
        return new Dimension(AllIcons.General.ErrorsInProgress.getIconWidth() + 2, AllIcons.General.ErrorsInProgress.getIconHeight() + 2);
    }

    private class DomElementsTrafficLightRenderer
    extends TrafficLightRenderer {
        public DomElementsTrafficLightRenderer(XmlFile xmlFile) {
            if (xmlFile == null) {
                DomElementsTrafficLightRenderer.a(0);
            }
            super(xmlFile.getProject(), PsiDocumentManager.getInstance((Project)xmlFile.getProject()).getDocument((PsiFile)xmlFile), (PsiFile)xmlFile);
        }

        @NotNull
        protected TrafficLightRenderer.DaemonCodeAnalyzerStatus getDaemonCodeAnalyzerStatus(@NotNull SeverityRegistrar severityRegistrar) {
            if (severityRegistrar == null) {
                DomElementsTrafficLightRenderer.a(1);
            }
            TrafficLightRenderer.DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = super.getDaemonCodeAnalyzerStatus(severityRegistrar);
            if (this.isInspectionCompleted()) {
                daemonCodeAnalyzerStatus.errorAnalyzingFinished = true;
            }
            TrafficLightRenderer.DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus2 = daemonCodeAnalyzerStatus;
            if (daemonCodeAnalyzerStatus2 == null) {
                DomElementsTrafficLightRenderer.a(2);
            }
            return daemonCodeAnalyzerStatus2;
        }

        protected void fillDaemonCodeAnalyzerErrorsStatus(@NotNull TrafficLightRenderer.DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus, @NotNull SeverityRegistrar severityRegistrar) {
            if (daemonCodeAnalyzerStatus == null) {
                DomElementsTrafficLightRenderer.a(3);
            }
            if (severityRegistrar == null) {
                DomElementsTrafficLightRenderer.a(4);
            }
            for (int i2 = 0; i2 < daemonCodeAnalyzerStatus.errorCount.length; ++i2) {
                HighlightSeverity highlightSeverity = severityRegistrar.getSeverityByIndex(i2);
                if (highlightSeverity == null) continue;
                int n2 = 0;
                for (DomElement domElement : DomElementsErrorPanel.this.e) {
                    DomElementsProblemsHolder domElementsProblemsHolder = DomElementsErrorPanel.this.c.getCachedProblemHolder(domElement);
                    n2 += (SeverityRegistrar.getSeverityRegistrar((Project)this.getProject()).compare(highlightSeverity, HighlightSeverity.WARNING) >= 0 ? domElementsProblemsHolder.getProblems(domElement, true, true) : domElementsProblemsHolder.getProblems(domElement, true, highlightSeverity)).size();
                }
                daemonCodeAnalyzerStatus.errorCount[i2] = n2;
            }
        }

        protected boolean isInspectionCompleted() {
            return ContainerUtil.and((Object[])DomElementsErrorPanel.this.e, domElement -> DomElementsErrorPanel.this.c.getHighlightStatus((DomElement)domElement) == DomHighlightStatus.INSPECTIONS_FINISHED);
        }

        protected boolean isErrorAnalyzingFinished() {
            return ContainerUtil.and((Object[])DomElementsErrorPanel.this.e, domElement -> DomElementsErrorPanel.this.c.getHighlightStatus((DomElement)domElement).compareTo(DomHighlightStatus.ANNOTATORS_FINISHED) >= 0);
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 2: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "xmlFile";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "severityRegistrar";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/xml/highlighting/DomElementsErrorPanel$DomElementsTrafficLightRenderer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "status";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/xml/highlighting/DomElementsErrorPanel$DomElementsTrafficLightRenderer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDaemonCodeAnalyzerStatus";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getDaemonCodeAnalyzerStatus";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "fillDaemonCodeAnalyzerErrorsStatus";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

