/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Key;
import com.intellij.pom.Navigatable;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.xml.AnnotatedElement;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.JavaMethod;
import com.intellij.util.xml.JavaMethodSignature;
import com.intellij.util.xml.impl.DomImplUtil;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.Invocation;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class InvocationCache {
    private static final Map<JavaMethodSignature, Invocation> b = new HashMap<JavaMethodSignature, Invocation>();
    private final Map<Method, Invocation> d = ConcurrentFactoryMap.createMap(method -> b.get(new JavaMethodSignature(method)));
    private final Map<Method, JavaMethod> f;
    private final Map<JavaMethod, Boolean> e = ConcurrentFactoryMap.createMap(javaMethod -> DomImplUtil.isTagValueGetter(javaMethod));
    private final Map<JavaMethod, Boolean> h = ConcurrentFactoryMap.createMap(javaMethod -> DomImplUtil.isTagValueSetter(javaMethod));
    private final Map<JavaMethod, Map<Class, Object>> g = ConcurrentFactoryMap.createMap(javaMethod -> ConcurrentFactoryMap.createMap(clazz -> javaMethod.getAnnotation(clazz)));
    private final Map<Class, Object> a;
    private final Class c;

    private static void b(Class<?> clazz) {
        for (final Method method : ReflectionUtil.getClassDeclaredMethods(clazz)) {
            if ("equals".equals(method.getName())) {
                b.put(new JavaMethodSignature(method), new Invocation(){

                    @Override
                    public Object invoke(DomInvocationHandler<?, ?> domInvocationHandler, Object[] objectArray) throws Throwable {
                        Object object;
                        DomElement domElement = domInvocationHandler.getProxy();
                        if (domElement == (object = objectArray[0])) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (object instanceof DomElement) {
                            DomInvocationHandler domInvocationHandler2 = DomManagerImpl.getDomInvocationHandler(domElement);
                            return domInvocationHandler2 != null && domInvocationHandler2.equals((Object)DomManagerImpl.getDomInvocationHandler((DomElement)object));
                        }
                        return false;
                    }
                });
                continue;
            }
            if ("hashCode".equals(method.getName())) {
                b.put(new JavaMethodSignature(method), new Invocation(){

                    @Override
                    public Object invoke(DomInvocationHandler<?, ?> domInvocationHandler, Object[] objectArray) throws Throwable {
                        return domInvocationHandler.hashCode();
                    }
                });
                continue;
            }
            b.put(new JavaMethodSignature(method), new Invocation(){

                @Override
                public Object invoke(DomInvocationHandler<?, ?> domInvocationHandler, Object[] objectArray) throws Throwable {
                    return method.invoke((Object)domInvocationHandler, objectArray);
                }
            });
        }
    }

    public InvocationCache(Class clazz2) {
        this.c = clazz2;
        this.f = ConcurrentFactoryMap.createMap(method -> JavaMethod.getMethod((Class)this.c, (Method)method));
        this.a = ConcurrentFactoryMap.createMap(clazz -> this.c.getAnnotation(clazz));
    }

    @Nullable
    public Invocation getInvocation(Method method) {
        return this.d.get(method);
    }

    public JavaMethod getInternedMethod(Method method) {
        return this.f.get(method);
    }

    public void putInvocation(Method method, Invocation invocation) {
        this.d.put(method, invocation);
    }

    public boolean isTagValueGetter(JavaMethod javaMethod) {
        return this.e.get(javaMethod);
    }

    public boolean isTagValueSetter(JavaMethod javaMethod) {
        return this.h.get(javaMethod);
    }

    @Nullable
    public <T extends Annotation> T getMethodAnnotation(JavaMethod javaMethod, Class<T> clazz) {
        return (T)((Annotation)this.g.get(javaMethod).get(clazz));
    }

    @Nullable
    public <T extends Annotation> T getClassAnnotation(Class<T> clazz) {
        return (T)((Annotation)this.a.get(clazz));
    }

    static {
        InvocationCache.b(DomElement.class);
        InvocationCache.b(Navigatable.class);
        InvocationCache.b(AnnotatedElement.class);
        InvocationCache.b(Object.class);
        b.put(new JavaMethodSignature("getUserData", new Class[]{Key.class}), new Invocation(){

            @Override
            public Object invoke(DomInvocationHandler<?, ?> domInvocationHandler, Object[] objectArray) throws Throwable {
                return domInvocationHandler.getUserData((Key)objectArray[0]);
            }
        });
        b.put(new JavaMethodSignature("putUserData", new Class[]{Key.class, Object.class}), new Invocation(){

            @Override
            public Object invoke(DomInvocationHandler<?, ?> domInvocationHandler, Object[] objectArray) throws Throwable {
                domInvocationHandler.putUserData((Key)objectArray[0], objectArray[1]);
                return null;
            }
        });
        b.put(new JavaMethodSignature("getXmlElement", new Class[0]), new Invocation(){

            @Override
            public Object invoke(DomInvocationHandler<?, ?> domInvocationHandler, Object[] objectArray) throws Throwable {
                return domInvocationHandler.getXmlElement();
            }
        });
        b.put(new JavaMethodSignature("getXmlTag", new Class[0]), new Invocation(){

            @Override
            public Object invoke(DomInvocationHandler<?, ?> domInvocationHandler, Object[] objectArray) throws Throwable {
                return domInvocationHandler.getXmlTag();
            }
        });
        b.put(new JavaMethodSignature("getParent", new Class[0]), new Invocation(){

            @Override
            public Object invoke(DomInvocationHandler<?, ?> domInvocationHandler, Object[] objectArray) throws Throwable {
                return domInvocationHandler.getParent();
            }
        });
        b.put(new JavaMethodSignature("accept", new Class[]{DomElementVisitor.class}), new Invocation(){

            @Override
            public Object invoke(DomInvocationHandler<?, ?> domInvocationHandler, Object[] objectArray) throws Throwable {
                domInvocationHandler.accept((DomElementVisitor)objectArray[0]);
                return null;
            }
        });
        b.put(new JavaMethodSignature("acceptChildren", new Class[]{DomElementVisitor.class}), new Invocation(){

            @Override
            public Object invoke(DomInvocationHandler<?, ?> domInvocationHandler, Object[] objectArray) throws Throwable {
                domInvocationHandler.acceptChildren((DomElementVisitor)objectArray[0]);
                return null;
            }
        });
        b.put(new JavaMethodSignature("getAnnotation", new Class[]{Class.class}), new Invocation(){

            @Override
            public Object invoke(DomInvocationHandler<?, ?> domInvocationHandler, Object[] objectArray) throws Throwable {
                return domInvocationHandler.getAnnotation((Class)objectArray[0]);
            }
        });
        b.put(new JavaMethodSignature("getRawText", new Class[0]), new Invocation(){

            @Override
            public final Object invoke(DomInvocationHandler<?, ?> domInvocationHandler, Object[] objectArray) throws Throwable {
                return domInvocationHandler.getValue();
            }
        });
        b.put(new JavaMethodSignature("getXmlAttribute", new Class[0]), new Invocation(){

            @Override
            public final Object invoke(DomInvocationHandler<?, ?> domInvocationHandler, Object[] objectArray) throws Throwable {
                return domInvocationHandler.getXmlElement();
            }
        });
        b.put(new JavaMethodSignature("getXmlAttributeValue", new Class[0]), new Invocation(){

            @Override
            @Nullable
            public final Object invoke(DomInvocationHandler<?, ?> domInvocationHandler, Object[] objectArray) throws Throwable {
                XmlAttribute xmlAttribute = (XmlAttribute)domInvocationHandler.getXmlElement();
                return xmlAttribute != null ? xmlAttribute.getValueElement() : null;
            }
        });
        b.put(new JavaMethodSignature("getConverter", new Class[0]), new Invocation(){

            @Override
            public final Object invoke(DomInvocationHandler<?, ?> domInvocationHandler, Object[] objectArray) throws Throwable {
                try {
                    return domInvocationHandler.getScalarConverter();
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable.getCause();
                    if (throwable2 instanceof ProcessCanceledException) {
                        throw (ProcessCanceledException)throwable2;
                    }
                    throw new RuntimeException(throwable);
                }
            }
        });
    }
}

