/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.libraries.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ui.Util;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBComboBoxLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.editors.JBComboBoxTableCellEditorComponent;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SortedList;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.webcore.ScriptingFrameworkDescriptor;
import com.intellij.webcore.WebCoreBundle;
import com.intellij.webcore.libraries.LangScriptingContextProvider;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Queue;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractListModel;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditLibraryDialog
extends DialogWrapper {
    private static final int p = 0;
    private static final int t = 1;
    private final String m;
    private final String e;
    private static final Comparator<VirtualFile> f = (virtualFile, virtualFile2) -> virtualFile.getName().compareToIgnoreCase(virtualFile2.getName());
    private JPanel u;
    private JTextField k;
    private final JBTable w;
    private final JBList s;
    private JComboBox v;
    private JTextField d;
    private JRadioButton c;
    private JRadioButton y;
    private JPanel l;
    private JPanel j;
    private final Project i;
    private final FileTableModel o;
    private final LangScriptingContextProvider a;
    private final MyDocUrlListModel h;
    private ScriptingFrameworkDescriptor x;
    private final Icon n;
    private final Icon r;
    private final AnActionButton g;
    private final AnActionButton b;
    private final FileChooserDescriptor q;

    public EditLibraryDialog(String string, LangScriptingContextProvider langScriptingContextProvider, Project project2) {
        super(true);
        this.m();
        this.q = new FileChooserDescriptor(true, true, false, true, false, true){
            {
                this.setTitle(WebCoreBundle.message((String)"edit.library.attach.files.dialog.title", (Object[])new Object[0]));
            }

            public boolean isFileSelectable(VirtualFile virtualFile) {
                if (!virtualFile.isDirectory() && !EditLibraryDialog.this.a.acceptsExtension(virtualFile.getExtension())) {
                    return false;
                }
                return super.isFileSelectable(virtualFile);
            }

            public boolean isFileVisible(VirtualFile virtualFile, boolean bl2) {
                if (!virtualFile.isDirectory() && !EditLibraryDialog.this.a.acceptsExtension(virtualFile.getExtension())) {
                    return false;
                }
                return super.isFileVisible(virtualFile, bl2);
            }
        };
        this.n = langScriptingContextProvider.getFileIcon();
        this.r = AllIcons.Nodes.Folder;
        this.a = langScriptingContextProvider;
        this.i = project2;
        this.w = new JBTable();
        this.w.setStriped(true);
        this.w.setUpdateSelectionOnSort(true);
        JPanel jPanel = ToolbarDecorator.createDecorator((JTable)this.w).disableUpAction().disableDownAction().setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                List list2 = EditLibraryDialog.this.b();
                if (list2.isEmpty()) {
                    return;
                }
                DefaultActionGroup defaultActionGroup = new DefaultActionGroup(list2.toArray(AnAction.EMPTY_ARRAY));
                JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)defaultActionGroup, DataManager.getInstance().getDataContext((Component)anActionButton.getContextComponent()), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true).show(anActionButton.getPreferredPopupPoint());
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                EditLibraryDialog.this.l();
            }
        }).createPanel();
        this.l.add((Component)jPanel, "Center");
        this.setTitle(string);
        this.m = langScriptingContextProvider.getLibraryTypeName(OrderRootType.SOURCES);
        this.e = langScriptingContextProvider.getLibraryTypeName(OrderRootType.CLASSES);
        this.o = new FileTableModel();
        this.w.setRowHeight(this.w.getRowHeight() + 5);
        this.w.setModel((TableModel)this.o);
        new TableSpeedSearch((JTable)this.w);
        this.h = new MyDocUrlListModel();
        this.s = new JBList((ListModel)this.h);
        this.h.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent listDataEvent) {
                EditLibraryDialog.this.n();
            }

            @Override
            public void intervalRemoved(ListDataEvent listDataEvent) {
                Object object = listDataEvent.getSource();
                if (object instanceof MyDocUrlListModel && ((MyDocUrlListModel)object).getDocUrls().length == 0) {
                    EditLibraryDialog.this.n();
                }
            }

            @Override
            public void contentsChanged(ListDataEvent listDataEvent) {
            }
        });
        this.s.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                EditLibraryDialog.this.b.setEnabled(EditLibraryDialog.this.s.getSelectedIndex() >= 0);
            }
        });
        this.g = new AnActionButton("Download", AllIcons.Actions.Download){

            public void actionPerformed(@NotNull AnActionEvent anActionEvent) {
                if (anActionEvent == null) {
                    5.a(0);
                }
                EditLibraryDialog.this.i();
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/webcore/libraries/ui/EditLibraryDialog$5", "actionPerformed"));
            }
        };
        this.b = new AnActionButton("Edit", AllIcons.ToolbarDecorator.Edit){

            public void actionPerformed(@NotNull AnActionEvent anActionEvent) {
                if (anActionEvent == null) {
                    6.a(0);
                }
                EditLibraryDialog.this.j();
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/webcore/libraries/ui/EditLibraryDialog$6", "actionPerformed"));
            }
        };
        this.j.add((Component)ToolbarDecorator.createDecorator((JList)this.s).disableUpDownActions().setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                EditLibraryDialog.this.c();
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                EditLibraryDialog.this.a();
            }
        }).addExtraAction(this.b).addExtraAction(this.g).createPanel(), "Center");
        this.g.setEnabled(false);
        this.b.setEnabled(false);
        this.f();
        this.d.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                EditLibraryDialog.this.k();
            }
        });
        this.init();
        TableColumn tableColumn = this.w.getColumnModel().getColumn(1);
        tableColumn.setMaxWidth(80);
        tableColumn.setCellEditor((TableCellEditor)((Object)new TypeCellEditor()));
        tableColumn.setCellRenderer(new DefaultTableCellRenderer(){
            private final JBComboBoxLabel a = new JBComboBoxLabel();

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
                VirtualFile virtualFile = EditLibraryDialog.this.o.getFileAt(n2);
                if (virtualFile == null || virtualFile.isDirectory()) {
                    this.a.setText("");
                    this.a.setIcon(null);
                } else {
                    this.a.setText(String.valueOf(object));
                    if (bl2) {
                        this.a.setSelectionIcon();
                    } else {
                        this.a.setRegularIcon();
                    }
                }
                this.a.setBackground(bl2 ? jTable.getSelectionBackground() : jTable.getBackground());
                this.a.setForeground(bl2 ? jTable.getSelectionForeground() : jTable.getForeground());
                return this.a;
            }
        });
        TableColumn tableColumn2 = this.w.getColumnModel().getColumn(0);
        tableColumn2.setCellRenderer(new FileNameTableCellRenderer());
    }

    @NotNull
    private List<AnAction> b() {
        ArrayList arrayList = ContainerUtil.newArrayList((Object[])new AnAction[]{new AnAction(WebCoreBundle.message((String)"edit.library.attach.files.popup.title", (Object[])new Object[0]), null, this.n){

            public void actionPerformed(@NotNull AnActionEvent anActionEvent) {
                if (anActionEvent == null) {
                    11.a(0);
                }
                EditLibraryDialog.this.d();
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/webcore/libraries/ui/EditLibraryDialog$11", "actionPerformed"));
            }
        }, new AnAction(WebCoreBundle.message((String)"edit.library.attach.directories.popup.title", (Object[])new Object[0]), null, this.r){

            public void actionPerformed(@NotNull AnActionEvent anActionEvent) {
                if (anActionEvent == null) {
                    12.a(0);
                }
                EditLibraryDialog.this.g();
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/webcore/libraries/ui/EditLibraryDialog$12", "actionPerformed"));
            }
        }});
        if (arrayList == null) {
            EditLibraryDialog.a(0);
        }
        return arrayList;
    }

    public EditLibraryDialog(String string, LangScriptingContextProvider langScriptingContextProvider, Project project2, ScriptingLibraryModel scriptingLibraryModel) {
        this(string, langScriptingContextProvider, project2);
        this.k.setText(scriptingLibraryModel.getName());
        this.o.setFiles(scriptingLibraryModel.getSourceFiles(), scriptingLibraryModel.getCompactFiles());
        Set set = scriptingLibraryModel.getDocUrls();
        this.h.setDocUrls(set);
        if (scriptingLibraryModel.getFrameworkDescriptor() != null) {
            this.a(scriptingLibraryModel.getFrameworkDescriptor());
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.c);
        buttonGroup.add(this.y);
        if (scriptingLibraryModel.getLibraryLevel() == ScriptingLibraryModel.LibraryLevel.GLOBAL) {
            this.y.setSelected(true);
        } else {
            this.c.setSelected(true);
        }
        this.n();
    }

    private void a(ScriptingFrameworkDescriptor scriptingFrameworkDescriptor) {
        this.x = scriptingFrameworkDescriptor;
        this.d.setText(scriptingFrameworkDescriptor.getFrameworkVersion());
        for (int i2 = 0; i2 < this.v.getItemCount(); ++i2) {
            Object e2 = this.v.getItemAt(i2);
            if (!(e2 instanceof ScriptingFrameworkDescriptor) || !scriptingFrameworkDescriptor.getFrameworkName().equals(((ScriptingFrameworkDescriptor)e2).getFrameworkName())) continue;
            this.v.setSelectedItem(e2);
        }
    }

    private void n() {
        for (String string : this.getDocUrls()) {
            if (this.a.getOfflineDocUrl(string) == null) continue;
            this.g.setEnabled(true);
            return;
        }
        this.g.setEnabled(false);
    }

    private void f() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ScriptingFrameworkDescriptor[] scriptingFrameworkDescriptorArray = this.a.getSupportedFrameworks(this.i);
        arrayList.add(new String("<Custom>"));
        if (scriptingFrameworkDescriptorArray != null) {
            arrayList.addAll(Arrays.asList(scriptingFrameworkDescriptorArray));
        }
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(ArrayUtil.toObjectArray(arrayList));
        this.v.setModel(defaultComboBoxModel);
        this.v.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = EditLibraryDialog.this.v.getSelectedItem();
                if (object instanceof ScriptingFrameworkDescriptor) {
                    String string = ((ScriptingFrameworkDescriptor)object).getFrameworkName();
                    if (EditLibraryDialog.this.x == null || !string.equals(EditLibraryDialog.this.x.getFrameworkName())) {
                        EditLibraryDialog.this.x = new ScriptingFrameworkDescriptor(((ScriptingFrameworkDescriptor)object).getFrameworkName(), null);
                        EditLibraryDialog.this.d.setText("");
                    }
                } else {
                    EditLibraryDialog.this.x = null;
                    EditLibraryDialog.this.d.setText("");
                }
            }
        });
    }

    private void i() {
        LinkedHashSet linkedHashSet = ContainerUtil.newLinkedHashSet();
        for (String string : this.getDocUrls()) {
            String string2 = this.a.getOfflineDocUrl(string);
            if (string2 == null) continue;
            linkedHashSet.add(string2);
        }
        this.a(ContainerUtil.newLinkedList((Iterable)linkedHashSet), this.getRootPane());
    }

    private void a(@NotNull Queue<String> queue, @Nullable Component component) {
        if (queue == null) {
            EditLibraryDialog.a(1);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        String string = queue.poll();
        if (string != null) {
            this.a.downloadOfflineDoc(this.i, string, component, (Consumer<File>)((Consumer)file -> {
                if (queue == null) {
                    EditLibraryDialog.a(4);
                }
                AtomicBoolean atomicBoolean = new AtomicBoolean(true);
                if (file != null) {
                    WriteAction.run(() -> {
                        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)file, (boolean)true);
                        if (virtualFile != null) {
                            atomicBoolean.set(false);
                            this.h.addUrl(virtualFile.getUrl());
                        }
                    });
                }
                if (atomicBoolean.get()) {
                    this.a(queue, component);
                }
            }));
        }
    }

    protected JComponent createCenterPanel() {
        return this.u;
    }

    public String getLibName() {
        return this.k.getText();
    }

    private void d() {
        VirtualFile[] virtualFileArray = FileChooser.chooseFiles((FileChooserDescriptor)this.q, (Project)this.i, null);
        if (virtualFileArray.length == 0) {
            return;
        }
        VfsUtilCore.DistinctVFilesRootsCollection distinctVFilesRootsCollection = new VfsUtilCore.DistinctVFilesRootsCollection(virtualFileArray);
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : distinctVFilesRootsCollection) {
            if (!virtualFile.isValid()) continue;
            if (virtualFile.isDirectory()) {
                this.a(virtualFile, arrayList);
                continue;
            }
            arrayList.add(virtualFile);
        }
        this.a(arrayList);
    }

    private void g() {
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createMultipleFoldersDescriptor();
        fileChooserDescriptor.setTitle(WebCoreBundle.message((String)"edit.library.dialog.attach.directories.dialog.title", (Object[])new Object[0]));
        VirtualFile[] virtualFileArray = FileChooser.chooseFiles((FileChooserDescriptor)fileChooserDescriptor, (Project)this.i, null);
        if (virtualFileArray.length == 0) {
            return;
        }
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : virtualFileArray) {
            if (!virtualFile.isValid()) continue;
            arrayList.add(virtualFile);
        }
        this.a(arrayList);
    }

    private void a(@NotNull List<VirtualFile> list2) {
        if (list2 == null) {
            EditLibraryDialog.a(2);
        }
        Collections.sort(list2, f);
        int n2 = 0;
        for (VirtualFile virtualFile : list2) {
            this.a(virtualFile, n2++ == list2.size() - 1);
        }
        this.h();
        if (this.k.getText().isEmpty() && !list2.isEmpty()) {
            this.k.setText(list2.get(0).getName());
        }
    }

    private void a(VirtualFile virtualFile, final Collection<VirtualFile> collection) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)virtualFile, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile virtualFile) {
                if (virtualFile == null) {
                    14.a(0);
                }
                if (virtualFile.isValid() && !virtualFile.isDirectory() && EditLibraryDialog.this.a.acceptsExtension(virtualFile.getExtension())) {
                    collection.add(virtualFile);
                }
                return true;
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/webcore/libraries/ui/EditLibraryDialog$14", "visitFile"));
            }
        });
    }

    private void a(VirtualFile virtualFile, boolean bl2) {
        int n2 = this.o.addFile(virtualFile);
        this.w.setRowSelectionInterval(n2, n2);
        if (bl2) {
            TableUtil.scrollSelectionToVisible((JTable)this.w);
        }
    }

    private void l() {
        int[] nArray = this.w.getSelectedRows();
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
        for (int n2 : nArray) {
            arrayList.add(this.o.getFileAt(n2));
        }
        this.o.removeFiles(arrayList);
    }

    public VirtualFile[] getSourceFiles() {
        return this.o.a();
    }

    public VirtualFile[] getCompactFiles() {
        return this.o.getCompactFiles();
    }

    public String[] getDocUrls() {
        return this.h.getDocUrls();
    }

    protected void doOKAction() {
        if (!EditLibraryDialog.a(this.k.getText())) {
            Messages.showErrorDialog((Project)this.i, (String)IdeBundle.message((String)"scripting.lib.invalid.name", (Object[])new Object[0]), (String)"Error");
            return;
        }
        super.doOKAction();
    }

    private static boolean a(String string) {
        return string != null && string.matches("\\w[\\w\\d\\._\\-\\d ]*");
    }

    private void j() {
        String string = (String)this.s.getSelectedValue();
        int n2 = this.s.getSelectedIndex();
        VirtualFile virtualFile = Util.showSpecifyJavadocUrlDialog((JComponent)this.u, (String)string);
        if (virtualFile != null && virtualFile.isValid()) {
            String string2 = virtualFile.getUrl();
            this.h.replaceUrl(string, string2);
            this.s.ensureIndexIsVisible(n2);
            this.s.setSelectedIndex(n2);
            this.n();
        }
    }

    private void c() {
        VirtualFile virtualFile;
        String string = null;
        if (this.x == null) {
            this.h();
        }
        if (this.x != null) {
            string = this.e();
        }
        if ((virtualFile = Util.showSpecifyJavadocUrlDialog((JComponent)this.u, (String)(string != null ? string : ""))) != null && virtualFile.isValid()) {
            String string2 = virtualFile.getUrl();
            int n2 = this.h.addUrl(string2);
            this.s.ensureIndexIsVisible(n2);
            this.s.setSelectedIndex(n2);
            this.n();
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.k;
    }

    @Nullable
    private String e() {
        String string = this.a.getDefaultDocUrl(this.x);
        if (string != null && !this.h.contains(string)) {
            return string;
        }
        return null;
    }

    private void a() {
        this.h.remove((String)this.s.getSelectedValue());
    }

    @Nullable
    public ScriptingFrameworkDescriptor getSelectedFramework() {
        return this.x;
    }

    private void h() {
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
        arrayList.addAll(Arrays.asList(this.o.getCompactFiles()));
        arrayList.addAll(Arrays.asList(this.o.a()));
        for (VirtualFile virtualFile : arrayList) {
            ScriptingFrameworkDescriptor scriptingFrameworkDescriptor = this.a.detectFramework(virtualFile);
            if (scriptingFrameworkDescriptor == null) continue;
            this.d.setText(scriptingFrameworkDescriptor.getFrameworkVersion());
            this.a(scriptingFrameworkDescriptor);
            if (this.k.getText().isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(scriptingFrameworkDescriptor.getFrameworkName());
                if (scriptingFrameworkDescriptor.getFrameworkVersion() != null) {
                    stringBuilder.append(' ').append(scriptingFrameworkDescriptor.getFrameworkVersion());
                }
                this.k.setText(stringBuilder.toString());
            }
            return;
        }
    }

    private void k() {
        if (this.x != null) {
            this.x.setFrameworkVersion(this.d.getText());
        }
    }

    @NotNull
    public ScriptingLibraryModel.LibraryLevel getLibraryLevel() {
        ScriptingLibraryModel.LibraryLevel libraryLevel = this.y.isSelected() ? ScriptingLibraryModel.LibraryLevel.GLOBAL : ScriptingLibraryModel.LibraryLevel.PROJECT;
        if (libraryLevel == null) {
            EditLibraryDialog.a(3);
        }
        return libraryLevel;
    }

    static /* synthetic */ Comparator access$2400() {
        return f;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/webcore/libraries/ui/EditLibraryDialog";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToAdd";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddFilesActions";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/webcore/libraries/ui/EditLibraryDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryLevel";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processUrlQueue";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addVirtualFiles";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processUrlQueue$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void m() {
        JPanel jPanel;
        JPanel jPanel2;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JTextField jTextField;
        JComboBox jComboBox;
        JTextField jTextField2;
        JPanel jPanel3;
        this.u = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        this.k = jTextField2 = new JTextField();
        jPanel4.add((Component)jTextField2, new GridConstraints(0, 1, 1, 4, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel = new JLabel();
        this.a(jLabel, ResourceBundle.getBundle("messages/IdeBundle").getString("scripting.lib.name"));
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Framework type:");
        jLabel2.setDisplayedMnemonic('F');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.v = jComboBox = new JComboBox();
        jPanel4.add(jComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Version:");
        jLabel3.setDisplayedMnemonic('V');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jLabel3, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.d = jTextField = new JTextField();
        jPanel4.add((Component)jTextField, new GridConstraints(1, 3, 1, 1, 8, 1, 6, 0, null, new Dimension(55, -1), new Dimension(55, -1)));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Visibility:");
        jPanel4.add((Component)jLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(2, 1, 1, 4, 0, 3, 3, 3, null, null, null));
        this.c = jRadioButton2 = new JRadioButton();
        jRadioButton2.setSelected(true);
        jRadioButton2.setText("Project");
        jRadioButton2.setMnemonic('P');
        jRadioButton2.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.y = jRadioButton = new JRadioButton();
        jRadioButton.setText("Global");
        jRadioButton.setMnemonic('G');
        jRadioButton.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jRadioButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(1, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        this.l = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 2, 7, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel3.add((Component)jPanel6, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 2, null, null, null));
        jPanel6.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/IdeBundle").getString("scripting.lib.docUrl.title"), (int)0, (int)0, null, null));
        this.j = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel6.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        jLabel.setLabelFor(jTextField2);
        jLabel2.setLabelFor(jComboBox);
        jLabel3.setLabelFor(jTextField);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.u;
    }

    private /* synthetic */ void a(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        char c2 = '\u0000';
        int n2 = -1;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (string.charAt(i2) == '&') {
                if (++i2 == string.length()) break;
                if (!bl2 && string.charAt(i2) != '&') {
                    bl2 = true;
                    c2 = string.charAt(i2);
                    n2 = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i2));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl2) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n2);
        }
    }

    private static class MyDocUrlListModel
    extends AbstractListModel {
        private final ArrayList<String> a = new ArrayList();

        private MyDocUrlListModel() {
        }

        public void setDocUrls(Set<String> set) {
            if (set != null && set.size() > 0) {
                this.a.addAll(set);
            }
        }

        @Override
        public int getSize() {
            return this.a.size();
        }

        @Override
        public Object getElementAt(int n2) {
            return this.a.get(n2);
        }

        public int addUrl(String string) {
            if (!this.a.contains(string)) {
                this.a.add(string);
                int n2 = this.a.indexOf(string);
                this.fireIntervalAdded(this, n2, n2);
                return n2;
            }
            return this.a.indexOf(string);
        }

        public void replaceUrl(String string, String string2) {
            if (string == null || !this.a.contains(string)) {
                return;
            }
            int n2 = this.a.indexOf(string);
            this.a.remove(string);
            this.a.add(n2, string2);
        }

        public int indexOf(String string) {
            return this.a.indexOf(string);
        }

        public void remove(String string) {
            if (string == null || !this.a.contains(string)) {
                return;
            }
            int n2 = this.a.indexOf(string);
            this.a.remove(string);
            this.fireIntervalRemoved(this, n2, n2);
        }

        public boolean contains(String string) {
            return this.a.contains(string);
        }

        public String[] getDocUrls() {
            return ArrayUtil.toStringArray(this.a);
        }
    }

    private class FileTableModel
    extends AbstractTableModel {
        private final SortedList<VirtualFile> b = new SortedList(EditLibraryDialog.access$2400());
        private final HashSet<VirtualFile> a = new HashSet();

        private FileTableModel() {
        }

        @Override
        public String getColumnName(int n2) {
            switch (n2) {
                case 0: {
                    return IdeBundle.message((String)"scripting.lib.file.name", (Object[])new Object[0]);
                }
                case 1: {
                    return IdeBundle.message((String)"scripting.lib.file.type", (Object[])new Object[0]);
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n2, int n3) {
            VirtualFile virtualFile;
            return n3 == 1 && (virtualFile = this.getFileAt(n2)) != null && !virtualFile.isDirectory();
        }

        @Override
        public void setValueAt(Object object, int n2, int n3) {
            VirtualFile virtualFile;
            if (n3 == 1 && (virtualFile = EditLibraryDialog.this.o.getFileAt(n2)) != null) {
                this.a(virtualFile, EditLibraryDialog.this.e.equals(object));
            }
        }

        public int addFile(VirtualFile virtualFile) {
            this.b.add((Object)virtualFile);
            if (!virtualFile.isDirectory() && EditLibraryDialog.this.a.isCompact(virtualFile)) {
                this.a.add(virtualFile);
            }
            this.fireTableDataChanged();
            return this.b.indexOf((Object)virtualFile);
        }

        public void setFiles(Set<VirtualFile> set, Set<VirtualFile> set2) {
            this.b.clear();
            this.b.addAll(set);
            this.b.addAll(set2);
            for (VirtualFile virtualFile : set) {
                this.a(virtualFile, false, false);
            }
            for (VirtualFile virtualFile : set2) {
                this.a(virtualFile, true, false);
            }
        }

        private void a(VirtualFile virtualFile, boolean bl2) {
            this.a(virtualFile, bl2, true);
        }

        private void a(VirtualFile virtualFile, boolean bl2, boolean bl3) {
            boolean bl4 = false;
            if (bl2 && !virtualFile.isDirectory()) {
                if (!this.a.contains(virtualFile)) {
                    this.a.add(virtualFile);
                    bl4 = true;
                }
            } else if (this.a.contains(virtualFile)) {
                this.a.remove(virtualFile);
                bl4 = true;
            }
            if (bl4 && bl3) {
                this.fireTableDataChanged();
            }
        }

        @Override
        public int getRowCount() {
            return this.b.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int n2, int n3) {
            VirtualFile virtualFile = (VirtualFile)this.b.get(n2);
            switch (n3) {
                case 0: {
                    return virtualFile.getPresentableName();
                }
                case 1: {
                    return this.a.contains(virtualFile) ? EditLibraryDialog.this.e : EditLibraryDialog.this.m;
                }
            }
            return "";
        }

        @Nullable
        public VirtualFile getFileAt(int n2) {
            if (n2 < 0 || n2 >= this.b.size()) {
                return null;
            }
            return (VirtualFile)this.b.get(n2);
        }

        public void removeFile(VirtualFile virtualFile) {
            if (this.b.remove((Object)virtualFile)) {
                this.fireTableDataChanged();
            }
        }

        public void removeFiles(List<VirtualFile> list2) {
            if (this.b.removeAll(list2)) {
                this.fireTableDataChanged();
            }
        }

        private VirtualFile[] a(boolean bl2) {
            ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
            for (VirtualFile virtualFile : this.b) {
                if (this.a.contains(virtualFile) != bl2) continue;
                arrayList.add(virtualFile);
            }
            return arrayList.toArray(VirtualFile.EMPTY_ARRAY);
        }

        public VirtualFile[] getCompactFiles() {
            return this.a(true);
        }

        private VirtualFile[] a() {
            return this.a(false);
        }
    }

    private class TypeCellEditor
    extends AbstractTableCellEditor {
        private final JBComboBoxTableCellEditorComponent a = new JBComboBoxTableCellEditorComponent();

        public TypeCellEditor() {
            this.a.setOptions(new Object[]{EditLibraryDialog.this.m, EditLibraryDialog.this.e});
            this.a.setToString(object -> (String)object);
        }

        public Object getCellEditorValue() {
            return this.a.getEditorValue();
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl2, int n2, int n3) {
            VirtualFile virtualFile = EditLibraryDialog.this.o.getFileAt(n2);
            this.a.setCell(jTable, n2, n3);
            if (virtualFile != null) {
                Object object2 = EditLibraryDialog.this.o.getValueAt(n2, 1);
                this.a.setDefaultValue(object2);
            }
            return this.a;
        }
    }

    private class FileNameTableCellRenderer
    extends DefaultTableCellRenderer {
        private FileNameTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl2, bl3, n2, n3);
            if (component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                VirtualFile virtualFile = EditLibraryDialog.this.o.getFileAt(n2);
                if (virtualFile != null) {
                    jLabel.setToolTipText(virtualFile.getPresentableUrl());
                    jLabel.setIcon(virtualFile.isDirectory() ? EditLibraryDialog.this.r : EditLibraryDialog.this.n);
                }
                jLabel.setBorder(null);
            }
            return component;
        }
    }
}

