/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.libraries.ui.download;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.download.DownloadableFileSetVersions;
import com.intellij.webcore.libraries.LangScriptingContextProvider;
import com.intellij.webcore.libraries.ui.download.AdditionalDownloadableLibraryProvider;
import com.intellij.webcore.libraries.ui.download.DefaultDownloadableWebLibrariesSource;
import com.intellij.webcore.libraries.ui.download.DownloadableFileSetDescriptionWithUrl;
import com.intellij.webcore.libraries.ui.download.DownloadableWebLibrariesSource;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DownloadWebLibraryDialog
extends DialogWrapper {
    private JPanel a;
    private JBTable d;
    private JLabel b;
    private DownloadableFileSetDescriptionWithUrl c;

    public DownloadWebLibraryDialog(@NotNull Project project2, LangScriptingContextProvider langScriptingContextProvider) {
        if (project2 == null) {
            DownloadWebLibraryDialog.a(0);
        }
        super(project2);
        this.a();
        this.setTitle("Download Library");
        this.setOKButtonText("Download and Install");
        this.setCancelButtonText("Close");
        this.setOKActionEnabled(false);
        this.d.setSelectionMode(0);
        DefaultComboBoxModel<DefaultDownloadableWebLibrariesSource> defaultComboBoxModel = new DefaultComboBoxModel<DefaultDownloadableWebLibrariesSource>();
        defaultComboBoxModel.addElement(new DefaultDownloadableWebLibrariesSource(project2, langScriptingContextProvider));
        DownloadableWebLibrariesSource downloadableWebLibrariesSource = AdditionalDownloadableLibraryProvider.getLibrary(project2);
        if (downloadableWebLibrariesSource != null) {
            this.b.setText(downloadableWebLibrariesSource.toString());
            this.a(project2, downloadableWebLibrariesSource, langScriptingContextProvider);
        }
        this.init();
        TableColumnModel tableColumnModel = this.d.getColumnModel();
        int[] nArray = new int[]{100, 20, 300};
        for (int i2 = 0; i2 < tableColumnModel.getColumnCount(); ++i2) {
            tableColumnModel.getColumn(i2).setPreferredWidth(nArray[i2]);
        }
        new TableSpeedSearch((JTable)this.d).setComparator(new SpeedSearchComparator(true));
        this.d.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                TableModel tableModel = DownloadWebLibraryDialog.this.d.getModel();
                if (tableModel instanceof MyLibraryTableModel) {
                    DownloadWebLibraryDialog.this.setOKActionEnabled(true);
                    DownloadWebLibraryDialog.this.c = ((MyLibraryTableModel)tableModel).getDescriptionAt(DownloadWebLibraryDialog.this.d.getSelectedRow());
                }
            }
        });
    }

    private void a(final @NotNull Project project2, final @NotNull DownloadableWebLibrariesSource downloadableWebLibrariesSource, final @NotNull LangScriptingContextProvider langScriptingContextProvider) {
        if (project2 == null) {
            DownloadWebLibraryDialog.a(1);
        }
        if (downloadableWebLibrariesSource == null) {
            DownloadWebLibraryDialog.a(2);
        }
        if (langScriptingContextProvider == null) {
            DownloadWebLibraryDialog.a(3);
        }
        final DefaultTableModel defaultTableModel = new DefaultTableModel(new Object[]{"Fetching a list of libraries..."}, 1){

            @Override
            public boolean isCellEditable(int n2, int n3) {
                return false;
            }
        };
        this.setOKActionEnabled(false);
        this.d.setModel((TableModel)defaultTableModel);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (downloadableWebLibrariesSource == null) {
                DownloadWebLibraryDialog.a(4);
            }
            if (langScriptingContextProvider == null) {
                DownloadWebLibraryDialog.a(5);
            }
            if (project2 == null) {
                DownloadWebLibraryDialog.a(6);
            }
            downloadableWebLibrariesSource.prepareTableModel(new DownloadableFileSetVersions.FileSetVersionsCallback<DownloadableFileSetDescriptionWithUrl>(){

                public void onSuccess(@NotNull List<? extends DownloadableFileSetDescriptionWithUrl> list2) {
                    if (list2 == null) {
                        3.a(0);
                    }
                    if (list2.size() > 0) {
                        langScriptingContextProvider.filterExistingLibraries(project2, list2);
                        ApplicationManager.getApplication().invokeLater(() -> {
                            if (list2 == null) {
                                3.a(3);
                            }
                            if (downloadableWebLibrariesSource == null) {
                                3.a(4);
                            }
                            DownloadWebLibraryDialog.this.d.setModel((TableModel)new MyLibraryTableModel(list2, downloadableWebLibrariesSource.includeVersionColumn()));
                        }, ModalityState.any());
                    }
                }

                public void onError(@NotNull String string) {
                    if (string == null) {
                        3.a(1);
                    }
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (string == null) {
                            3.a(2);
                        }
                        defaultTableModel.setColumnIdentifiers(new Object[]{"Error while fetching list of libraries: " + string});
                    }, ModalityState.any());
                }

                private static /* synthetic */ void a(int n2) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n2) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "versions";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "errorMessage";
                            break;
                        }
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "librariesSource";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/webcore/libraries/ui/download/DownloadWebLibraryDialog$3";
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onSuccess";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onError";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "lambda$onError$1";
                            break;
                        }
                        case 3: 
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[2] = "lambda$onSuccess$0";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        });
    }

    @Nullable
    protected String getHelpId() {
        return "JavaScript.Libraries";
    }

    protected JComponent createCenterPanel() {
        return this.a;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.a;
    }

    @Nullable
    public DownloadableFileSetDescriptionWithUrl getSelection() {
        return this.c;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "librariesSource";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        objectArray2[1] = "com/intellij/webcore/libraries/ui/download/DownloadWebLibraryDialog";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "populate";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$populate$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void a() {
        JLabel jLabel;
        JBTable jBTable;
        JPanel jPanel;
        this.a = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.d = jBTable = new JBTable();
        jBTable.setAutoResizeMode(2);
        jBTable.setStriped(true);
        jBScrollPane.setViewportView((Component)jBTable);
        this.b = jLabel = new JLabel();
        jLabel.setText("No libraries available");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.a;
    }

    private static class MyLibraryTableModel
    extends AbstractTableModel {
        private final int e;
        private final int c;
        private final int a;
        private final List<? extends DownloadableFileSetDescriptionWithUrl> b;
        private final boolean d;

        public MyLibraryTableModel(List<? extends DownloadableFileSetDescriptionWithUrl> list2, boolean bl2) {
            this.b = list2;
            this.d = bl2;
            this.e = 0;
            this.c = this.d ? 1 : -1;
            this.a = this.d ? 2 : 1;
            Collections.sort(this.b, (downloadableFileSetDescription, downloadableFileSetDescription2) -> {
                if (downloadableFileSetDescription.getName().equals(downloadableFileSetDescription2.getName())) {
                    return downloadableFileSetDescription.getVersionString().compareTo(downloadableFileSetDescription2.getVersionString());
                }
                return downloadableFileSetDescription.getName().compareToIgnoreCase(downloadableFileSetDescription2.getName());
            });
        }

        @Override
        public int getRowCount() {
            return this.b.size();
        }

        @Override
        public int getColumnCount() {
            return this.d ? 3 : 2;
        }

        @Override
        @Nullable
        public Object getValueAt(int n2, int n3) {
            DownloadableFileSetDescriptionWithUrl downloadableFileSetDescriptionWithUrl = this.b.get(n2);
            if (n3 == this.e) {
                return downloadableFileSetDescriptionWithUrl.getName();
            }
            if (n3 == this.c) {
                return downloadableFileSetDescriptionWithUrl.getVersionString();
            }
            if (n3 == this.a) {
                return downloadableFileSetDescriptionWithUrl.getUrl();
            }
            return null;
        }

        @Override
        @Nullable
        public String getColumnName(int n2) {
            if (n2 == this.e) {
                return "Name";
            }
            if (n2 == this.c) {
                return "Version";
            }
            if (n2 == this.a) {
                return "URL";
            }
            return "";
        }

        @Nullable
        public DownloadableFileSetDescriptionWithUrl getDescriptionAt(int n2) {
            if (n2 < 0 || n2 >= this.b.size()) {
                return null;
            }
            return this.b.get(n2);
        }
    }
}

