/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.rpp.generatearraymethods;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.PsiFieldMember;
import com.intellij.ide.util.MemberChooser;
import com.intellij.openapi.actionSystem.DataConstants;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactorJBundle;
import com.sixrr.rpp.utils.ArrayUtils;
import com.sixrr.rpp.utils.PsiUtils;
import com.sixrr.rpp.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;

class GenerateArrayMethodsHandler
extends EditorWriteActionHandler {
    GenerateArrayMethodsHandler() {
    }

    public void executeWriteAction(Editor editor, DataContext dataContext) {
        PsiElement psiElement;
        CaretModel caretModel = editor.getCaretModel();
        int n2 = caretModel.getOffset();
        PsiFile psiFile = (PsiFile)dataContext.getData("psi.File");
        Project project2 = (Project)dataContext.getData(DataConstants.PROJECT);
        if (psiFile == null) {
            return;
        }
        PsiElement psiElement2 = psiFile.findElementAt(n2);
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement2, PsiClass.class);
        if (psiClass == null) {
            return;
        }
        for (psiElement = psiElement2; psiElement != null && !psiElement.getParent().equals(psiClass); psiElement = psiElement.getParent()) {
        }
        if (psiElement != null) {
            psiElement = PsiTreeUtil.getNextSiblingOfType((PsiElement)psiElement, PsiMember.class);
        }
        List<PsiField> list2 = ArrayUtils.getUnimplementedArrayFields(psiClass);
        GenerateArrayMethodsHandler.a(list2, project2, psiElement);
    }

    private static void a(PsiField psiField, PsiElement psiElement) {
        PsiClass psiClass = psiField.getContainingClass();
        String string = psiField.getName();
        String string2 = PsiUtils.stripFieldName(psiField);
        String string3 = StringUtils.createSingularFromName(string2);
        PsiArrayType psiArrayType = (PsiArrayType)psiField.getType();
        PsiType psiType = psiArrayType.getDeepComponentType();
        String string4 = psiArrayType.getPresentableText();
        GenerateArrayMethodsHandler.b(psiClass, psiField, string, string3, psiType, psiArrayType, psiElement);
        GenerateArrayMethodsHandler.a(psiClass, psiField, string, string3, psiType, psiArrayType, psiElement);
        GenerateArrayMethodsHandler.a(psiClass, psiField, string, string2, string4, psiElement);
    }

    private static void b(PsiClass psiClass, PsiField psiField, String string, String string2, PsiType psiType, PsiArrayType psiArrayType, PsiElement psiElement) {
        int n2;
        PsiManager psiManager = psiClass.getManager();
        Project project2 = psiManager.getProject();
        CodeStyleSettingsManager codeStyleSettingsManager = CodeStyleSettingsManager.getInstance((Project)project2);
        JavaCodeStyleSettings javaCodeStyleSettings = (JavaCodeStyleSettings)codeStyleSettingsManager.getCurrentSettings().getCustomSettings(JavaCodeStyleSettings.class);
        String string3 = "set" + StringUtil.capitalize((String)string2) + "At";
        if (PsiUtils.classHasMethod(psiClass, string3)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(128);
        String string4 = psiField.hasModifierProperty("static") ? "static " : "";
        stringBuilder.append("public " + string4 + "void ");
        stringBuilder.append(string3);
        stringBuilder.append("(");
        stringBuilder.append(javaCodeStyleSettings.GENERATE_FINAL_PARAMETERS ? "final " : "");
        stringBuilder.append(psiType.getPresentableText());
        stringBuilder.append(' ');
        stringBuilder.append(javaCodeStyleSettings.PARAMETER_NAME_PREFIX);
        stringBuilder.append(string2);
        stringBuilder.append(javaCodeStyleSettings.PARAMETER_NAME_SUFFIX);
        int n3 = psiArrayType.getArrayDimensions();
        for (n2 = 0; n2 < n3; ++n2) {
            stringBuilder.append(",");
            stringBuilder.append(javaCodeStyleSettings.GENERATE_FINAL_PARAMETERS ? "final " : "");
            stringBuilder.append(" int ");
            stringBuilder.append(javaCodeStyleSettings.PARAMETER_NAME_PREFIX);
            stringBuilder.append(GenerateArrayMethodsHandler.a(n2));
            stringBuilder.append(javaCodeStyleSettings.PARAMETER_NAME_SUFFIX);
        }
        stringBuilder.append("){");
        stringBuilder.append(string);
        for (n2 = 0; n2 < n3; ++n2) {
            stringBuilder.append('[');
            stringBuilder.append(javaCodeStyleSettings.PARAMETER_NAME_PREFIX);
            stringBuilder.append(GenerateArrayMethodsHandler.a(n2));
            stringBuilder.append(javaCodeStyleSettings.PARAMETER_NAME_SUFFIX);
            stringBuilder.append(']');
        }
        stringBuilder.append("=");
        stringBuilder.append(javaCodeStyleSettings.PARAMETER_NAME_PREFIX);
        stringBuilder.append(string2);
        stringBuilder.append(javaCodeStyleSettings.PARAMETER_NAME_SUFFIX);
        stringBuilder.append(';');
        stringBuilder.append('}');
        String string5 = stringBuilder.toString();
        PsiUtils.addMethodToClass(psiClass, string5, psiElement);
    }

    @NonNls
    private static String a(int n2) {
        switch (n2) {
            case 0: {
                return "i";
            }
            case 1: {
                return "j";
            }
            case 2: {
                return "k";
            }
        }
        return "i" + (n2 - 2);
    }

    private static void a(PsiClass psiClass, PsiField psiField, String string, String string2, PsiType psiType, PsiArrayType psiArrayType, PsiElement psiElement) {
        int n2;
        PsiManager psiManager = psiClass.getManager();
        Project project2 = psiManager.getProject();
        CodeStyleSettingsManager codeStyleSettingsManager = CodeStyleSettingsManager.getInstance((Project)project2);
        JavaCodeStyleSettings javaCodeStyleSettings = (JavaCodeStyleSettings)codeStyleSettingsManager.getCurrentSettings().getCustomSettings(JavaCodeStyleSettings.class);
        String string3 = "get" + StringUtil.capitalize((String)string2) + "At";
        if (PsiUtils.classHasMethod(psiClass, string3)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(128);
        String string4 = psiField.hasModifierProperty("static") ? "static " : "";
        stringBuilder.append("public " + string4 + psiType.getPresentableText() + ' ');
        stringBuilder.append(string3);
        stringBuilder.append('(');
        int n3 = psiArrayType.getArrayDimensions();
        for (n2 = 0; n2 < n3; ++n2) {
            if (n2 != 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(javaCodeStyleSettings.GENERATE_FINAL_PARAMETERS ? "final " : "");
            stringBuilder.append("int ");
            stringBuilder.append(javaCodeStyleSettings.PARAMETER_NAME_PREFIX);
            stringBuilder.append(GenerateArrayMethodsHandler.a(n2));
            stringBuilder.append(javaCodeStyleSettings.PARAMETER_NAME_SUFFIX);
        }
        stringBuilder.append(')');
        stringBuilder.append('{');
        stringBuilder.append("return ");
        stringBuilder.append(string);
        for (n2 = 0; n2 < n3; ++n2) {
            stringBuilder.append('[');
            stringBuilder.append(javaCodeStyleSettings.PARAMETER_NAME_PREFIX);
            stringBuilder.append(GenerateArrayMethodsHandler.a(n2));
            stringBuilder.append(javaCodeStyleSettings.PARAMETER_NAME_SUFFIX);
            stringBuilder.append(']');
        }
        stringBuilder.append(";}");
        String string5 = stringBuilder.toString();
        PsiUtils.addMethodToClass(psiClass, string5, psiElement);
    }

    private static void a(PsiClass psiClass, PsiField psiField, String string, String string2, String string3, PsiElement psiElement) {
        String string4 = "get" + StringUtil.capitalize((String)string2);
        if (PsiUtils.classHasMethod(psiClass, string4)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(128);
        String string5 = psiField.hasModifierProperty("static") ? "static " : "";
        stringBuilder.append("public " + string5 + string3 + ' ');
        stringBuilder.append(string4 + "()");
        stringBuilder.append('{');
        if (PsiUtil.isLanguageLevel5OrHigher((PsiElement)psiClass)) {
            stringBuilder.append("return " + string + ".clone();");
        } else {
            stringBuilder.append("return (" + string3 + ')' + string + ".clone();");
        }
        stringBuilder.append('}');
        String string6 = stringBuilder.toString();
        PsiUtils.addMethodToClass(psiClass, string6, psiElement);
    }

    private static void a(List<PsiField> list2, Project project2, PsiElement psiElement) {
        int n2 = list2.size();
        PsiFieldMember[] psiFieldMemberArray = new PsiFieldMember[n2];
        for (int i2 = 0; i2 < list2.size(); ++i2) {
            psiFieldMemberArray[i2] = new PsiFieldMember(list2.get(i2));
        }
        MemberChooser memberChooser = new MemberChooser((ClassMember[])psiFieldMemberArray, true, true, project2);
        memberChooser.setCopyJavadocVisible(false);
        memberChooser.setTitle(RefactorJBundle.message((String)"generate.array.access.methods.title", (Object[])new Object[0]));
        memberChooser.setSize(200, 200);
        SwingUtilities.invokeLater(() -> {
            memberChooser.show();
            if (memberChooser.getExitCode() == 1) {
                return;
            }
            List list2 = memberChooser.getSelectedElements();
            if (list2 != null) {
                ArrayList<PsiField> arrayList = new ArrayList<PsiField>();
                for (PsiFieldMember psiFieldMember : list2) {
                    arrayList.add((PsiField)psiFieldMember.getPsiElement());
                }
                GenerateArrayMethodsHandler.b(arrayList, project2, psiElement);
            }
        });
    }

    private static void b(List<PsiField> list2, Project project2, PsiElement psiElement) {
        Runnable runnable = () -> {
            Application application = ApplicationManager.getApplication();
            application.runWriteAction(() -> GenerateArrayMethodsHandler.a(list2, psiElement));
        };
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.executeCommand(project2, runnable, RefactorJBundle.message((String)"generate.array.methods.undo.string", (Object[])new Object[0]), null);
    }

    private static void a(List<PsiField> list2, PsiElement psiElement) {
        PsiField psiField2;
        for (PsiField psiField2 : list2) {
            GenerateArrayMethodsHandler.a(psiField2, psiElement);
        }
        PsiField psiField3 = list2.get(0);
        psiField2 = psiField3.getContainingClass();
        PsiUtils.reformatClass((PsiClass)psiField2);
    }
}

