/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.rpp.mergeloops;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.sixrr.rpp.intention.PsiElementPredicate;
import com.sixrr.rpp.mergeloops.SharedDeclarationUtil;
import com.sixrr.rpp.utils.ErrorUtil;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import java.util.HashSet;
import java.util.Set;

class MergeLoopsPredicate
implements PsiElementPredicate {
    MergeLoopsPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement psiElement) {
        if (psiElement instanceof PsiForeachStatement) {
            PsiForeachStatement psiForeachStatement = (PsiForeachStatement)psiElement;
            if (ErrorUtil.containsError((PsiElement)psiForeachStatement)) {
                return false;
            }
            PsiElement psiElement2 = PsiTreeUtil.skipWhitespacesForward((PsiElement)psiForeachStatement);
            if (!(psiElement2 instanceof PsiForeachStatement)) {
                return false;
            }
            PsiForeachStatement psiForeachStatement2 = (PsiForeachStatement)psiElement2;
            if (ErrorUtil.containsError(psiElement2)) {
                return false;
            }
            return MergeLoopsPredicate.a(psiForeachStatement, psiForeachStatement2);
        }
        if (psiElement instanceof PsiForStatement) {
            PsiForStatement psiForStatement = (PsiForStatement)psiElement;
            if (ErrorUtil.containsError((PsiElement)psiForStatement)) {
                return false;
            }
            PsiElement psiElement3 = PsiTreeUtil.skipWhitespacesForward((PsiElement)psiForStatement);
            if (!(psiElement3 instanceof PsiForStatement)) {
                return false;
            }
            PsiForStatement psiForStatement2 = (PsiForStatement)psiElement3;
            if (ErrorUtil.containsError(psiElement3)) {
                return false;
            }
            return MergeLoopsPredicate.a(psiForStatement, psiForStatement2);
        }
        return false;
    }

    private static boolean a(PsiForStatement psiForStatement, PsiForStatement psiForStatement2) {
        PsiStatement psiStatement = psiForStatement.getInitialization();
        PsiStatement psiStatement2 = psiForStatement2.getInitialization();
        if (!EquivalenceChecker.getCanonicalPsiEquivalence().statementsAreEquivalent(psiStatement, psiStatement2)) {
            return false;
        }
        PsiExpression psiExpression = psiForStatement.getCondition();
        PsiExpression psiExpression2 = psiForStatement2.getCondition();
        if (!EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(psiExpression, psiExpression2)) {
            return false;
        }
        PsiStatement psiStatement3 = psiForStatement.getUpdate();
        PsiStatement psiStatement4 = psiForStatement2.getUpdate();
        if (!EquivalenceChecker.getCanonicalPsiEquivalence().statementsAreEquivalent(psiStatement3, psiStatement4)) {
            return false;
        }
        PsiStatement psiStatement5 = psiForStatement.getBody();
        PsiStatement psiStatement6 = psiForStatement2.getBody();
        if (!ControlFlowUtils.statementMayCompleteNormally((PsiStatement)psiStatement5)) {
            return false;
        }
        return MergeLoopsPredicate.a(psiStatement5, psiStatement6);
    }

    private static boolean a(PsiForeachStatement psiForeachStatement, PsiForeachStatement psiForeachStatement2) {
        boolean bl2;
        PsiType psiType;
        String string;
        PsiExpression psiExpression = psiForeachStatement.getIteratedValue();
        PsiExpression psiExpression2 = psiForeachStatement2.getIteratedValue();
        if (!EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(psiExpression, psiExpression2)) {
            return false;
        }
        PsiParameter psiParameter = psiForeachStatement.getIterationParameter();
        PsiParameter psiParameter2 = psiForeachStatement2.getIterationParameter();
        String string2 = psiParameter.getName();
        if (!string2.equals(string = psiParameter2.getName())) {
            return false;
        }
        PsiType psiType2 = psiParameter.getType();
        if (!psiType2.equals(psiType = psiParameter2.getType())) {
            return false;
        }
        boolean bl3 = psiParameter.hasModifierProperty("final");
        if (bl3 != (bl2 = psiParameter2.hasModifierProperty("final"))) {
            return false;
        }
        PsiStatement psiStatement = psiForeachStatement.getBody();
        if (!ControlFlowUtils.statementMayCompleteNormally((PsiStatement)psiStatement)) {
            return false;
        }
        PsiStatement psiStatement2 = psiForeachStatement2.getBody();
        return MergeLoopsPredicate.a(psiStatement, psiStatement2);
    }

    private static boolean a(PsiStatement psiStatement, PsiStatement psiStatement2) {
        int n2 = SharedDeclarationUtil.calculateNumSharedDeclarations(psiStatement, psiStatement2);
        Set<String> set = MergeLoopsPredicate.a(psiStatement, n2);
        if (MergeLoopsPredicate.a(set, psiStatement2)) {
            return false;
        }
        Set<String> set2 = MergeLoopsPredicate.a(psiStatement2, n2);
        return !MergeLoopsPredicate.a(set2, psiStatement);
    }

    private static boolean a(Set<String> set, PsiStatement psiStatement) {
        DeclarationVisitor declarationVisitor = new DeclarationVisitor(set);
        psiStatement.accept((PsiElementVisitor)declarationVisitor);
        return declarationVisitor.a();
    }

    private static Set<String> a(PsiStatement psiStatement, int n2) {
        HashSet<String> hashSet = new HashSet<String>();
        if (psiStatement instanceof PsiDeclarationStatement) {
            MergeLoopsPredicate.a((PsiDeclarationStatement)psiStatement, hashSet);
        } else if (psiStatement instanceof PsiBlockStatement) {
            PsiBlockStatement psiBlockStatement = (PsiBlockStatement)psiStatement;
            PsiCodeBlock psiCodeBlock = psiBlockStatement.getCodeBlock();
            PsiStatement[] psiStatementArray = psiCodeBlock.getStatements();
            for (int i2 = n2; i2 < psiStatementArray.length; ++i2) {
                if (!(psiStatementArray[i2] instanceof PsiDeclarationStatement)) continue;
                MergeLoopsPredicate.a((PsiDeclarationStatement)psiStatementArray[i2], hashSet);
            }
        }
        return hashSet;
    }

    private static void a(PsiDeclarationStatement psiDeclarationStatement, Set<String> set) {
        PsiElement[] psiElementArray;
        for (PsiElement psiElement : psiElementArray = psiDeclarationStatement.getDeclaredElements()) {
            if (!(psiElement instanceof PsiVariable)) continue;
            PsiVariable psiVariable = (PsiVariable)psiElement;
            String string = psiVariable.getName();
            set.add(string);
        }
    }

    private static class DeclarationVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final Set<String> a;
        private boolean b = false;

        private DeclarationVisitor(Set<String> set) {
            this.a = new HashSet<String>(set);
        }

        public void visitVariable(PsiVariable psiVariable) {
            super.visitVariable(psiVariable);
            String string = psiVariable.getName();
            for (String string2 : this.a) {
                String string3 = string2;
                if (!string3.equals(string)) continue;
                this.b = true;
            }
        }

        private boolean a() {
            return this.b;
        }
    }
}

