/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.rpp.pulljavadocup;

import com.intellij.openapi.help.HelpManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.RefactorJBundle;
import com.intellij.refactoring.classMembers.DelegatingMemberInfoModel;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.MemberInfoChangeListener;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.psi.MethodInheritanceUtils;
import com.intellij.refactoring.ui.ClassCellRenderer;
import com.intellij.refactoring.ui.MemberSelectionPanel;
import com.intellij.refactoring.ui.MemberSelectionTable;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.sixrr.rpp.RefactorJConfig;
import com.sixrr.rpp.utils.JavadocUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class PullJavadocUpDialog
extends RefactoringDialog
implements MemberInfoChangeListener<PsiMember, MemberInfo> {
    private final PsiClass a;
    private final List<MemberInfo> e;
    private final JTextField d;
    private JComboBox b;
    private final JCheckBox c;

    PullJavadocUpDialog(PsiClass psiClass, PsiMethod psiMethod) {
        super(psiClass.getProject(), true);
        this.setModal(true);
        this.setTitle(RefactorJBundle.message((String)"pull.javadoc.up.title", (Object[])new Object[0]));
        this.a = psiClass;
        this.d = new JTextField();
        this.c = new JCheckBox(RefactorJBundle.message((String)"replace.existing.comments.checkbox", (Object[])new Object[0]));
        MemberInfoBase.Filter<PsiMember> filter = new MemberInfoBase.Filter<PsiMember>(){

            public boolean includeMember(PsiMember psiMember) {
                if (psiMember instanceof PsiMethod) {
                    PsiMethod[] psiMethodArray;
                    PsiMethod psiMethod = (PsiMethod)psiMember;
                    if (psiMethod.isConstructor()) {
                        return false;
                    }
                    if (!JavadocUtils.hasJavadoc(psiMethod)) {
                        return false;
                    }
                    for (PsiMethod psiMethod2 : psiMethodArray = psiMethod.findSuperMethods()) {
                        if (psiMethod2.getContainingClass() instanceof PsiCompiledElement) continue;
                        return true;
                    }
                    return false;
                }
                return false;
            }
        };
        this.e = MemberInfo.extractClassMembers((PsiClass)this.a, (MemberInfoBase.Filter)filter, (boolean)true);
        for (MemberInfo memberInfo : this.e) {
            if (!((PsiMember)memberInfo.getMember()).equals(psiMethod)) continue;
            memberInfo.setChecked(true);
        }
        super.init();
        RefactorJConfig refactorJConfig = RefactorJConfig.getInstance();
        this.c.setSelected(refactorJConfig.PULL_JAVADOC_UP_REPLACE_EXISTING_JAVADOC);
        this.validateButtons();
    }

    protected void doAction() {
    }

    protected boolean areButtonsValid() {
        List<PsiMethod> list2 = this.getMethodsToPullUp();
        return !list2.isEmpty();
    }

    protected String getDimensionServiceKey() {
        return "RefactorJ.PullJavadocUp";
    }

    protected JComponent createNorthPanel() {
        Box box = Box.createVerticalBox();
        this.d.setEditable(false);
        this.d.setText(this.a.getQualifiedName());
        JPanel jPanel = new JPanel(new BorderLayout());
        box.add(jPanel);
        JLabel jLabel = new JLabel(RefactorJBundle.message((String)"pull.up.javadoc.from.label", (Object[])new Object[]{this.a.getName()}));
        jPanel.add((Component)jLabel, "North");
        PsiClass[] psiClassArray = MethodInheritanceUtils.getNonLibrarySuperClasses((PsiClass)this.a);
        this.b = new JComboBox<PsiClass>(psiClassArray);
        this.b.setRenderer(new ClassCellRenderer(this.b.getRenderer()));
        jPanel.add((Component)this.b, "South");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)box, "Center");
        return jPanel2;
    }

    protected JComponent createCenterPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        MemberSelectionPanel memberSelectionPanel = new MemberSelectionPanel(RefactorJBundle.message((String)"methods.to.pull.up.javadoc.from.panel", (Object[])new Object[0]), this.e, null);
        MemberSelectionTable memberSelectionTable = memberSelectionPanel.getTable();
        memberSelectionTable.setMemberInfoModel((MemberInfoModel)new DelegatingMemberInfoModel<PsiMember, MemberInfo>(memberSelectionTable.getMemberInfoModel()){

            public Boolean isFixedAbstract(MemberInfo memberInfo) {
                return Boolean.TRUE;
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)memberSelectionPanel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.c, gridBagConstraints);
        memberSelectionTable.addMemberInfoChangeListener((MemberInfoChangeListener)this);
        return jPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.b;
    }

    protected void doHelpAction() {
        HelpManager helpManager = HelpManager.getInstance();
        helpManager.invokeHelp("refactorj.pullJavadocUp");
    }

    public void memberInfoChanged(MemberInfoChange memberInfoChange) {
        this.validateButtons();
    }

    public List<PsiMethod> getMethodsToPullUp() {
        ArrayList<PsiMethod> arrayList = new ArrayList<PsiMethod>();
        for (MemberInfo memberInfo : this.e) {
            if (!memberInfo.isChecked()) continue;
            PsiMember psiMember = (PsiMember)memberInfo.getMember();
            arrayList.add((PsiMethod)psiMember);
        }
        return arrayList;
    }

    public PsiClass getTargetClass() {
        return (PsiClass)this.b.getSelectedItem();
    }

    public boolean getReplaceExistingComments() {
        return this.c.isSelected();
    }
}

