/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.rpp.removeproperty;

import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.refactoring.RefactorJBundle;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.border.IdeaTitledBorder;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.rpp.RefactorJConfig;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

class RemovePropertyDialog
extends RefactoringDialog {
    private final PsiField d;
    private final JCheckBox c;
    private final JCheckBox a;
    private final JTextField b;

    RemovePropertyDialog(PsiField psiField) {
        super(psiField.getProject(), true);
        this.setModal(true);
        this.d = psiField;
        this.a = new JCheckBox(RefactorJBundle.message((String)"remove.property.getter.checkbox", (Object[])new Object[0]));
        this.c = new JCheckBox(RefactorJBundle.message((String)"remove.property.setter.checkbox", (Object[])new Object[0]));
        this.b = new JTextField(30);
        Document document = this.b.getDocument();
        DocumentAdapter documentAdapter = new DocumentAdapter(){

            protected void textChanged(DocumentEvent documentEvent) {
                RemovePropertyDialog.this.validateButtons();
            }
        };
        document.addDocumentListener((DocumentListener)documentAdapter);
        this.setTitle(RefactorJBundle.message((String)"remove.property.title", (Object[])new Object[0]));
        this.init();
        RefactorJConfig refactorJConfig = RefactorJConfig.getInstance();
        this.c.setSelected(refactorJConfig.REMOVE_PROPERTY_REMOVE_SETTER);
        this.a.setSelected(refactorJConfig.REMOVE_PROPERTY_REMOVE_GETTER);
        this.validateButtons();
    }

    protected String getDimensionServiceKey() {
        return "RefactorJ.RemoveProperty";
    }

    protected JComponent createNorthPanel() {
        JPanel jPanel = new JPanel();
        String string = RefactorJBundle.message((String)"remove.property.border", (Object[])new Object[]{this.d.getName()});
        IdeaTitledBorder ideaTitledBorder = IdeBorderFactory.createTitledBorder((String)string, (boolean)true);
        jPanel.setBorder((Border)ideaTitledBorder);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.a, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.c, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)new JLabel(RefactorJBundle.message((String)"replacement.expression.label", (Object[])new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.b, gridBagConstraints);
        return jPanel;
    }

    protected JComponent createCenterPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        return jPanel;
    }

    protected void doAction() {
    }

    protected boolean areButtonsValid() {
        return this.a();
    }

    private boolean a() {
        String string = this.getReplacementExpression();
        if (string.length() == 0) {
            return true;
        }
        PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)this.d.getManager().getProject()).getElementFactory();
        try {
            psiElementFactory.createExpressionFromText(string, (PsiElement)this.d.getContainingClass());
            return true;
        }
        catch (IncorrectOperationException incorrectOperationException) {
            return false;
        }
    }

    protected void validateButtons() {
        if (this.a()) {
            this.b.setForeground(JBColor.foreground());
        } else {
            this.b.setForeground((Color)JBColor.RED);
        }
        super.validateButtons();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.a;
    }

    protected void doHelpAction() {
        HelpManager helpManager = HelpManager.getInstance();
        helpManager.invokeHelp("refactorj.removeProperty");
    }

    public boolean getRemoveSetter() {
        return this.c.isSelected();
    }

    public boolean getRemoveGetter() {
        return this.a.isSelected();
    }

    public String getReplacementExpression() {
        return this.b.getText();
    }
}

