/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.library;

import com.google.common.collect.Iterables;
import com.intellij.jarRepository.RepositoryLibraryType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryDependencyScopeSuggester;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryEditingUtil;
import com.intellij.openapi.util.Comparing;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryDescription;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.idea.maven.utils.library.RepositoryUtils;
import org.jetbrains.idea.maven.utils.library.propertiesEditor.RepositoryLibraryPropertiesModel;

public class RepositoryLibrarySupport {
    @NotNull
    private final Project a;
    @NotNull
    private final RepositoryLibraryPropertiesModel c;
    @NotNull
    private final RepositoryLibraryDescription b;

    public RepositoryLibrarySupport(@NotNull Project project2, @NotNull RepositoryLibraryDescription repositoryLibraryDescription, @NotNull RepositoryLibraryPropertiesModel repositoryLibraryPropertiesModel) {
        if (project2 == null) {
            RepositoryLibrarySupport.a(0);
        }
        if (repositoryLibraryDescription == null) {
            RepositoryLibrarySupport.a(1);
        }
        if (repositoryLibraryPropertiesModel == null) {
            RepositoryLibrarySupport.a(2);
        }
        this.a = project2;
        this.b = repositoryLibraryDescription;
        this.c = repositoryLibraryPropertiesModel;
    }

    public void addSupport(@NotNull Module module2, @NotNull ModifiableRootModel modifiableRootModel, @NotNull ModifiableModelsProvider modifiableModelsProvider) {
        LibraryTable.ModifiableModel modifiableModel;
        Library library2;
        if (module2 == null) {
            RepositoryLibrarySupport.a(3);
        }
        if (modifiableRootModel == null) {
            RepositoryLibrarySupport.a(4);
        }
        if (modifiableModelsProvider == null) {
            RepositoryLibrarySupport.a(5);
        }
        if ((library2 = (Library)Iterables.find(Arrays.asList((modifiableModel = modifiableModelsProvider.getLibraryTableModifiableModel(module2.getProject())).getLibraries()), library -> this.b((Library)library), null)) == null) {
            library2 = this.a(module2, modifiableModel);
        } else {
            modifiableModelsProvider.disposeLibraryTableModifiableModel(modifiableModel);
        }
        DependencyScope dependencyScope = LibraryDependencyScopeSuggester.getDefaultScope((Library)library2);
        ModifiableRootModel modifiableRootModel2 = modifiableModelsProvider.getModuleModifiableModel(module2);
        LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)Iterables.find(Arrays.asList(modifiableRootModel2.getOrderEntries()), orderEntry -> orderEntry instanceof LibraryOrderEntry && ((LibraryOrderEntry)orderEntry).getScope() == dependencyScope && this.b(((LibraryOrderEntry)orderEntry).getLibrary()), null);
        modifiableModelsProvider.disposeModuleModifiableModel(modifiableRootModel2);
        if (libraryOrderEntry == null) {
            modifiableRootModel.addLibraryEntry(library2).setScope(dependencyScope);
        }
    }

    private LibraryEx a(@NotNull Module module2, LibraryTable.ModifiableModel modifiableModel) {
        if (module2 == null) {
            RepositoryLibrarySupport.a(6);
        }
        RepositoryLibraryProperties repositoryLibraryProperties = new RepositoryLibraryProperties(this.b.getGroupId(), this.b.getArtifactId(), this.c.getVersion(), this.c.isIncludeTransitiveDependencies());
        LibraryEx libraryEx = (LibraryEx)modifiableModel.createLibrary(LibraryEditingUtil.suggestNewLibraryName(modifiableModel, RepositoryLibraryType.getInstance().getDescription(repositoryLibraryProperties)), RepositoryLibraryType.REPOSITORY_LIBRARY_KIND);
        RepositoryLibraryProperties repositoryLibraryProperties2 = (RepositoryLibraryProperties)libraryEx.getProperties();
        repositoryLibraryProperties2.setMavenId(repositoryLibraryProperties.getMavenId());
        ApplicationManager.getApplication().runWriteAction(() -> modifiableModel.commit());
        RepositoryUtils.loadDependencies(module2.getProject(), libraryEx, this.c.isDownloadSources(), this.c.isDownloadJavaDocs(), null);
        return libraryEx;
    }

    private boolean b(Library library) {
        if (!(library instanceof LibraryEx)) {
            return false;
        }
        LibraryEx libraryEx = (LibraryEx)library;
        if (!RepositoryLibraryType.REPOSITORY_LIBRARY_KIND.equals((Object)libraryEx.getKind())) {
            return false;
        }
        LibraryProperties libraryProperties = libraryEx.getProperties();
        if (!(libraryProperties instanceof RepositoryLibraryProperties)) {
            return false;
        }
        RepositoryLibraryProperties repositoryLibraryProperties = (RepositoryLibraryProperties)libraryProperties;
        RepositoryLibraryDescription repositoryLibraryDescription = RepositoryLibraryDescription.findDescription((RepositoryLibraryProperties)repositoryLibraryProperties);
        if (!repositoryLibraryDescription.equals(this.b)) {
            return false;
        }
        return Comparing.equal((String)repositoryLibraryProperties.getVersion(), (String)this.c.getVersion());
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryDescription";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiableModelsProvider";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/utils/library/RepositoryLibrarySupport";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addSupport";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createNewLibrary";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

