/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.library;

import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.jarRepository.RepositoryLibraryType;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.NewLibraryEditor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryDescription;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;

public class RepositoryUtils {
    private static final Logger a = Logger.getInstance((String)"#org.jetbrains.idea.maven.utils.library.RepositoryUtils");

    public static boolean libraryHasSources(@Nullable Library library) {
        return library != null && library.getUrls(OrderRootType.SOURCES).length > 0;
    }

    public static boolean libraryHasSources(@Nullable LibraryEditor libraryEditor) {
        return libraryEditor != null && libraryEditor.getUrls(OrderRootType.SOURCES).length > 0;
    }

    public static boolean libraryHasJavaDocs(@Nullable Library library) {
        return library != null && library.getUrls(JavadocOrderRootType.getInstance()).length > 0;
    }

    public static boolean libraryHasJavaDocs(@Nullable LibraryEditor libraryEditor) {
        return libraryEditor != null && libraryEditor.getUrls(JavadocOrderRootType.getInstance()).length > 0;
    }

    public static String getStorageRoot(Library library, Project project2) {
        return RepositoryUtils.getStorageRoot(library.getUrls(OrderRootType.CLASSES), project2);
    }

    public static String getStorageRoot(String[] stringArray, Project project2) {
        if (stringArray.length == 0) {
            return null;
        }
        String string = FileUtil.toSystemIndependentName((String)JarRepositoryManager.getLocalRepositoryPath().getAbsolutePath());
        List list2 = JBIterable.of((Object[])stringArray).transform(string2 -> {
            String string3 = StringUtil.trimStart((String)string2, (String)"jar://");
            return string3.startsWith(string) ? null : FileUtil.toSystemDependentName((String)PathUtil.getParentPath((String)string3));
        }).toList();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            String string3;
            Integer n2 = (Integer)hashMap.get(string3 = (String)iterator.next());
            hashMap.put(string3, n2 != null ? n2 + 1 : 1);
        }
        return (String)Collections.max(hashMap.entrySet(), Comparator.comparing(Map.Entry::getValue)).getKey();
    }

    @Deprecated
    public static String resolveEffectiveVersion(@NotNull Project project2, @NotNull RepositoryLibraryProperties repositoryLibraryProperties) {
        if (project2 == null) {
            RepositoryUtils.a(0);
        }
        if (repositoryLibraryProperties == null) {
            RepositoryUtils.a(1);
        }
        String string = repositoryLibraryProperties.getVersion();
        boolean bl2 = "LATEST".equals(string);
        boolean bl3 = "RELEASE".equals(string);
        if (bl2 || bl3) {
            try {
                Collection<String> collection = JarRepositoryManager.getAvailableVersions(project2, RepositoryLibraryDescription.findDescription((String)repositoryLibraryProperties.getGroupId(), (String)repositoryLibraryProperties.getArtifactId())).get();
                for (String string2 : collection) {
                    if (bl3 && string2.endsWith("-SNAPSHOT")) continue;
                    string = string2;
                    break;
                }
            }
            catch (InterruptedException | ExecutionException exception) {
                a.error("Got unexpected exception while resolving artifact versions", (Throwable)exception);
            }
        }
        return string;
    }

    public static void loadDependencies(@NotNull Project project2, @NotNull LibraryEx libraryEx, boolean bl2, boolean bl3, @Nullable String string) {
        if (project2 == null) {
            RepositoryUtils.a(2);
        }
        if (libraryEx == null) {
            RepositoryUtils.a(3);
        }
        if (libraryEx.getKind() != RepositoryLibraryType.REPOSITORY_LIBRARY_KIND) {
            return;
        }
        RepositoryLibraryProperties repositoryLibraryProperties = (RepositoryLibraryProperties)libraryEx.getProperties();
        String[] stringArray = libraryEx.getUrls(AnnotationOrderRootType.getInstance());
        JarRepositoryManager.loadDependenciesAsync(project2, repositoryLibraryProperties, bl2, bl3, null, string, collection -> {
            if (project2 == null) {
                RepositoryUtils.a(6);
            }
            if (libraryEx == null) {
                RepositoryUtils.a(7);
            }
            ApplicationManager.getApplication().invokeLater(collection == null || collection.isEmpty() ? () -> {
                if (project2 == null) {
                    RepositoryUtils.a(10);
                }
                Notifications.Bus.notify((Notification)new Notification("Repository", "Repository library synchronization", "No files were downloaded for " + repositoryLibraryProperties.getMavenId(), NotificationType.ERROR), (Project)project2);
            } : () -> {
                if (libraryEx == null) {
                    RepositoryUtils.a(8);
                }
                if (!libraryEx.isDisposed()) {
                    WriteAction.run(() -> {
                        if (libraryEx == null) {
                            RepositoryUtils.a(9);
                        }
                        NewLibraryEditor newLibraryEditor = new NewLibraryEditor(null, (LibraryProperties)repositoryLibraryProperties);
                        newLibraryEditor.setKeepInvalidUrls(false);
                        newLibraryEditor.removeAllRoots();
                        newLibraryEditor.addRoots((Collection<? extends OrderRoot>)collection);
                        for (String string : stringArray) {
                            newLibraryEditor.addRoot(string, AnnotationOrderRootType.getInstance());
                        }
                        LibraryEx.ModifiableModelEx modifiableModelEx2 = libraryEx.getModifiableModel();
                        newLibraryEditor.applyTo(modifiableModelEx2);
                        modifiableModelEx2.commit();
                    });
                }
            });
        });
    }

    public static void reloadDependencies(@NotNull Project project2, @NotNull LibraryEx libraryEx) {
        if (project2 == null) {
            RepositoryUtils.a(4);
        }
        if (libraryEx == null) {
            RepositoryUtils.a(5);
        }
        RepositoryUtils.loadDependencies(project2, libraryEx, RepositoryUtils.libraryHasSources((Library)libraryEx), RepositoryUtils.libraryHasJavaDocs((Library)libraryEx), RepositoryUtils.getStorageRoot((Library)libraryEx, project2));
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/utils/library/RepositoryUtils";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveEffectiveVersion";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "loadDependencies";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "reloadDependencies";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$loadDependencies$4";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$3";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$2";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

